/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.FileVO;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.search.CommentVO;
import com.jxdinfo.mp.common.model.zone.PraiseUserVO;
import com.jxdinfo.mp.common.model.zone.ZoneVO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.zone.commen.ApiConstants;
import com.jxdinfo.mp.zone.dao.CommentMapper;
import com.jxdinfo.mp.zone.dao.PraiseMapper;
import com.jxdinfo.mp.zone.dao.ZoneMapper;
import com.jxdinfo.mp.zone.model.file.ZoneFileDO;
import com.jxdinfo.mp.zone.model.type.TypeDO;
import com.jxdinfo.mp.zone.model.zone.CommentDO;
import com.jxdinfo.mp.zone.model.zone.OrganiseDO;
import com.jxdinfo.mp.zone.model.zone.PraiseDO;
import com.jxdinfo.mp.zone.model.zone.ZoneDO;
import com.jxdinfo.mp.zone.model.zone.ZoneDTO;
import com.jxdinfo.mp.zone.service.FileService;
import com.jxdinfo.mp.zone.service.TypeService;
import com.jxdinfo.mp.zone.service.ZoneService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@HussarTokenDs
@Service
public class ZoneServiceImpl
extends ServiceImpl<ZoneMapper, ZoneDO>
implements ZoneService {
    @Resource
    private ZoneMapper zoneMapper;
    @Resource
    private CommentMapper commentMapper;
    @Resource
    private PraiseMapper praiseMapper;
    @Resource
    private FileService fileService;
    @Resource
    private Environment environment;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private ZoneService zoneService;
    @Resource
    private IHussarBaseOrganizationBoService iHussarBaseOrganizationBoService;
    @Resource
    private IOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private OrganizationProperties organizationProperties;
    @Resource
    private TypeService typeService;

    public PageVO<ZoneVO> getZoneList(PageDTO pageDTO, CurrentLoginUser currentLoginUser, Long deptID, Long typeID) {
        List<Long> deptIdList = this.getDeptIDList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(typeID != null, (Object)"t1.TYPE_ID", (Object)typeID);
        queryWrapper.orderByDesc((Object)"t1.TOP", (Object[])new String[]{"t1.CREATE_TIME"});
        PageVO pageVO = new PageVO();
        if (deptID == null) {
            deptIdList.add(currentLoginUser.getCompanyID());
            queryWrapper.in((Object)"t1.DEPT_ID", deptIdList);
        } else {
            queryWrapper.eq((Object)"t1.DEPT_ID", (Object)deptID);
        }
        PageDTO<Long> page = this.zoneMapper.pageZoneIds(pageDTO, (Wrapper)queryWrapper);
        this.copyPage(page, pageVO);
        if (CollUtil.isNotEmpty((Collection)page.getList())) {
            ArrayList<ZoneVO> list = new ArrayList<ZoneVO>();
            for (Long id : page.getList()) {
                long commentCount;
                ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)id);
                if (ToolUtil.isEmpty((Object)zoneVO.getAllowPraise())) {
                    zoneVO.setAllowPraise(Boolean.valueOf(true));
                }
                if (ToolUtil.isEmpty((Object)zoneVO.getAllowComment())) {
                    zoneVO.setAllowComment(Boolean.valueOf(true));
                }
                if ((commentCount = this.redisTemplate.opsForZSet().size((Object)(this.zoneCommentKey() + id)).longValue()) == 0L) {
                    zoneVO.setComments(new ArrayList());
                } else {
                    ArrayList commentVOS = new ArrayList(this.redisTemplate.opsForZSet().reverseRange((Object)(this.zoneCommentKey() + id), 0L, 2L));
                    if (commentCount > 0L && commentCount <= 3L) {
                        zoneVO.setComments(commentVOS);
                    } else {
                        ArrayList<Object> commentVOList = new ArrayList<Object>();
                        int i = 0;
                        while ((long)i < commentCount - 3L) {
                            commentVOList.add(new CommentVO());
                            ++i;
                        }
                        commentVOList.addAll(0, commentVOS);
                        zoneVO.setComments(commentVOList);
                    }
                }
                long praiseCount = this.redisTemplate.opsForZSet().size((Object)(this.zonePraiseKey() + id));
                if (praiseCount == 0L) {
                    zoneVO.setPraiseUser(new ArrayList());
                } else {
                    ArrayList praiseUserVOS = new ArrayList(this.redisTemplate.opsForZSet().reverseRange((Object)(this.zonePraiseKey() + id), 0L, 100000L));
                    zoneVO.setPraiseUser(praiseUserVOS);
                }
                list.add(zoneVO);
            }
            pageVO.setList(list);
            this.dealDeptNamePraiseComment((PageVO<ZoneVO>)pageVO, currentLoginUser);
        } else {
            pageVO.setList(new ArrayList());
        }
        pageVO.setLastTime(DateUtil.now());
        return pageVO;
    }

    public boolean deleteZonePraise(Long msgID, Long userID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"USER_ID", (Object)userID);
        return this.praiseMapper.delete((Wrapper)queryWrapper) > 0;
    }

    public boolean saveZonePraise(PraiseDO praiseDO) {
        return this.praiseMapper.insert(praiseDO) > 0;
    }

    public long getZonePraise(Long msgID, Long userID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"USER_ID", (Object)userID);
        return this.praiseMapper.selectCount((Wrapper)queryWrapper);
    }

    public boolean deleteZoneComment(Long commentID, Long userID) {
        CommentVO commentVO = this.getCommentById(commentID);
        if (commentVO == null) {
            return true;
        }
        if (userID != null && !userID.equals(commentVO.getSenderId())) {
            return false;
        }
        this.commentMapper.deleteById(commentID);
        this.redisTemplate.opsForZSet().remove((Object)(this.zoneCommentKey() + commentVO.getMsgID()), new Object[]{commentVO});
        return true;
    }

    @Transactional
    public boolean deleteZone(Long msgID) {
        this.zoneMapper.deleteById(msgID);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MSG_ID", (Object)msgID);
        this.fileService.remove((Wrapper)queryWrapper);
        this.commentMapper.delete((Wrapper)queryWrapper);
        this.praiseMapper.delete((Wrapper)queryWrapper);
        this.redisTemplate.opsForHash().delete((Object)this.zoneKey(), new Object[]{msgID});
        this.redisTemplate.delete((Object)(this.zoneCommentKey() + msgID));
        this.redisTemplate.delete((Object)(this.zonePraiseKey() + msgID));
        return true;
    }

    public List<Long> getBrotherDeptID(Long deptID) {
        Long parentID = this.iHussarBaseOrganizationBoService.findOrganizationById(deptID).getParentId();
        if (HussarUtils.isNotEmpty((Object)parentID)) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(deptID);
            return arrayList;
        }
        List organizationsByParentId = this.iHussarBaseOrganizationBoService.findOrganizationsByParentId(parentID);
        return organizationsByParentId.stream().map(OrganizationBo::getId).collect(Collectors.toList());
    }

    public List<Map<String, String>> getZoneSendPermission() {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List pOrgsList = this.iHussarBaseOrganizationBoService.findParentOrganizationsByUserId(userId);
        HashMap organization = new HashMap();
        pOrgsList.forEach(n -> organization.put(n.getId() + "", n.getOrganName()));
        list.add(organization);
        return list;
    }

    public List<Map<String, String>> getSendRange() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List pOrgsList = this.iHussarBaseOrganizationBoService.findParentOrganizationsByUserId(BaseSecurityUtil.getUser().getUserId());
        pOrgsList.forEach(n -> {
            HashMap<String, String> organization = new HashMap<String, String>();
            organization.put("deptID", String.valueOf(n.getId()));
            organization.put("deptName", n.getOrganName());
            list.add(organization);
        });
        return list;
    }

    public List<OrganiseDO> getDepartmentList() {
        Long tenantId = BaseSecurityUtil.getUser().getTenantId();
        String tenantName = BaseSecurityUtil.getUser().getTenantName();
        if (tenantId == null) {
            tenantId = this.organizationProperties.getDefaultCompanyId();
        }
        if (StrUtil.isEmpty((CharSequence)tenantName)) {
            tenantName = this.organizationProperties.getDefaultCompanyName();
        }
        ArrayList<OrganiseDO> organiseDOList = new ArrayList<OrganiseDO>();
        List<Long> deptIdList = this.getDeptIDList();
        OrganiseDO all = new OrganiseDO();
        all.setOrgID(Long.valueOf(0L));
        all.setOrgName("\u6240\u6709");
        organiseDOList.add(all);
        OrganiseDO company = new OrganiseDO();
        company.setOrgID(tenantId);
        if (CollectionUtil.isNotEmpty(deptIdList)) {
            List organizations = this.iHussarBaseOrganizationBoService.findOrganizationsByIds(deptIdList);
            ArrayList organiseDOS = new ArrayList();
            organizations.forEach(f -> {
                OrganiseDO organiseDO = new OrganiseDO();
                organiseDO.setOrgID(f.getId());
                organiseDO.setOrgName(f.getOrganName());
                organiseDO.setParentOrgID(f.getParentId());
                organiseDOS.add(organiseDO);
            });
            organiseDOList.addAll(organiseDOS);
        }
        company.setOrgName(tenantName);
        if (ToolUtil.isNotEmpty((Object)tenantId) && ToolUtil.isNotEmpty((Object)tenantName)) {
            organiseDOList.add(1, company);
        }
        return organiseDOList;
    }

    private void dealDeptNamePraiseComment(PageVO<ZoneVO> pageVO, CurrentLoginUser currentLoginUser) {
        List<String> collectIds = this.zoneMapper.collectedZoneIds(currentLoginUser.getId());
        pageVO.getList().forEach(n -> {
            Set set;
            if (collectIds.contains(n.getMsgID().toString())) {
                n.setCollected(Boolean.valueOf(true));
            }
            if (StrUtil.isEmpty((CharSequence)n.getDeptName())) {
                n.setDeptName(BaseSecurityUtil.getUser().getTenantName());
            }
            if (ToolUtil.isEmpty((Object)n.getAllowPraise())) {
                n.setAllowPraise(Boolean.valueOf(true));
            }
            if (ToolUtil.isEmpty((Object)n.getAllowComment())) {
                n.setAllowComment(Boolean.valueOf(true));
            }
            if (n.getAllowPraise().booleanValue()) {
                set = this.redisTemplate.opsForZSet().range((Object)(this.zonePraiseKey() + n.getMsgID()), 0L, -1L);
                if (set == null) {
                    n.setPraise(Boolean.valueOf(false));
                } else {
                    n.setPraise(Boolean.valueOf(set.stream().map(PraiseUserVO::getUserID).collect(Collectors.toList()).contains(currentLoginUser.getId())));
                }
            }
            if (!n.getAllowPraise().booleanValue()) {
                n.setPraiseUser(null);
            }
            if (!n.getAllowComment().booleanValue()) {
                n.setComments(null);
            }
            if (n.getAllowComment().booleanValue()) {
                set = this.redisTemplate.opsForZSet().range((Object)(this.zoneCommentKey() + n.getMsgID()), 0L, -1L);
                if (set == null) {
                    n.setPraise(Boolean.valueOf(false));
                } else {
                    n.setCommented(Boolean.valueOf(set.stream().map(CommentVO::getSenderId).collect(Collectors.toList()).contains(currentLoginUser.getId())));
                }
            }
        });
    }

    public PageVO<ZoneVO> searchZone(String searchKey, PageDTO pageDTO, CurrentLoginUser currentLoginUser) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List<Long> deptIdList = this.getDeptIDList();
        deptIdList.add(currentLoginUser.getCompanyID());
        ((QueryWrapper)((QueryWrapper)queryWrapper.in((Object)"t1.DEPT_ID", deptIdList)).and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.like(!StrUtil.isEmpty((CharSequence)searchKey), (Object)"t1.BODY", (Object)StringUtil.replaceSpecialChar((String)searchKey))).or()).like(!StrUtil.isEmpty((CharSequence)searchKey), (Object)"t1.SENDER_NAME", (Object)StringUtil.replaceSpecialChar((String)searchKey));
        })).orderByDesc((Object)"t1.CREATE_TIME");
        PageDTO<Long> page = this.zoneMapper.pageZoneIds(pageDTO, (Wrapper)queryWrapper);
        PageVO pageVO = new PageVO();
        this.copyPage(page, pageVO);
        if (CollUtil.isNotEmpty((Collection)page.getList())) {
            ArrayList<ZoneVO> list = new ArrayList<ZoneVO>();
            for (Long id : page.getList()) {
                ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)id);
                zoneVO.setCommentNum(this.redisTemplate.opsForZSet().size((Object)(this.zoneCommentKey() + id)));
                zoneVO.setPraiseNum(this.redisTemplate.opsForZSet().size((Object)(this.zonePraiseKey() + id)));
                Set commentVOS = this.redisTemplate.opsForZSet().range((Object)(this.zoneCommentKey() + id), 0L, 3L);
                zoneVO.setComments(commentVOS != null ? new ArrayList(commentVOS) : new ArrayList());
                Set praiseUserVOS = this.redisTemplate.opsForZSet().range((Object)(this.zonePraiseKey() + id), 0L, 10000L);
                zoneVO.setPraiseUser(praiseUserVOS != null ? new ArrayList(praiseUserVOS) : new ArrayList());
                list.add(zoneVO);
            }
            pageVO.setList(list);
            this.dealDeptNamePraiseComment((PageVO<ZoneVO>)pageVO, currentLoginUser);
        } else {
            pageVO.setList(new ArrayList());
        }
        return pageVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> sendZone(ZoneDTO zoneDTO, CurrentLoginUser currentLoginUser) {
        ZoneDO zoneDO = new ZoneDO();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
        BeanUtils.copyProperties((Object)zoneDTO, (Object)zoneDO);
        zoneDO.setMsgTime(LocalDateTime.parse(zoneDTO.getMsgTime(), dateTimeFormatter));
        zoneDO.setAllowComment(Integer.valueOf(zoneDTO.getAllowComment() != false ? 1 : 0));
        zoneDO.setAllowPraise(Integer.valueOf(zoneDTO.getAllowPraise() != false ? 1 : 0));
        zoneDO.setTop(Integer.valueOf(zoneDTO.getTop() != false ? 1 : 0));
        ZoneDO existedZone = (ZoneDO)this.zoneMapper.selectById(zoneDO.getMsgID());
        if (existedZone != null) {
            if (!this.isLogin(currentLoginUser) || !currentLoginUser.getId().equals(existedZone.getSenderCode())) {
                return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MSG_ID", (Object)zoneDTO.getMsgID());
            this.fileService.remove((Wrapper)queryWrapper);
        }
        ArrayList zoneFileDOS = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)zoneDTO.getFileList())) {
            zoneDTO.getFileList().stream().distinct().forEach(file -> {
                ZoneFileDO zoneFileDO = new ZoneFileDO();
                zoneFileDO.setFileID(file.getFileID());
                zoneFileDO.setFilePath(file.getFilePath());
                zoneFileDO.setFileName(file.getFileName());
                zoneFileDO.setFileSize(file.getFileSize());
                zoneFileDO.setMsgID(zoneDTO.getMsgID());
                zoneFileDO.setFileType(Integer.valueOf(file.getFileType().ordinal()));
                zoneFileDO.setMd5(file.getMd5());
                zoneFileDO.setFileStatus(Integer.valueOf(0));
                zoneFileDO.setOrderTime(file.getOrderTime());
                zoneFileDO.setHeight(file.getHeight());
                zoneFileDO.setWidth(file.getWidth());
                zoneFileDOS.add(zoneFileDO);
            });
        }
        ZoneVO zoneVO = new ZoneVO();
        BeanUtils.copyProperties((Object)zoneDO, (Object)zoneVO);
        zoneVO.setFileList(zoneDTO.getFileList());
        zoneVO.setAllowComment(Boolean.valueOf(zoneDO.getAllowComment() == 1));
        zoneVO.setAllowPraise(Boolean.valueOf(zoneDO.getAllowPraise() == 1));
        zoneVO.setTop(Boolean.valueOf(1 == zoneDO.getTop()));
        zoneVO.setTypeName(this.zoneMapper.getTypeName(zoneVO.getTypeID()));
        OrganizationBo organization = this.iHussarBaseOrganizationBoService.findOrganizationById(zoneVO.getDeptID());
        Long senderCode = currentLoginUser.getId();
        zoneDO.setSenderCode(senderCode);
        zoneDO.setSenderDeptName(currentLoginUser.getDeptName());
        zoneDO.setSenderDeptID(currentLoginUser.getDeptId());
        this.saveOrUpdate(zoneDO);
        this.fileService.saveBatch(zoneFileDOS);
        zoneVO.setSenderCode(senderCode);
        zoneVO.setSenderDeptName(currentLoginUser.getDeptName());
        zoneVO.setSenderDeptID(currentLoginUser.getDeptId());
        zoneVO.setDeptID(organization.getId());
        zoneVO.setDeptName(organization.getOrganName());
        zoneVO.setMsgTime(dateTimeFormatter.format(zoneDO.getMsgTime()));
        this.redisTemplate.opsForHash().put((Object)this.zoneKey(), (Object)zoneVO.getMsgID(), (Object)zoneVO);
        return Result.succeed((Object)true);
    }

    public List<Long> getDeptIDList() {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        Long deptId = BaseSecurityUtil.getUser().getDeptId();
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        List pOrgsList = this.iHussarBaseOrganizationBoService.findParentOrganizationsByUserId(userId);
        pOrgsList.forEach(n -> deptIdList.add(n.getId()));
        if (deptIdList.size() > 1) {
            List cOrgsList = this.iHussarBaseOrganizationBoService.findOrganizationsByParentId(deptId);
            cOrgsList.forEach(n -> deptIdList.add(n.getId()));
        }
        return deptIdList;
    }

    public boolean saveZoneComment(CommentDO commentDO) {
        return this.commentMapper.insert(commentDO) > 0;
    }

    public boolean save(ZoneDO entity) {
        return super.save((Object)entity);
    }

    public boolean removeById(Serializable id) {
        int i = 0;
        while ((long)i < this.redisTemplate.opsForList().size((Object)"zoneList")) {
            ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForList().index((Object)"zoneList", (long)i);
            if (zoneVO.getMsgID().equals(id)) {
                this.redisTemplate.opsForList().remove((Object)"zoneList", (long)i, (Object)zoneVO);
                break;
            }
            ++i;
        }
        return super.removeById(id);
    }

    public boolean updateById(ZoneDO entity) {
        return super.updateById((Object)entity);
    }

    public ZoneDO getById(Serializable id) {
        return (ZoneDO)super.getById(id);
    }

    public PageDTO<ZoneVO> getManageZoneList(PageDTO pageDTO, String searchKey, Long deptID, Long typeID, CurrentLoginUser currentLoginUser) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.isAdmin(currentLoginUser)) {
            queryWrapper.eq((Object)"SENDER_CODE", currentLoginUser != null ? currentLoginUser.getId() : "");
        }
        ((QueryWrapper)((QueryWrapper)queryWrapper.like(!StrUtil.isEmpty((CharSequence)searchKey), (Object)"Z.BODY", (Object)StringUtil.replaceSpecialChar((String)searchKey))).eq(deptID != null, (Object)"Z.SENDER_DEPT_ID", (Object)deptID)).eq(typeID != null, (Object)"T.TYPE_ID", (Object)typeID);
        PageDTO<ZoneVO> page = this.zoneMapper.getManageZoneList(pageDTO, queryWrapper);
        page.getList().forEach(e -> {
            if (e.getMsgTime() != null && e.getMsgTime().length() > 19) {
                e.setMsgTime(DateUtil.parse((CharSequence)e.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS").toString("yyyy-MM-dd HH:mm:ss"));
            }
            if (e.getDeptName() == null || e.getDeptName().isEmpty()) {
                String tenantName = BaseSecurityUtil.getUser().getTenantName();
                e.setDeptName(tenantName);
            }
        });
        return page;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteZone(List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"MSG_ID", ids);
        this.fileService.removeByIds(ids);
        this.zoneMapper.delete((Wrapper)queryWrapper);
        this.commentMapper.delete((Wrapper)queryWrapper);
        this.praiseMapper.delete((Wrapper)queryWrapper);
        ArrayList<Long> zoneKeys = new ArrayList<Long>();
        ArrayList<String> commentKeys = new ArrayList<String>();
        ArrayList<String> praiseKeys = new ArrayList<String>();
        for (Long i : ids) {
            commentKeys.add(this.zoneCommentKey() + i);
            praiseKeys.add(this.zonePraiseKey() + i);
            zoneKeys.add(i);
        }
        this.redisTemplate.delete(commentKeys);
        this.redisTemplate.delete(praiseKeys);
        this.redisTemplate.opsForHash().delete((Object)this.zoneKey(), zoneKeys.toArray());
        return true;
    }

    public boolean deleteZoneComment(Long id) {
        return this.deleteZoneComment(id, null);
    }

    public List<CommentVO> getCommentList(Long msgID) {
        return this.zoneMapper.getComment(msgID);
    }

    public long count(Wrapper<ZoneDO> queryWrapper) {
        return super.count(queryWrapper);
    }

    public Result getManageZoneInfo(Long msgID) {
        long endIndex;
        long startIndex;
        Long size;
        ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)msgID);
        if (null == zoneVO) {
            return Result.failed((String)"\u8be5\u5de5\u4f5c\u5708\u5df2\u88ab\u5220\u9664");
        }
        if (zoneVO.getAllowPraise() == null || !zoneVO.getAllowPraise().booleanValue()) {
            zoneVO.setPraiseUser(null);
        } else {
            size = this.redisTemplate.opsForZSet().size((Object)(this.zonePraiseKey() + zoneVO.getMsgID()));
            if (size != null && size != 0L) {
                startIndex = 0L;
                endIndex = size - 1L;
                Set praiseUserVOS = this.redisTemplate.opsForZSet().reverseRange((Object)(this.zonePraiseKey() + zoneVO.getMsgID()), startIndex, endIndex);
                ArrayList list = praiseUserVOS != null ? new ArrayList(praiseUserVOS) : new ArrayList();
                zoneVO.setPraiseUser(list);
            }
        }
        if (zoneVO.getAllowComment() == null || !zoneVO.getAllowComment().booleanValue()) {
            zoneVO.setComments(null);
        } else {
            size = this.redisTemplate.opsForZSet().size((Object)(this.zoneCommentKey() + zoneVO.getMsgID()));
            if (size != null && size != 0L) {
                startIndex = 0L;
                endIndex = size - 1L;
                Set commentVOS = this.redisTemplate.opsForZSet().reverseRange((Object)(this.zoneCommentKey() + zoneVO.getMsgID()), startIndex, endIndex);
                ArrayList commentVOList = commentVOS != null ? new ArrayList(commentVOS) : new ArrayList();
                zoneVO.setComments(commentVOList);
            }
        }
        Long deptId = zoneVO.getDeptID();
        if (deptId != null) {
            try {
                OrganizationBo organizationBo = this.iHussarBaseOrganizationBoService.findOrganizationById(deptId);
                zoneVO.setDeptName(organizationBo.getOrganName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        zoneVO.setTypeName(((TypeDO)this.typeService.getById((Serializable)zoneVO.getTypeID())).getTypeName());
        return Result.succeed((Object)zoneVO);
    }

    public Result getZoneInfo(Long id, CurrentLoginUser currentLoginUser) {
        Set set;
        ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)id);
        if (null == zoneVO) {
            return Result.failed((String)"\u8be5\u5de5\u4f5c\u5708\u5df2\u88ab\u5220\u9664");
        }
        if (this.zoneMapper.collectedZoneIds(currentLoginUser.getId()).contains(id.toString())) {
            zoneVO.setCollected(Boolean.valueOf(true));
        }
        if (zoneVO.getAllowPraise() == null || !zoneVO.getAllowPraise().booleanValue()) {
            zoneVO.setPraiseUser(null);
        }
        if (zoneVO.getAllowPraise().booleanValue()) {
            set = this.redisTemplate.opsForZSet().range((Object)(this.zonePraiseKey() + zoneVO.getMsgID()), 0L, -1L);
            if (set == null) {
                zoneVO.setPraise(Boolean.valueOf(false));
            } else {
                zoneVO.setPraise(Boolean.valueOf(set.stream().map(PraiseUserVO::getUserID).collect(Collectors.toList()).contains(currentLoginUser.getId())));
            }
        }
        if (zoneVO.getAllowComment() == null || !zoneVO.getAllowComment().booleanValue()) {
            zoneVO.setComments(null);
        }
        if (zoneVO.getAllowComment().booleanValue()) {
            set = this.redisTemplate.opsForZSet().range((Object)(this.zoneCommentKey() + zoneVO.getMsgID()), 0L, -1L);
            if (set == null) {
                zoneVO.setCommented(Boolean.valueOf(false));
            } else {
                zoneVO.setCommented(Boolean.valueOf(set.stream().map(CommentVO::getSenderId).collect(Collectors.toList()).contains(currentLoginUser.getId())));
            }
        }
        if (StrUtil.isEmpty((CharSequence)zoneVO.getDeptName())) {
            zoneVO.setDeptName(BaseSecurityUtil.getUser().getTenantName());
        }
        return Result.succeed((Object)zoneVO);
    }

    public boolean saveOrUpdate(ZoneDO entity) {
        return super.saveOrUpdate((Object)entity);
    }

    boolean isLogin(CurrentLoginUser currentLoginUser) {
        return currentLoginUser != null;
    }

    public boolean isMine(CurrentLoginUser currentLoginUser, Long msgID) {
        if (this.isLogin(currentLoginUser)) {
            ZoneDO zoneDO = this.getById(msgID);
            return zoneDO != null && currentLoginUser.getId().equals(zoneDO.getSenderCode());
        }
        return false;
    }

    public boolean isAdmin(CurrentLoginUser currentLoginUser) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || user.getRolesList() == null) {
            return false;
        }
        List roleIdList = user.getRolesList().stream().map(Object::toString).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(roleIdList)) {
            return roleIdList.contains(this.environment.getProperty("mp.role.sysAdmin")) || roleIdList.contains(this.environment.getProperty("mp.role.jqx_admin_role"));
        }
        return false;
    }

    public List<ZoneDO> list(Wrapper<ZoneDO> queryWrapper) {
        return super.list(queryWrapper);
    }

    public List<ZoneVO> listAllZones() {
        List<ZoneVO> zoneVOS = this.zoneMapper.listAllZones();
        List<FileVO> fileVOList = this.zoneMapper.getAllFile();
        Map<Object, Object> fileListMap = new HashMap();
        if (CollectionUtil.isNotEmpty(fileVOList)) {
            fileListMap = fileVOList.stream().collect(Collectors.groupingBy(FileVO::getMsgID));
        }
        HashMap thisFileListMap = fileListMap;
        zoneVOS.stream().map(n -> {
            if (CollectionUtil.isNotEmpty((Map)thisFileListMap)) {
                List fileList = (List)thisFileListMap.get(n.getMsgID());
                n.setFileList(fileList);
            }
            return n;
        }).collect(Collectors.toList());
        List collect = zoneVOS.stream().map(ZoneVO::getDeptID).collect(Collectors.toList());
        HashSet set = new HashSet(collect);
        collect.clear();
        collect.addAll(set);
        List allOrgList = this.organizationBoService.getAllOrgList();
        List collect1 = allOrgList.stream().map(SysStru::getId).collect(Collectors.toList());
        List allExsitOrgList = collect.stream().filter(m -> collect1.contains(m)).collect(Collectors.toList());
        List organizations = this.iHussarBaseOrganizationBoService.findOrganizationsByIds(allExsitOrgList);
        return zoneVOS.stream().peek(z -> organizations.stream().filter(o -> o.getId().equals(z.getDeptID())).forEach(f -> z.setDeptName(f.getOrganName()))).collect(Collectors.toList());
    }

    public List<PraiseUserVO> listPraiseUserByZoneId(Long zoneId) {
        List<Object> praiseUserVOS = this.zoneMapper.listPraiseUserByZoneId(zoneId);
        List userIds = praiseUserVOS.stream().map(PraiseUserVO::getUserID).collect(Collectors.toList());
        Map userInfo = this.userBoService.getUserInfo(userIds);
        Collection sysUsers = userInfo.values();
        if (HussarUtils.isNotEmpty(sysUsers)) {
            praiseUserVOS = praiseUserVOS.stream().peek(m -> sysUsers.stream().filter(s -> m.getUserID().equals(s.getId())).forEach(s -> m.setUserName(s.getUserName()))).collect(Collectors.toList());
        }
        return praiseUserVOS;
    }

    public List<CommentVO> listCommentByZoneId(Long zoneId) {
        return this.zoneMapper.listCommentByZoneId(zoneId);
    }

    public CommentVO getCommentById(Long id) {
        return this.zoneMapper.getCommentById(id);
    }

    public PraiseUserVO getPraiseUserVO(Long uid, Long zoneId) {
        return this.zoneMapper.getPraiseUserVO(uid, zoneId);
    }

    public ZoneVO getZoneVO(Long id) {
        ZoneVO zoneVO = this.zoneMapper.getZoneVO(id);
        try {
            OrganizationBo organization = this.iHussarBaseOrganizationBoService.findOrganizationById(zoneVO.getDeptID());
            zoneVO.setDeptName(organization.getOrganName());
        }
        catch (Exception e) {
            String tenantName = BaseSecurityUtil.getUser().getTenantName();
            zoneVO.setDeptName(tenantName);
        }
        return zoneVO;
    }

    public PageVO<ZoneVO> listZone(PageDTO pageDTO, CurrentLoginUser currentLoginUser, Long deptID, Long typeID) {
        PageDTO<Long> page;
        List<Long> deptIdList = this.getDeptIDList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(typeID != null && typeID != -1L, (Object)"t1.TYPE_ID", (Object)typeID);
        queryWrapper.orderByDesc((Object)"t1.TOP", (Object[])new String[]{"t1.CREATE_TIME"});
        PageVO pageVO = new PageVO();
        if (deptID == null || deptID == 0L) {
            deptIdList.add(currentLoginUser.getCompanyID());
            page = this.zoneMapper.pageZoneIds(pageDTO, (Wrapper)queryWrapper);
        } else {
            if (ApiConstants.DEFAULT_ROOT_DEPT_ID != deptID) {
                queryWrapper.eq((Object)"t1.DEPT_ID", (Object)deptID);
            }
            page = this.zoneMapper.pageZoneIds(pageDTO, (Wrapper)queryWrapper);
        }
        this.copyPage(page, pageVO);
        if (CollUtil.isNotEmpty((Collection)page.getList())) {
            ArrayList<ZoneVO> list = new ArrayList<ZoneVO>();
            for (Long id : page.getList()) {
                ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)id);
                if (zoneVO == null) {
                    this.zoneListToRedis();
                    zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneKey(), (Object)id);
                }
                long commentCount = this.redisTemplate.opsForZSet().size((Object)(this.zoneCommentKey() + id));
                zoneVO.setCommentNum(Long.valueOf(commentCount));
                if (commentCount == 0L) {
                    zoneVO.setComments(new ArrayList());
                } else {
                    zoneVO.setComments(new ArrayList(this.redisTemplate.opsForZSet().reverseRange((Object)(this.zoneCommentKey() + id), 0L, 2L)));
                }
                long praiseCount = this.redisTemplate.opsForZSet().size((Object)(this.zonePraiseKey() + id));
                zoneVO.setPraiseNum(Long.valueOf(praiseCount));
                if (praiseCount == 0L) {
                    zoneVO.setPraiseUser(new ArrayList());
                } else {
                    zoneVO.setPraiseUser(new ArrayList(this.redisTemplate.opsForZSet().reverseRange((Object)(this.zonePraiseKey() + id), 0L, 10000L)));
                }
                list.add(zoneVO);
            }
            pageVO.setList(list);
            this.dealDeptNamePraiseComment((PageVO<ZoneVO>)pageVO, currentLoginUser);
        } else {
            pageVO.setList(new ArrayList());
        }
        pageVO.setLastTime(DateUtil.now());
        return pageVO;
    }

    public long getUnreadMessage(String lastTime, CurrentLoginUser currentLoginUser) {
        ArrayList<Long> allDeptID = new ArrayList<Long>();
        allDeptID.add(currentLoginUser.getDeptId());
        this.iHussarBaseOrganizationBoService.findParentOrganizationsByUserId(BaseSecurityUtil.getUser().getUserId()).forEach(organiseDO -> allDeptID.add(organiseDO.getId()));
        this.iHussarBaseOrganizationBoService.findOrganizationsByParentId(BaseSecurityUtil.getUser().getDeptId()).forEach(organiseDO -> allDeptID.add(organiseDO.getId()));
        allDeptID.add(currentLoginUser.getCompanyID());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isEmpty((CharSequence)lastTime)) {
            queryWrapper.gt((Object)"CREATE_TIME", (Object)DateUtil.lastWeek().toString());
        } else {
            queryWrapper.gt((Object)"CREATE_TIME", (Object)lastTime);
        }
        queryWrapper.in((Object)"DEPT_ID", allDeptID);
        return this.count((Wrapper<ZoneDO>)queryWrapper);
    }

    private void copyPage(PageDTO pageDTO, PageVO pageVO) {
        pageVO.setPageCount(pageDTO.getPageCount());
        pageVO.setPageSize(pageDTO.getPageSize());
        pageVO.setPageNum(pageDTO.getPageNum());
    }

    private void zoneListToRedis() {
        String tenantId = String.valueOf(BaseSecurityUtil.getUser().getTenantId());
        String zoneKey = "zone";
        String commentKey = "zoneComment:";
        String praiseKey = "zonePraise:";
        for (ZoneVO z : this.zoneService.listAllZones()) {
            List praiseUserVOS;
            this.redisTemplate.opsForHash().put((Object)zoneKey, (Object)z.getMsgID(), (Object)z);
            List commentVOS = this.zoneService.listCommentByZoneId(z.getMsgID());
            if (CollUtil.isNotEmpty((Collection)commentVOS)) {
                this.redisTemplate.opsForZSet().add((Object)(commentKey + z.getMsgID()), new HashSet(commentVOS));
            }
            if (!CollUtil.isNotEmpty((Collection)(praiseUserVOS = this.zoneService.listPraiseUserByZoneId(z.getMsgID())))) continue;
            this.redisTemplate.opsForZSet().add((Object)(praiseKey + z.getMsgID()), new HashSet(praiseUserVOS));
        }
    }
}

