/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.search.CommentVO;
import com.jxdinfo.mp.common.model.zone.PraiseUserVO;
import com.jxdinfo.mp.common.model.zone.ZoneVO;
import com.jxdinfo.mp.zone.dao.CommentMapper;
import com.jxdinfo.mp.zone.model.type.TypeDO;
import com.jxdinfo.mp.zone.model.type.TypeDTO;
import com.jxdinfo.mp.zone.model.zone.CommentDO;
import com.jxdinfo.mp.zone.model.zone.OrganiseDO;
import com.jxdinfo.mp.zone.model.zone.PraiseDO;
import com.jxdinfo.mp.zone.model.zone.ZoneDO;
import com.jxdinfo.mp.zone.model.zone.ZoneDTO;
import com.jxdinfo.mp.zone.service.TypeService;
import com.jxdinfo.mp.zone.service.ZoneService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5de5\u4f5c\u5708\u76f8\u5173\u64cd\u4f5c"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/zones"})
public class ZoneController {
    @Resource
    private ZoneService zoneService;
    @Resource
    private TypeService typeService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private CommentMapper commentMapper;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868,J_Z_0001")
    @GetMapping(value={"/list"})
    public Result<PageVO<ZoneVO>> getZoneList(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(required=false) @ApiParam(value="\u90e8\u95e8id") Long deptID, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578bid") Long typeID, @RequestParam(defaultValue="10") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.zoneService.getZoneList(pageDTO, currentLoginUser, deptID, typeID));
    }

    @ApiOperation(value="\u6839\u636e\u90e8\u95e8id\u83b7\u53d6\u5de5\u4f5c\u5708\u7c7b\u578b\u5217\u8868,J_Z_0002")
    @GetMapping(value={"/type/{id}"})
    @ResponseBody
    public Result<List<TypeDO>> getZoneTypeInfo(@PathVariable(value="id") @ApiParam(value="\u5de5\u4f5c\u5708\u7c7b\u578bid") Long deptID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"DEPT_ID", (Object)deptID)).orderByAsc((Object)"SHOW_ORDER");
        return Result.succeed((Object)this.typeService.list((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u65b0\u589e\u3001\u7f16\u8f91\u5de5\u4f5c\u5708,J_Z_0004")
    @PostMapping(value={"log"})
    public Result<Boolean> sendZone(@RequestBody @ApiParam(value="\u5de5\u4f5c\u5708\u4f20\u8f93\u5bf9\u8c61") ZoneDTO zoneDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        zoneDTO.setSenderDeptID(currentLoginUser.getDeptId());
        zoneDTO.setSenderDeptName(currentLoginUser.getDeptName());
        return this.zoneService.sendZone(zoneDTO, currentLoginUser);
    }

    @ApiOperation(value="\u65b0\u589e\u5de5\u4f5c\u5708\u7c7b\u578b,J_Z_0005")
    @PostMapping(value={"/type"})
    @ResponseBody
    public Result<Boolean> addZoneType(@RequestBody @ApiParam(value="\u5de5\u4f5c\u5708\u7c7b\u578b\u4f20\u8f93\u5bf9\u8c61") TypeDTO typeDTO) {
        TypeDO typeDO = new TypeDO();
        BeanUtils.copyProperties((Object)typeDTO, (Object)typeDO);
        QueryWrapper queryWrapper = new QueryWrapper();
        typeDO.setShowOrder(Integer.valueOf((int)this.typeService.count((Wrapper)queryWrapper)));
        typeDO.setTypeID(Long.valueOf(IdWorker.getId((Object)typeDO)));
        return Result.succeed((Object)this.typeService.save((Object)typeDO));
    }

    @ApiOperation(value="\u5de5\u4f5c\u5708\u641c\u7d22,J_Z_0006")
    @GetMapping(value={"/searches"})
    public Result<PageVO<ZoneVO>> searchZone(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u6761\u4ef6") String searchKey, @RequestParam(defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.zoneService.searchZone(searchKey, pageDTO, currentLoginUser));
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5de5\u4f5c\u5708,J_Z_0007")
    @PostMapping(value={"/deleteZone/{id}"})
    public Result<Boolean> deleteZone(@PathVariable(value="id") @ApiParam(value="\u5de5\u4f5c\u5708id") Long msgID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        if (this.zoneService.isMine(currentLoginUser, msgID)) {
            return Result.succeed((Object)this.zoneService.deleteZone(msgID));
        }
        return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
    }

    @ApiOperation(value="\u6839\u636emsgID,top\u5de5\u4f5c\u5708\u7f6e\u9876\u6216\u53d6\u6d88\u7f6e\u9876,J_Z_0008 J_Z_0009")
    @PostMapping(value={"/top/{id}"})
    public Result<Boolean> setTopStatus(@PathVariable(value="id") @ApiParam(value="\u5de5\u4f5c\u5708id") Long msgID, @RequestParam @ApiParam(value="\u5de5\u4f5c\u5708\u662f\u5426\u7f6e\u9876") int top) {
        ZoneDO zoneDO = new ZoneDO();
        zoneDO.setMsgID(msgID);
        zoneDO.setTop(Integer.valueOf(top));
        this.zoneService.updateById((Object)zoneDO);
        ZoneVO zoneVO = (ZoneVO)this.redisTemplate.opsForHash().get((Object)this.zoneService.zoneKey(), (Object)msgID);
        zoneVO.setTop(Boolean.valueOf(top == 1));
        this.redisTemplate.opsForHash().put((Object)this.zoneService.zoneKey(), (Object)msgID, (Object)zoneVO);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u6839\u636euserID\u83b7\u53d6\u53d1\u9001\u5de5\u4f5c\u5708\u6743\u9650,J_Z_0010")
    @GetMapping(value={"/permission"})
    public Result<List<Map<String, String>>> getZoneSendPermission() {
        return Result.succeed((Object)this.zoneService.getZoneSendPermission());
    }

    @ApiOperation(value="\u6839\u636euserID\u83b7\u53d6\u90e8\u95e8\u5217\u8868,J_Z_0011")
    @GetMapping(value={"/dept"})
    public Result<List<OrganiseDO>> getDepartmentList() {
        return Result.succeed((Object)this.zoneService.getDepartmentList());
    }

    @ApiOperation(value="\u70b9\u8d5e/\u53d6\u6d88\u70b9\u8d5e,J_Z_0012")
    @PostMapping(value={"/praise/{id}"})
    public Result<Boolean> setPraiseStatus(@PathVariable(value="id") @ApiParam(value="\u5de5\u4f5c\u5708\u6d88\u606fid") Long msgID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam @ApiParam(value="\u662f\u5426\u70b9\u8d5e") String praise) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
        if ("1".equals(praise)) {
            if (this.zoneService.getZonePraise(msgID, currentLoginUser.getId()) > 0L) {
                return Result.succeed((Object)false);
            }
            LocalDateTime thisTime = LocalDateTime.now();
            String nowStr = thisTime.format(df);
            PraiseDO praiseDO = new PraiseDO();
            praiseDO.setMsgID(msgID);
            praiseDO.setUserID(currentLoginUser.getId());
            praiseDO.setCreateTime(thisTime);
            PraiseUserVO praiseUserVO = new PraiseUserVO();
            BeanUtils.copyProperties((Object)praiseDO, (Object)praiseUserVO);
            praiseUserVO.setUserName(currentLoginUser.getUserName());
            this.zoneService.saveZonePraise(praiseDO);
            praiseUserVO.setCreateTime(nowStr);
            this.redisTemplate.opsForZSet().add((Object)(this.zoneService.zonePraiseKey() + msgID), (Object)praiseUserVO, praiseUserVO.getScore().doubleValue());
            return Result.succeed((Object)true);
        }
        PraiseUserVO praiseUserVO = this.zoneService.getPraiseUserVO(currentLoginUser.getId(), msgID);
        if (praiseUserVO == null) {
            return Result.succeed((Object)true);
        }
        this.zoneService.deleteZonePraise(msgID, currentLoginUser.getId());
        this.redisTemplate.opsForZSet().remove((Object)(this.zoneService.zonePraiseKey() + msgID), new Object[]{praiseUserVO});
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u5de5\u4f5c\u5708\u6d88\u606f\u8bc4\u8bba,J_Z_0013")
    @PostMapping(value={"/comment"})
    public Result addZoneComment(@RequestParam @ApiParam(value="\u5de5\u4f5c\u5708ID") Long msgID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam @ApiParam(value="\u8bc4\u8bba\u5185\u5bb9") String comment, @RequestParam(required=false) @ApiParam(value="\u88ab\u8bc4\u8bba\u7684\u8bc4\u8bbaID") Long targetCommentID) {
        CommentDO targetCommentDO;
        CommentDO commentDO = new CommentDO();
        commentDO.setComment(comment);
        commentDO.setSenderID(currentLoginUser.getId());
        commentDO.setSenderName(currentLoginUser.getUserName());
        commentDO.setMsgID(msgID);
        commentDO.setTargetCommentID(targetCommentID);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
        String nowStr = now.format(df);
        commentDO.setCreateTime(now);
        this.zoneService.saveZoneComment(commentDO);
        CommentVO commentVO = new CommentVO();
        commentVO.setMsgID(msgID);
        commentVO.setComment(comment);
        commentVO.setSenderId(commentDO.getSenderID());
        commentVO.setSenderName(commentDO.getSenderName());
        if (commentDO.getTargetCommentID() != null && (targetCommentDO = (CommentDO)this.commentMapper.selectById(commentDO.getTargetCommentID())) != null) {
            commentVO.setReceiverId(targetCommentDO.getSenderID());
            commentVO.setReceiverName(targetCommentDO.getSenderName());
        }
        commentVO.setTargetCommentId(commentDO.getTargetCommentID());
        commentVO.setCreateTime(nowStr);
        commentVO.setCommentId(commentDO.getCommentID());
        this.redisTemplate.opsForZSet().add((Object)(this.zoneService.zoneCommentKey() + msgID), (Object)commentVO, commentVO.getScore().doubleValue());
        return Result.succeed((Object)commentDO.getCommentID(), (String)"");
    }

    @ApiOperation(value="\u6839\u636ecommentID,userID\u5220\u9664\u5de5\u4f5c\u5708\u8bc4\u8bba,J_Z_0014")
    @PostMapping(value={"/deleteZoneComment/{id}"})
    public Result<Boolean> deleteZoneComment(@PathVariable(value="id") @ApiParam(value="\u8bc4\u8bba\u7684id") Long commentID, @RequestParam @ApiParam(value="\u5220\u9664\u4eba\u7684id") Long userID) {
        return Result.succeed((Object)this.zoneService.deleteZoneComment(commentID, userID));
    }

    @ApiOperation(value="\u6839\u636elastTime\uff0cuserId\u83b7\u53d6\u83b7\u53d6\u5de5\u4f5c\u5708\u672a\u8bfb\u6761\u6570,J_Z_0016")
    @GetMapping(value={"/unread"})
    public Result<String> getUnreadMessage(@RequestParam(required=false) @ApiParam(value="\u4e0a\u6b21\u67e5\u770b\u65f6\u95f4") String lastTime, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        long zoneCount = this.zoneService.getUnreadMessage(lastTime, currentLoginUser);
        return Result.succeed((Object)String.valueOf(zoneCount), (String)"");
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u8bc4\u8bba,J_Z_0017")
    @GetMapping(value={"/comment"})
    public Result<List<CommentVO>> getCommentList(@RequestParam @ApiParam(value="\u5de5\u4f5c\u5708id") Long msgID) {
        return Result.succeed((Object)this.zoneService.getCommentList(msgID));
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u8bc4\u8bba\u5217\u8868,J_Z_0018")
    @GetMapping(value={"/{id}/comments"})
    public Result<PageDTO<CommentVO>> getCommentPage(@PathVariable(value="id") @ApiParam(value="\u641c\u7d22\u6761\u4ef6") String zoneID, @RequestParam(defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        Long size = this.redisTemplate.opsForZSet().size((Object)(this.zoneService.zoneCommentKey() + zoneID));
        if (size != null && size != 0L) {
            pageDTO.setTotal(size.longValue());
            long startIndex = (pageNum - 1) * pageSize;
            long endIndex = startIndex + (long)pageSize;
            Set commentVOS = this.redisTemplate.opsForZSet().reverseRange((Object)(this.zoneService.zoneCommentKey() + zoneID), startIndex, endIndex);
            ArrayList commentVOList = commentVOS != null ? new ArrayList(commentVOS) : new ArrayList();
            pageDTO.setList(commentVOList);
            return Result.succeed((Object)pageDTO);
        }
        pageDTO.setRecords(new ArrayList());
        return Result.succeed((Object)pageDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u70b9\u8d5e\u5217\u8868,J_Z_0019")
    @GetMapping(value={"/{id}/praises"})
    public Result<PageDTO<PraiseUserVO>> getPraisePage(@PathVariable(value="id") @ApiParam(value="\u5de5\u4f5c\u5708id") String zoneID, @RequestParam(defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        Long size = this.redisTemplate.opsForZSet().size((Object)(this.zoneService.zonePraiseKey() + zoneID));
        if (size != null && size != 0L) {
            pageDTO.setTotal(size.longValue());
            long startIndex = (pageNum - 1) * pageSize;
            long endIndex = startIndex + (long)pageSize;
            Set praiseUserVOS = this.redisTemplate.opsForZSet().reverseRange((Object)(this.zoneService.zonePraiseKey() + zoneID), startIndex, endIndex);
            ArrayList list = praiseUserVOS != null ? new ArrayList(praiseUserVOS) : new ArrayList();
            pageDTO.setList(list);
            return Result.succeed((Object)pageDTO);
        }
        pageDTO.setList(new ArrayList());
        return Result.succeed((Object)pageDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u8be6\u60c5")
    @GetMapping(value={"{id}"})
    public Result<ZoneVO> getZoneInfo(@PathVariable @ApiParam(value="\u5de5\u4f5c\u5708ID") Long id, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return this.zoneService.getZoneInfo(id, currentLoginUser);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868,J_Z_0020")
    @GetMapping(value={"/list/zone"})
    public Result<PageVO<ZoneVO>> listZone(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(required=false) @ApiParam(value="\u90e8\u95e8id") Long deptID, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578bid") Long typeID, @RequestParam(defaultValue="10") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.zoneService.listZone(pageDTO, currentLoginUser, deptID, typeID));
    }
}

