/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.ueditor;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class ConfigManager {
    private final String rootPath;
    private final String originalPath;
    private final String contextPath;
    private static final String configFileName = "config.json";
    private String parentPath = null;
    private JSONObject jsonConfig = null;
    private static final String SCRAWL_FILE_NAME = "scrawl";
    private static final String REMOTE_FILE_NAME = "remote";

    private ConfigManager(String rootPath, String contextPath, String uri) throws FileNotFoundException, IOException {
        this.rootPath = rootPath = rootPath.replace("\\", "/");
        this.contextPath = contextPath;
        this.originalPath = contextPath.length() > 0 ? this.rootPath + uri.substring(contextPath.length()) : this.rootPath + uri;
        this.initEnv();
    }

    public static ConfigManager getInstance(String rootPath, String contextPath, String uri) {
        try {
            return new ConfigManager(rootPath, contextPath, uri);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public JSONObject getAllConfig() {
        return this.jsonConfig;
    }

    public Map<String, Object> getConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String savePath = null;
        switch (type) {
            case 4: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong((Object)"fileMaxSize"));
                conf.put("allowFiles", this.getArray("fileAllowFiles"));
                conf.put("fieldName", this.jsonConfig.get((Object)"fileFieldName"));
                savePath = (String)this.jsonConfig.get((Object)"filePathFormat");
                break;
            }
            case 1: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.jsonConfig.getLong((Object)"imageMaxSize"));
                conf.put("allowFiles", this.getArray("imageAllowFiles"));
                conf.put("fieldName", this.jsonConfig.get((Object)"imageFieldName"));
                savePath = (String)this.jsonConfig.get((Object)"imagePathFormat");
                break;
            }
            case 3: {
                conf.put("maxSize", this.jsonConfig.getLong((Object)"videoMaxSize"));
                conf.put("allowFiles", this.getArray("videoAllowFiles"));
                conf.put("fieldName", this.jsonConfig.get((Object)"videoFieldName"));
                savePath = (String)this.jsonConfig.get((Object)"videoPathFormat");
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", this.jsonConfig.getLong((Object)"scrawlMaxSize"));
                conf.put("fieldName", this.jsonConfig.get((Object)"scrawlFieldName"));
                conf.put("isBase64", "true");
                savePath = (String)this.jsonConfig.get((Object)"scrawlPathFormat");
                break;
            }
            case 5: {
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", this.getArray("catcherLocalDomain"));
                conf.put("maxSize", this.jsonConfig.getLong((Object)"catcherMaxSize"));
                conf.put("allowFiles", this.getArray("catcherAllowFiles"));
                conf.put("fieldName", this.jsonConfig.get((Object)"catcherFieldName") + "[]");
                savePath = (String)this.jsonConfig.get((Object)"catcherPathFormat");
                break;
            }
            case 7: {
                conf.put("allowFiles", this.getArray("imageManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.get((Object)"imageManagerListPath"));
                conf.put("count", this.jsonConfig.getInt((Object)"imageManagerListSize"));
                break;
            }
            case 6: {
                conf.put("allowFiles", this.getArray("fileManagerAllowFiles"));
                conf.put("dir", this.jsonConfig.get((Object)"fileManagerListPath"));
                conf.put("count", this.jsonConfig.getInt((Object)"fileManagerListSize"));
            }
        }
        conf.put("savePath", savePath);
        conf.put("rootPath", this.rootPath);
        return conf;
    }

    private void initEnv() throws FileNotFoundException, IOException {
        File file = new File(this.originalPath);
        if (!file.isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        this.parentPath = file.getParent();
        String configContent = this.readFile(this.getConfigPath());
        try {
            JSONObject jsonConfig;
            this.jsonConfig = jsonConfig = new JSONObject((Object)configContent);
        }
        catch (Exception e) {
            this.jsonConfig = null;
        }
    }

    private String getConfigPath() {
        return this.parentPath + File.separator + configFileName;
    }

    private String[] getArray(String key) {
        JSONArray jsonArray = this.jsonConfig.getJSONArray((Object)key);
        String[] result = new String[jsonArray.size()];
        int len = jsonArray.size();
        for (int i = 0; i < len; ++i) {
            result[i] = (String)jsonArray.get(i);
        }
        return result;
    }

    private String readFile(String path) throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
            BufferedReader bfReader = new BufferedReader(reader);
            String tmpContent = null;
            while ((tmpContent = bfReader.readLine()) != null) {
                builder.append(tmpContent);
            }
            bfReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.filter(builder.toString());
    }

    private String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }
}

