/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.service.IIMService;
import javax.annotation.Resource;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class ReceiptMessageConsumer {
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired(required=false)
    private IIMService iimService;
    @Resource
    RedisTemplate redisTemplate;

    @JmsListener(destination="eimv5_ReceiptQueue")
    public void receiptMessageConsumer(ActiveMQTextMessage msgObject) throws JMSException {
        if (msgObject.getText() == null) {
            return;
        }
        EventMsgBean eventMsgBean = (EventMsgBean)JSON.parseObject((String)msgObject.getText(), EventMsgBean.class);
        Long eventMsgTime = Long.valueOf(eventMsgBean.getEventTime());
        if (eventMsgBean.getMode().equals((Object)BaseMsgBean.Mode.GROUPCHAT)) {
            this.iimService.updateGroupUserReceipt(eventMsgBean);
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userID").is((Object)eventMsgBean.getSenderCode()).and("objID").is((Object)eventMsgBean.getObjID()).and("type").is((Object)"read").and("mode").is((Object)String.valueOf(eventMsgBean.getMode().ordinal())));
        Update update = Update.update((String)"time", (Object)eventMsgTime).set("userID", (Object)eventMsgBean.getSenderCode()).set("objID", (Object)eventMsgBean.getObjID()).set("mode", (Object)String.valueOf(eventMsgBean.getMode().ordinal())).set("type", (Object)"read");
        this.mongoTemplate.upsert(query, (UpdateDefinition)update, "userTime");
        if (eventMsgBean.getEventType().equals((Object)EventMsgBean.EventType.OPENWINDOW)) {
            // empty if block
        }
    }
}

