/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.util;

import cn.hutool.core.util.StrUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialUtil {
    private static final Logger log = LoggerFactory.getLogger(InitialUtil.class);

    public static String generateInitials(String chinese) {
        StringBuilder pybf = new StringBuilder();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char c : arr) {
            if (c > '\u0080') {
                try {
                    String[] toHyPyStr = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                    if (toHyPyStr == null || toHyPyStr.length <= 0) continue;
                    pybf.append(toHyPyStr[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    log.info(e.getMessage());
                }
                continue;
            }
            pybf.append(c);
        }
        return pybf.toString().replaceAll("\\W", "").trim().toUpperCase();
    }

    public static String fullPinyin(String chinese) {
        if (StrUtil.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder pybf = new StringBuilder();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char c : arr) {
            if (c > '\u0080') {
                try {
                    String[] toHyPyStr = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                    if (toHyPyStr != null && toHyPyStr.length > 0) {
                        pybf.append(toHyPyStr[0]).append("-");
                        continue;
                    }
                    pybf.append(c);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    log.info(e.getMessage());
                }
                continue;
            }
            pybf.append(c);
        }
        if (pybf.substring(pybf.length() - 1).equals("-")) {
            return pybf.toString().trim().toUpperCase().substring(0, pybf.length() - 1);
        }
        return pybf.toString().trim().toUpperCase();
    }
}

