/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.mp.common.model.EimUserVO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.organization.dao.UserMapperJqx;
import com.jxdinfo.mp.organization.service.UserCacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class UserCacheServiceImpl
implements UserCacheService {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private Environment environment;
    @Resource
    private UserMapperJqx userMapperJqx;
    @Resource
    private RedisTemplate redisTemplate;

    public String getUserState(String userStateRedisKey) {
        ValueOperations opt = this.stringRedisTemplate.opsForValue();
        return opt.get((Object)userStateRedisKey) + "";
    }

    public List<EimUserVO> getRosterDTOListState(List<EimUserVO> eimUserList) {
        String userStateSetting = this.environment.getProperty("mp.organization.userState.setting");
        if (!eimUserList.isEmpty() && "true".equals(userStateSetting)) {
            ArrayList<Long> userIDList = new ArrayList<Long>();
            StringBuilder userIDs = new StringBuilder();
            eimUserList.forEach(eimUser -> {
                Long userID = eimUser.getId();
                String userState = this.getUserState("Onlinestate:" + userID);
                if ("online".equals(userState)) {
                    eimUser.setUserState("1");
                } else {
                    userIDList.add(userID);
                    userIDs.append(userID).append(",");
                }
            });
            List<String> channelUserIDList = this.userMapperJqx.getChannelUserIds(userIDList);
            StringBuilder channelUserIDs = new StringBuilder();
            channelUserIDList.forEach(channelUserID -> channelUserIDs.append((String)channelUserID).append(","));
            eimUserList.forEach(rosterVO -> {
                Long userID = rosterVO.getId();
                if (channelUserIDs.toString().contains(String.valueOf(userID))) {
                    rosterVO.setUserState("2");
                } else if (userIDs.toString().contains(String.valueOf(userID))) {
                    rosterVO.setUserState("3");
                }
            });
        }
        return eimUserList;
    }

    public List<RosterVO> getRosterVoListState(List<RosterVO> eimUserList) {
        String userStateSetting = this.environment.getProperty("mp.organization.userState.setting");
        if (!eimUserList.isEmpty() && "true".equals(userStateSetting)) {
            ArrayList<Long> userIDList = new ArrayList<Long>();
            StringBuilder userIDs = new StringBuilder();
            eimUserList.forEach(eimUser -> {
                Long userID = eimUser.getUserId();
                String userState = this.getUserState("Onlinestate:" + userID);
                if ("online".equals(userState)) {
                    eimUser.setUserState("1");
                } else {
                    userIDList.add(userID);
                    userIDs.append(userID).append(",");
                }
            });
            List<String> channelUserIDList = this.userMapperJqx.getChannelUserIds(userIDList);
            StringBuilder channelUserIDs = new StringBuilder();
            channelUserIDList.forEach(channelUserID -> channelUserIDs.append((String)channelUserID).append(","));
            eimUserList.forEach(rosterVO -> {
                Long userID = rosterVO.getUserId();
                if (channelUserIDs.toString().contains(String.valueOf(userID))) {
                    rosterVO.setUserState("2");
                } else if (userIDs.toString().contains(String.valueOf(userID))) {
                    rosterVO.setUserState("3");
                }
            });
        }
        return eimUserList;
    }

    public boolean clearUserAll() {
        String key = "users:";
        this.redisTemplate.delete((Object)key);
        return true;
    }

    public void delete(String key) {
        key = "eim_cache:" + key;
        if (key.endsWith(":")) {
            this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)(key + "*")));
        } else {
            this.redisTemplate.delete((Object)key);
        }
    }
}

