/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.im.service.IIMService;
import com.jxdinfo.mp.organization.feign.EimPubPlatService2;
import com.jxdinfo.mp.organization.model.SearchVO;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.IPubPlatService;
import com.jxdinfo.mp.organization.service.SearchService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    public static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    @Resource
    private ContactService contactService;
    @Resource
    private IIMService imService;
    @Resource
    private EimPubPlatService2 eimPubPlatService2;
    @Resource
    private IPubPlatService pubPlatService;

    public Result<SearchVO> searchOverAll(String searchKey, String platform, String deviceType, int size, CurrentLoginUser currentLoginUser) {
        SearchVO searchVO = new SearchVO();
        PageVO rosterVOPageVO = new PageVO();
        rosterVOPageVO.setPageNum(Integer.valueOf(1));
        rosterVOPageVO.setPageSize(Integer.valueOf(size));
        PageDTO pageDTO = new PageDTO();
        BeanUtils.copyProperties((Object)rosterVOPageVO, (Object)pageDTO);
        long start1 = System.currentTimeMillis();
        pageDTO = this.contactService.searchContact(searchKey, IMConstants.DEFAULT_COMPANY_ID, pageDTO, currentLoginUser.getId());
        log.error("\u641c\u7d22\u8054\u7cfb\u4eba\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start1 + "ms"));
        BeanUtils.copyProperties((Object)pageDTO, (Object)rosterVOPageVO);
        rosterVOPageVO.setPageCount(Integer.valueOf(Integer.parseInt(String.valueOf(pageDTO.getSize()))));
        searchVO.setRosterPageVO(rosterVOPageVO);
        try {
            PageVO groupVOPageVO = new PageVO();
            groupVOPageVO.setPageNum(Integer.valueOf(1));
            groupVOPageVO.setPageSize(Integer.valueOf(size));
            long start2 = System.currentTimeMillis();
            PageDTO groupVOPageDTO = this.imService.findGroup(searchKey, groupVOPageVO.getPageNum().intValue(), groupVOPageVO.getPageSize().intValue(), currentLoginUser.getId());
            log.error("\u641c\u7d22\u7fa4\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start2 + "ms"));
            BeanUtils.copyProperties((Object)groupVOPageDTO, (Object)groupVOPageVO);
            groupVOPageVO.setPageCount(groupVOPageDTO.getPageCount());
            searchVO.setGroupPageVO(groupVOPageVO);
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u672a\u8d2d\u4e70\u529f\u80fd");
        }
        try {
            PageVO pubPlatVOPageVO = new PageVO();
            pubPlatVOPageVO.setPageNum(Integer.valueOf(1));
            pubPlatVOPageVO.setPageSize(Integer.valueOf(size));
            long start3 = System.currentTimeMillis();
            PageDTO data = this.pubPlatService.getAppListWithExtend(searchKey, platform, null, deviceType, pubPlatVOPageVO.getPageSize(), pubPlatVOPageVO.getPageNum(), currentLoginUser);
            log.error("\u641c\u7d22\u5fae\u5e94\u7528\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start3 + "ms"));
            searchVO.setApplicationExtendVoPage(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u672a\u8d2d\u4e70\u529f\u80fd");
        }
        return Result.succeed((Object)searchVO);
    }

    public Result<SearchVO> searchOverType(String searchKey, String platform, String deviceType, int type, PageVO pageVO, CurrentLoginUser currentLoginUser) {
        SearchVO searchVO = new SearchVO();
        if (type == 0) {
            PageDTO pageDTO = new PageDTO();
            BeanUtils.copyProperties((Object)pageVO, (Object)pageDTO);
            pageDTO = this.contactService.searchContact(searchKey, IMConstants.DEFAULT_COMPANY_ID, pageDTO, currentLoginUser.getId());
            BeanUtils.copyProperties((Object)pageDTO, (Object)pageVO);
            searchVO.setRosterPageVO(pageVO);
            return Result.succeed((Object)searchVO);
        }
        if (type == 1) {
            try {
                PageDTO groupVOPageDTO = this.imService.findGroup(searchKey, pageVO.getPageNum().intValue(), pageVO.getPageSize().intValue(), currentLoginUser.getId());
                BeanUtils.copyProperties((Object)groupVOPageDTO, (Object)pageVO);
                searchVO.setGroupPageVO(pageVO);
                return Result.succeed((Object)searchVO);
            }
            catch (Exception e) {
                log.info("\u8c03\u7528\u672a\u8d2d\u4e70\u529f\u80fd");
                return Result.failed((String)"\u529f\u80fd\u4e0d\u5177\u5907");
            }
        }
        if (type == 2) {
            try {
                PageDTO data = this.pubPlatService.getAppListWithExtend(searchKey, platform, null, deviceType, pageVO.getPageSize(), pageVO.getPageNum(), currentLoginUser);
                searchVO.setApplicationExtendVoPage(data);
                return Result.succeed((Object)searchVO);
            }
            catch (Exception e) {
                log.info("\u8c03\u7528\u672a\u8d2d\u4e70\u529f\u80fd");
                return Result.failed((String)"\u529f\u80fd\u4e0d\u5177\u5907");
            }
        }
        return Result.failed((String)"\u7c7b\u578b\u53c2\u6570\u4e0d\u6b63\u786e");
    }
}

