/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.RosterDO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.organization.dao.LinkManMapper;
import com.jxdinfo.mp.organization.dao.SysUserJqxMapper;
import com.jxdinfo.mp.organization.dao.UserMapperJqx;
import com.jxdinfo.mp.organization.dao.UserMessageMapper;
import com.jxdinfo.mp.organization.model.WorkExperienceDTO;
import com.jxdinfo.mp.organization.model.linkman.LinkManDO;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.model.mobileuser.UserVO;
import com.jxdinfo.mp.organization.service.LinkManForMybatisService;
import com.jxdinfo.mp.organization.service.LinkManService;
import com.jxdinfo.mp.organization.service.UserCacheService;
import com.jxdinfo.mp.organization.service.UserService;
import com.jxdinfo.mp.zone.commen.ApiConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class LinkManServiceImpl
extends ServiceImpl<LinkManMapper, LinkManDO>
implements LinkManService {
    @Resource
    private LinkManMapper linkManMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    private LinkManForMybatisService linkManForMybatisService;
    @Resource
    private UserMapperJqx userMapperJqx;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private IHussarBaseStaffBoService staffBoService;
    @Resource
    private SysUserJqxMapper sysUserJqxMapper;
    @Resource
    private UserCacheService userCacheService;
    @Resource
    private UserService userService;
    @Resource
    private OrganizationProperties organizationProperties;
    @Value(value="${userInfoUrl}")
    private String userInfoUrl;
    @Value(value="${mp.role.user_role_manager}")
    private String jqxManagerRole;
    @Value(value="${mp.organization.workExperienceUrl}")
    private String workExperienceUrl;
    @Value(value="${mp.organization.workExperienceRoleId}")
    private String workExperienceRoleId;
    @Resource
    IHussarBaseOrganizationBoService iHussarBaseOrganizationBoService;
    @Resource
    UserMessageMapper userMessageMapper;

    public PageDTO<RosterVO> getLinkManList(PageInfo pageInfo, Long userID) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        PageDTO pageDTO = new PageDTO();
        pageDTO.setCurrent(pageInfo.getCurrent());
        pageDTO.setSize(pageInfo.getSize());
        PageDTO<RosterVO> linkManDOPage = this.linkManMapper.getLinkManList((PageDTO<RosterVO>)pageDTO, userID);
        if (CollectionUtil.isEmpty((Collection)linkManDOPage.getList())) {
            return linkManDOPage;
        }
        List friendIds = linkManDOPage.getList().stream().map(RosterVO::getUserId).collect(Collectors.toList());
        Map<Long, RosterVO> rosterVOMap = linkManDOPage.getList().stream().collect(Collectors.toMap(RosterVO::getUserId, rosterVO -> rosterVO));
        List staffBoList = this.staffBoService.findStaffsByUserIds(friendIds);
        if (CollectionUtil.isEmpty((Collection)staffBoList)) {
            return pageDTO;
        }
        List sysUsers = this.sysUserJqxMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, friendIds));
        Map<Long, SysUsers> sysUsersMap = sysUsers.stream().collect(Collectors.toMap(SysUsers::getEmployeeId, sysUsers1 -> sysUsers1));
        Map<Long, Integer> topManagerMap = this.userService.listByIds(friendIds).stream().collect(Collectors.toMap(RosterDO::getUserID, RosterDO::getTopManager, (v1, v2) -> v1));
        List rosterVOList = staffBoList.stream().map(sysUser -> {
            SysUsers thiSysUsers = (SysUsers)sysUsersMap.get(sysUser.getId());
            RosterVO rosterVO = (RosterVO)rosterVOMap.get(thiSysUsers.getId());
            if (CollectionUtil.isNotEmpty((Collection)sysUser.getOrganList())) {
                rosterVO.setOrganiseID(Long.valueOf(Long.parseLong(((OrganVo)sysUser.getOrganList().get(0)).getId())));
                rosterVO.setOrganiseName(((OrganVo)sysUser.getOrganList().get(0)).getLabel());
                rosterVO.setOrganList(sysUser.getOrganList());
            }
            rosterVO.setUserName(sysUser.getStaffName());
            rosterVO.setChar1(thiSysUsers.getChar1());
            String mobile = thiSysUsers.getMobile();
            if (HussarUtils.isNotEmpty((Object)topManagerMap) && 1 == (Integer)topManagerMap.get(thiSysUsers.getId())) {
                if (StringUtils.isNotEmpty((CharSequence)mobile)) {
                    rosterVO.setMobile(StringUtil.replaceSecretPhone((String)mobile));
                    rosterVO.setTelephone("****");
                }
            } else {
                rosterVO.setMobile(mobile);
            }
            return rosterVO;
        }).collect(Collectors.toList());
        PageDTO resultPage = new PageDTO();
        resultPage.setPageSize(Integer.valueOf(Integer.parseInt(String.valueOf(pageInfo.getSize()))));
        resultPage.setPageNum(Integer.valueOf(Integer.parseInt(String.valueOf(pageInfo.getCurrent()))));
        this.userCacheService.getRosterVoListState(rosterVOList);
        resultPage.setList(rosterVOList);
        resultPage.setTotal(linkManDOPage.getTotal());
        return resultPage;
    }

    public UserVO getLinkManInfo(Long userID, Long friendID) {
        SysUsers sysUsers = (SysUsers)this.sysUserJqxMapper.selectById(friendID);
        StaffBo staffByUser = this.staffBoService.findStaffByUserId(friendID);
        UserStaffVo userStaffVo = new UserStaffVo();
        BeanUtils.copyProperties((Object)staffByUser, (Object)userStaffVo);
        BeanUtils.copyProperties((Object)sysUsers, (Object)userStaffVo);
        userStaffVo.setEmail(sysUsers.geteMail());
        RosterDO rosterDO = (RosterDO)this.userService.getById((Serializable)userID);
        if (HussarUtils.isNotEmpty((Object)userStaffVo) && HussarUtils.isNotEmpty((Object)rosterDO.getTopManager()) && 1 == rosterDO.getTopManager()) {
            userStaffVo.setMobile(StringUtil.replaceSecretPhone((String)sysUsers.getMobile()));
            userStaffVo.setEmail(StringUtil.replaceSecretEmail((String)sysUsers.geteMail()));
        }
        RosterVO linkManInfo = this.linkManMapper.getLinkManInfo(BaseSecurityUtil.getUser().getUserId(), friendID);
        UserVO userVO = new UserVO();
        BeanUtils.copyProperties((Object)userStaffVo, (Object)userVO);
        userVO.setFriends(Boolean.valueOf(linkManInfo != null && linkManInfo.getFriends() != false));
        userVO.setTop(Boolean.valueOf(linkManInfo != null && linkManInfo.getTop() != false));
        userVO.setHeadImgId(linkManInfo == null ? "" : linkManInfo.getHeadImgId());
        userVO.setChar1(sysUsers.getChar1());
        return userVO;
    }

    public UserVO getContactPeopleInfo(Long friendID, CurrentLoginUser loginUser) {
        String response;
        UserVO userVO = new UserVO();
        if (IMConstants.LUOMENGYI_USER_ID.equals(friendID)) {
            userVO.setUserId(IMConstants.LUOMENGYI_USER_ID);
            userVO.setBirthday("1999-06-28");
            userVO.setGraduateDate("2021-06-30");
            userVO.setParentOrganName("\u5ba1\u6838\u90e8\u95e8");
            userVO.setWorkDate("2021-06-30");
            userVO.setStaffPosition("\u5458\u5de5");
            userVO.setStaffPositionName("\u5458\u5de5");
            userVO.setPost("\u5458\u5de5");
            userVO.setTelephone("");
            userVO.setUserName("\u9a86\u840c\u4e00");
            userVO.setMobile("18661377801");
            userVO.setWorkId("2021060137");
            userVO.setAddress("");
            userVO.setParentId(ApiConstants.DEFAULT_ROOT_DEPT_ID);
            userVO.setGraduateSchool("\u4e2d\u56fd\u77f3\u6cb9\u5927\u5b66");
            userVO.setEmail("49919086@qq.com");
            userVO.setFriends(Boolean.valueOf(false));
            userVO.setTopManager(Integer.valueOf(1));
            ArrayList<OrganVo> organVoList = new ArrayList<OrganVo>();
            OrganVo organVo = new OrganVo();
            organVo.setId("100058");
            organVo.setLabel("\u5ba1\u6838\u90e8\u95e8");
            organVoList.add(organVo);
            userVO.setOrganList(organVoList);
            return userVO;
        }
        long start1 = System.currentTimeMillis();
        userVO = this.getUserVOByUserId(friendID);
        System.out.println("\u83b7\u53d6staff\u4fe1\u606f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
        if (userVO != null && HussarUtils.isEmpty((Object)userVO.getStaffPositionName())) {
            userVO.setStaffPositionName(userVO.getStaffPosition());
        }
        List roleIDS = BaseSecurityUtil.getUser().getRolesList();
        boolean managerRole = roleIDS.contains(Long.parseLong(this.jqxManagerRole));
        CloseableHttpClient client = HttpClients.createDefault();
        String url = this.userInfoUrl + userVO.getChar1();
        HttpGet getUserInfo = new HttpGet(url);
        Object jsonObject = null;
        try {
            getUserInfo.addHeader("content-type", "text/xml");
            long start = System.currentTimeMillis();
            HttpResponse res = client.execute((HttpUriRequest)getUserInfo);
            System.out.println("\u52a0\u8f7djxd\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            response = EntityUtils.toString((HttpEntity)res.getEntity());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JSONObject data = JSONObject.parseObject((String)response).getJSONObject("data");
        if (ToolUtil.isNotEmpty((Object)data)) {
            userVO.setPost(data.getString("position"));
        }
        if (CollUtil.isEmpty((Collection)roleIDS) || !managerRole) {
            userVO.setEducation("");
            userVO.setGraMajor("");
            userVO.setGraduateSchool("");
            userVO.setGraduateDate("");
            userVO.setNativePlace("");
        } else if (ToolUtil.isNotEmpty((Object)data)) {
            userVO.setEducation(data.getString("education"));
            userVO.setGraMajor(data.getString("graMajor"));
            userVO.setGraduateSchool(data.getString("graSchool"));
            userVO.setGraduateDate(data.getString("graTime"));
            userVO.setNativePlace(data.getString("nativePlace"));
        }
        RosterVO rosterVO = this.userMapperJqx.userDetail(friendID);
        if (rosterVO != null) {
            userVO.setTopManager(rosterVO.getTopManager());
            userVO.setHeadImgId(rosterVO.getHeadImgId());
            userVO.setModifyTime(rosterVO.getModifyTime());
        } else {
            userVO.setTopManager(Integer.valueOf(0));
            userVO.setHeadImgId(null);
            userVO.setModifyTime(null);
        }
        RosterVO linkManInfo = this.linkManMapper.getLinkManInfo(BaseSecurityUtil.getUser().getUserId(), friendID);
        userVO.setFriends(Boolean.valueOf(linkManInfo != null && linkManInfo.getFriends() != false));
        userVO.setTop(Boolean.valueOf(linkManInfo != null && linkManInfo.getTop() != false));
        String birthday = userVO.getBirthday();
        if (birthday != null) {
            userVO.setBirthday(birthday.length() > 9 ? birthday.substring(0, 10) : birthday);
        }
        userVO.setUserId(friendID);
        String workDate = userVO.getWorkDate();
        if (workDate != null) {
            userVO.setWorkDate(workDate.length() > 9 ? workDate.substring(0, 10) : workDate);
        }
        if (ToolUtil.isNotEmpty((Object)userVO.getTopManager()) && 1 == userVO.getTopManager()) {
            userVO.setMobile(StringUtil.replaceSecretPhone((String)userVO.getMobile()));
            userVO.setEmail(StringUtil.replaceSecretEmail((String)userVO.getEmail()));
        }
        if (HussarUtils.isNotEmpty((Object)loginUser.getId()) && ToolUtil.isNotEmpty((Object)userVO.getTopManager()) && 1 == userVO.getTopManager()) {
            userVO.setMobile(StringUtil.replaceSecretPhone((String)userVO.getMobile()));
            userVO.setEmail(StringUtil.replaceSecretEmail((String)userVO.getEmail()));
        }
        return userVO;
    }

    public WorkExperienceDTO getWorkExperience(CurrentLoginUser loginUser) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean anyMatch = securityUser.getRolesList().contains(Long.parseLong(this.workExperienceRoleId));
        WorkExperienceDTO workExperienceDTO = new WorkExperienceDTO();
        workExperienceDTO.setWorkExperienceUrl(this.workExperienceUrl);
        workExperienceDTO.setCanReadWorkExperience(Boolean.valueOf(anyMatch));
        return workExperienceDTO;
    }

    private UserVO getUserVOByUserId(Long userId) {
        UserVO userVO = new UserVO();
        StaffBo staff = this.staffBoService.findStaffByUserId(userId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(userId);
        Map userInfo = this.userBoService.getUserInfo(ids);
        SysUsers sysUsers = (SysUsers)userInfo.get(userId);
        BeanUtil.copyProperties((Object)staff, (Object)userVO, (String[])new String[0]);
        BeanUtil.copyProperties((Object)sysUsers, (Object)userVO, (String[])new String[0]);
        userVO.setEmail(sysUsers.geteMail());
        userVO.setParentId(sysUsers.getDepartmentId());
        userVO.setChar1(sysUsers.getChar1());
        List organizationBos = this.iHussarBaseOrganizationBoService.searchOrganizationByUserId(userId);
        if (CollUtil.isNotEmpty((Collection)organizationBos)) {
            userVO.setParentOrganName(((OrganizationBo)organizationBos.get(0)).getOrganName());
        }
        return userVO;
    }

    private LambdaQueryWrapper<LinkManDO> buildQueryWrapper(Long userID, Long friendID) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(userID != null, LinkManDO::getUserID, (Object)userID)).eq(friendID != null, LinkManDO::getFriendID, (Object)friendID);
        return queryWrapper;
    }

    public Boolean addLinkMan(Long friendID, CurrentLoginUser currentLoginUser) {
        LinkManDO linkManDO = new LinkManDO();
        linkManDO.setUserID(currentLoginUser.getId());
        linkManDO.setFriendID(friendID);
        linkManDO.setIsFriend(Integer.valueOf(1));
        long flag = this.linkManMapper.selectCount((Wrapper)this.buildQueryWrapper(linkManDO.getUserID(), linkManDO.getFriendID()));
        if (flag > 0L) {
            return this.linkManMapper.update(linkManDO, (Wrapper)this.buildQueryWrapper(linkManDO.getUserID(), linkManDO.getFriendID())) > 0;
        }
        linkManDO.setIsTop(Integer.valueOf(0));
        return this.linkManMapper.insert(linkManDO) > 0;
    }

    public Boolean deleteLinkMan(Long friendID, CurrentLoginUser currentLoginUser) {
        LinkManDO linkManDO = new LinkManDO();
        linkManDO.setUserID(currentLoginUser.getId());
        linkManDO.setFriendID(friendID);
        linkManDO.setIsFriend(Integer.valueOf(0));
        return this.linkManMapper.update(linkManDO, (Wrapper)this.buildQueryWrapper(linkManDO.getUserID(), linkManDO.getFriendID())) > 0;
    }

    public Boolean updateUserTop(Long friendID, CurrentLoginUser currentLoginUser, int isTop) {
        LinkManDO linkManDO = new LinkManDO();
        linkManDO.setUserID(currentLoginUser.getId());
        linkManDO.setFriendID(friendID);
        linkManDO.setIsTop(Integer.valueOf(isTop));
        if (this.linkManMapper.selectCount((Wrapper)this.buildQueryWrapper(linkManDO.getUserID(), linkManDO.getFriendID())) > 0L) {
            return this.linkManMapper.update(linkManDO, (Wrapper)this.buildQueryWrapper(linkManDO.getUserID(), linkManDO.getFriendID())) > 0;
        }
        linkManDO.setIsFriend(Integer.valueOf(0));
        return this.linkManMapper.insert(linkManDO) > 0;
    }

    @Transactional
    public Boolean addMoreLinkMan(List<Long> friendIds, Long userID) {
        ArrayList<LinkManDO> linkManDOListForUpdate = new ArrayList<LinkManDO>();
        ArrayList<LinkManDO> linkManDOListForAdd = new ArrayList<LinkManDO>();
        List linkManDOList = this.list((Wrapper)new LambdaQueryWrapper().eq(LinkManDO::getUserID, (Object)userID));
        linkManDOList = linkManDOList.stream().filter(a -> ToolUtil.isNotEmpty((Object)a.getFriendID())).collect(Collectors.toList());
        for (Long friendId : friendIds) {
            int flag = 0;
            for (LinkManDO friend : linkManDOList) {
                if (friend.getFriendID().equals(friendId)) {
                    LinkManDO linkManDO = new LinkManDO();
                    linkManDO.setUserFriendId(friend.getUserFriendId());
                    linkManDO.setIsFriend(Integer.valueOf(1));
                    linkManDOListForUpdate.add(linkManDO);
                    break;
                }
                ++flag;
            }
            if (flag != linkManDOList.size()) continue;
            LinkManDO linkManDO = new LinkManDO();
            linkManDO.setUserFriendId(Long.valueOf(IdWorker.getId((Object)linkManDO)));
            linkManDO.setUserID(userID);
            linkManDO.setFriendID(friendId);
            linkManDO.setIsTop(Integer.valueOf(0));
            linkManDO.setIsFriend(Integer.valueOf(1));
            linkManDOListForAdd.add(linkManDO);
        }
        boolean flag = false;
        if (!linkManDOListForUpdate.isEmpty()) {
            flag = this.linkManForMybatisService.updateBatchById(linkManDOListForUpdate);
        }
        if (!linkManDOListForAdd.isEmpty()) {
            flag = this.linkManForMybatisService.saveBatch(linkManDOListForAdd);
        }
        return flag;
    }

    public List<HeadingImg> queryUserHeadFileID(List<Long> userIDs) {
        return this.linkManMapper.queryUserHeadFileID(userIDs);
    }

    public SysUsers userDetail(Long userID, Long currentUserID) {
        ArrayList<Long> lists = new ArrayList<Long>();
        lists.add(userID);
        Map userInfo = this.userBoService.getUserInfo(lists);
        return (SysUsers)userInfo.get(userID);
    }

    public SearchUserVo userDetailByUserCode(String userCode) {
        SearchUserVo searchUserVo = new SearchUserVo();
        BeanUtils.copyProperties((Object)this.sysUsersService.getOne(null, userCode, Arrays.asList("1", "2", "3", "4")), (Object)searchUserVo);
        searchUserVo.setDepartmentName(this.hussarBaseOrganizationBoService.findOrganizationById(searchUserVo.getDepartmentId()).getOrganName());
        return searchUserVo;
    }

    public List<RosterVO> getUserDetail(String userIDs) {
        return this.userMapperJqx.getUserDetail(userIDs);
    }

    public List<RosterVO> getTopFriend(Long userId, String time) {
        return this.userMessageMapper.getTopInfo(userId, time);
    }
}

