/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.mail.core.bean.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.utils.JsonUtils;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.VCardMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.util.FileTool;
import com.jxdinfo.mp.organization.dao.CollectionMapper;
import com.jxdinfo.mp.organization.model.collection.CollectionDO;
import com.jxdinfo.mp.organization.model.collection.CollectionDTO;
import com.jxdinfo.mp.organization.model.collection.ReceiverDTO;
import com.jxdinfo.mp.organization.service.CollectionService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.mp.organization.service.impl.CollectionServiceImpl")
@HussarTokenDs
public class CollectionServiceImpl
extends ServiceImpl<CollectionMapper, CollectionDO>
implements CollectionService {
    public static final Logger LOGGER = LoggerFactory.getLogger(CollectionServiceImpl.class);
    @Resource
    private CollectionMapper collectionMapper;
    @Resource
    private MessageProducerService messageProducerService;
    @Resource
    private Environment environment;
    @Value(value="mp.multi-tenant.OUT_NET_URL")
    private String URL;

    public Result<Boolean> collection(CollectionDTO collectionDTO, CurrentLoginUser loginUser) {
        String url = this.environment.getProperty(this.URL);
        CollectionDO collectionDO = new CollectionDO();
        LOGGER.info("json\u89e3\u6790\u539f\u578b{}", (Object)collectionDTO.getAssistInfo());
        JSONObject jsonObject = JSONObject.parseObject((String)collectionDTO.getAssistInfo());
        BeanUtil.copyProperties((Object)collectionDTO, (Object)collectionDO);
        if (jsonObject != null) {
            String newsType = String.valueOf(jsonObject.get((Object)"newsType"));
            String editLink = String.valueOf(jsonObject.get((Object)"editLink"));
            if ("1".equals(newsType) || "2".equals(newsType) || "0".equals(newsType) && "0".equals(editLink)) {
                jsonObject.put("url", (Object)(url + "/newsDetail.html?newsID=" + collectionDTO.getContentID()));
            }
            collectionDO.setAssistInfo(JsonUtils.encode((Object)jsonObject));
        }
        collectionDO.setUserID(loginUser.getId());
        collectionDO.setDataStatus(1);
        return Result.succeed((Object)this.save(collectionDO));
    }

    public Result<Boolean> cancelCollection(Long collectID, CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CollectionDO::getCollectID, (Object)collectID)).or()).eq(CollectionDO::getContentID, (Object)collectID)).eq(CollectionDO::getUserID, (Object)loginUser.getId())));
    }

    public Result<PageVO<CollectionDO>> getCollectionList(CurrentLoginUser loginUser, String searchKey, Integer collectType, PageInfo pageInfo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Page iPage = HussarPageUtils.convert((PageInfo)pageInfo);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(CollectionDO::getUserID, (Object)loginUser.getId())).like(HussarUtils.isNotEmpty((Object)searchKey), CollectionDO::getContent, (Object)StringUtil.replaceSpecialChar((String)searchKey))).eq(null != collectType, CollectionDO::getCollectType, (Object)collectType)).orderByDesc(HussarBaseEntity::getCreateTime);
        PageVO pageVO = new PageVO();
        Page page = (Page)this.page((IPage)iPage, (Wrapper)wrapper);
        BeanUtils.copyProperties((Object)page, (Object)pageVO);
        pageVO.setPageCount(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        pageVO.setPageSize(Integer.valueOf(Integer.parseInt(String.valueOf(page.getSize()))));
        pageVO.setPageNum(Integer.valueOf(Integer.parseInt(String.valueOf(page.getCurrent()))));
        pageVO.setList(page.getRecords());
        return Result.succeed((Object)pageVO);
    }

    public Boolean forwardCollection(CurrentLoginUser loginUser, Long collectionID, List<ReceiverDTO> receiverDTOList) {
        TextMsgBean baseMsgBean;
        CollectionDO collectionDO = (CollectionDO)this.collectionMapper.selectById(collectionID);
        if (collectionDO == null) {
            return false;
        }
        LOGGER.info("json\u89e3\u6790\u539f\u578b{}", (Object)collectionDO.getAssistInfo());
        HashMap assistInfo = (HashMap)JSON.parseObject((String)collectionDO.getAssistInfo(), HashMap.class);
        switch (collectionDO.getCollectType()) {
            case 0: {
                baseMsgBean = new TextMsgBean();
                baseMsgBean.setBody(collectionDO.getContent());
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
                break;
            }
            case 1: {
                ImgMsgBean imgMsgBean = new ImgMsgBean();
                imgMsgBean.setFileID(String.valueOf(collectionDO.getFileID()));
                imgMsgBean.setBody("[\u56fe\u7247]");
                imgMsgBean.setFileName(collectionDO.getContent());
                imgMsgBean.setFileSize((String)assistInfo.get("fileSize"));
                imgMsgBean.setWidth(Integer.valueOf((String)assistInfo.get("width")).intValue());
                imgMsgBean.setHeight(Integer.valueOf((String)assistInfo.get("height")).intValue());
                imgMsgBean.setFileStatus(ImgMsgBean.FileStatus.UPLOADSUCCESS);
                baseMsgBean = imgMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.IMAGE);
                break;
            }
            case 2: {
                FileMsgBean videoFileMsgBean = new FileMsgBean();
                videoFileMsgBean.setFileID(String.valueOf(collectionDO.getFileID()));
                videoFileMsgBean.setBody("[\u6587\u4ef6]");
                videoFileMsgBean.setFileName(collectionDO.getContent());
                videoFileMsgBean.setFileStatus(FileMsgBean.FileStatus.UPLOADSUCCESS);
                videoFileMsgBean.setFileSize(Float.valueOf((String)assistInfo.get("fileSize")).floatValue());
                baseMsgBean = videoFileMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.FILETYPE);
                break;
            }
            case 3: {
                VoiceMsgBean voiceMsgBean = new VoiceMsgBean();
                voiceMsgBean.setBody("[\u8bed\u97f3]");
                voiceMsgBean.setFileID(String.valueOf(collectionDO.getFileID()));
                voiceMsgBean.setLength(Integer.valueOf((String)assistInfo.get("length")).intValue());
                voiceMsgBean.setFileName(collectionDO.getContent());
                voiceMsgBean.setFileStatus(VoiceMsgBean.FileStatus.UPLOADSUCCESS);
                baseMsgBean = voiceMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.AUDIO);
                break;
            }
            case 4: {
                FileMsgBean fileMsgBean = new FileMsgBean();
                fileMsgBean.setFileID(String.valueOf(collectionDO.getFileID()));
                fileMsgBean.setBody("[\u6587\u4ef6]");
                fileMsgBean.setFileName(collectionDO.getContent());
                fileMsgBean.setFileSize(Float.valueOf((String)assistInfo.get("fileSize")).floatValue());
                fileMsgBean.setFileType(FileTool.getFileType((String)((String)assistInfo.get("fileType"))));
                fileMsgBean.setFileStatus(FileMsgBean.FileStatus.UPLOADSUCCESS);
                baseMsgBean = fileMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.FILETYPE);
                break;
            }
            case 5: {
                ArticleMsgBean articleMsgBean = new ArticleMsgBean();
                ArticleBean articleBean = new ArticleBean();
                articleBean.setTitle(collectionDO.getContent());
                articleBean.setSubTitle("");
                articleBean.setShowOrder("1");
                articleBean.setBid(String.valueOf(collectionDO.getContentID()));
                articleBean.setUrl("com.jxdinfo.mp.zonekit.activity.ZoneDetailActivity#JQX://Zone/ZoneDetailVC");
                articleBean.setLinkType(ArticleBean.LinkType.NATIVE);
                articleBean.setFileID(String.valueOf(collectionDO.getFileID()));
                ArrayList<ArticleBean> articleBeans = new ArrayList<ArticleBean>();
                articleBeans.add(articleBean);
                articleMsgBean.setArticles(articleBeans);
                baseMsgBean = articleMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.ARTICLES);
                baseMsgBean.setBody(collectionDO.getContent());
                break;
            }
            case 6: {
                LocationMsgBean locationMsgBean = new LocationMsgBean();
                locationMsgBean.setBody(collectionDO.getContent());
                locationMsgBean.setThumbnailId(collectionDO.getFileID());
                locationMsgBean.setFileSize((String)assistInfo.get("fileSize"));
                locationMsgBean.setLocationInfo((String)assistInfo.get("locationInfo"));
                locationMsgBean.setLocationName(collectionDO.getContent());
                locationMsgBean.setLongitude((String)assistInfo.get("longitude"));
                locationMsgBean.setLatitude((String)assistInfo.get("latitude"));
                locationMsgBean.setFileStatus(LocationMsgBean.FileStatus.UPLOADSUCCESS);
                baseMsgBean = locationMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.LOCATION);
                break;
            }
            case 7: {
                ArticleMsgBean articleMsgBean = new ArticleMsgBean();
                ArticleBean articleBean = new ArticleBean();
                articleBean.setTitle(collectionDO.getContent());
                articleBean.setSubTitle((String)assistInfo.get("subTitle"));
                articleBean.setShowOrder("1");
                articleBean.setBid(String.valueOf(Long.valueOf((String)assistInfo.get("bid"))));
                articleBean.setUrl((String)assistInfo.get("url"));
                articleBean.setLinkType(ArticleBean.LinkType.values()[Integer.parseInt((String)assistInfo.get("linkType"))]);
                ArrayList<ArticleBean> articleBeans = new ArrayList<ArticleBean>();
                articleBeans.add(articleBean);
                articleMsgBean.setArticles(articleBeans);
                baseMsgBean = articleMsgBean;
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.ARTICLES);
                baseMsgBean.setBody(collectionDO.getContent());
                break;
            }
            case 8: {
                ArticleMsgBean articleMsgBean = new ArticleMsgBean();
                ArticleBean articleBean = new ArticleBean();
                articleBean.setTitle(collectionDO.getContent());
                articleBean.setSubTitle((String)assistInfo.get("subTitle"));
                articleBean.setShowOrder("1");
                articleBean.setBid(String.valueOf(collectionDO.getContentID()));
                articleBean.setUrl((String)assistInfo.get("url"));
                articleBean.setFileID(String.valueOf(collectionDO.getFileID()));
                articleBean.setLinkType(ArticleBean.LinkType.WEB);
                ArrayList<ArticleBean> articleBeans = new ArrayList<ArticleBean>();
                articleBeans.add(articleBean);
                articleMsgBean.setArticles(articleBeans);
                baseMsgBean = articleMsgBean;
                baseMsgBean.setBody(collectionDO.getContent());
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.ARTICLES);
                break;
            }
            case 9: {
                VCardMsgBean vCardMsgBean = new VCardMsgBean();
                vCardMsgBean.setUserId(Long.valueOf((String)assistInfo.get("userId")));
                vCardMsgBean.setUserName((String)assistInfo.get("userName"));
                vCardMsgBean.setPhoneNum((String)assistInfo.get("phoneNum"));
                vCardMsgBean.setEmail((String)assistInfo.get("email"));
                vCardMsgBean.setOrganiseName((String)assistInfo.get("organiseName"));
                vCardMsgBean.setCompanyName((String)assistInfo.get("companyName"));
                vCardMsgBean.setRecommendType(Integer.parseInt((String)assistInfo.get("recommendType")));
                vCardMsgBean.setFromName((String)assistInfo.get("fromName"));
                vCardMsgBean.setImageData((String)assistInfo.get("imageData"));
                baseMsgBean = vCardMsgBean;
                baseMsgBean.setBody(collectionDO.getContent());
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.VCARD);
                break;
            }
            default: {
                return false;
            }
        }
        baseMsgBean.setSenderCode(loginUser.getId().toString());
        baseMsgBean.setSenderName(loginUser.getUserName());
        baseMsgBean.setMsgTime(DateUtil.now());
        baseMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        baseMsgBean.setRead(BaseMsgBean.Read.UNREAD);
        baseMsgBean.setResource("system");
        return this.pushMessage(receiverDTOList, (BaseMsgBean)baseMsgBean);
    }

    public Result<Long> getCollectionNum(CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.count((Wrapper)new LambdaQueryWrapper().eq(CollectionDO::getUserID, (Object)loginUser.getId())));
    }

    private boolean pushMessage(ReceiverDTO receiverDTO, BaseMsgBean baseMsgBean) {
        baseMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)baseMsgBean)));
        baseMsgBean.setReceiverName(receiverDTO.getName());
        baseMsgBean.setReceiverCode(receiverDTO.getUserID().toString());
        baseMsgBean.setCompID(ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId()) ? BaseSecurityUtil.getUser().getTenantId().toString() : null);
        baseMsgBean.setCompName(BaseSecurityUtil.getUser().getTenantName());
        if ("user".equals(receiverDTO.getType())) {
            baseMsgBean.setMode(BaseMsgBean.Mode.CHAT);
        } else if ("group".equals(receiverDTO.getType())) {
            baseMsgBean.setMode(BaseMsgBean.Mode.GROUPCHAT);
        }
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.ARTICLES)) {
            ArticleMsgBean articleMsgBean = (ArticleMsgBean)baseMsgBean;
            ((ArticleBean)articleMsgBean.getArticles().get(0)).setObjID(String.valueOf(IdWorker.getId((Object)articleMsgBean)));
        }
        PushMessageDTO pushMessageDTO = new PushMessageDTO(baseMsgBean, baseMsgBean.getMode(), null, null);
        return this.messageProducerService.sendMessage(pushMessageDTO);
    }

    private boolean pushMessage(List<ReceiverDTO> receiverDTOList, BaseMsgBean baseMsgBean) {
        receiverDTOList.forEach(receiverDTO -> this.pushMessage((ReceiverDTO)receiverDTO, baseMsgBean));
        return true;
    }
}

