/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller.manage;

import cn.hutool.core.bean.BeanUtil;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.UserCacheService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u540e\u53f0\u7ba1\u7406"})
@ApiVersion
@RestController
@RequestMapping(value={"/contact/manager"})
public class ContactManageController {
    @Resource
    private ContactService contactService;
    @Resource
    private UserCacheService userCacheService;

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u5217\u8868")
    @GetMapping(value={"/organise"})
    public Result<List<OrganizationTreeVo>> selectOrgList(@RequestParam(value="isShow", required=false) @ApiParam(value="\u662f\u5426\u663e\u793a\u9690\u85cf\u90e8\u95e8") String isShow, @RequestParam(value="searchKey", required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(value="parentOrgID", required=false) @ApiParam(value="\u7236\u7ea7\u7ec4\u7ec7id") Long parentOrgID, @RequestParam(name="pageSize", defaultValue="-1") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(name="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum) {
        isShow = isShow == null ? "1" : isShow;
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.contactService.getOrgTree(isShow, searchKey, parentOrgID, pageDTO));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u8be6\u60c5")
    @GetMapping
    public Result<OrganizationBo> getOrganise(@RequestParam(value="orgID") @ApiParam(value="\u90e8\u95e8id") Long orgID) {
        return Result.succeed((Object)this.contactService.getOrganise(orgID));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u548c\u5de5\u53f7\u67e5\u8be2\u4eba\u5458")
    @GetMapping(value={"/user"})
    public Result<PageVO<UserStaffVo>> searchUser(@RequestParam(value="searchKey", required=false) @ApiParam(value="\u7528\u6237\u540d\u6216\u5de5\u53f7") String searchKey, @RequestParam(value="orgIDs", required=false) @ApiParam(value="\u90e8\u95e8id") List<Long> orgIDs, @RequestParam(value="roleIds", required=false) @ApiParam(value="\u7528\u6237\u89d2\u8272id") String roleIDs, @RequestParam(value="isShow", required=false) @ApiParam(value="\u662f\u5426\u663e\u793a\u79bb\u804c\u4eba\u5458") String isShow, @RequestParam(name="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(name="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum, @RequestParam(value="objID", required=false) @ApiParam(value="\u5fae\u5e94\u7528id") Long objID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.contactService.searchUser(currentLoginUser.getId(), searchKey, orgIDs, roleIDs, isShow, pageDTO, objID));
    }

    @ApiOperation(value="\u751f\u6210\u9996\u5b57\u6bcd\u6216\u5168\u62fc")
    @PutMapping(value={"/initials"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> generateInitials(@RequestParam(required=false) String full) {
        return Result.succeed((Object)this.contactService.generateInitials(full));
    }

    @ApiOperation(value="\u6e05\u9664\u7528\u6237\u7f13\u5b58")
    @PostMapping(value={"/cache"})
    public Result<Boolean> clearUserCache() {
        return Result.succeed((Object)this.userCacheService.clearUserAll());
    }

    @ApiOperation(value="\u6839\u636e\u63a8\u9001\u5386\u53f2msgID\u67e5\u8be2\u63a8\u9001\u7684\u4eba\u5458")
    @GetMapping(value={"/receiver"})
    public Result<PageVO<RosterVO>> getReceiver(@RequestParam Long msgID, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam(required=false) String orgIDs, @RequestParam(required=false) String roleIDs) {
        PageDTO pageDTO = new PageDTO();
        PageVO pageVO = new PageVO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        BeanUtil.copyProperties((Object)this.contactService.getReceiver(msgID, pageDTO, searchKey, orgIDs, roleIDs), (Object)pageVO, (String[])new String[0]);
        return Result.succeed((Object)pageVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u6709\u8be5\u5fae\u5e94\u7528\u6743\u9650\u7684\u4eba")
    @GetMapping(value={"/permission"})
    public Result<PageVO<RosterVO>> getPermission(@RequestParam Long pubPlatID, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam(required=false) String orgIDs, @RequestParam(required=false) String roleIDs) {
        PageDTO pageDTO = new PageDTO();
        PageVO pageVO = new PageVO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        BeanUtil.copyProperties((Object)this.contactService.getPermission(pubPlatID, searchKey, pageDTO, orgIDs, roleIDs), (Object)pageVO, (String[])new String[0]);
        return Result.succeed((Object)pageVO);
    }
}

