/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.organization.model.WorkExperienceDTO;
import com.jxdinfo.mp.organization.model.mobileuser.UserVO;
import com.jxdinfo.mp.organization.service.LinkManService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u8054\u7cfb\u4eba\u76f8\u5173\u64cd\u4f5c", tags={"\u8054\u7cfb\u4eba\u76f8\u5173\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/v1/linkMan"})
public class LinkManController {
    @Resource
    private LinkManService linkManService;

    @ApiOperation(value="\u67e5\u8be2\u5e38\u7528\u8054\u7cfb\u4eba\u5217\u8868")
    @GetMapping(value={"getLinkManList"})
    public Result<PageDTO<RosterVO>> getLinkManList(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo) {
        if (pageInfo == null || pageInfo.getSize() == 0L) {
            pageInfo = new PageInfo();
            pageInfo.setCurrent(1L);
            pageInfo.setSize(Integer.MAX_VALUE);
        }
        return Result.succeed((Object)this.linkManService.getLinkManList(pageInfo, currentLoginUser.getId()));
    }

    @ApiOperation(value="\u52a0\u4e3a\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/addLinkMan"})
    public Result<Boolean> addLinkMan(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(name="friendID") @ApiParam(value="\u597d\u53cbid") Long friendID) {
        return Result.succeed((Object)this.linkManService.addLinkMan(friendID, currentLoginUser));
    }

    @ApiOperation(value="\u5220\u9664\u8054\u7cfb\u4eba")
    @PostMapping(value={"/deleteLinkMan"})
    public Result<Boolean> deleteLinkMan(@RequestParam(name="friendID") @ApiParam(value="\u597d\u53cbid") Long friendID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.deleteLinkMan(friendID, currentLoginUser));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u6761\u597d\u53cb\u8d44\u6599")
    @GetMapping(value={"/{friendID}"})
    public Result<UserVO> getLinkManInfo(@PathVariable(name="friendID") @ApiParam(value="\u597d\u53cbid") Long friendID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.getLinkManInfo(currentLoginUser.getId(), friendID));
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u8d44\u6599 J_U_1007")
    @GetMapping(value={"/jxd/{friendID}"})
    public Result<UserVO> getContactPeopleInfo(@PathVariable(name="friendID") @ApiParam(value="\u597d\u53cbid") Long friendID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.getContactPeopleInfo(friendID, currentLoginUser));
    }

    @ApiOperation(value="\u662f\u5426\u53ef\u67e5\u770b\u4efb\u804c\u5c65\u5386")
    @GetMapping(value={"/workexperience"})
    public Result<WorkExperienceDTO> getWorkExperience(@LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.getWorkExperience(currentLoginUser));
    }

    @ApiOperation(value="\u53d8\u66f4\u8054\u7cfb\u4eba\u662f\u5426\u7f6e\u9876\u4fe1\u606f")
    @PostMapping(value={"/top"})
    public Result<Boolean> topLinkMan(@RequestParam(name="friendID") @ApiParam(value="\u597d\u53cbid") Long friendID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(name="isTop") @ApiParam(value="\u7f6e\u9876") int isTop) {
        return Result.succeed((Object)this.linkManService.updateUserTop(friendID, currentLoginUser, isTop));
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u8054\u7cfb\u4eba")
    @PostMapping(value={"addLinkMen"})
    public Result<Boolean> addLinkMen(@RequestParam @ApiParam(value="\u597d\u53cbid\u96c6\u5408,\u591a\u4e2a\u7528,\u5206\u9694") List<Long> friendIds, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.addMoreLinkMan(friendIds, currentLoginUser.getId()));
    }
}

