/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.organization.ContactVO;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.zone.commen.ApiConstants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/contact"})
public class ContactController {
    @Resource
    private ContactService contactService;

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u548c\u4eba\u5458\uff08\u662f\u5426\u8054\u7cfb\u4eba\uff09J_U_0008 J_U_0018")
    @GetMapping(value={"/getContactInfo"})
    public Result<PageVO<ContactVO>> getContactInfo(@RequestParam(name="needFriendState", required=false) @ApiParam(value="\u662f\u5426\u9700\u8981\u83b7\u53d6\u8054\u7cfb\u4eba\u72b6\u6001\uff0c\u9ed8\u8ba4\u4e0d\u9700\u8981") boolean needFriendState, @RequestParam(name="orgID", required=false) @ApiParam(value="\u90e8\u95e8id") Long orgID, @RequestParam(name="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") Integer pageSize, @RequestParam(name="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") Integer pageNum) {
        if (orgID == null || orgID == -1L) {
            orgID = ApiConstants.DEFAULT_ROOT_DEPT_ID;
        }
        return Result.succeed((Object)this.contactService.getContactInfo(orgID, needFriendState, pageSize, pageNum));
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u90e8\u95e8 J_U_0041")
    @GetMapping(value={"/getAllContact"})
    public Result<PageVO<OrganVo>> getAllContact(@RequestParam(name="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(name="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum) {
        PageVO pageVO = new PageVO();
        pageVO.setPageNum(Integer.valueOf(pageNum));
        pageVO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.contactService.getAllContact());
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u7ea7\u90e8\u95e8\u548c\u4eba\u5458")
    @GetMapping(value={"/next"})
    public Result<List<OrganizationBo>> getNextContact(@RequestParam(required=false) @ApiParam(value="\u90e8\u95e8id") Long orgID) {
        return Result.succeed((Object)this.contactService.getNextContact(orgID));
    }

    @ApiOperation(value="\u67e5\u627e\u90e8\u95e8\u4eba\u5458\uff08\u662f\u5426\u8054\u7cfb\u4eba\uff09J_U_0009 J_U_0019", notes="todo iam\u63d0\u4f9b\u7684\u641c\u7d22\u63a5\u53e3\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/user"})
    public Result<List<RosterVO>> searchContacts(@RequestParam(name="needFriendState", required=false) @ApiParam(value="\u662f\u5426\u9700\u8981\u8fd4\u56de\u597d\u53cb\u72b6\u6001") boolean needFriendState, @RequestParam(name="orgID", required=false) @ApiParam(value="\u90e8\u95e8id") Long orgID, @RequestParam(name="userName", required=false) @ApiParam(value="\u9700\u67e5\u8be2\u7684\u7528\u6237\u540d") String userName, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setCurrent(1L);
        pageDTO.setPageSize(Integer.valueOf(500));
        if (!needFriendState) {
            return Result.succeed((Object)this.contactService.searchContact(userName, orgID, pageDTO, currentLoginUser.getId()).getList());
        }
        return Result.succeed((Object)this.contactService.searchContactWithIsFriend(userName, orgID, pageDTO, currentLoginUser.getId()).getList());
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b50\u90e8\u95e8\u7684id")
    @GetMapping(value={"/child/{orgID}"})
    public Result<List<Long>> getChildrenList(@PathVariable(name="orgID") Long orgID) {
        List orgIDList = this.contactService.getAllChildList(orgID);
        orgIDList.removeIf(n -> n.equals(orgID));
        return Result.succeed((Object)orgIDList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7236\u90e8\u95e8\u7684id")
    @GetMapping(value={"/parent/{orgID}"})
    public Result<List<Long>> getParentsList(@PathVariable(name="orgID") Long orgID) {
        return Result.succeed((Object)this.contactService.getAllParentList(orgID));
    }
}

