/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.organization.dao.ProblemMapper;
import com.jxdinfo.mp.organization.model.feedback.ProblemDO;
import com.jxdinfo.mp.organization.model.feedback.ProblemDTO;
import com.jxdinfo.mp.organization.service.ProblemFileService;
import com.jxdinfo.mp.organization.service.ProblemService;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class ProblemServiceImpl
extends ServiceImpl<ProblemMapper, ProblemDO>
implements ProblemService {
    @Resource
    private ProblemFileService problemFileService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveProblem(ProblemDTO problemDTO) {
        if (CollUtil.isNotEmpty((Collection)problemDTO.getFiles())) {
            problemDTO.getFiles().forEach(n -> {
                String time = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
                n.setBusinessID(problemDTO.getProblemID());
                n.setCreateTime(time);
                n.setModifyTime(time);
            });
            this.problemFileService.saveBatch((Collection)problemDTO.getFiles());
        }
        ProblemDO problemDO = new ProblemDO();
        BeanUtil.copyProperties((Object)problemDTO, (Object)problemDO, (String[])new String[0]);
        problemDO.setCreateTime(DateUtil.now());
        problemDO.setModifyTime(DateUtil.now());
        return this.save(problemDO);
    }

    public boolean save(ProblemDO entity) {
        return super.save((Object)entity);
    }

    public boolean updateById(ProblemDO entity) {
        return super.updateById((Object)entity);
    }
}

