/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.MobileClient;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterDTO;
import com.jxdinfo.mp.organization.model.device.DeviceDO;
import com.jxdinfo.mp.organization.model.device.DeviceLoginRecordDO;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.model.mainuser.CSTypeVO;
import com.jxdinfo.mp.organization.model.platBind.PlatBindDTO;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.DeviceLoginRecordService;
import com.jxdinfo.mp.organization.service.DeviceService;
import com.jxdinfo.mp.organization.service.LinkManService;
import com.jxdinfo.mp.organization.service.PushService;
import com.jxdinfo.mp.organization.service.UserService;
import com.jxdinfo.mp.organization.util.DeviceUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7528\u6237\u76f8\u5173\u64cd\u4f5c"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/user"})
public class UserController {
    @Resource
    private UserService userService;
    @Resource
    private LinkManService linkManService;
    @Resource
    private PushService pushService;
    @Resource
    private ContactService contactService;
    @Resource
    private DeviceLoginRecordService deviceLoginRecordService;
    @Resource
    private DeviceService deviceService;

    @ApiOperation(value="\u4fee\u6539\u4e2a\u4eba\u8d44\u6599 J_U_0010")
    @PostMapping(value={"updateMessage"})
    public Result<Boolean> updateMessage(@RequestBody @ApiParam(value="\u7528\u6237\u8d44\u6599\u5b9e\u4f53\u7c7b") RosterDTO rosterDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.userService.updateUserMessage(rosterDTO, currentLoginUser.getId()));
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5934\u50cf J_U_0038")
    @PostMapping(value={"/headImg"})
    public Result<Boolean> updateHeadImg(@RequestParam(name="headImgId") @ApiParam(value="\u5934\u50cf\u56fe\u7247id") String headImgId, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.userService.updateHeadImg(loginUser.getId(), headImgId));
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801 J_U_0011")
    @PostMapping(value={"/password"})
    public Result<Boolean> updatePassword(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(name="oldPassWd") @ApiParam(value="\u65e7\u5bc6\u7801") String oldPassWd, @RequestParam(name="newPassWd") @ApiParam(value="\u65b0\u5bc6\u7801") String newPassWd) {
        return null;
    }

    @ApiOperation(value="\u4fdd\u5b58\u63a8\u9001 J_U_0014")
    @PostMapping(value={"/addPush"})
    public Result<Boolean> addPush(@RequestParam(name="channelID") @ApiParam(value="\u63a8\u9001id") String channelID, @RequestParam(name="resource") @ApiParam(value="\u8d44\u6e90") String resource, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.pushService.addPush(channelID, resource, currentLoginUser));
    }

    @ApiOperation(value="\u6e05\u9664\u63a8\u9001 J_U_0015")
    @PostMapping(value={"/delPush"})
    public Result<Boolean> delPush(@RequestParam(name="channelID") @ApiParam(value="\u63a8\u9001id") String channelID, @RequestParam(name="resource") @ApiParam(value="\u8d44\u6e90") String resource, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam @ApiParam(value="mobileClient\u7684JSON\u5b57\u7b26\u4e32") String jsonString) {
        DeviceDO deviceDO;
        MobileClient mobileClient = (MobileClient)JSON.parseObject((String)jsonString, MobileClient.class);
        if (mobileClient != null && (deviceDO = this.deviceService.getExistedDeviceDO(mobileClient.getUniqueIdentifier(), currentLoginUser.getId())) != null) {
            DeviceLoginRecordDO deviceLoginRecordDO = DeviceUtil.getDeviceLoginRecordDO(mobileClient);
            deviceLoginRecordDO.setDeviceID(deviceDO.getDeviceId());
            deviceLoginRecordDO.setStatus(Integer.valueOf(0));
            this.deviceLoginRecordService.save((Object)deviceLoginRecordDO);
        }
        return Result.succeed((Object)this.pushService.delPush(channelID, resource, currentLoginUser));
    }

    @ApiOperation(value="\u4fee\u6539\u63d0\u9192\u65b9\u5f0f J_U_0016")
    @PostMapping(value={"/remind"})
    public Result<Boolean> updateRemind(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(name="isVibrateRemind") @ApiParam(value="\u662f\u5426\u9707\u52a8") Integer isVibrateRemind, @RequestParam(name="isSoundRemind") @ApiParam(value="\u662f\u5426\u58f0\u97f3\u63d0\u9192") Integer isSoundRemind) {
        return Result.succeed((Object)this.userService.updateUserRemind(currentLoginUser, isVibrateRemind, isSoundRemind));
    }

    @ApiOperation(value="\u83b7\u53d6\u63d0\u9192\u65b9\u5f0f J_U_0017")
    @GetMapping(value={"/remind"})
    public Result<Map<String, Integer>> getRemind(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.userService.getUserRemind(currentLoginUser));
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u5e73\u53f0\u7ed1\u5b9a\u3001\u89e3\u7ed1 J_U_0032")
    @PostMapping(value={"/plat"})
    public Result<Boolean> bindPlat(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestBody @ApiParam(value="\u4e09\u65b9\u5e73\u53f0\u5b9e\u4f53\u7c7b") PlatBindDTO platBindDTO) {
        return this.userService.bindPlat(currentLoginUser.getId(), platBindDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e09\u65b9\u7ed1\u5b9a\u72b6\u6001\u4fe1\u606f J_U_0034")
    @GetMapping(value={"/plat"})
    public Result<List<Map<String, String>>> getPlatStatus(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.userService.getPlatStatus(currentLoginUser.getId()));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u670d\u7c7b\u578b\u548c\u5ba2\u670d\u4eba\u5458")
    @GetMapping(value={"/csType"})
    public Result<CSTypeVO> getCsType(@RequestParam(name="typeID", required=false) @ApiParam(value="\u7c7b\u578bid") Long typeID, @RequestParam(name="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(name="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u7801") int pageNum) {
        return Result.succeed((Object)this.userService.getCsType(typeID, pageSize, pageNum));
    }

    @ApiOperation(value="\u6839\u636etoken\u83b7\u53d6\u7528\u6237\u7684\u5de5\u53f7")
    @GetMapping(value={"/jobNum"})
    public JSONObject getJobNum(@RequestParam(name="companyID") @ApiParam(value="companyID") String companyID) {
        return this.userService.getJobNum(companyID);
    }

    @ApiOperation(value="\u6839\u636etoken\u83b7\u53d6\u7528\u6237")
    @GetMapping(value={"/token/{token}"})
    public SecurityUser getUser1(@PathVariable(name="token") @ApiParam(value="token") String token, @RequestParam(name="companyID", required=false) @ApiParam(value="companyID") String companyID) {
        return BaseSecurityUtil.getUser((String)token);
    }

    @ApiOperation(value="\u6839\u636etoken\u83b7\u53d6\u7528\u6237,\u517c\u5bb9\u6559\u57f9\u5e94\u7528\u63a5\u53e3")
    @GetMapping(value={"/edu/token/{token}"})
    public RosterDTO getUserForEdu(@PathVariable(name="token") @ApiParam(value="token") String token, @RequestParam(name="companyID", required=false) @ApiParam(value="companyID") String companyID) {
        SecurityUser user = BaseSecurityUtil.getUser((String)token);
        RosterDTO rosterDTO = new RosterDTO();
        rosterDTO.setUserCode(user.getUserName());
        return rosterDTO;
    }

    @ApiOperation(value="\u6839\u636eUserIDs\u83b7\u53d6\u7528\u6237")
    @PostMapping(value={"list"})
    public Result<List<UserStaffVo>> getUser(@RequestBody List<Long> userIDs, @RequestParam(required=false) String searchKey, @RequestParam(required=false) String orgIDs, @RequestParam(required=false) String roleIDs, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return Result.succeed((Object)this.userService.getUser(userIDs, searchKey, currentLoginUser.getId(), pageNum, pageSize, orgIDs, roleIDs));
    }

    @GetMapping(value={"/userImg"})
    @ApiOperation(value="\u6839\u636euserID\u83b7\u53d6\u7528\u6237\u5934\u50cffileID")
    public List<HeadingImg> queryUserHeadFileID(@RequestParam(name="userIDs") List<Long> userIDs) {
        return this.linkManService.queryUserHeadFileID(userIDs);
    }

    @ApiOperation(value="\u540c\u6b65\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/config"})
    public Result<Map<String, Object>> synConfig(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(value="time", required=false) @ApiParam(value="\u4e0a\u6b21\u540c\u6b65\u7684\u670d\u52a1\u5668\u7684\u65f6\u95f4") String time, @RequestParam(value="zonetime", required=false) @ApiParam(value="\u5de5\u4f5c\u5708\u4e0a\u6b21\u67e5\u770b\u65f6\u95f4") String zoneTime) {
        return Result.succeed((Object)this.userService.sycConfig(currentLoginUser, time, zoneTime));
    }

    @ApiOperation(value="\u6839\u636euserID\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"userDetail"})
    public Result<SysUsers> userDetail(@RequestParam @ApiParam(value="\u7528\u6237id") Long userID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.linkManService.userDetail(userID, currentLoginUser.getId()));
    }

    @ApiOperation(value="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/userCode"})
    public Result<SearchUserVo> userDetailByUserCode(@RequestParam @ApiParam(value="\u7528\u6237\u8d26\u53f7") String userCode) {
        return Result.succeed((Object)this.linkManService.userDetailByUserCode(userCode));
    }

    @ApiOperation(value="\u67e5\u627e\u90e8\u95e8\u4eba\u5458")
    @GetMapping(value={"searchContacts"})
    public Result<List<UserStaffVo>> searchContacts(@RequestParam(name="userName", required=false) @ApiParam(value="\u9700\u67e5\u8be2\u7684\u7528\u6237\u540d") String userName, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.contactService.searchContactByUserName(userName, currentLoginUser.getId()));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u5934\u50cf")
    @GetMapping(value={"/getUserImage/{userId}/{imageType}"})
    public void getUserImage(HttpServletResponse response, @RequestParam(name="type", required=false) @ApiParam(value="\u7c7b\u578b") String type, @PathVariable(value="userId") @ApiParam(value="\u7528\u6237id") Long userId, @PathVariable(value="imageType") @ApiParam(value="\u56fe\u7247\u7c7b\u578b") String imageType) {
        this.userService.getUserImage(response, type, userId, imageType);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u5934\u50cf")
    @GetMapping(value={"/getUserImage/{userId}"})
    public void getUserImage(HttpServletResponse response, @RequestParam(name="type", required=false) @ApiParam(value="\u7c7b\u578b") String type, @PathVariable(value="userId") @ApiParam(value="\u7528\u6237id") Long userId) {
        this.userService.getUserImage(response, type, userId, null);
    }
}

