/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.organization.dao.ProblemCommonMapper;
import com.jxdinfo.mp.organization.model.feedback.ProblemCommonDO;
import com.jxdinfo.mp.organization.model.feedback.ProblemCommonDTO;
import com.jxdinfo.mp.organization.model.feedback.ProblemTypeDO;
import com.jxdinfo.mp.organization.service.ProblemCommonService;
import com.jxdinfo.mp.organization.service.ProblemFileService;
import com.jxdinfo.mp.organization.service.ProblemTypeService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class ProblemCommonServiceImpl
extends ServiceImpl<ProblemCommonMapper, ProblemCommonDO>
implements ProblemCommonService {
    @Resource
    private ProblemFileService problemFileService;
    @Resource
    private ProblemCommonMapper problemCommonMapper;
    @Resource
    private ProblemTypeService problemTypeService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveCommonProblem(ProblemCommonDTO problemCommonDTO) {
        ProblemCommonDO problemCommonDO = new ProblemCommonDO();
        BeanUtil.copyProperties((Object)problemCommonDTO, (Object)problemCommonDO, (String[])new String[0]);
        problemCommonDO.setCreateTime(DateUtil.now());
        problemCommonDO.setModifyTime(DateUtil.now());
        this.saveFiles(problemCommonDTO);
        return this.save(problemCommonDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateCommonProblem(ProblemCommonDTO problemCommonDTO) {
        ProblemCommonDO problemCommonDO = new ProblemCommonDO();
        BeanUtil.copyProperties((Object)problemCommonDTO, (Object)problemCommonDO, (String[])new String[0]);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"BUSINESSID", (Object)problemCommonDO.getObjID());
        this.problemFileService.remove((Wrapper)queryWrapper);
        this.saveFiles(problemCommonDTO);
        return this.updateById(problemCommonDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeCommonProblem(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"BUSINESSID", (Object)id);
        this.problemFileService.remove((Wrapper)queryWrapper);
        return this.removeById((Serializable)((Object)id));
    }

    public PageDTO<ProblemCommonDO> getCommonProblemList(PageDTO<ProblemCommonDO> pageDTO, String searchKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            ((QueryWrapper)queryWrapper.eq((Object)"PROBLEM", (Object)searchKey)).orderByDesc((Object)"CREATETIME");
        }
        return this.problemCommonMapper.getCommentProblemList(pageDTO, queryWrapper);
    }

    public ProblemCommonDTO getCommonProblem(String problemId) {
        ProblemCommonDTO commonProblemDTO = new ProblemCommonDTO();
        BeanUtil.copyProperties((Object)this.getById((Serializable)((Object)problemId)), (Object)commonProblemDTO, (String[])new String[0]);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"BUSINESSID", (Object)problemId)).orderByAsc((Object)"CREATETIME");
        commonProblemDTO.setFiles(this.problemFileService.list((Wrapper)queryWrapper));
        return commonProblemDTO;
    }

    public Boolean saveType(ProblemTypeDO problemTypeDO) {
        problemTypeDO.setCreateTime(DateUtil.now());
        problemTypeDO.setModifyTime(DateUtil.now());
        return this.problemTypeService.save((Object)problemTypeDO);
    }

    public boolean updateById(ProblemCommonDO entity) {
        return super.updateById((Object)entity);
    }

    public boolean save(ProblemCommonDO entity) {
        return super.save((Object)entity);
    }

    void saveFiles(ProblemCommonDTO commonProblemDTO) {
        if (CollUtil.isNotEmpty((Collection)commonProblemDTO.getFiles())) {
            commonProblemDTO.getFiles().forEach(n -> {
                String time = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
                n.setBusinessID(commonProblemDTO.getObjID());
                n.setCreateTime(time);
                n.setModifyTime(time);
            });
            this.problemFileService.saveBatch((Collection)commonProblemDTO.getFiles());
        }
    }
}

