/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.im.dao.sensitive.SensitiveWordConfigMapper;
import com.jxdinfo.mp.im.model.sensitive.MessageType;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordConfigDO;
import com.jxdinfo.mp.im.service.SensitiveWordConfigService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class SensitiveWordConfigServiceImpl
extends ServiceImpl<SensitiveWordConfigMapper, SensitiveWordConfigDO>
implements SensitiveWordConfigService {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordConfigServiceImpl.class);
    @Resource
    private JmsMessagingTemplate jmsMessagingTemplate;
    private String topicName = "eimv5_sensitiveword_update";

    public Result<SensitiveWordConfigDO> queryConfig() {
        List list = this.list();
        Collections.reverse(list);
        if (list != null && list.size() > 0) {
            return Result.succeed(list.get(0));
        }
        return Result.succeed(null);
    }

    public Result<Boolean> saveConfig(SensitiveWordConfigDO sensitiveWordConfigDO, CurrentLoginUser currentLoginUser) {
        if (StrUtil.isEmpty((CharSequence)sensitiveWordConfigDO.getObjID())) {
            DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();
            sensitiveWordConfigDO.setObjID(defaultIdentifierGenerator.nextId((Object)sensitiveWordConfigDO).toString());
            sensitiveWordConfigDO.setCreateTime(LocalDateTime.now());
        }
        sensitiveWordConfigDO.setLastTime(LocalDateTime.now());
        try {
            ActiveMQTopic topic = new ActiveMQTopic(this.topicName);
            MessageType messageType = new MessageType();
            messageType.setType(Integer.valueOf(2));
            if (ToolUtil.isNotEmpty((Object)currentLoginUser.getCompanyID())) {
                messageType.setCompanyId(currentLoginUser.getCompanyID().toString());
            }
            messageType.setValue(sensitiveWordConfigDO.getDataStatus());
            String json = JSON.toJSONString((Object)messageType);
            log.info(json);
            this.jmsMessagingTemplate.convertAndSend((Object)topic, (Object)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.failed((String)"\u4fee\u6539\u654f\u611f\u8bcd\u914d\u7f6e\u5931\u8d25\uff01");
        }
        return Result.succeed((Object)this.saveOrUpdate(sensitiveWordConfigDO));
    }
}

