/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.im.dao.custom.IHeadImg2Mapper;
import com.jxdinfo.mp.im.dao.custom.RobotMapper;
import com.jxdinfo.mp.im.dao.custom.RobotUserMapper;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.custom.MainRobotDO;
import com.jxdinfo.mp.im.model.custom.RobotDO;
import com.jxdinfo.mp.im.model.custom.RobotUserDO;
import com.jxdinfo.mp.im.model.custom.RobotVO;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.service.MainRobotService;
import com.jxdinfo.mp.im.service.RobotService;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class RobotServiceImpl
extends ServiceImpl<RobotMapper, RobotDO>
implements RobotService {
    @Autowired
    private Environment environment;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private IHeadImg2Mapper IHeadImg2Mapper;
    @Resource
    private RobotUserMapper robotUserMapper;
    @Resource
    private RobotMapper robotMapper;
    @Resource
    private IOrganizationBoService organizationService;
    @Resource
    private MainRobotService mainRobotService;

    public boolean evaluateQuestion(CurrentLoginUser loginUser, Long robotID, String robotName, String questionID, String evaluation) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("recordId", questionID);
        paramsMap.put("access", evaluation);
        boolean flag = HttpUtil.get((String)this.environment.getProperty("mp.custom.server.url"), paramsMap).contains("1");
        if (flag) {
            NoticeMsgBean noticeMsgBean = new NoticeMsgBean();
            PushMessageDTO pushMessageDTO = new PushMessageDTO();
            noticeMsgBean.setEventType(NoticeMsgBean.EventType.BLANK);
            if ("0".equals(evaluation)) {
                noticeMsgBean.setBody("\u3010\u65e0\u7528\u3011\u611f\u8c22\u60a8\u5bf9\u672c\u6b21\u670d\u52a1\u8fdb\u884c\u8bc4\u4ef7\uff01");
            } else {
                noticeMsgBean.setBody("\u3010\u6709\u7528\u3011\u611f\u8c22\u60a8\u5bf9\u672c\u6b21\u670d\u52a1\u8fdb\u884c\u8bc4\u4ef7\uff01");
            }
            noticeMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)noticeMsgBean)));
            noticeMsgBean.setValue(String.valueOf(robotID));
            noticeMsgBean.setReceiver(String.valueOf(robotID));
            noticeMsgBean.setReceiverCode(robotID.toString());
            noticeMsgBean.setReceiverName(robotName);
            noticeMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
            noticeMsgBean.setSenderName("\u7cfb\u7edf");
            noticeMsgBean.setResource("system");
            noticeMsgBean.setMsgType(BaseMsgBean.MsgType.NOTICE);
            noticeMsgBean.setMode(BaseMsgBean.Mode.CUSTOMERCHAT);
            noticeMsgBean.setMsgReceiverCode(loginUser.getId());
            noticeMsgBean.setMsgReceiverName(loginUser.getUserName());
            noticeMsgBean.setMsgTime(DateUtil.now());
            noticeMsgBean.setCompID(ToolUtil.isNotEmpty((Object)loginUser.getCompanyID()) ? loginUser.getCompanyID().toString() : null);
            noticeMsgBean.setCompName(loginUser.getCompanyName());
            pushMessageDTO.setBaseMsgBean((BaseMsgBean)noticeMsgBean);
            pushMessageDTO.setMode(BaseMsgBean.Mode.CUSTOMERCHAT);
            pushMessageDTO.setReceiverIds(String.valueOf(loginUser.getId()));
            this.pushService.sendMessage(pushMessageDTO);
        }
        return flag;
    }

    public boolean save(RobotDO entity) {
        return super.save((Object)entity);
    }

    public boolean updateById(RobotDO entity) {
        return super.updateById((Object)entity);
    }

    @Transactional
    public Map<String, Object> saveOrEditRobots(RobotVO robotVO, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != robotVO.getShowOrder()) {
            int showOrder = robotVO.getShowOrder();
            QueryWrapper doQueryWrapper = new QueryWrapper();
            if (flag == 1) {
                doQueryWrapper.ne((Object)"ROBOT_ID", (Object)robotVO.getObjID());
            }
            doQueryWrapper.eq((Object)"SHOW_ORDER", (Object)showOrder);
            if (this.robotMapper.selectCount((Wrapper)doQueryWrapper) >= 1L) {
                map.put("map", Result.failed((Object)false, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u6218\u58eb\u987a\u5e8f"));
                return map;
            }
        }
        if (robotVO.getObjID() == null) {
            robotVO.setObjID(Long.valueOf(IdWorker.getId((Object)robotVO)));
        } else {
            HeadingImg head = robotVO.getHeadingImg();
            HeadingImg headingImg = (HeadingImg)this.IHeadImg2Mapper.selectById(robotVO.getObjID());
            if (null == headingImg) {
                if (null != head) {
                    this.IHeadImg2Mapper.insert(head);
                }
            } else if (null != head) {
                this.IHeadImg2Mapper.updateById(head);
            }
        }
        if (robotVO.getUsers() != null && robotVO.getUsers().size() > 0) {
            ArrayList idList = new ArrayList();
            if (flag == 1) {
                ArrayList ids = new ArrayList();
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"ROBOT_ID", (Object)robotVO.getObjID());
                List list = this.robotUserMapper.selectList((Wrapper)queryWrapper1);
                list.forEach(item -> ids.add(item.getUserID()));
                robotVO.getUsers().forEach(item -> idList.add(item.getUserId()));
                for (int i = 0; i < idList.size(); ++i) {
                    if (ids.isEmpty()) continue;
                    for (int j = 0; j < ids.size(); ++j) {
                        if (!((Long)idList.get(i)).equals(ids.get(j))) continue;
                        ids.remove(j);
                        idList.remove(i);
                    }
                }
                idList.addAll(ids);
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"ROBOT_ID", (Object)robotVO.getObjID());
                this.robotUserMapper.delete((Wrapper)queryWrapper2);
            } else {
                robotVO.getUsers().forEach(item -> idList.add(item.getUserId()));
            }
            for (Long id : idList) {
                RobotUserDO robotUserDO = new RobotUserDO();
                robotUserDO.setUserID(id);
                robotUserDO.setRobotID(robotVO.getObjID());
                robotUserDO.setDataStatus(Integer.valueOf(1));
                this.robotUserMapper.insert(robotUserDO);
            }
        }
        MainRobotDO mainRobotDO = new MainRobotDO();
        mainRobotDO.setRobotID(robotVO.getObjID());
        mainRobotDO.setRobotName(robotVO.getRobotName());
        mainRobotDO.setCompanyID(BaseSecurityUtil.getUser().getTenantId());
        mainRobotDO.setDataStatus(Integer.valueOf(1));
        mainRobotDO.setCreateTime(LocalDateTime.now());
        mainRobotDO.setLastTime(mainRobotDO.getCreateTime());
        RobotDO robotDO = new RobotDO();
        BeanUtil.copyProperties((Object)robotVO, (Object)robotDO, (String[])new String[0]);
        if (flag == 0) {
            robotDO.setSecretKey(IdUtil.randomUUID().substring(0, 16).toUpperCase());
            robotDO.setCreateTime(LocalDateTime.now());
            robotDO.setLastTime(robotDO.getCreateTime());
            mainRobotDO.setSecretKey(robotDO.getSecretKey());
            map.put("result", Result.succeed((Object)super.save((Object)robotDO)));
            map.put("mainDO", mainRobotDO);
            return map;
        }
        RobotDO robotOld = (RobotDO)this.robotMapper.selectById(robotVO.getObjID());
        robotDO.setCreateTime(robotOld.getCreateTime());
        robotDO.setLastTime(LocalDateTime.now());
        robotDO.setObjID(robotOld.getObjID());
        mainRobotDO.setSecretKey(robotDO.getSecretKey());
        map.put("result", Result.succeed((Object)super.updateById((Object)robotDO)));
        map.put("mainDO", mainRobotDO);
        return map;
    }

    public Result<Boolean> deleteRobots(String robotID) {
        int num = 0;
        List list = Arrays.stream(robotID.split(",")).mapToLong(Convert::toLong).boxed().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"HEADIMG_ID", list);
        num += this.IHeadImg2Mapper.delete((Wrapper)queryWrapper);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.in((Object)"ROBOT_ID", list);
        num += this.robotUserMapper.delete((Wrapper)queryWrapper1);
        QueryWrapper queryWrapper3 = new QueryWrapper();
        queryWrapper3.in((Object)"ROBOT_ID", list);
        return Result.succeed((Object)((num += this.robotMapper.delete((Wrapper)queryWrapper3)) > 0 ? 1 : 0));
    }

    public Result<RobotVO> robotDetail(Long robotID) {
        RobotVO robotVO = new RobotVO();
        RobotDO robotDO = (RobotDO)this.robotMapper.selectById(robotID);
        BeanUtil.copyProperties((Object)robotDO, (Object)robotVO, (String[])new String[0]);
        HeadingImg headingImg = (HeadingImg)this.IHeadImg2Mapper.selectById(robotVO.getObjID());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROBOT_ID", (Object)robotID);
        List robotUserDOList = this.robotUserMapper.selectList((Wrapper)queryWrapper);
        ArrayList list = new ArrayList();
        robotUserDOList.forEach(RobotUserDO2 -> {
            SysUsers sysUsers = this.organizationService.userDetail(RobotUserDO2.getUserID());
            RosterVO rosterVO = new RosterVO();
            rosterVO.setUserId(sysUsers.getId());
            rosterVO.setUserName(sysUsers.getUserName());
            list.add(rosterVO);
        });
        robotVO.setUsers(list);
        robotVO.setHeadingImg(headingImg);
        return Result.succeed((Object)robotVO);
    }

    public Result<String> updateKey(Long robotID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        RobotDO robotDO = new RobotDO();
        String secretKey = IdUtil.randomUUID().substring(0, 16).toUpperCase();
        queryWrapper.eq((Object)"SECRET_KEY", (Object)secretKey);
        if (this.robotMapper.selectCount((Wrapper)queryWrapper) == 0L) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"ROBOT_ID", (Object)robotID);
            robotDO.setObjID(robotID);
            robotDO.setSecretKey(secretKey);
            this.robotMapper.update(robotDO, (Wrapper)queryWrapper1);
        }
        return Result.succeed((Object)secretKey, (String)"200");
    }

    public <E extends IPage<RobotDO>> E page(E page, Wrapper<RobotDO> queryWrapper) {
        return (E)super.page(page, queryWrapper);
    }
}

