/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.news.NewsVO;
import com.jxdinfo.mp.im.dao.material.MaterialArticleMapper;
import com.jxdinfo.mp.im.dao.material.MaterialFileMapper;
import com.jxdinfo.mp.im.dao.material.MaterialMapper;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.material.FileDTO;
import com.jxdinfo.mp.im.model.material.FileMaterialDO;
import com.jxdinfo.mp.im.model.material.MaterialArticleDO;
import com.jxdinfo.mp.im.model.material.MaterialArticleVO;
import com.jxdinfo.mp.im.model.material.MaterialDO;
import com.jxdinfo.mp.im.model.material.MaterialDTO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.service.MaterialArticleService;
import com.jxdinfo.mp.im.service.MaterialFileService;
import com.jxdinfo.mp.im.service.MaterialService;
import com.jxdinfo.mp.im.util.FileTool;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class MaterialServiceImpl
extends ServiceImpl<MaterialMapper, MaterialDO>
implements MaterialService {
    @Resource
    private MaterialMapper materialMapper;
    @Resource
    private Environment environment;
    @Resource
    private MaterialFileMapper materialFileMapper;
    @Resource
    private MaterialFileService materialFileService;
    @Resource
    private MaterialArticleService materialArticleService;
    @Resource
    private MaterialArticleMapper materialArticleMapper;

    public List<String> getUserNameList(Long materialID) {
        return this.materialMapper.getUserNameList(materialID);
    }

    public PubMsgLogDTO getMaterial(Long materialID) {
        PubMsgLogDTO pubMsgLogDTO = new PubMsgLogDTO();
        MaterialDTO materialDTO = new MaterialDTO();
        MaterialDO materialDO = (MaterialDO)this.materialMapper.selectById(materialID);
        if (materialDO == null) {
            return null;
        }
        List<MaterialArticleVO> materialArticleVOS = this.materialMapper.getImgTextMaterial(materialID);
        if (HussarUtils.isNotEmpty(materialArticleVOS) && materialDO.getMessageType() == 8) {
            materialArticleVOS.forEach(materialArticleVO -> {
                if (materialArticleVO.getMsgLinkID() != null) {
                    NewsVO newsInfo = this.materialMapper.getNewsInfo(materialArticleVO.getMsgLinkID());
                    if (newsInfo != null) {
                        materialArticleVO.setIsNews("news");
                        materialArticleVO.setMsgTitle(newsInfo.getTitle());
                        materialArticleVO.setEditLink(Convert.toInt((Object)StrUtil.isNotEmpty((CharSequence)newsInfo.getUrl())));
                    } else {
                        materialArticleVO.setIsNews("article");
                    }
                }
            });
        }
        materialDTO.setTitle(materialDO.getTitle());
        materialDTO.setContent(materialDO.getMsgBody());
        materialDTO.setMaterialArticleVOList(materialArticleVOS);
        materialDTO.setFileBean(this.materialMapper.getFileMaterial(materialID));
        materialDTO.setMaterialType(materialDO.getMessageType());
        materialDTO.setObjID(materialID);
        pubMsgLogDTO.setMaterialDTO(materialDTO);
        return pubMsgLogDTO;
    }

    @Transactional
    public boolean deleteMaterial(List<Long> materialIds) {
        this.materialMapper.deleteBatchIds(materialIds);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(MaterialArticleDO::getMsgID, materialIds);
        List articleList = this.materialArticleMapper.selectList((Wrapper)queryWrapper);
        ArrayList<Long> articleIDList = new ArrayList<Long>();
        if (!articleList.isEmpty()) {
            articleList.forEach(materialArticleDO -> articleIDList.add(materialArticleDO.getObjID()));
            List<Long> fileIDList = this.materialMapper.selectOldImg(articleIDList);
            if (ToolUtil.isNotEmpty(fileIDList)) {
                this.materialFileMapper.deleteBatchIds(fileIDList);
            }
            this.materialArticleMapper.delete((Wrapper)queryWrapper);
        }
        List materialDOList = this.materialMapper.selectBatchIds(materialIds);
        ArrayList fileIDList = new ArrayList();
        if (!materialDOList.isEmpty()) {
            materialDOList.forEach(material -> fileIDList.add(material.getFileID()));
            if (ToolUtil.isNotEmpty(fileIDList)) {
                this.materialFileMapper.deleteBatchIds(fileIDList);
            }
        }
        return true;
    }

    @Transactional
    public boolean saveMaterial(MaterialDTO materialDTO, CurrentLoginUser loginUser, String urlSplicing) {
        if (materialDTO.getMaterialType() == 0) {
            this.saveMaterial(materialDTO.getTitle(), materialDTO.getContent(), loginUser, BaseMsgBean.MsgType.TEXT, null);
            return true;
        }
        if (materialDTO.getMaterialType() == 8) {
            this.saveImgText(materialDTO, loginUser, urlSplicing);
            return true;
        }
        if (materialDTO.getMaterialType() == 3 || materialDTO.getMaterialType() == 1) {
            this.saveFile(materialDTO, loginUser);
            return true;
        }
        return false;
    }

    @Transactional
    public boolean updateMaterial(MaterialDTO materialDTO, CurrentLoginUser loginUser, String urlSplicing) {
        MaterialDO materialDO = new MaterialDO();
        materialDO.setObjID(materialDTO.getObjID());
        materialDO.setMsgBody(materialDTO.getContent());
        materialDO.setTitle(materialDTO.getTitle());
        materialDO.setLastEditor(loginUser.getId());
        materialDO.setLastTime(LocalDateTime.now());
        materialDO.setMessageType(materialDTO.getMaterialType());
        if (materialDTO.getMaterialType() == 0) {
            this.materialMapper.updateById(materialDO);
            return true;
        }
        if (materialDTO.getMaterialType() == 8) {
            this.updateImgText(materialDTO, urlSplicing);
            this.materialMapper.updateById(materialDO);
            return true;
        }
        if (materialDTO.getMaterialType() == 1 || materialDTO.getMaterialType() == 3) {
            materialDO.setFileID(materialDTO.getFileBean().getFileID());
            this.updateFile(materialDTO);
            this.materialMapper.updateById(materialDO);
            return true;
        }
        return false;
    }

    public PageDTO<NewsVO> getNewsListManage(PageDTO pageDTO, Wrapper wrapper) {
        return this.materialMapper.getNewsListManage(pageDTO, wrapper);
    }

    private Long saveMaterial(String title, String msgContent, CurrentLoginUser loginUser, BaseMsgBean.MsgType msgType, Long fileID) {
        MaterialDO materialDO = new MaterialDO();
        materialDO.setMsgBody(msgContent);
        materialDO.setTitle(title);
        materialDO.setMessageType(Integer.valueOf(msgType.ordinal()));
        materialDO.setFileID(fileID);
        materialDO.setCreateUserName(loginUser.getUserName());
        this.materialMapper.insert(materialDO);
        return materialDO.getObjID();
    }

    private FileMaterialDO setMaterialFile(FileDTO fileDTO, FileMsgBean.FileType fileType) {
        FileMaterialDO fileMaterialDO = new FileMaterialDO();
        BeanUtil.copyProperties((Object)fileDTO, (Object)fileMaterialDO, (String[])new String[0]);
        fileMaterialDO.setFileType(Integer.valueOf(fileType.ordinal()));
        return fileMaterialDO;
    }

    private MaterialArticleDO setMaterialArticle(MaterialArticleVO materialArticleVO, int i, Long msgID, String urlSplicing) {
        MaterialArticleDO materialArticleDO = new MaterialArticleDO();
        if (materialArticleVO.getMsgLinkID() == null) {
            materialArticleDO.setUrl(materialArticleVO.getMsgLink());
            materialArticleDO.setbID("0");
        } else {
            if (materialArticleVO.getEditLink() != null && 1 == materialArticleVO.getEditLink()) {
                materialArticleDO.setUrl(materialArticleVO.getMsgLink());
            } else if (materialArticleVO.getLinkType() == 1) {
                materialArticleDO.setUrl(this.environment.getProperty("mp.web.NEWS_URL") + materialArticleVO.getMsgLinkID());
            } else if (materialArticleVO.getLinkType() == 0) {
                materialArticleDO.setUrl(this.environment.getProperty("mp.web.ARTICLE_URL") + materialArticleVO.getMsgLinkID());
            }
            materialArticleDO.setbID(String.valueOf(materialArticleVO.getMsgLinkID()));
        }
        BeanUtil.copyProperties((Object)materialArticleVO, (Object)materialArticleDO, (String[])new String[0]);
        if (materialArticleVO.getObjID() != null) {
            materialArticleDO.setObjID(materialArticleVO.getObjID());
        } else {
            materialArticleDO.setObjID(Long.valueOf(IdWorker.getId((Object)materialArticleDO)));
        }
        materialArticleDO.setShowOrder(i + 1 + "");
        materialArticleDO.setMsgID(msgID);
        return materialArticleDO;
    }

    private void saveImgText(MaterialDTO materialDTO, CurrentLoginUser loginUser, String urlSplicing) {
        Long materialId = this.saveMaterial(materialDTO.getTitle(), "", loginUser, BaseMsgBean.MsgType.ARTICLES, null);
        ArrayList<FileMaterialDO> materialFileDOList = new ArrayList<FileMaterialDO>();
        List materialArticleVOList = materialDTO.getMaterialArticleVOList();
        ArrayList<MaterialArticleDO> materialArticleDOList = new ArrayList<MaterialArticleDO>();
        for (int i = 0; i < materialArticleVOList.size(); ++i) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"FILE_ID", (Object)((MaterialArticleVO)materialArticleVOList.get(i)).getFileID());
            if (this.materialFileMapper.selectCount((Wrapper)wrapper) == 0L) {
                materialFileDOList.add(this.setMaterialFile((FileDTO)materialArticleVOList.get(i), FileMsgBean.FileType.IMAGEFILE));
            }
            materialArticleDOList.add(this.setMaterialArticle((MaterialArticleVO)materialArticleVOList.get(i), i, materialId, urlSplicing));
        }
        if (!materialFileDOList.isEmpty()) {
            this.materialFileService.saveBatch(materialFileDOList);
        }
        if (!materialArticleDOList.isEmpty()) {
            this.materialArticleService.saveBatch(materialArticleDOList);
        }
    }

    private void saveFile(MaterialDTO materialDTO, CurrentLoginUser loginUser) {
        FileDTO fileBean = materialDTO.getFileBean();
        if (fileBean.getFileType() == 1) {
            this.saveMaterial(materialDTO.getTitle(), "", loginUser, BaseMsgBean.MsgType.IMAGE, fileBean.getFileID());
        } else {
            this.saveMaterial(materialDTO.getTitle(), "", loginUser, BaseMsgBean.MsgType.FILETYPE, fileBean.getFileID());
        }
        if (fileBean.getFileID() != null && this.materialFileMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"FILE_ID", (Object)fileBean.getFileID())) > 0L) {
            return;
        }
        Float fileSize = fileBean.getFileSize();
        fileBean.setFileSize(Float.valueOf(fileSize.floatValue() / 1024.0f == 0.0f ? 0.1f : fileSize.floatValue() / 1024.0f));
        FileMaterialDO materialFileDO = new FileMaterialDO();
        BeanUtil.copyProperties((Object)fileBean, (Object)materialFileDO, (String[])new String[0]);
        materialFileDO.setFileType(Integer.valueOf(FileTool.getFileType((String)materialFileDO.getFileName()).ordinal()));
        this.materialFileMapper.insert(materialFileDO);
    }

    private void updateImgText(MaterialDTO materialDTO, String urlSplicing) {
        List materialArticleVOList = materialDTO.getMaterialArticleVOList();
        ArrayList<FileMaterialDO> materialFileAdd = new ArrayList<FileMaterialDO>();
        ArrayList<Long> materialFileDel = new ArrayList<Long>();
        ArrayList<MaterialArticleDO> materialArticleAdd = new ArrayList<MaterialArticleDO>();
        ArrayList<Long> fileIDList = new ArrayList<Long>();
        for (int i = 0; i < materialArticleVOList.size(); ++i) {
            MaterialArticleVO materialArticleVO = (MaterialArticleVO)materialArticleVOList.get(i);
            fileIDList.add(materialArticleVO.getFileID());
            if (materialArticleVO.getObjID() == null) {
                materialFileAdd.add(this.setMaterialFile((FileDTO)materialArticleVO, FileMsgBean.FileType.IMAGEFILE));
                materialArticleAdd.add(this.setMaterialArticle(materialArticleVO, i, materialDTO.getObjID(), urlSplicing));
                continue;
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"FILE_ID", (Object)materialArticleVO.getFileID());
            if (this.materialFileMapper.selectCount((Wrapper)wrapper) == 0L) {
                materialFileDel.add(materialArticleVO.getObjID());
                materialFileAdd.add(this.setMaterialFile((FileDTO)materialArticleVO, FileMsgBean.FileType.IMAGEFILE));
            }
            materialArticleAdd.add(this.setMaterialArticle(materialArticleVO, i, materialDTO.getObjID(), urlSplicing));
        }
        List<Object> oldFileIDS = new ArrayList();
        if (!materialFileDel.isEmpty()) {
            oldFileIDS = this.materialMapper.selectOldImg(materialFileDel);
        }
        if (!materialFileAdd.isEmpty()) {
            this.materialFileService.saveOrUpdateBatch(materialFileAdd);
        }
        if (!materialArticleAdd.isEmpty()) {
            this.materialArticleService.saveOrUpdateBatch(materialArticleAdd);
        }
        if (!oldFileIDS.isEmpty()) {
            this.materialFileService.removeByIds(oldFileIDS);
        }
        this.materialMapper.deleteMaterialFile(materialDTO.getObjID(), fileIDList);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"MSG_ID", (Object)materialDTO.getObjID())).notIn((Object)"FILE_ID", fileIDList);
        this.materialArticleMapper.delete((Wrapper)wrapper);
    }

    private void updateFile(MaterialDTO materialDTO) {
        if (materialDTO.getFileBean() != null) {
            this.materialFileMapper.deleteById(((MaterialDO)this.materialMapper.selectById(materialDTO.getObjID())).getFileID());
            if (materialDTO.getFileBean().getFileType() == 1) {
                this.materialFileMapper.insert(this.setMaterialFile(materialDTO.getFileBean(), FileMsgBean.FileType.IMAGEFILE));
            } else {
                this.materialFileMapper.insert(this.setMaterialFile(materialDTO.getFileBean(), FileTool.getFileType((String)materialDTO.getFileBean().getFileName())));
            }
        }
    }

    public <E extends IPage<MaterialDO>> E page(E page) {
        return (E)super.page(page);
    }

    public <E extends IPage<MaterialDO>> E page(E page, Wrapper<MaterialDO> queryWrapper) {
        return (E)super.page(page, queryWrapper);
    }
}

