/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordConfigDO;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordDO;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordVO;
import com.jxdinfo.mp.im.service.SensitiveWordConfigService;
import com.jxdinfo.mp.im.service.SensitiveWordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u654f\u611f\u8bcdcontroller"})
@ApiVersion
@RestController
@RequestMapping(value={"v1/sensitiveword"})
public class SensitiveWordController {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordController.class);
    @Resource
    private SensitiveWordService sensitiveWordService;
    @Resource
    private SensitiveWordConfigService sensitiveWordConfigService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u654f\u611f\u8bcd\u5217\u8868")
    @GetMapping(value={"list"})
    public Result<PageDTO<SensitiveWordVO>> querySensitiveWordsByContent(@RequestParam(required=false) @ApiParam(value="\u654f\u611f\u8bcd") String content, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum) {
        return this.sensitiveWordService.querySensitiveWordsByContent(content, pageSize, pageNum);
    }

    @ApiOperation(value="\u65b0\u589e\u654f\u611f\u8bcd")
    @PostMapping(value={"add"})
    public Result<Boolean> saveSensitiveWords(@RequestBody @ApiParam(value="\u654f\u611f\u8bcd\u5185\u5bb9\uff0c\u591a\u4e2a\u654f\u611f\u8bcd\u7528\u9017\u53f7\u9694\u5f00") String content) {
        return this.sensitiveWordService.saveSensitiveWordsFromText(content);
    }

    @ApiOperation(value="\u4fee\u6539\u654f\u611f\u8bcd")
    @PostMapping(value={"update"})
    public Result<Boolean> updateSensitiveWordById(@RequestBody @ApiParam(value="\u654f\u611f\u8bcdDO") SensitiveWordDO sensitiveWordDO) {
        return this.sensitiveWordService.updateSensitiveWordById(sensitiveWordDO);
    }

    @ApiOperation(value="\u5220\u9664\u654f\u611f\u8bcd")
    @PostMapping(value={"delete"})
    public Result<Boolean> deleteSensitiveWordsByIds(@RequestBody @ApiParam(value="\u654f\u611f\u8bcd\u4e3b\u952eid") List<String> idList) {
        return this.sensitiveWordService.deleteSensitiveWordsByIds(idList);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165")
    @PostMapping(value={"batchimport"})
    public Result<Boolean> saveSensitiveWordsFromFile(@ApiParam(value="\u6587\u4ef6") MultipartFile file) throws IOException {
        return this.sensitiveWordService.saveSensitiveWordsFromFile(file);
    }

    @ApiOperation(value="\u624b\u52a8\u901a\u77e5OF\u66f4\u65b0\u8bcd\u5e93")
    @GetMapping(value={"notice"})
    public Result<Boolean> notice(@LoginUser CurrentLoginUser currentLoginUser) {
        return this.sensitiveWordService.notice(currentLoginUser);
    }

    @ApiOperation(value="\u67e5\u8be2\u654f\u611f\u8bcd\u914d\u7f6e")
    @GetMapping(value={"config/query"})
    public Result<SensitiveWordConfigDO> queryConfig() {
        return this.sensitiveWordConfigService.queryConfig();
    }

    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u654f\u611f\u8bcd\u914d\u7f6e")
    @PostMapping(value={"config/save"})
    public Result<Boolean> saveConfig(@RequestBody @ApiParam(value="\u654f\u611f\u8bcdDTO") SensitiveWordConfigDO sensitiveWordConfigDO, @LoginUser CurrentLoginUser currentLoginUser) {
        return this.sensitiveWordConfigService.saveConfig(sensitiveWordConfigDO, currentLoginUser);
    }
}

