/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.utils.JqxSpringUtil;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.custom.MainRobotDO;
import com.jxdinfo.mp.im.model.custom.RobotUserDO;
import com.jxdinfo.mp.im.model.custom.RobotVO;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.service.MainRobotService;
import com.jxdinfo.mp.im.service.RobotService;
import com.jxdinfo.mp.im.service.RobotUserService;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.push.model.PushEventMessageDTO;
import com.jxdinfo.mp.push.service.MessageProducerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5ba2\u670d\u76f8\u5173\u63a5\u53e3\uff0c\u5f85\u6d4b2023-10-17"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/custom"})
public class RobotController {
    @Resource
    private RobotUserService robotUserService;
    @Resource
    private RobotService robotService;
    @Resource
    private IOrganizationBoService organizationBoService;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private MainRobotService mainRobotService;

    @ApiOperation(value="\u6839\u636e\u673a\u5668\u4ebaID\u968f\u673a\u83b7\u53d6\u4e00\u4e2a\u5ba2\u670d")
    @GetMapping
    public Result<UserStaffVo> getCustomUser(@ApiIgnore @LoginUser CurrentLoginUser loginUser, @RequestParam(value="robotID") @ApiParam(value="\u673a\u5668\u4ebaID") Long robotID, @RequestParam(value="robotName") String robotName) {
        QueryWrapper robotUserDOQueryWrapper = new QueryWrapper();
        List robotUserDOList = this.robotUserService.list((Wrapper)robotUserDOQueryWrapper.eq((Object)"ROBOTID", (Object)robotID));
        Long id = ((RobotUserDO)robotUserDOList.get(new Random().nextInt(robotUserDOList.size()))).getUserID();
        UserStaffVo userStaffVo = this.organizationBoService.getLinkManInfo(id);
        if (null != userStaffVo) {
            NoticeMsgBean noticeMsgBean = new NoticeMsgBean();
            PushMessageDTO pushMessageDTO = new PushMessageDTO();
            noticeMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)noticeMsgBean)));
            noticeMsgBean.setEventType(NoticeMsgBean.EventType.BLANK);
            noticeMsgBean.setBody("\u60a8\u597d\uff0c\u4eba\u5de5\u5ba2\u670d" + userStaffVo.getUserName() + "\u4e3a\u60a8\u63d0\u4f9b\u670d\u52a1");
            noticeMsgBean.setValue(String.valueOf(robotID));
            noticeMsgBean.setReceiver(String.valueOf(robotID));
            noticeMsgBean.setReceiverCode(robotID.toString());
            noticeMsgBean.setReceiverName(robotName);
            noticeMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
            noticeMsgBean.setSenderName("\u7cfb\u7edf");
            noticeMsgBean.setResource("system");
            noticeMsgBean.setMsgType(BaseMsgBean.MsgType.NOTICE);
            noticeMsgBean.setMode(BaseMsgBean.Mode.CUSTOMERCHAT);
            noticeMsgBean.setMsgTime(DateUtil.now());
            noticeMsgBean.setMsgReceiverCode(loginUser.getId());
            noticeMsgBean.setMsgReceiverName(loginUser.getUserName());
            noticeMsgBean.setCompID(ToolUtil.isNotEmpty((Object)loginUser.getCompanyID()) ? loginUser.getCompanyID().toString() : null);
            noticeMsgBean.setCompName(loginUser.getCompanyName());
            pushMessageDTO.setBaseMsgBean((BaseMsgBean)noticeMsgBean);
            pushMessageDTO.setMode(BaseMsgBean.Mode.CUSTOMERCHAT);
            pushMessageDTO.setReceiverIds(String.valueOf(loginUser.getId()));
            this.pushService.sendMessage(pushMessageDTO);
            EventMsgBean eventMsgBean = new EventMsgBean();
            eventMsgBean.setEventTime(DateUtil.now());
            eventMsgBean.setEventType(EventMsgBean.EventType.OPENWINDOW);
            eventMsgBean.setMode(BaseMsgBean.Mode.CUSTOMERCHAT);
            eventMsgBean.setSenderResource("system");
            eventMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
            eventMsgBean.setObjID(robotID + "," + loginUser.getId());
            PushEventMessageDTO eventMessageDTO = new PushEventMessageDTO();
            eventMessageDTO.setMsg(eventMsgBean);
            eventMessageDTO.setUserID(userStaffVo.getUserId() + "");
            this.pushService.sendEventMessage(eventMessageDTO);
        }
        return Result.succeed((Object)userStaffVo);
    }

    @ApiOperation(value="\u8bc4\u4ef7\u95ee\u9898")
    @PostMapping(value={"evaluate/question"})
    public Result<Boolean> evaluateQuestion(@ApiIgnore @LoginUser CurrentLoginUser loginUser, @RequestParam(value="robotID") Long robotID, @RequestParam(value="robotName") String robotName, @RequestParam(value="questionID", required=false) String questionID, @RequestParam(value="evaluation") String evaluation) {
        questionID = null == questionID ? "" : questionID;
        return Result.succeed((Object)this.robotService.evaluateQuestion(loginUser, robotID, robotName, questionID, evaluation));
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868")
    @GetMapping(value={"robots"})
    public Result<IPage> queryRobotList(@RequestParam(required=false) String searchKey, @RequestParam(required=false, defaultValue="1") int pageNum, @RequestParam(required=false, defaultValue="20") int pageSize) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        String robotName = StrUtil.isEmpty((CharSequence)searchKey) ? "" : searchKey;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.like((Object)"ROBOT_NAME", (Object)JqxSpringUtil.replaceSpecialChar((String)robotName.trim()))).last("ORDER BY SHOW_ORDER");
        return Result.succeed((Object)this.robotService.page((IPage)pageDTO, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u65b0\u589e\u673a\u5668\u4eba")
    @PostMapping(value={"robots"})
    public Result<Boolean> saveRobots(@RequestBody RobotVO robotVO) {
        Map map = this.robotService.saveOrEditRobots(robotVO, 0);
        Result result = (Result)map.get("result");
        MainRobotDO mainRobotDO = (MainRobotDO)map.get("mainDO");
        this.mainRobotService.saveRobot(mainRobotDO);
        return result;
    }

    @ApiOperation(value="\u5220\u9664\u673a\u5668\u4eba")
    @DeleteMapping(value={"robots/{robotID}"})
    public Result<Boolean> deleteRobots(@PathVariable String robotID) {
        List list = Arrays.stream(robotID.split(",")).mapToLong(Convert::toLong).boxed().collect(Collectors.toList());
        this.mainRobotService.deleteRobot(list, BaseSecurityUtil.getUser().getTenantId());
        return this.robotService.deleteRobots(robotID);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u673a\u5668\u4eba\u8be6\u60c5")
    @GetMapping(value={"robots/{robotID}"})
    public Result<RobotVO> robotDetail(@PathVariable Long robotID) {
        return this.robotService.robotDetail(robotID);
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u5668\u4eba")
    @PatchMapping(value={"robots/{robotID}"})
    public Result<Boolean> editRobots(@RequestBody RobotVO robotVO, @PathVariable Long robotID) {
        robotVO.setObjID(robotID);
        Map map = this.robotService.saveOrEditRobots(robotVO, 1);
        Result result = (Result)map.get("result");
        MainRobotDO mainRobotDO = (MainRobotDO)map.get("mainDO");
        this.mainRobotService.saveRobot(mainRobotDO);
        return result;
    }

    @ApiOperation(value="\u5237\u65b0KEY")
    @PatchMapping(value={"{robotID}/key"})
    public Result<String> updateKey(@PathVariable Long robotID) {
        return this.robotService.updateKey(robotID);
    }
}

