/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.common.model.organization.ContactDTO;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.group.GroupAdminDTO;
import com.jxdinfo.mp.im.model.group.GroupDTO;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7fa4\u7ec4\u76f8\u5173\u63a5\u53e3V2"})
@ApiVersion
@RestController
@RequestMapping(value={"v2/groups"})
public class GroupControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(GroupControllerV2.class);
    @Resource
    private GroupService groupService;
    @Resource
    private GroupUserService groupUserService;

    @ApiOperation(value="\u521b\u5efa\u7fa4\u7ec4")
    @PostMapping
    public Result<String> creatGroup(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784DTO") ContactDTO contactDTO, @RequestParam(required=false) @ApiParam(value="\u7fa4\u7ec4ID") String roomID, @RequestParam(required=false) @ApiParam(value="\u7fa4\u7ec4name") String roomName, @RequestParam @ApiParam(value="\u7fa4\u4e3bID") String adminID, @RequestParam(required=false) @ApiParam(value="\u7fa4\u7c7b\u578b,0 \u666e\u901a\u7fa4\uff0c1 \u90e8\u95e8\u7fa4\uff0c2 CRM\u7fa4\uff0c\u9ed8\u8ba4\u4e3a0\u666e\u901a\u7fa4") String groupType, @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            GroupDTO groupDTO = new GroupDTO();
            if (StrUtil.isNotEmpty((CharSequence)roomID)) {
                groupDTO.setRoomID(Long.valueOf(Long.parseLong(roomID)));
            }
            if (StrUtil.isNotEmpty((CharSequence)roomName)) {
                groupDTO.setRoomName(roomName);
            }
            if (StrUtil.isNotEmpty((CharSequence)adminID)) {
                groupDTO.setAdminID(Long.valueOf(Long.parseLong(adminID)));
            }
            if (StrUtil.isNotEmpty((CharSequence)groupType)) {
                groupDTO.setGroupType(Integer.valueOf(Integer.parseInt(groupType)));
            } else {
                groupDTO.setGroupType(Integer.valueOf(0));
            }
            if (contactDTO != null && contactDTO.getUsers() != null) {
                groupDTO.setUsers(contactDTO.getUsers());
            }
            String adminName = currentLoginUser == null ? "" : currentLoginUser.getUserName();
            GroupVO result = this.groupService.createGroup(groupDTO, adminName);
            return Result.succeed((Object)result.getRoomID().toString(), (String)"\u7fa4\u804a\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25", (Throwable)e);
            return Result.failed((String)("\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25: " + e.getMessage()));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u4fe1\u606f")
    @GetMapping(value={"/{roomID}"})
    public Result<GroupVO> groupDetail(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") String roomID, @RequestParam(required=false) @ApiParam(value="userId") Long userId, @LoginUser CurrentLoginUser currentLoginUser) {
        try {
            Long userID;
            Long l = userID = currentLoginUser == null ? userId : currentLoginUser.getId();
            if (userID == null || userID <= 0L) {
                return Result.failed((String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return this.groupService.groupDetail(Long.valueOf(Long.parseLong(roomID)), userID);
        }
        catch (NumberFormatException e) {
            log.error("\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            return Result.failed((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
    }

    @ApiOperation(value="\u9000\u51fa\u7fa4\u7ec4 + \u7fa4\u7ec4\u5220\u4eba 'J_T_0002'+'J_T_0004'")
    @PostMapping(value={"{roomID}/deleteUser"})
    public Result<Boolean> exitGroup(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") String roomID, @RequestBody(required=false) @ApiParam(value="\u4eba\u5458\u96c6\u5408\uff0c[{\"userID\":\"6xxx3dxxx4-ce81-49b7-91a4-ac1cccccc576\",\"userName\":\"\u4ed8\u5fd7\u5fe0\"}]") String userList, @RequestParam(required=false) @ApiParam(value="\u5f53\u524d\u767b\u5f55\u4ebaid") String userId, @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            if (StrUtil.isEmpty((CharSequence)userId)) {
                return Result.failed((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f");
            }
            Long roomIDLong = Long.parseLong(roomID);
            if (userList != null) {
                List rosterList = JSON.parseArray((String)userList, RosterVO.class);
                return this.groupService.deleteGroupMember(roomIDLong, rosterList, currentLoginUser);
            }
            return this.groupService.exitGroup(roomIDLong, currentLoginUser);
        }
        catch (Exception e) {
            log.error("\u9000\u51fa\u7fa4\u7ec4\u5931\u8d25", (Throwable)e);
            return Result.failed((String)("\u64cd\u4f5c\u5931\u8d25: " + e.getMessage()));
        }
    }

    @ApiOperation(value="\u7fa4\u7ec4\u52a0\u4eba")
    @PostMapping(value={"/{roomID}/user"})
    public Result<Boolean> addGroupMember(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784DTO") ContactDTO contactDTO, @PathVariable String roomID, @RequestParam(value="inviteUserID", required=false) @ApiParam(value="\u9080\u8bf7\u4ebaid\uff0c\u5982\u679c\u662f\u4e3b\u52a8\u52a0\u7fa4\uff0c\u8be5\u503c\u53ef\u4e0d\u586b") Long inviteUserID, @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            Long userID;
            String userName = "";
            if (currentLoginUser != null) {
                userID = currentLoginUser.getId();
                userName = currentLoginUser.getUserName();
            } else {
                userID = inviteUserID;
            }
            Long roomIDLong = Long.parseLong(roomID);
            return this.groupService.addGroupMember(contactDTO, roomIDLong, userName, userID);
        }
        catch (Exception e) {
            log.error("\u7fa4\u7ec4\u52a0\u4eba\u5931\u8d25", (Throwable)e);
            return Result.failed((String)("\u52a0\u4eba\u5931\u8d25: " + e.getMessage()));
        }
    }

    @ApiOperation(value="\u6279\u91cf\u7fa4\u7ec4\u52a0\u4eba")
    @PostMapping(value={"/joinMultiGroups"})
    public Result<Boolean> joinMultiGroups(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784DTO") ContactDTO contactDTO, @RequestParam(value="roomIDList") @ApiParam(value="\u7fa4\u7ec4id\u5217\u8868") List<String> roomIDList, @RequestParam(value="inviteUserID", required=true) @ApiParam(value="\u9080\u8bf7\u4ebaid") String inviteUserID, @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            return this.joinMultiGroupsBatch(contactDTO, roomIDList, inviteUserID, currentLoginUser);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u7fa4\u7ec4\u52a0\u4eba\u5931\u8d25", (Throwable)e);
            return Result.failed((String)("\u6279\u91cf\u7fa4\u7ec4\u52a0\u4eba\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    private Result<Boolean> joinMultiGroupsBatch(ContactDTO contactDTO, List<String> roomIDList, String inviteUserID, CurrentLoginUser currentLoginUser) throws Exception {
        if (contactDTO == null || contactDTO.getUsers() == null || contactDTO.getUsers().isEmpty()) {
            return Result.failed((String)"\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<GroupUserDO> batchInsertList = new ArrayList<GroupUserDO>();
        ArrayList<GroupUserDO> batchUpdateList = new ArrayList<GroupUserDO>();
        Long inviteUserIDLong = Long.parseLong(inviteUserID);
        for (String roomID : roomIDList) {
            Long roomIDLong = Long.parseLong(roomID);
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomIDLong)).eq((Object)"DATA_STATUS", (Object)1);
            List existingUsers = this.groupUserService.list((Wrapper)queryWrapper);
            Set existingUserIds = existingUsers.stream().map(GroupUserDO::getUserID).collect(Collectors.toSet());
            QueryWrapper outQueryWrapper = new QueryWrapper();
            ((QueryWrapper)outQueryWrapper.eq((Object)"GROUP_ID", (Object)roomIDLong)).eq((Object)"DATA_STATUS", (Object)0);
            List outUsers = this.groupUserService.list((Wrapper)outQueryWrapper);
            Map outUserMap = outUsers.stream().collect(Collectors.toMap(GroupUserDO::getUserID, Function.identity(), (a, b) -> a));
            for (RosterVO user : contactDTO.getUsers()) {
                if (existingUserIds.contains(user.getUserId())) continue;
                GroupUserDO groupUserDO = new GroupUserDO();
                groupUserDO.setUserID(user.getUserId());
                groupUserDO.setGroupID(roomIDLong);
                groupUserDO.setCreateTime(DateUtil.toLocalDateTime((Date)new Date()));
                groupUserDO.setDataStatus(Integer.valueOf(1));
                groupUserDO.setIsRemind(Integer.valueOf(0));
                groupUserDO.setIsSave(Integer.valueOf(1));
                groupUserDO.setIsTop(Integer.valueOf(0));
                if (outUserMap.containsKey(user.getUserId())) {
                    GroupUserDO outUser = (GroupUserDO)outUserMap.get(user.getUserId());
                    groupUserDO.setGroupUserId(outUser.getGroupUserId());
                    batchUpdateList.add(groupUserDO);
                    continue;
                }
                batchInsertList.add(groupUserDO);
            }
        }
        boolean success = true;
        if (!batchInsertList.isEmpty()) {
            success = this.groupUserService.saveBatch(batchInsertList);
        }
        if (success && !batchUpdateList.isEmpty()) {
            success = this.groupUserService.updateBatchById(batchUpdateList);
        }
        return success ? Result.succeed((Object)true) : Result.failed((String)"\u6279\u91cf\u52a0\u4eba\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="\u6279\u91cf\u8f6c\u8ba9\u7fa4\u7ec4")
    @PostMapping(value={"/transfer"})
    public Result<Boolean> transferGroupList(@RequestBody @ApiParam(value="\u7fa4\u7ba1\u7406\u5458DTO\u5217\u8868") List<GroupAdminDTO> groupAdminDTOList, @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            return this.transferGroupListBatch(groupAdminDTOList, currentLoginUser);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u7fa4\u7ec4\u8f6c\u8ba9\u5931\u8d25", (Throwable)e);
            return Result.failed((String)("\u6279\u91cf\u7fa4\u7ec4\u8f6c\u8ba9\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    private Result<Boolean> transferGroupListBatch(List<GroupAdminDTO> groupAdminDTOList, CurrentLoginUser currentLoginUser) {
        if (groupAdminDTOList == null || groupAdminDTOList.isEmpty()) {
            return Result.failed((String)"\u8f6c\u8ba9\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        int successCount = 0;
        int batchSize = 50;
        for (int i = 0; i < groupAdminDTOList.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, groupAdminDTOList.size());
            List<GroupAdminDTO> batch = groupAdminDTOList.subList(i, endIndex);
            try {
                int batchSuccessCount = this.processBatchTransfer(batch, currentLoginUser, errorMessages);
                successCount += batchSuccessCount;
                continue;
            }
            catch (Exception e) {
                log.error("\u6279\u6b21\u8f6c\u8ba9\u5931\u8d25\uff0c\u6279\u6b21\u8303\u56f4: {}-{}", new Object[]{i, endIndex - 1, e});
                errorMessages.add(String.format("\u6279\u6b21%d-%d\u8f6c\u8ba9\u5931\u8d25: %s", i, endIndex - 1, e.getMessage()));
            }
        }
        int totalCount = groupAdminDTOList.size();
        if (successCount == totalCount) {
            return Result.succeed((Object)true);
        }
        String errorMsg = String.format("\u6279\u91cf\u8f6c\u8ba9\u5b8c\u6210\uff0c\u6210\u529f%d\u4e2a\uff0c\u5931\u8d25%d\u4e2a", successCount, totalCount - successCount);
        if (!errorMessages.isEmpty()) {
            errorMsg = errorMsg + "\u3002\u9519\u8bef\u8be6\u60c5: " + String.join((CharSequence)"; ", errorMessages.subList(0, Math.min(3, errorMessages.size())));
        }
        return Result.failed((String)errorMsg);
    }

    private int processBatchTransfer(List<GroupAdminDTO> batch, CurrentLoginUser currentLoginUser, List<String> errorMessages) {
        int successCount = 0;
        for (GroupAdminDTO groupAdminDTO : batch) {
            String errorMsg;
            try {
                Long roomIDLong = Long.parseLong(groupAdminDTO.getRoomID());
                Long userIDLong = Long.parseLong(groupAdminDTO.getUserID());
                Long adminIDLong = Long.parseLong(groupAdminDTO.getAdminID());
                Result result = this.groupService.transferGroup(roomIDLong, userIDLong, adminIDLong, currentLoginUser);
                if (result.getSuccess().booleanValue()) {
                    ++successCount;
                    continue;
                }
                String errorMsg2 = String.format("\u7fa4\u7ec4%s\u8f6c\u8ba9\u5931\u8d25: %s", roomIDLong, result.getMsg());
                errorMessages.add(errorMsg2);
                log.error(errorMsg2);
            }
            catch (NumberFormatException e) {
                errorMsg = String.format("\u7fa4\u7ec4\u53c2\u6570\u683c\u5f0f\u9519\u8bef: roomID=%s, userID=%s, adminID=%s", groupAdminDTO.getRoomID(), groupAdminDTO.getUserID(), groupAdminDTO.getAdminID());
                errorMessages.add(errorMsg);
                log.error(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                errorMsg = String.format("\u7fa4\u7ec4%s\u8f6c\u8ba9\u5f02\u5e38: %s", groupAdminDTO.getRoomID(), e.getMessage());
                errorMessages.add(errorMsg);
                log.error(errorMsg, (Throwable)e);
            }
        }
        return successCount;
    }
}

