/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.unifiedtodo.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.mp.im.unifiedtodo.annotation.TodoMessagePush;
import com.jxdinfo.mp.im.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.mp.im.unifiedtodo.dto.TodoPushMessageDTO;
import com.jxdinfo.mp.im.unifiedtodo.service.TodoMessagePushService;
import com.jxdinfo.mp.im.unifiedtodo.service.TodoPushDeduplicationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TodoMessagePushAspect {
    private static final Logger log = LoggerFactory.getLogger(TodoMessagePushAspect.class);
    @Autowired
    private TodoMessagePushService todoMessagePushService;
    @Autowired
    private UnifiedTodoProperties unifiedTodoProperties;
    @Autowired
    private TodoPushDeduplicationService todoPushDeduplicationService;

    @Pointcut(value="execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.saveTask(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.updateTask(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.deleteTask(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.addTaskUser(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.deleteTaskUser(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.addUrgeTask(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.transferUserTask(..)) || execution(* com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController.transferTaskDeleteTaskUser(..))")
    public void todoMessagePushPointcut() {
    }

    @Around(value="todoMessagePushPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.unifiedTodoProperties.isEnabled()) {
            log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u529f\u80fd\u5df2\u7981\u7528\uff0c\u8df3\u8fc7AOP\u62e6\u622a\u903b\u8f91");
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getName();
        TodoMessagePush.PushType pushType = this.getPushTypeByMethodName(methodName);
        Object[] originalArgs = joinPoint.getArgs();
        log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u62e6\u622a\u65b9\u6cd5\uff1a{},\u53c2\u6570:{}", (Object)methodName, (Object)JSONUtil.toJsonStr((Object)originalArgs));
        ArrayList<SaveToDoDto> preDeleteTaskDetails = new ArrayList<SaveToDoDto>();
        if (pushType == TodoMessagePush.PushType.DELETE_TASK) {
            try {
                Object taskIds;
                Map body = this.findArgument(originalArgs, Map.class);
                if (body != null && StrUtil.isNotEmpty((CharSequence)(taskIds = (String)body.get("taskIds")))) {
                    String[] taskIdArray;
                    for (String taskId : taskIdArray = ((String)taskIds).split(",")) {
                        String trimmedTaskId = taskId.trim();
                        if (!StrUtil.isNotEmpty((CharSequence)trimmedTaskId)) continue;
                        try {
                            SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(trimmedTaskId);
                            if (taskDetail == null) continue;
                            preDeleteTaskDetails.add(taskDetail);
                            log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] DELETE_TASK\u64cd\u4f5c\u524d\u5df2\u83b7\u53d6\u5f85\u529e\u8be6\u60c5\uff0ctaskId: {}", (Object)trimmedTaskId);
                        }
                        catch (Exception ex) {
                            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6taskId: {} \u7684\u8be6\u60c5\u5931\u8d25: {}", (Object)trimmedTaskId, (Object)ex.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] DELETE_TASK\u64cd\u4f5c\u524d\u83b7\u53d6\u5f85\u529e\u8be6\u60c5\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
        Object result = joinPoint.proceed();
        try {
            if (pushType != null && this.isMethodExecutionSuccessful(result)) {
                if (pushType == TodoMessagePush.PushType.DELETE_TASK && !preDeleteTaskDetails.isEmpty()) {
                    for (SaveToDoDto taskDetail : preDeleteTaskDetails) {
                        TodoPushMessageDTO pushMessageDTO = this.buildTodoPushMessageDTO(pushType, originalArgs, taskDetail);
                        if (pushMessageDTO == null) continue;
                        this.todoPushDeduplicationService.processPushMessage(pushMessageDTO);
                        log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u8bf7\u6c42\u5df2\u5904\u7406\uff0c\u63a8\u9001\u7c7b\u578b\uff1a{}, \u4efb\u52a1ID\uff1a{},\u6253\u5f00\u65b9\u5f0f\uff1a{}", new Object[]{pushType, pushMessageDTO.getTaskId(), pushMessageDTO.getOpenType()});
                    }
                } else if (pushType == TodoMessagePush.PushType.UPDATE_TASK_STATUS) {
                    UpdateTaskStatusDto updateTaskStatusDto = this.findArgument(originalArgs, UpdateTaskStatusDto.class);
                    if (updateTaskStatusDto != null && StrUtil.isNotEmpty((CharSequence)updateTaskStatusDto.getTaskId())) {
                        String[] taskIdArray;
                        String taskIds = updateTaskStatusDto.getTaskId();
                        for (String taskId : taskIdArray = taskIds.split(",")) {
                            String trimmedTaskId = taskId.trim();
                            if (!StrUtil.isNotEmpty((CharSequence)trimmedTaskId)) continue;
                            UpdateTaskStatusDto singleTaskDto = new UpdateTaskStatusDto();
                            BeanUtils.copyProperties((Object)updateTaskStatusDto, (Object)singleTaskDto);
                            singleTaskDto.setTaskId(trimmedTaskId);
                            TodoPushMessageDTO pushMessageDTO = this.buildTodoPushMessageDTO(pushType, new Object[]{singleTaskDto});
                            if (pushMessageDTO == null) continue;
                            this.todoPushDeduplicationService.processPushMessage(pushMessageDTO);
                            log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u8bf7\u6c42\u5df2\u5904\u7406\uff0c\u63a8\u9001\u7c7b\u578b\uff1a{}, \u4efb\u52a1ID\uff1a{},\u6253\u5f00\u65b9\u5f0f\uff1a{}", new Object[]{pushType, pushMessageDTO.getTaskId(), pushMessageDTO.getOpenType()});
                        }
                    }
                } else {
                    TodoPushMessageDTO pushMessageDTO = this.buildTodoPushMessageDTO(pushType, originalArgs);
                    if (pushMessageDTO != null) {
                        this.todoPushDeduplicationService.processPushMessage(pushMessageDTO);
                        log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u8bf7\u6c42\u5df2\u5904\u7406\uff0c\u63a8\u9001\u7c7b\u578b\uff1a{}, \u4efb\u52a1ID\uff1a{},\u6253\u5f00\u65b9\u5f0f\uff1a{}", new Object[]{pushType, pushMessageDTO.getTaskId(), pushMessageDTO.getOpenType()});
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private boolean isMethodExecutionSuccessful(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof ApiResponse) {
            ApiResponse apiResponse = (ApiResponse)result;
            return apiResponse.isSuccess();
        }
        return true;
    }

    private TodoMessagePush.PushType getPushTypeByMethodName(String methodName) {
        switch (methodName) {
            case "saveTask": {
                return TodoMessagePush.PushType.SAVE_TASK;
            }
            case "updateTask": {
                return TodoMessagePush.PushType.UPDATE_TASK;
            }
            case "deleteTask": {
                return TodoMessagePush.PushType.DELETE_TASK;
            }
            case "updateTaskStatus": {
                return TodoMessagePush.PushType.UPDATE_TASK_STATUS;
            }
            case "updateUserStatus": {
                return TodoMessagePush.PushType.UPDATE_USER_STATUS;
            }
            case "updateTaskUser": {
                return TodoMessagePush.PushType.UPDATE_TASK_USER;
            }
            case "addTaskUser": {
                return TodoMessagePush.PushType.ADD_TASK_USER;
            }
            case "deleteTaskUser": {
                return TodoMessagePush.PushType.DELETE_TASK_USER;
            }
            case "addUrgeTask": {
                return TodoMessagePush.PushType.ADD_URGE_TASK;
            }
            case "transferUserTask": {
                return TodoMessagePush.PushType.TRANSFER_USER_TASK;
            }
            case "updateTaskStatusWithOutFollowers": {
                return TodoMessagePush.PushType.UPDATE_TASK_STATUS_WITHOUT_FOLLOWERS;
            }
            case "transferTaskDeleteTaskUser": {
                return TodoMessagePush.PushType.TRANSFER_TASK_DELETE_USER;
            }
        }
        return null;
    }

    private TodoPushMessageDTO buildTodoPushMessageDTO(TodoMessagePush.PushType pushType, Object[] args) {
        return this.buildTodoPushMessageDTO(pushType, args, null);
    }

    private TodoPushMessageDTO buildTodoPushMessageDTO(TodoMessagePush.PushType pushType, Object[] args, SaveToDoDto preDeleteTaskDetail) {
        if (args == null || args.length == 0) {
            return null;
        }
        TodoPushMessageDTO pushMessageDTO = new TodoPushMessageDTO();
        pushMessageDTO.setPushType(pushType);
        pushMessageDTO.setCreateTime(new Date());
        String currentOperatorId = this.getCurrentOperatorId();
        pushMessageDTO.setCurrentOperatorId(currentOperatorId);
        switch (pushType) {
            case SAVE_TASK: 
            case UPDATE_TASK: 
            case UPDATE_TASK_USER: {
                return this.buildSaveToDoMessage(pushMessageDTO, args);
            }
            case ADD_URGE_TASK: {
                return this.buildUrgeTaskMessage(pushMessageDTO, args);
            }
            case DELETE_TASK: {
                if (preDeleteTaskDetail != null) {
                    return this.buildDeleteTaskMessageWithPreSavedDetail(pushMessageDTO, args, preDeleteTaskDetail);
                }
                return this.buildDeleteTaskMessageBasic(pushMessageDTO, args);
            }
            case UPDATE_TASK_STATUS: 
            case UPDATE_TASK_STATUS_WITHOUT_FOLLOWERS: {
                return this.buildUpdateTaskStatusMessage(pushMessageDTO, args);
            }
            case UPDATE_USER_STATUS: {
                return this.buildUpdateUserStatusMessage(pushMessageDTO, args);
            }
            case ADD_TASK_USER: 
            case DELETE_TASK_USER: 
            case TRANSFER_TASK_DELETE_USER: {
                return this.buildTaskUserMessage(pushMessageDTO, args);
            }
            case TRANSFER_USER_TASK: {
                return this.buildTransferTaskMessage(pushMessageDTO, args);
            }
        }
        log.warn("\u672a\u5904\u7406\u7684\u63a8\u9001\u7c7b\u578b: {}", (Object)pushType);
        return null;
    }

    private TodoPushMessageDTO buildSaveToDoMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        SaveToDoDto saveToDoDto = this.findArgument(args, SaveToDoDto.class);
        if (saveToDoDto == null) {
            return null;
        }
        if (StrUtil.isNotEmpty((CharSequence)saveToDoDto.getTaskId())) {
            try {
                SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(saveToDoDto.getTaskId());
                if (taskDetail != null) {
                    this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
                }
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            }
        }
        pushMessageDTO.setCreateUserId(StrUtil.isNotEmpty((CharSequence)saveToDoDto.getCreateUserId()) ? Long.valueOf(Long.parseLong(saveToDoDto.getCreateUserId())) : null);
        pushMessageDTO.setCreateUserName(saveToDoDto.getCreateUserName());
        pushMessageDTO.setExecutorIds(this.parseUserIds(saveToDoDto.getExecutors()));
        pushMessageDTO.setFollowerIds(this.parseUserIds(saveToDoDto.getFollowers()));
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildUrgeTaskMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        block6: {
            SaveToDoDto saveToDoDto = this.findArgument(args, SaveToDoDto.class);
            if (saveToDoDto == null) {
                return null;
            }
            BeanUtils.copyProperties((Object)saveToDoDto, (Object)pushMessageDTO);
            pushMessageDTO.setSystemId(String.valueOf(saveToDoDto.getSystemId()));
            pushMessageDTO.setCreateUserId(StrUtil.isNotEmpty((CharSequence)saveToDoDto.getCreateUserId()) ? Long.valueOf(Long.parseLong(saveToDoDto.getCreateUserId())) : null);
            pushMessageDTO.setCreateUserName(saveToDoDto.getCreateUserName());
            if (StrUtil.isNotEmpty((CharSequence)saveToDoDto.getTaskId())) {
                try {
                    SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(saveToDoDto.getTaskId());
                    if (taskDetail != null) {
                        this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
                        pushMessageDTO.setExecutorIds(this.parseUserIds(taskDetail.getExecutors()));
                        pushMessageDTO.setFollowerIds(this.parseUserIds(taskDetail.getFollowers()));
                        log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u50ac\u529e\u4efb\u52a1\u67e5\u8be2\u5230\u6267\u884c\u4eba: {}, \u5173\u6ce8\u4eba: {}", (Object)taskDetail.getExecutors(), (Object)taskDetail.getFollowers());
                        break block6;
                    }
                    log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u50ac\u529e\u4efb\u52a1\u672a\u67e5\u8be2\u5230taskId: {} \u7684\u8be6\u7ec6\u4fe1\u606f", (Object)saveToDoDto.getTaskId());
                    pushMessageDTO.setExecutorIds(this.parseUserIds(saveToDoDto.getExecutors()));
                    pushMessageDTO.setFollowerIds(this.parseUserIds(saveToDoDto.getFollowers()));
                }
                catch (Exception e) {
                    log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u50ac\u529e\u4efb\u52a1\u67e5\u8be2taskId: {} \u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38: {}", new Object[]{saveToDoDto.getTaskId(), e.getMessage(), e});
                    pushMessageDTO.setExecutorIds(this.parseUserIds(saveToDoDto.getExecutors()));
                    pushMessageDTO.setFollowerIds(this.parseUserIds(saveToDoDto.getFollowers()));
                }
            } else {
                pushMessageDTO.setExecutorIds(this.parseUserIds(saveToDoDto.getExecutors()));
                pushMessageDTO.setFollowerIds(this.parseUserIds(saveToDoDto.getFollowers()));
            }
        }
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildDeleteTaskMessageBasic(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        Map body = this.findArgument(args, Map.class);
        if (body == null) {
            return null;
        }
        String taskIds = (String)body.get("taskIds");
        String systemId = (String)body.get("systemId");
        pushMessageDTO.setTaskId(taskIds);
        pushMessageDTO.setSystemId(systemId);
        pushMessageDTO.setProcessInstanceid((String)body.get("processInstId"));
        log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u6784\u5efaDELETE_TASK\u57fa\u672c\u6d88\u606f\uff0ctaskIds: {}, systemId: {}", (Object)taskIds, (Object)systemId);
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildUpdateTaskStatusMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        UpdateTaskStatusDto updateTaskStatusDto = this.findArgument(args, UpdateTaskStatusDto.class);
        if (updateTaskStatusDto == null) {
            return null;
        }
        String taskIds = updateTaskStatusDto.getTaskId();
        pushMessageDTO.setTaskId(taskIds);
        pushMessageDTO.setSystemId(updateTaskStatusDto.getSystemId());
        pushMessageDTO.setProcessInstanceid(updateTaskStatusDto.getProcessInstId());
        pushMessageDTO.setTaskStatus(updateTaskStatusDto.getTaskStatus());
        pushMessageDTO.setWebLinkurl(updateTaskStatusDto.getWebLinkurl());
        pushMessageDTO.setMobileLinkurl(updateTaskStatusDto.getMobileLinkurl());
        pushMessageDTO.setFormId(updateTaskStatusDto.getFormId());
        String firstTaskId = taskIds.contains(",") ? taskIds.split(",")[0].trim() : taskIds;
        try {
            SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(firstTaskId);
            if (taskDetail != null) {
                this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
            }
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6\u4efb\u52a1\u8be6\u60c5\u5931\u8d25\uff0ctaskId: {}, error: {}", (Object)firstTaskId, (Object)e.getMessage());
        }
        pushMessageDTO.setUserType("1");
        pushMessageDTO.setExecuteStatus("0");
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildUpdateUserStatusMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        UnifiedTaskUser unifiedTaskUser = this.findArgument(args, UnifiedTaskUser.class);
        if (unifiedTaskUser == null) {
            return null;
        }
        pushMessageDTO.setTaskId(unifiedTaskUser.getTaskId());
        pushMessageDTO.setSystemId(String.valueOf(unifiedTaskUser.getSystemId()));
        pushMessageDTO.setUserExecuteStatus(unifiedTaskUser.getExecuteStatus());
        try {
            SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(unifiedTaskUser.getTaskId());
            if (taskDetail != null) {
                this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
            }
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6\u4efb\u52a1\u8be6\u60c5\u5931\u8d25\uff0ctaskId: {}, error: {}", (Object)unifiedTaskUser.getTaskId(), (Object)e.getMessage());
        }
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildTaskUserMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        List unifiedTaskUsers = this.findArgument(args, List.class);
        if (CollUtil.isEmpty((Collection)unifiedTaskUsers)) {
            return null;
        }
        UnifiedTaskUser firstUser = (UnifiedTaskUser)unifiedTaskUsers.get(0);
        pushMessageDTO.setTaskId(firstUser.getTaskId());
        pushMessageDTO.setSystemId(firstUser.getSystemId() != null ? firstUser.getSystemId().toString() : null);
        try {
            SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(firstUser.getTaskId());
            if (taskDetail != null) {
                this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
            }
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6\u4efb\u52a1\u8be6\u60c5\u5931\u8d25\uff0ctaskId: {}, error: {}", (Object)firstUser.getTaskId(), (Object)e.getMessage());
        }
        HashSet<String> executorIds = new HashSet<String>();
        HashSet<String> followerIds = new HashSet<String>();
        for (Object obj : unifiedTaskUsers) {
            if (!(obj instanceof UnifiedTaskUser)) continue;
            UnifiedTaskUser user = (UnifiedTaskUser)obj;
            if ("1".equals(user.getUserType())) {
                executorIds.add(user.getUserId());
                continue;
            }
            if (!"0".equals(user.getUserType())) continue;
            followerIds.add(user.getUserId());
        }
        TodoMessagePush.PushType pushType = pushMessageDTO.getPushType();
        if (pushType == TodoMessagePush.PushType.ADD_TASK_USER) {
            pushMessageDTO.setNewExecutorIds(executorIds);
            pushMessageDTO.setNewFollowerIds(followerIds);
        } else if (pushType == TodoMessagePush.PushType.DELETE_TASK_USER || pushType == TodoMessagePush.PushType.TRANSFER_TASK_DELETE_USER) {
            pushMessageDTO.setDeletedExecutorIds(executorIds);
            pushMessageDTO.setDeletedFollowerIds(followerIds);
        }
        return pushMessageDTO;
    }

    private TodoPushMessageDTO buildTransferTaskMessage(TodoPushMessageDTO pushMessageDTO, Object[] args) {
        TransferTaskDto transferTaskDto = this.findArgument(args, TransferTaskDto.class);
        if (transferTaskDto == null) {
            return null;
        }
        SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(transferTaskDto.getTaskId());
        if (taskDetail != null) {
            this.copyTaskDetailToDTO(taskDetail, pushMessageDTO);
        }
        pushMessageDTO.setTaskId(transferTaskDto.getTaskId());
        pushMessageDTO.setSystemId(transferTaskDto.getSystemId() != null ? transferTaskDto.getSystemId().toString() : null);
        TodoPushMessageDTO.TransferInfo transferInfo = new TodoPushMessageDTO.TransferInfo();
        transferInfo.setOriginalExecutorId(transferTaskDto.getConsignor() != null ? Long.valueOf(Long.parseLong(transferTaskDto.getConsignor())) : null);
        transferInfo.setNewExecutorId(transferTaskDto.getUserId() != null ? Long.valueOf(Long.parseLong(transferTaskDto.getUserId())) : null);
        transferInfo.setTransferReason("\u4efb\u52a1\u8f6c\u529e");
        pushMessageDTO.setTransferInfo(transferInfo);
        return pushMessageDTO;
    }

    private void copyTaskDetailToDTO(SaveToDoDto taskDetail, TodoPushMessageDTO pushMessageDTO) {
        if (taskDetail == null || pushMessageDTO == null) {
            return;
        }
        BeanUtils.copyProperties((Object)taskDetail, (Object)pushMessageDTO);
        if (StrUtil.isNotEmpty((CharSequence)taskDetail.getCreateUserId())) {
            pushMessageDTO.setCreateUserId(Long.parseLong(taskDetail.getCreateUserId()));
            pushMessageDTO.setCreateUserName(taskDetail.getCreateUserName());
        }
        pushMessageDTO.setExecutorIds(this.parseUserIds(taskDetail.getExecutors()));
        pushMessageDTO.setFollowerIds(this.parseUserIds(taskDetail.getFollowers()));
        if (taskDetail.getSystemId() != null) {
            pushMessageDTO.setSystemId(String.valueOf(taskDetail.getSystemId()));
        }
    }

    private <T> T findArgument(Object[] args, Class<T> targetType) {
        for (Object arg : args) {
            if (arg == null || !targetType.isAssignableFrom(arg.getClass())) continue;
            return (T)arg;
        }
        return null;
    }

    private Set<String> parseUserIds(List<UnifiedTaskUser> users) {
        if (CollUtil.isEmpty(users)) {
            return new HashSet<String>();
        }
        return users.stream().map(user -> user.getUserId()).collect(Collectors.toSet());
    }

    private TodoPushMessageDTO buildDeleteTaskMessageWithPreSavedDetail(TodoPushMessageDTO pushMessageDTO, Object[] args, SaveToDoDto preDeleteTaskDetail) {
        this.copyTaskDetailToDTO(preDeleteTaskDetail, pushMessageDTO);
        log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u4f7f\u7528\u9884\u4fdd\u5b58\u8be6\u60c5\u6784\u5efaDELETE_TASK\u63a8\u9001\u6d88\u606f\uff0ctaskId: {}, executors: {}, followers: {}", new Object[]{preDeleteTaskDetail.getTaskId(), preDeleteTaskDetail.getExecutors(), preDeleteTaskDetail.getFollowers()});
        return pushMessageDTO;
    }

    private String getCurrentOperatorId() {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null && user.getId() != null) {
                String userId = String.valueOf(user.getId());
                log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u6210\u529f\u83b7\u53d6\u5f53\u524d\u64cd\u4f5c\u8005ID: {}", (Object)userId);
                return userId;
            }
            log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u5f53\u524d\u7528\u6237\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u672a\u767b\u5f55\u6216\u533f\u540d\u8bbf\u95ee");
            return null;
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6\u5f53\u524d\u64cd\u4f5c\u8005ID\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }
}

