/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.enums.BaseErrorCode;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.common.model.organization.ContactDTO;
import com.jxdinfo.mp.common.model.organization.ContactVO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.dao.custom.IHeadImg2Mapper;
import com.jxdinfo.mp.im.dao.group.GroupMapper;
import com.jxdinfo.mp.im.dao.group.GroupUserMapper;
import com.jxdinfo.mp.im.enums.GroupErrorCode;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.db.GroupDO;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.group.GroupDTO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.service.GroupCacheService;
import com.jxdinfo.mp.im.service.GroupManageService;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import com.jxdinfo.mp.im.util.ListUtil;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
@HussarTokenDs
public class GroupServiceImpl
extends ServiceImpl<GroupMapper, GroupDO>
implements GroupService {
    private static final Logger log = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private GroupManageService groupManageService;
    @Resource
    private IOrganizationBoService organizationService;
    @Resource
    private GroupCacheService groupCacheService;
    @Resource
    private GroupMapper groupMapper;
    @Resource
    private GroupUserMapper groupUserMapper;
    @Resource
    private IHeadImg2Mapper IHeadImg2Mapper;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ContactService contactService;
    @Resource
    private OrganizationProperties organizationProperties;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    private static final Long BOSS_ID = 1994060001L;

    private void addMember(Long roomID, List<RosterVO> rosterList) {
        ArrayList<GroupUserDO> addList = new ArrayList<GroupUserDO>();
        ArrayList<GroupUserDO> updateList = new ArrayList<GroupUserDO>();
        String key = "ApiGroupChat:" + roomID;
        Object groupVO = HussarCacheUtil.get((String)"eim_cache", (Object)key);
        List groupUserDOOut = new ArrayList();
        List groupUserDOIn = new ArrayList();
        if (groupVO != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomID)).eq((Object)"DATA_STATUS", (Object)0);
            groupUserDOOut = this.groupUserMapper.selectList((Wrapper)queryWrapper);
            QueryWrapper queryWrapper2 = new QueryWrapper();
            ((QueryWrapper)queryWrapper2.eq((Object)"GROUP_ID", (Object)roomID)).eq((Object)"DATA_STATUS", (Object)1);
            groupUserDOIn = this.groupUserMapper.selectList((Wrapper)queryWrapper2);
        }
        for (RosterVO item : rosterList) {
            if (groupUserDOIn.stream().anyMatch(e -> e.getUserID().equals(item.getUserId()))) continue;
            GroupUserDO groupUserDO = new GroupUserDO();
            groupUserDO.setUserID(item.getUserId());
            groupUserDO.setGroupID(roomID);
            groupUserDO.setCreateTime(DateUtil.toLocalDateTime((Date)new Date()));
            groupUserDO.setDataStatus(Integer.valueOf(1));
            groupUserDO.setIsRemind(Integer.valueOf(0));
            groupUserDO.setIsSave(Integer.valueOf(1));
            groupUserDO.setIsTop(Integer.valueOf(0));
            boolean flag = false;
            for (GroupUserDO groupUser : groupUserDOOut) {
                if (!groupUserDO.getUserID().equals(groupUser.getUserID())) continue;
                groupUserDO.setDataStatus(Integer.valueOf(1));
                groupUserDO.setGroupUserId(groupUser.getGroupUserId());
                flag = true;
                break;
            }
            if (flag) {
                updateList.add(groupUserDO);
                continue;
            }
            addList.add(groupUserDO);
        }
        if (CollectionUtil.isNotEmpty(addList)) {
            this.groupUserService.saveBatch(addList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.groupUserService.updateBatchById(updateList);
        }
    }

    private boolean judgeGroupHead(Long roomID) {
        GroupDO groupDO = (GroupDO)this.groupMapper.selectById(roomID);
        if (groupDO == null) {
            return false;
        }
        int headType = groupDO.getHeadType();
        return headType == 0;
    }

    @Transactional
    public Result<Boolean> groupNotice(Long roomID, String notice, CurrentLoginUser currentLoginUser) {
        GroupDO groupDO = (GroupDO)this.groupMapper.selectById(roomID);
        if (groupDO.getAdminID() == null || !currentLoginUser.getId().equals(groupDO.getAdminID())) {
            return Result.failed((Object)false, (String)"\u4e0d\u662f\u7fa4\u4e3b\uff0c\u6ca1\u6709\u6743\u9650");
        }
        groupDO.setNotice(notice);
        groupDO.setNoticeTime(DateUtil.now());
        groupDO.setSenderID(currentLoginUser.getId());
        groupDO.setSenderName(currentLoginUser.getUserName());
        this.groupCacheService.clearRoomCache(roomID);
        return Result.succeed((Object)(this.groupMapper.updateById(groupDO) > 0 ? 1 : 0));
    }

    @Transactional
    public Result<Boolean> modifyGroupHead(Long roomID, Long userID, String headImgId) {
        GroupDO groupDO = (GroupDO)this.groupMapper.selectById(roomID);
        if (groupDO.getAdminID() == null || !userID.equals(groupDO.getAdminID())) {
            return Result.failed((Object)false, (String)"\u4e0d\u662f\u7fa4\u4e3b\uff0c\u6ca1\u6709\u6743\u9650");
        }
        HeadingImg head = new HeadingImg();
        head.setHeadimgId(roomID);
        head.setFileId(Long.valueOf(Long.parseLong(headImgId)));
        HeadingImg headingImg = (HeadingImg)this.IHeadImg2Mapper.selectById(roomID);
        if (headingImg == null) {
            this.IHeadImg2Mapper.insert(head);
        } else {
            this.IHeadImg2Mapper.updateById(head);
        }
        groupDO.setHeadType(Integer.valueOf(1));
        this.groupCacheService.clearRoomCache(roomID);
        int num = this.groupMapper.updateById(groupDO);
        return Result.succeed((Object)(num > 0 ? 1 : 0));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public GroupVO createGroup(GroupDTO groupDTO, String adminName) throws IOException {
        long start2 = System.currentTimeMillis();
        List rosterList = groupDTO.getUsers();
        Long roomID = groupDTO.getRoomID();
        Long adminID = groupDTO.getAdminID();
        String roomName = groupDTO.getRoomName();
        long start3 = System.currentTimeMillis();
        final GroupDO groupDO = new GroupDO();
        final Long groupID = roomID == null ? IdWorker.getId((Object)groupDO) : roomID;
        if (StrUtil.isNotEmpty((CharSequence)roomName)) {
            groupDO.setGroupName(roomName);
        }
        groupDO.setGroupId(groupID);
        groupDO.setAdminID(adminID);
        groupDO.setGroupType(Integer.valueOf(0));
        this.groupMapper.insert(groupDO);
        long start = System.currentTimeMillis();
        this.addMember(groupID, rosterList);
        System.out.println("\u7fa4\u7684\u4eba\u5458\u6dfb\u52a0\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        long start4 = System.currentTimeMillis();
        GroupVO groupVO = new GroupVO();
        groupVO.setRoomID(groupID);
        groupVO.setUsers(rosterList);
        groupVO.setUserCount(rosterList.size());
        groupVO.setRoomName(groupDO.getGroupName());
        String key = "ApiGroupChat:" + roomID;
        HussarCacheUtil.put((String)"eim_cache", (Object)key, (Object)groupVO);
        groupVO.setRoomName(this.getRoomName(groupVO, false));
        System.out.println("redis\u5b58\u50a8\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start4) + "ms");
        long start5 = System.currentTimeMillis();
        if (this.judgeGroupHead(roomID)) {
            this.groupManageService.generateRoomHeadImg(groupVO);
        }
        System.out.println("\u751f\u6210\u7fa4\u5934\u50cf\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start5) + "ms");
        long start6 = System.currentTimeMillis();
        String inviteeNames = ListUtil.listToString(rosterList.stream().filter(r -> !r.getUserId().equals(adminID)).map(RosterVO::getUserName).collect(Collectors.toList()), (String)"\uff0c");
        final String bodyStr = adminName + "\u9080\u8bf7" + inviteeNames + "\u8fdb\u5165\u7fa4\u804a";
        groupDO.setGroupName(groupVO.getRoomName());
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                GroupServiceImpl.this.groupCacheService.clearRoomCache(groupID);
                GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, bodyStr, "", NoticeMsgBean.EventType.ADDUSER);
            }
        });
        System.out.println("\u53d1\u9001notice\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start6) + "ms");
        System.out.println("\u521b\u5efa\u7fa4\u804a\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start2) + "ms");
        return groupVO;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public Result<Boolean> exitGroup(final Long roomID, final CurrentLoginUser currentLoginUser) throws IOException {
        Result result = new Result();
        result.setSuccess(Boolean.valueOf(false));
        result.setData((Object)false);
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (groupVO.getAdminID() == null || CollectionUtil.isEmpty((Collection)groupVO.getUsers())) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_NOT_EXIST);
        }
        List groupUserIdList = groupVO.getUsers().stream().map(RosterVO::getUserId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(groupUserIdList) && !groupUserIdList.contains(currentLoginUser.getId())) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_MEMBER_NOT_EXIST);
        }
        if (groupVO.getGroupType() != null && groupVO.getGroupType() == 1) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_PERMISSION_DENIED);
        }
        final String msgBody = currentLoginUser.getUserName() + "\u9000\u51fa\u4e86\u5f53\u524d\u7fa4\u804a";
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomID)).eq((Object)"USER_ID", (Object)currentLoginUser.getId());
        GroupUserDO groupUserDO = (GroupUserDO)this.groupUserService.getOne((Wrapper)queryWrapper);
        groupUserDO.setDataStatus(Integer.valueOf(0));
        groupUserDO.setIsTop(Integer.valueOf(0));
        int flag = this.groupUserMapper.updateById(groupUserDO);
        final GroupDO groupDO = new GroupDO();
        GroupDO groupDO1 = (GroupDO)this.groupMapper.selectById(roomID);
        groupDO.setGroupId(roomID);
        groupDO.setGroupName(groupVO.getRoomName());
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        if (groupVO.getUsers().size() > 1) {
            if (groupDO1.getAdminID().equals(currentLoginUser.getId())) {
                Long perAdminID = ((RosterVO)groupVO.getUsers().get(1)).getUserId();
                groupDO.setAdminID(perAdminID);
                this.groupMapper.updateById(groupDO);
            }
        } else {
            groupDO.setAdminID(null);
            ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(GroupDO::getGroupId, (Object)roomID)).set(GroupDO::getAdminID, null);
            this.groupMapper.update(groupDO, (Wrapper)lambdaUpdateWrapper);
        }
        groupDO.setGroupName(this.getRoomName(groupVO, true));
        groupVO.setUsers(groupVO.getUsers().stream().filter(r -> !r.getUserId().equals(currentLoginUser.getId())).collect(Collectors.toList()));
        if (flag > 0 && groupVO.getUsers().size() > 0) {
            if (this.judgeGroupHead(roomID)) {
                this.groupManageService.generateRoomHeadImg(groupVO);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    GroupServiceImpl.this.groupCacheService.clearRoomCache(roomID);
                    GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, msgBody, currentLoginUser.getId() + "", NoticeMsgBean.EventType.DELETEUSER);
                }
            });
            result.setSuccess(Boolean.valueOf(true));
            result.setData((Object)true);
        } else if (flag > 0) {
            this.groupCacheService.clearRoomCache(roomID);
            result.setSuccess(Boolean.valueOf(true));
            result.setData((Object)true);
        } else {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_REMOVE_MEMBER_FAILED);
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public Result<Boolean> addGroupMember(ContactDTO contactDTO, final Long roomID, String userName, Long inviteUserID, String userId) throws IOException {
        Result result = new Result();
        result.setSuccess(Boolean.valueOf(false));
        result.setData((Object)false);
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (groupVO.getGroupType() != null && groupVO.getGroupType() == 1) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_PERMISSION_DENIED);
        }
        if (groupVO.getAdminID() == null || CollectionUtil.isEmpty((Collection)groupVO.getUsers())) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_NOT_EXIST);
        }
        List groupUserIdList = groupVO.getUsers().stream().map(RosterVO::getUserId).collect(Collectors.toList());
        if (inviteUserID != null && !groupUserIdList.contains(inviteUserID)) {
            return Result.failed((Object)false, (BaseErrorCode)GroupErrorCode.GROUP_MEMBER_NOT_EXIST);
        }
        List<RosterVO> rosterList = contactDTO.getUsers();
        List contactList = contactDTO.getOrgs();
        if (contactList != null && contactList.size() != 0) {
            Long orgID = contactDTO.getOrgID();
            List list = this.organizationService.searchContact(orgID, null, null);
            rosterList.addAll(list);
        }
        List existingUserIds = groupVO.getUsers().stream().map(RosterVO::getUserId).collect(Collectors.toList());
        if (!(rosterList = rosterList.stream().filter(r -> !existingUserIds.contains(r.getUserId())).distinct().collect(Collectors.toList())).isEmpty()) {
            Optional<RosterVO> inviteUser;
            this.addMember(roomID, rosterList);
            rosterList.forEach(r -> r.setCreateTime(DateUtil.now()));
            String inviteeNames = ListUtil.listToString(rosterList.stream().map(RosterVO::getUserName).collect(Collectors.toList()), (String)"\uff0c");
            final String groupUserIDs = ListUtil.listToString(rosterList.stream().map(r -> String.valueOf(r.getUserId())).collect(Collectors.toList()));
            String body = StrUtil.isEmpty((CharSequence)userName) ? ((inviteUser = groupVO.getUsers().stream().filter(rosterVO -> rosterVO.getUserId().equals(inviteUserID)).findFirst()).isPresent() ? inviteeNames + "\u901a\u8fc7" + inviteUser.get().getUserName() + "\u5206\u4eab\u7684\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a" : inviteeNames + "\u901a\u8fc7\u4e8c\u7ef4\u7801\u52a0\u5165\u7fa4\u804a") : userName + "\u9080\u8bf7" + inviteeNames + "\u8fdb\u5165\u7fa4\u804a";
            if (groupVO.getUsers().size() < 9) {
                groupVO.getUsers().addAll(rosterList);
                groupVO.setUsers(groupVO.getUsers());
                if (this.judgeGroupHead(roomID)) {
                    this.groupManageService.generateRoomHeadImg(groupVO);
                }
            }
            final GroupDO groupDO = new GroupDO();
            groupDO.setGroupName(this.getRoomName(groupVO, true));
            groupDO.setGroupId(groupVO.getRoomID());
            final String finalBody = body;
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    GroupServiceImpl.this.groupCacheService.clearRoomCache(roomID);
                    GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, finalBody, groupUserIDs, NoticeMsgBean.EventType.ADDUSER);
                }
            });
            result.setSuccess(Boolean.valueOf(true));
            result.setData((Object)true);
        } else {
            result.setMsg("\u8be5\u4eba\u5df2\u5b58\u5728");
        }
        return result;
    }

    private String getRoomName(GroupVO groupVO, boolean search) {
        if (groupVO.getRoomName() == null || "".equals(groupVO.getRoomName())) {
            List<RosterVO> userList;
            if (search) {
                userList = userList.subList(0, (userList = this.groupMapper.getAllUserByRoomID(groupVO.getRoomID())).size() > 5 ? 5 : userList.size());
            } else {
                userList = groupVO.getUsers();
                userList = userList.subList(0, Math.min(userList.size(), 5));
            }
            return ListUtil.listToString(userList.stream().filter(Objects::nonNull).map(RosterVO::getUserName).collect(Collectors.toList()), (String)"\uff0c");
        }
        return groupVO.getRoomName();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public Result<Boolean> deleteGroupMember(final Long roomID, List<RosterVO> rosterList, final CurrentLoginUser currentLoginUser, boolean superadmin) throws IOException {
        GroupDO groupDO;
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (!currentLoginUser.getId().equals(groupVO.getAdminID()) && !superadmin) {
            return Result.failed((Object)false, (String)"\u4e0d\u662f\u7fa4\u4e3b\uff0c\u6ca1\u6709\u6743\u9650");
        }
        ArrayList useridList = new ArrayList();
        rosterList.forEach(r -> useridList.add(r.getUserId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomID)).in((Object)"USER_ID", useridList);
        GroupUserDO groupUserDO = new GroupUserDO();
        groupUserDO.setDataStatus(Integer.valueOf(0));
        groupUserDO.setIsTop(Integer.valueOf(0));
        groupVO.getUsers().removeIf(r -> useridList.contains(r.getUserId()));
        if (this.groupUserService.update((Object)groupUserDO, (Wrapper)queryWrapper)) {
            groupDO = new GroupDO();
            groupDO.setGroupName(this.getRoomName(groupVO, false));
            groupDO.setGroupId(groupVO.getRoomID());
            if (this.judgeGroupHead(roomID)) {
                this.groupManageService.generateRoomHeadImg(groupVO);
            }
        } else {
            return Result.failed((Object)false, (String)"\u7fa4\u7ec4\u5220\u4eba\u5931\u8d25");
        }
        final String deleteUserName = rosterList.stream().map(RosterVO::getUserName).collect(Collectors.joining("\uff0c"));
        String deleteUserIds = rosterList.stream().map(rosterVO -> String.valueOf(rosterVO.getUserId())).collect(Collectors.joining(","));
        final String noticeUserIds = deleteUserIds + "," + groupVO.getUsers().stream().map(rosterVO -> rosterVO.getUserId().toString()).collect(Collectors.joining(","));
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                String msgBody = currentLoginUser.getUserName() + "\u5c06" + deleteUserName + "\u79fb\u51fa\u4e86\u7fa4\u804a";
                GroupServiceImpl.this.groupCacheService.clearRoomCache(roomID);
                GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, msgBody, noticeUserIds, NoticeMsgBean.EventType.DELETEUSER);
            }
        });
        return Result.succeed((Object)true);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public Result<Boolean> updateGroup(final GroupDTO groupDTO, CurrentLoginUser currentLoginUser) throws NullPointerException {
        GroupVO groupVO = this.groupCacheService.getRoomBean(groupDTO.getRoomID());
        if (groupVO.getAdminID() == null || CollectionUtil.isEmpty((Collection)groupVO.getUsers())) {
            return Result.failed((Object)false, (String)"\u8be5\u7fa4\u5df2\u89e3\u6563");
        }
        if (!groupVO.getUsers().stream().map(RosterVO::getUserId).collect(Collectors.toList()).contains(currentLoginUser.getId())) {
            return Result.failed((Object)false, (String)"\u4f60\u5df2\u88ab\u79fb\u51fa\u8be5\u7fa4\u804a");
        }
        Long userID = currentLoginUser.getId();
        Result result = new Result();
        result.setSuccess(Boolean.valueOf(true));
        result.setData((Object)true);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"GROUP_ID", (Object)groupDTO.getRoomID())).eq((Object)"USER_ID", (Object)userID);
        updateWrapper.set((Object)"IS_REMIND", (Object)(groupDTO.getRemind() != false ? 1 : 0));
        updateWrapper.set((Object)"IS_SAVE", (Object)(groupDTO.getSave() != false ? 1 : 0));
        updateWrapper.set((Object)"IS_TOP", (Object)(groupDTO.getTop() != false ? 1 : 0));
        this.groupUserService.update((Wrapper)updateWrapper);
        GroupVO oldGroup = this.groupCacheService.getRoomBean(groupDTO.getRoomID());
        if (groupDTO.getDefaultRoomName() > 0 && oldGroup.getAdminID().equals(userID) && StrUtil.isNotEmpty((CharSequence)groupDTO.getRoomName()) && !groupDTO.getRoomName().equals(oldGroup.getRoomName())) {
            final GroupDO groupDO = new GroupDO();
            groupDO.setGroupName(groupDTO.getRoomName());
            groupDO.setGroupId(groupDTO.getRoomID());
            this.groupMapper.updateById(groupDO);
            final String bodyStr = currentLoginUser.getUserName() + "\u4fee\u6539\u4e86\u7fa4\u540d\u79f0\u4e3a'" + groupDTO.getRoomName() + "'";
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    GroupServiceImpl.this.groupCacheService.clearRoomCache(groupDTO.getRoomID());
                    GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, bodyStr, groupDTO.getRoomName(), NoticeMsgBean.EventType.MODIFYGROUPNAME);
                }
            });
        } else {
            if (StrUtil.isNotEmpty((CharSequence)groupDTO.getRoomName()) && !groupDTO.getRoomName().equals(oldGroup.getRoomName()) && !groupDTO.getRoomName().equals(this.getRoomName(oldGroup, false))) {
                return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_PERMISSION_DENIED);
            }
            this.groupCacheService.clearRoomCache(groupDTO.getRoomID());
        }
        return result;
    }

    public Result<GroupVO> groupDetail(Long roomID, Long userID) {
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (groupVO == null || groupVO.getAdminID() == null) {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_NOT_EXIST);
        }
        if (!groupVO.getUsers().stream().map(RosterVO::getUserId).collect(Collectors.toList()).contains(userID)) {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_MEMBER_NOT_EXIST);
        }
        Long adminID = groupVO.getAdminID();
        List rosterList = groupVO.getGroupType() == 1 ? this.groupCacheService.getRosterBeanByAmount(roomID, 45) : (adminID.equals(userID) ? this.groupCacheService.getRosterBeanByAmount(roomID, 43) : this.groupCacheService.getRosterBeanByAmount(roomID, 44));
        List<GroupVO> userRoomList = this.groupUserMapper.getAllRoomStatusByUserId(userID, "");
        List groupVOList = userRoomList.stream().filter(r -> r.getRoomID().equals(roomID)).collect(Collectors.toList());
        if (HussarUtils.isEmpty(groupVOList)) {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_MEMBER_NOT_EXIST);
        }
        GroupVO currentRoomBean = (GroupVO)groupVOList.get(0);
        groupVO.setRemind(currentRoomBean.getRemind());
        groupVO.setSave(currentRoomBean.getSave());
        groupVO.setTop(currentRoomBean.getTop());
        groupVO.setUsers(rosterList);
        groupVO.setRoomName(this.getRoomName(groupVO, false));
        return Result.succeed((Object)groupVO);
    }

    public List<GroupVO> queryGroupList(Long userID, String groupType) {
        List<GroupVO> list = this.groupMapper.getRoomList(userID, groupType);
        list.forEach(groupVO -> {
            if (groupVO.getRoomName() == null || "".equals(groupVO.getRoomName())) {
                groupVO.setRoomName(ListUtil.listToString(groupVO.getUsers().stream().filter(Objects::nonNull).map(RosterVO::getUserName).collect(Collectors.toList()), (String)"\uff0c"));
            }
        });
        return list;
    }

    public List<GroupVO> findGroup(Long userID, String searchKey) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(1));
        pageDTO.setPageSize(Integer.valueOf(-1));
        return this.groupMapper.findRoom((PageDTO<GroupVO>)pageDTO, userID, SqlQueryUtil.transferSpecialChar((String)searchKey)).getList();
    }

    public Map<String, List> findGroupAndUser(Long userID, String searchKey, Long orgID) {
        HashMap<String, List> map = new HashMap<String, List>(2);
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(1));
        pageDTO.setPageSize(Integer.valueOf(-1));
        List groupList = this.groupMapper.findRoom((PageDTO<GroupVO>)pageDTO, userID, searchKey).getList();
        List userList = this.organizationService.searchContact(orgID, null, null);
        map.put("room", groupList);
        map.put("user", userList);
        return map;
    }

    public List<RosterVO> findUser(Long roomID, String userName, Long orgID, PageDTO<RosterVO> pageDTO) {
        List rosterList = this.organizationService.searchContact(orgID, userName, pageDTO);
        if (rosterList == null) {
            return new ArrayList<RosterVO>();
        }
        if (roomID != null) {
            List groupUidList = this.groupCacheService.getAllRosterBeanByRoomID(roomID).stream().map(r -> r.getUserId() + "").collect(Collectors.toList());
            rosterList.forEach(rosterBean -> rosterBean.setGroupMember(Boolean.valueOf(groupUidList.indexOf(rosterBean.getUserId()) > -1)));
        }
        return rosterList;
    }

    public List<RosterVO> getLinkMan(Long roomID) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrent(1L);
        pageInfo.setSize(Integer.MAX_VALUE);
        List rosterList = this.organizationService.getLinkManList(pageInfo).getRecords();
        List<Object> uidList = roomID != null && roomID != 0L && roomID != -1L ? this.groupCacheService.getAllRosterBeanByRoomID(roomID).stream().map(RosterVO::getUserId).collect(Collectors.toList()) : new ArrayList();
        return rosterList.stream().map(r -> {
            RosterVO rosterVO = new RosterVO();
            BeanUtil.copyProperties((Object)r, (Object)rosterVO, (String[])new String[0]);
            rosterVO.setUserId(r.getUserId());
            if (CollUtil.isNotEmpty((Collection)uidList)) {
                rosterVO.setGroupMember(Boolean.valueOf(uidList.contains(r.getUserId())));
            }
            return rosterVO;
        }).collect(Collectors.toList());
    }

    public PageVO<ContactVO> getLinkMan(Long orgID, Long roomID) {
        PageVO pageVO = new PageVO();
        pageVO.setList(new ArrayList());
        pageVO.setPageNum(Integer.valueOf(1));
        pageVO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        pageVO.setPageCount(Integer.valueOf(1000));
        ContactVO contactVO1 = new ContactVO();
        contactVO1.setOrgs(new ArrayList());
        contactVO1.setUsers(new ArrayList());
        ArrayList<Long> parentOrgIdList = new ArrayList<Long>();
        if (orgID == null) {
            orgID = IMConstants.DEFAULT_COMPANY_ID;
        }
        parentOrgIdList.add(orgID);
        List organUserTreeVos = this.userBoService.lazyOrganUserTree(parentOrgIdList, Boolean.valueOf(false), Integer.valueOf(2));
        organUserTreeVos.forEach(treeVo -> {
            if ("organ".equals(treeVo.getTypes())) {
                ContactVO contactVO = new ContactVO();
                contactVO.setOrgID((Long)treeVo.getId());
                contactVO.setOrgName(treeVo.getLabel());
                contactVO.setParentOrgID((Long)treeVo.getParentId());
                contactVO.setOrgsCount(Integer.valueOf(treeVo.getChildren().size()));
                contactVO.setMembersCount(treeVo.getUserCount());
                contactVO1.getOrgs().add(contactVO);
            } else if ("user".equals(treeVo.getTypes())) {
                RosterVO rosterVO = new RosterVO();
                rosterVO.setUserId((Long)treeVo.getId());
                rosterVO.setUserName(treeVo.getLabel());
                rosterVO.setOrganiseID((Long)treeVo.getParentId());
                contactVO1.getUsers().add(rosterVO);
            }
        });
        if (roomID != null) {
            if (CollectionUtil.isNotEmpty((Collection)contactVO1.getOrgs())) {
                contactVO1.setUsers(null);
            }
            if (CollectionUtil.isNotEmpty((Collection)contactVO1.getUsers())) {
                List groupUidList = this.groupCacheService.getAllRosterBeanByRoomID(roomID).stream().map(r -> r.getUserId() + "").collect(Collectors.toList());
                contactVO1.getUsers().forEach(rosterBean -> rosterBean.setGroupMember(Boolean.valueOf(groupUidList.indexOf(rosterBean.getUserId()) > -1)));
            }
        }
        pageVO.getList().add(contactVO1);
        return pageVO;
    }

    public PageVO<RosterVO> getGroupUserList(Long roomID, boolean includeMe, PageVO<RosterVO> pageVO, String searchKey) {
        ArrayList<Long> excludeUserList = new ArrayList<Long>();
        if (!includeMe) {
            excludeUserList.add(BaseSecurityUtil.getUser().getId());
        }
        return this.groupCacheService.getGroupUserList(pageVO, roomID, excludeUserList, searchKey);
    }

    public List<RosterVO> findGroupUserList(Long roomID, String searchKey, List<Long> excludeUserList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"EU.USER_NAME", (Object)searchKey)).or()).like((Object)"REPLACE(EU.CHAR_1,'-','')", (Object)searchKey)).or()).like((Object)"EU.CHAR_2", (Object)searchKey);
            });
        }
        queryWrapper.eq((Object)"EGU.GROUP_ID", (Object)roomID);
        queryWrapper.eq((Object)"EGU.DATA_STATUS", (Object)"1");
        if (CollUtil.isNotEmpty(excludeUserList)) {
            queryWrapper.notIn((Object)"EGU.USER_ID", excludeUserList);
        }
        return this.groupUserMapper.findUser((Wrapper)queryWrapper);
    }

    public Result<Boolean> transferGroup(Long roomID, Long userID, Long newAdminID, CurrentLoginUser currentLoginUser, boolean superadmin) {
        return this.transferGroup(roomID, userID, newAdminID, currentLoginUser, superadmin, "0");
    }

    public Result<Boolean> transferGroup(Long roomID, Long userID, Long newAdminID, CurrentLoginUser currentLoginUser, boolean superadmin, String quit) {
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (!userID.equals(groupVO.getAdminID()) && !superadmin) {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_PERMISSION_DENIED);
        }
        boolean newAdminInGroup = groupVO.getUsers().stream().anyMatch(r -> r.getUserId().equals(newAdminID));
        if (!newAdminInGroup) {
            GroupUserDO groupUserDO = new GroupUserDO();
            groupUserDO.setGroupID(roomID);
            groupUserDO.setUserID(newAdminID);
            groupUserDO.setGroupUserId(Long.valueOf(IdWorker.getId((Object)groupUserDO)));
            groupUserDO.setDataStatus(Integer.valueOf(1));
            groupUserDO.setIsRemind(Integer.valueOf(0));
            groupUserDO.setIsSave(Integer.valueOf(1));
            groupUserDO.setIsTop(Integer.valueOf(0));
            ArrayList<GroupUserDO> groupUserDOList = new ArrayList<GroupUserDO>();
            groupUserDOList.add(groupUserDO);
            this.groupUserService.saveBatch(groupUserDOList);
        }
        GroupDO groupDO = new GroupDO();
        groupDO.setGroupName(groupVO.getRoomName());
        groupDO.setGroupId(roomID);
        groupDO.setAdminID(newAdminID);
        this.groupMapper.updateById(groupDO);
        groupDO.setGroupName(this.getRoomName(groupVO, false));
        if (StrUtil.equals((CharSequence)quit, (CharSequence)"1")) {
            this.groupUserMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)roomID)).eq((Object)"USER_ID", (Object)userID));
        }
        this.groupCacheService.clearRoomCache(roomID);
        groupVO.setAdminID(newAdminID);
        UserStaffVo userAndStaffInfo = this.userBoService.getUserAndStaffInfo(newAdminID);
        String bodyStr = currentLoginUser == null || StrUtil.isEmpty((CharSequence)currentLoginUser.getUserName()) ? userAndStaffInfo.getUserName() + "\u5df2\u6210\u4e3a\u65b0\u7fa4\u4e3b" : currentLoginUser.getUserName() + "\u5c06\u7fa4\u4e3b\u8f6c\u8ba9\u7ed9" + userAndStaffInfo.getUserName();
        this.groupManageService.sendRoomNotice(groupDO, bodyStr, newAdminID + "", NoticeMsgBean.EventType.ASSIGNMENTADMIN);
        return Result.succeed((Object)true);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RuntimeException.class})
    public Result<Boolean> ungroup(final Long roomID, Long userID, CurrentLoginUser currentLoginUser) {
        Result result = new Result();
        result.setSuccess(Boolean.valueOf(true));
        result.setData((Object)true);
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        if (!userID.equals(groupVO.getAdminID())) {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_PERMISSION_DENIED);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomID)).eq((Object)"DATA_STATUS", (Object)1);
        List list = this.groupUserMapper.selectList((Wrapper)queryWrapper);
        for (GroupUserDO groupUserDO : list) {
            groupUserDO.setDataStatus(Integer.valueOf(2));
        }
        this.groupUserService.updateBatchById((Collection)list);
        GroupDO groupDO = new GroupDO();
        groupDO.setGroupId(roomID);
        groupDO.setGroupName(this.getRoomName(groupVO, false));
        groupDO.setAdminID(null);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(GroupDO::getGroupId, (Object)roomID)).set(GroupDO::getAdminID, null);
        this.groupMapper.update(groupDO, (Wrapper)lambdaUpdateWrapper);
        String msgBody = "";
        msgBody = StrUtil.isEmpty((CharSequence)groupVO.getRoomName()) ? "\u8be5\u7fa4\u5df2\u88ab" + currentLoginUser.getUserName() + "\u89e3\u6563" : groupVO.getRoomName() + "\u5df2\u88ab" + currentLoginUser.getUserName() + "\u89e3\u6563";
        this.groupManageService.sendRoomNotice(groupDO, msgBody, userID + "", NoticeMsgBean.EventType.DELETEGROUP);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                GroupServiceImpl.this.groupCacheService.clearRoomCache(roomID);
            }
        });
        return result;
    }

    public List<GroupVO> getGroupStatusByUserID(CurrentLoginUser currentLoginUser, String time) {
        return this.groupMapper.getGroupStatusByUserID(currentLoginUser.getId(), time);
    }

    public PageDTO<GroupVO> getAllGroupPage(PageDTO<GroupVO> pageDTO, String searchKey) {
        List msgTimeGroupVOList;
        List adminNameGroupVOList;
        long skipNum = (pageDTO.getPageNum() - 1) * pageDTO.getPageSize();
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"receiverCode"}).last("receiverCode").as("roomID").max("msgTime").as("lastMsgTime");
        PageDTO page = new PageDTO();
        page.setPageSize(Integer.valueOf(500000000));
        page.setPageNum(Integer.valueOf(1));
        page.setMaxLimit(Long.valueOf(-1L));
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"C.USER_NAME", (Object)StringUtil.replaceSpecialChar((String)searchKey))).or()).like((Object)"B.GROUP_NAME", (Object)StringUtil.replaceSpecialChar((String)searchKey));
            });
            pageDTO.setList(this.groupMapper.getAllGroupPage(page, (Wrapper)queryWrapper).getList());
            adminNameGroupVOList = pageDTO.getList();
            MatchOperation matchOperation = Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)1), Criteria.where((String)"receiverCode").in((Collection)adminNameGroupVOList.stream().map(GroupVO::getRoomID).map(String::valueOf).collect(Collectors.toList()))}));
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation, Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"lastMsgTime")})), Aggregation.skip((long)skipNum), Aggregation.limit((long)pageDTO.getPageSize().intValue())});
            msgTimeGroupVOList = this.mongoTemplate.aggregate(aggregation, "message", GroupVO.class).getMappedResults();
            pageDTO.setPageCount(Integer.valueOf(this.mongoTemplate.aggregate(Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation}), "message", GroupVO.class).getMappedResults().size()));
        } else {
            List messageDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"mode").is((Object)1)), MessageDO.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.isNotNull((Object)"ADMIN_ID");
            queryWrapper.ne((Object)"ADMIN_ID", (Object)"");
            adminNameGroupVOList = this.groupMapper.getAllGroupPage(page, (Wrapper)queryWrapper).getList();
            Criteria.where((String)"mode").is((Object)1);
            MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)"receiverCode").in((Collection)adminNameGroupVOList.stream().map(GroupVO::getRoomID).map(String::valueOf).collect(Collectors.toList())));
            pageDTO.setPageCount(Integer.valueOf(this.mongoTemplate.aggregate(Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation}), "message", GroupVO.class).getMappedResults().size()));
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation, Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"lastMsgTime")})), Aggregation.skip((long)skipNum), Aggregation.limit((long)pageDTO.getPageSize().intValue())});
            msgTimeGroupVOList = this.mongoTemplate.aggregate(aggregation, "message", GroupVO.class).getMappedResults();
        }
        msgTimeGroupVOList.forEach(msgTimeGroupVO -> adminNameGroupVOList.forEach(adminNameGroupVO -> {
            if (msgTimeGroupVO.getRoomID().equals(adminNameGroupVO.getRoomID())) {
                String lastMsgTime = msgTimeGroupVO.getLastMsgTime();
                if (HussarUtils.isNotEmpty((Object)lastMsgTime)) {
                    long l = (long)Double.parseDouble(lastMsgTime);
                    msgTimeGroupVO.setLastMsgTime(DateUtil.format((Date)DateUtil.date((long)l), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                msgTimeGroupVO.setRoomName(adminNameGroupVO.getRoomName());
                msgTimeGroupVO.setAdminName(adminNameGroupVO.getAdminName());
                msgTimeGroupVO.setAdminID(adminNameGroupVO.getAdminID());
                msgTimeGroupVO.setCreateTime(adminNameGroupVO.getCreateTime());
                msgTimeGroupVO.setNotice(adminNameGroupVO.getNotice());
            }
        }));
        pageDTO.setList(msgTimeGroupVOList);
        return pageDTO;
    }

    public Result<Boolean> changeGroupAdmin(Long roomID, Long userID, Long adminID) {
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        GroupDO groupDO = new GroupDO();
        groupDO.setGroupName(groupVO.getRoomName());
        groupDO.setGroupId(roomID);
        groupDO.setAdminID(userID);
        this.groupMapper.updateById(groupDO);
        groupDO.setGroupName(this.getRoomName(groupVO, false));
        this.groupCacheService.clearRoomCache(roomID);
        groupVO.setAdminID(userID);
        UserStaffVo userAndStaffInfo = this.userBoService.getUserAndStaffInfo(userID);
        String bodyStr = userAndStaffInfo.getUserName() + "\u5df2\u6210\u4e3a\u65b0\u7fa4\u4e3b";
        this.groupManageService.sendRoomNotice(groupDO, bodyStr, userID + "", NoticeMsgBean.EventType.ASSIGNMENTADMIN);
        return Result.succeed((Object)true);
    }

    @Transactional
    public Result<Boolean> deleteGroupUser(final Long roomID, final List<Long> userList) throws IOException {
        GroupDO groupDO;
        GroupVO groupVO = this.groupCacheService.getRoomBean(roomID);
        List remindUser = groupVO.getUsers().stream().filter(rosterVO -> !userList.contains(rosterVO.getUserId())).collect(Collectors.toList());
        if (CollUtil.isEmpty(remindUser)) {
            CurrentLoginUser currentLoginUser = new CurrentLoginUser();
            currentLoginUser.setUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            this.ungroup(roomID, groupVO.getAdminID(), currentLoginUser);
            return Result.succeed((Object)true);
        }
        if (userList.contains(groupVO.getAdminID())) {
            Long newAdminId = ((RosterVO)remindUser.get(0)).getUserId();
            this.changeGroupAdmin(roomID, newAdminId, groupVO.getAdminID());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)roomID)).in((Object)"USER_ID", userList);
        GroupUserDO groupUserDO = new GroupUserDO();
        groupUserDO.setDataStatus(Integer.valueOf(0));
        groupUserDO.setIsTop(Integer.valueOf(0));
        List rosterVOList = groupVO.getUsers().stream().filter(r -> userList.contains(r.getUserId())).collect(Collectors.toList());
        groupVO.setUsers(groupVO.getUsers().stream().filter(r -> !userList.contains(r.getUserId())).collect(Collectors.toList()));
        if (this.groupUserService.update((Object)groupUserDO, (Wrapper)queryWrapper)) {
            groupDO = new GroupDO();
            groupDO.setGroupName(this.getRoomName(groupVO, false));
            groupDO.setGroupId(groupVO.getRoomID());
            if (this.judgeGroupHead(roomID)) {
                this.groupManageService.generateRoomHeadImg(groupVO);
            }
        } else {
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_REMOVE_MEMBER_FAILED);
        }
        final String msgBody = "\u7cfb\u7edf\u5c06" + CollUtil.join(rosterVOList.stream().map(RosterVO::getUserName).collect(Collectors.toList()).iterator(), (CharSequence)"\uff0c") + "\u79fb\u51fa\u4e86\u7fa4\u804a";
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                GroupServiceImpl.this.groupCacheService.clearRoomCache(roomID);
                for (Long l : userList) {
                    GroupServiceImpl.this.groupManageService.sendRoomNotice(groupDO, msgBody, l + "", NoticeMsgBean.EventType.DELETEUSER);
                }
            }
        });
        return Result.succeed((Object)true);
    }

    @Transactional
    public boolean createOrgGroup(Long pOrgID) {
        log.error("\u521b\u5efa\u90e8\u95e8\u7fa4");
        SecurityUser user = BaseSecurityUtil.getUser();
        Long tenantId = user == null ? Long.valueOf(0L) : user.getTenantId();
        boolean flag = false;
        List contactVOList = this.organizationService.selectOrgList("", "", pOrgID, -1, 1);
        for (OrganizationTreeVo contactVO : contactVOList) {
            Long groupID;
            Long orgID = (Long)contactVO.getId();
            String orgName = contactVO.getLabel();
            if (1696830512947708241L == orgID || 100122L == orgID || 883004270675501057L == orgID) continue;
            if (!"\u7fa4".equals(orgName.substring(orgName.length() - 1))) {
                orgName = orgName + "\u7fa4";
                log.error("\u90e8\u95e8\u540d\u62fc\u63a5\uff1a{}", (Object)orgName);
            }
            QueryWrapper groupWrapper = new QueryWrapper();
            groupWrapper.eq((Object)"ADMIN_ID", (Object)orgID);
            groupWrapper.eq((Object)"GROUP_TYPE", (Object)1);
            GroupDO group = (GroupDO)this.groupMapper.selectOne((Wrapper)groupWrapper);
            if (group == null) {
                groupID = orgID;
                GroupDO groupDO = new GroupDO();
                groupDO.setGroupId(groupID);
                groupDO.setAdminID(orgID);
                groupDO.setGroupType(Integer.valueOf(1));
                groupDO.setGroupName(orgName);
                this.groupMapper.insert(groupDO);
                flag = true;
            } else {
                groupID = group.getGroupId();
                if (!orgName.equals(group.getGroupName())) {
                    group.setAdminID(orgID);
                    group.setGroupName(orgName);
                    int update = this.groupMapper.update(group, (Wrapper)groupWrapper);
                    log.error("\u66f4\u65b0\u7fa4\u540d\u5b8c\u6210\uff1a{},{}", (Object)orgName, (Object)update);
                }
                this.groupCacheService.delete("OfGroupChat:" + group.getGroupId());
                this.groupCacheService.delete("ApiGroupChat:" + group.getGroupId());
            }
            List<Long> orgIDList = this.organizationBoService.findOrganizationsByParentId(orgID).stream().map(OrganizationBo::getId).collect(Collectors.toList());
            orgIDList.add(orgID);
            if (!flag) {
                this.groupMapper.deleteMember(groupID, orgIDList);
            }
            QueryWrapper rosterWrapper = new QueryWrapper();
            rosterWrapper.in((Object)"DEPARTMENT_ID", orgIDList);
            ArrayList groupUserDOList = new ArrayList();
            this.contactService.getAllOrgUserNotInGroup(groupID, orgIDList).stream().distinct().forEach(rosterDO -> {
                GroupUserDO groupUserDO = new GroupUserDO();
                groupUserDO.setUserID(rosterDO.getUserID());
                groupUserDO.setGroupUserId(Long.valueOf(IdWorker.getId((Object)groupUserDO)));
                groupUserDO.setIsSave(Integer.valueOf(1));
                groupUserDO.setDataStatus(Integer.valueOf(1));
                groupUserDO.setGroupID(groupID);
                groupUserDOList.add(groupUserDO);
            });
            if (!groupUserDOList.isEmpty()) {
                this.groupUserService.saveBatch(groupUserDOList);
            }
            this.createOrgGroup(orgID);
        }
        if (Objects.equals(pOrgID, IMConstants.DEFAULT_COMPANY_ID)) {
            log.error("\u521b\u5efa\u516c\u53f8\u7fa4\uff1a" + IMConstants.DEFAULT_COMPANY_ID);
            QueryWrapper groupWrapper = new QueryWrapper();
            groupWrapper.eq((Object)"ADMIN_ID", (Object)IMConstants.DEFAULT_COMPANY_ID);
            groupWrapper.eq((Object)"GROUP_TYPE", (Object)1);
            GroupDO group = (GroupDO)this.groupMapper.selectOne((Wrapper)groupWrapper);
            if (group == null) {
                GroupDO groupDO = new GroupDO();
                groupDO.setGroupId(IMConstants.DEFAULT_COMPANY_ID);
                groupDO.setAdminID(IMConstants.DEFAULT_COMPANY_ID);
                groupDO.setGroupType(Integer.valueOf(1));
                groupDO.setGroupName("\u516c\u53f8\u7fa4");
                this.groupMapper.insert(groupDO);
            }
            this.createGroup(IMConstants.DEFAULT_COMPANY_ID);
            this.groupCacheService.delete("OfGroupChat:");
            this.groupCacheService.delete("ApiGroupChat:");
        }
        return true;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public boolean synchroGroup() {
        List organizationTreeVos = this.organizationService.selectOrgList("", "", IMConstants.DEFAULT_COMPANY_ID, -1, 1);
        ArrayList<Long> orgIDList = new ArrayList<Long>();
        organizationTreeVos.forEach(organizationTreeVo -> orgIDList.add((Long)organizationTreeVo.getId()));
        List<GroupVO> orgGroupList = this.groupMapper.getOrgGroupList(orgIDList);
        return true;
    }

    private void createGroup(Long groupId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"GROUP_ID", (Object)groupId);
        List groupUserDOList = this.groupUserMapper.selectList((Wrapper)wrapper);
        if (groupUserDOList != null) {
            List<RosterVO> allUserList = this.groupMapper.getAllUser();
            ArrayList<GroupUserDO> groupUserList = new ArrayList<GroupUserDO>();
            for (RosterVO rosterVO : allUserList) {
                if (Objects.equals(this.organizationProperties.getDepartingOrgId(), rosterVO.getOrganiseID())) continue;
                boolean oldGroupUser = false;
                for (GroupUserDO oldGroupUserDO : groupUserDOList) {
                    if (!rosterVO.getUserId().equals(oldGroupUserDO.getUserID())) continue;
                    groupUserList.add(oldGroupUserDO);
                    oldGroupUser = true;
                    break;
                }
                if (oldGroupUser) continue;
                GroupUserDO groupUserDO = new GroupUserDO();
                groupUserDO.setUserID(rosterVO.getUserId());
                groupUserDO.setGroupID(groupId);
                groupUserDO.setIsSave(Integer.valueOf(1));
                groupUserDO.setDataStatus(Integer.valueOf(1));
                groupUserList.add(groupUserDO);
            }
            this.groupUserMapper.delete((Wrapper)wrapper);
            long start = System.currentTimeMillis();
            this.groupUserService.saveBatch(groupUserList);
            log.error("\u5c06\u6240\u6709\u4eba\u5458\u62c9\u8fd1\u516c\u53f8\u7fa4,{}", (Object)(System.currentTimeMillis() - start));
        }
    }

    public boolean deleteQuitUser(List<Long> outUserList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"USER_ID", outUserList);
        this.groupUserMapper.delete((Wrapper)wrapper);
        return true;
    }

    public PageDTO<GroupVO> findGroupPage(PageDTO<GroupVO> pageDTO, Long userID, String searchKey) {
        PageDTO<GroupVO> voPageDTO = this.groupMapper.findRoom(pageDTO, userID, StringUtil.replaceSpecialChar((String)searchKey));
        voPageDTO.getList().forEach(groupVO -> {
            if (StrUtil.isEmpty((CharSequence)groupVO.getRoomName())) {
                StringBuilder stringBuilder = new StringBuilder();
                groupVO.getUsers().forEach(rosterVO -> stringBuilder.append(rosterVO.getUserName()).append(","));
                groupVO.setRoomName(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
            }
            List rosterVOS = groupVO.getUsers().stream().filter(rosterVO -> rosterVO.getUserName().contains(searchKey)).collect(Collectors.toList());
            groupVO.setUsers(rosterVOS);
        });
        return voPageDTO;
    }

    public GroupDO getById(Serializable id) {
        return (GroupDO)super.getById(id);
    }
}

