/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.application.vo.WorkstationApplicationVo;
import com.jxdinfo.mp.im.EimPubPlatService;
import com.jxdinfo.mp.im.dao.single.PubMsgLogMapper;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.material.MaterialDTO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.model.single.PubMsgLogVO;
import com.jxdinfo.mp.im.service.DealMessageService;
import com.jxdinfo.mp.im.service.MaterialService;
import com.jxdinfo.mp.im.service.MessageService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags={"\u540e\u53f0\u6d88\u606f\u7ba1\u7406"})
@RequestMapping(value={"/v1"})
public class PubPlatMessageController {
    @Autowired(required=false)
    private EimPubPlatService pubPlatService;
    @Resource
    private PubPlatMessageService pubPlatMessageService;
    @Resource
    private MessageService messageService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private DealMessageService dealMessageService;
    @Resource
    private MaterialService materialService;
    @Resource
    private JobServiceService jobServiceService;
    @Resource
    private PubMsgLogMapper pubMsgLogMapper;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;
    @Resource
    private IHussarBaseUserBoService userBoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5fae\u5e94\u7528\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/msg/pubPlat/list"})
    public Result<Page<WorkstationApplicationVo>> getPubPlatMsgList(@RequestParam(value="pubPlatName", required=false) @ApiParam(value="\u5fae\u5e94\u7528\u540d\u79f0") String pubPlatName, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return Result.succeed((Object)this.pubPlatMessageService.getPubPlatMsgList(pubPlatName, pageNum, pageSize));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7528\u6237\u7ed9\u5fae\u5e94\u7528\u53d1\u9001\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/msg/user"})
    public Result<PageDTO<RosterVO>> getUserMsgList(@RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(value="pubPlatId") @ApiParam(value="\u5fae\u5e94\u7528id") Long pubPlatID, @RequestParam(value="searchKey", required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser loginUser) {
        Long roleID = 1234567898654567890L;
        if (loginUser != null && !loginUser.getRoles().isEmpty()) {
            roleID = ((Role)loginUser.getRoles().get(0)).getRoleId();
        }
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.pubPlatMessageService.getUserMsgList(pageDTO, pubPlatID, searchKey, roleID));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u4e0e\u4e2a\u4eba\u4ea4\u4e92\u5217\u8868")
    @GetMapping(value={"/msg/detail"})
    public Result<Map<String, Object>> getPubMsgDetail(@RequestParam(value="pubPlatId") @ApiParam(value="\u516c\u4f17\u53f7id") Long pubPlatID, @RequestParam(value="userId") @ApiParam(value="\u56de\u590d\u4eba") Long userID, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.pubPlatMessageService.getPubMsgDetail(pubPlatID, userID, pageVO));
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u56de\u590d\u6d88\u606f")
    @GetMapping(value={"/msg/pubPlat"})
    public Result<Boolean> msgReply(@RequestParam(value="pubPlatId") @ApiParam(value="\u516c\u4f17\u53f7id") Long pubPlatID, @RequestParam(value="userId") @ApiParam(value="\u56de\u590d\u4eba") Long userID, @RequestParam(value="pubPlatName") @ApiParam(value="\u516c\u4f17\u53f7\u540d\u79f0") String pubPlatName, @RequestParam(value="message") @ApiParam(value="\u6d88\u606f\u5185\u5bb9") String msgContent) {
        return Result.succeed((Object)this.pubPlatMessageService.msgReply(pubPlatID, userID, pubPlatName, msgContent));
    }

    @ApiOperation(value="\u6839\u636emsgID\u67e5\u8be2\u7528\u6237")
    @GetMapping(value={"/message/user"})
    public Result<PageVO<RosterVO>> getUsers(@RequestParam(required=false) @ApiParam(value="msgID") Long msgID, @RequestParam(required=false) String orgIDs, @RequestParam(required=false) String roleIDs, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey) {
        return this.pubPlatMessageService.getUsers(msgID, searchKey, pageSize, pageNum, orgIDs, roleIDs);
    }

    @ApiOperation(value="\u6839\u636e\u5fae\u5e94\u7528id\u67e5\u8be2\u63a8\u9001\u5386\u53f2")
    @GetMapping(value={"/message/pubplat/send"})
    public Result<PageVO<BaseMsgBean>> getPubMsgHistory(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") Long pubPlatID, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return this.pubPlatMessageService.getPubMsgHistory(pubPlatID, pageNum, pageSize);
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u64a4\u56de\u6d88\u606f")
    @PostMapping(value={"/message/pubplat/withdraw"})
    public Result<Boolean> withDrawMessage(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestBody WithDrawMsgBean withDrawMsgBean) {
        if (currentLoginUser == null) {
            return Result.failed((String)"\u7528\u6237\u672a\u767b\u5f55");
        }
        withDrawMsgBean.setBody("\u6d88\u606f\u5df2\u64a4\u56de");
        withDrawMsgBean.setObjBody("\u6d88\u606f\u5df2\u64a4\u56de");
        withDrawMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)withDrawMsgBean)));
        withDrawMsgBean.setObjMsgTime(withDrawMsgBean.getObjMsgTime() + ":000");
        withDrawMsgBean.setSenderCode(String.valueOf(currentLoginUser.getId()));
        withDrawMsgBean.setSenderName(currentLoginUser.getName());
        return this.messageService.withDrawMessage(withDrawMsgBean, Integer.MAX_VALUE);
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u53d1\u9001\u6d88\u606f\uff08\u9ed8\u8ba4\u3001\u5b9a\u65f6\uff09")
    @PostMapping(value={"/pubPlat/push/addOrEdit"})
    public Result<Boolean> sendMessage(@RequestBody PubMsgLogDTO pubMsgLogDTO, @LoginUser CurrentLoginUser loginUser) {
        List userTemp;
        PubMsgLogDTO temp;
        if (ToolUtil.isNotEmpty((Object)pubMsgLogDTO.getMsgID()) && ToolUtil.isNotEmpty((Object)pubMsgLogDTO.getJobId())) {
            this.pubMsgLogMapper.deleteArticle(Collections.singletonList(pubMsgLogDTO.getMsgID()));
            this.pubMsgLogMapper.delete((Wrapper)new LambdaQueryWrapper().eq(PubMsgLogDO::getObjID, (Object)pubMsgLogDTO.getMsgID()));
            this.jobServiceService.deleteJobApi(pubMsgLogDTO.getJobId());
        }
        if (ToolUtil.isNotEmpty((Object)(temp = this.materialService.getMaterial(pubMsgLogDTO.getMaterialDTO().getObjID()))) && ToolUtil.isNotEmpty((Object)temp.getMaterialDTO())) {
            MaterialDTO materialDTO = (MaterialDTO)BeanUtil.copyProperties((Object)temp.getMaterialDTO(), MaterialDTO.class);
            pubMsgLogDTO.setMaterialDTO(materialDTO);
        }
        Long pubPlatID = pubMsgLogDTO.getPubPlatID();
        Map roleDateMap = (Map)this.sysAppVisitAuthorizationService.getAppRoleList(pubPlatID).getData();
        List permissionUsers = (List)roleDateMap.get("users");
        ArrayList permissionUserIds = new ArrayList();
        List permissionOrgans = (List)roleDateMap.get("organs");
        List<Object> permissionOrganIds = new ArrayList();
        List permissionRoles = (List)roleDateMap.get("roles");
        List<Object> permissionRoleIds = new ArrayList();
        List permissionPosts = (List)roleDateMap.get("posts");
        List<Object> permissionPostIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)permissionUsers)) {
            permissionUserIds.addAll(permissionUsers.stream().map(RoleVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionOrgans) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUsersByOrganUser(permissionOrganIds = permissionOrgans.stream().map(RoleVo::getId).collect(Collectors.toList()), null)))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionRoles) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUserInfoByRoleId(permissionRoleIds = permissionRoles.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionPosts) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUsersByPostIds(permissionPostIds = permissionPosts.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        pubMsgLogDTO.setUserIdStr(pubMsgLogDTO.getUserIDs());
        if (StringUtil.isNotEmpty((Object)pubMsgLogDTO.getUserIdStr())) {
            ArrayList thisPermissionUserIds = permissionUserIds;
            List thisId = Arrays.stream(pubMsgLogDTO.getUserIDs().split(",")).filter(userId -> !thisPermissionUserIds.contains(userId)).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(thisId)) {
                return Result.failed((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f");
            }
        }
        ArrayList userIds = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)pubMsgLogDTO.getRoleIDs()) || StrUtil.isNotEmpty((CharSequence)pubMsgLogDTO.getOrganiseIDs())) {
            List thisId;
            List<Object> organiseIds = new ArrayList();
            List<Object> roleIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)pubMsgLogDTO.getOrganiseIDs())) {
                List<Object> thisPermissionOrganIds = permissionOrganIds;
                organiseIds = Arrays.stream(pubMsgLogDTO.getOrganiseIDs().split(",")).map(Long::parseLong).collect(Collectors.toList());
                thisId = organiseIds.stream().filter(organiseId -> !thisPermissionOrganIds.contains(organiseId)).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(thisId)) {
                    return Result.failed((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f");
                }
            }
            if (ToolUtil.isNotEmpty((Object)pubMsgLogDTO.getRoleIDs())) {
                List<Object> thisPermissionRoleIds = permissionRoleIds;
                roleIds = Arrays.stream(pubMsgLogDTO.getRoleIDs().split(",")).map(Long::parseLong).collect(Collectors.toList());
                thisId = roleIds.stream().filter(roleId -> !thisPermissionRoleIds.contains(roleId)).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(thisId)) {
                    return Result.failed((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f");
                }
            }
            if (ToolUtil.isNotEmpty(organiseIds)) {
                userIds.addAll(this.hussarBaseUserBoService.getStruUserByStruIds(organiseIds).stream().map(SysStruUser::getUserId).collect(Collectors.toList()));
            }
            if (ToolUtil.isNotEmpty(roleIds)) {
                userIds.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleIds).stream().map(UserVo::getId).collect(Collectors.toList()));
            }
            if (StrUtil.isNotEmpty((CharSequence)pubMsgLogDTO.getUserIDs())) {
                ArrayList thisPermissionUserIds = permissionUserIds;
                userIds.addAll(Arrays.asList(pubMsgLogDTO.getUserIDs().split(",")).stream().map(Long::parseLong).collect(Collectors.toList()));
                thisId = userIds.stream().filter(userId -> !thisPermissionUserIds.contains(userId.toString())).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(thisId)) {
                    return Result.failed((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f");
                }
            }
            pubMsgLogDTO.setUserIDs(userIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        int state = 0;
        if (StrUtil.isNotEmpty((CharSequence)pubMsgLogDTO.getCron())) {
            return this.pubPlatMessageService.timingPush(pubMsgLogDTO, loginUser, pubMsgLogDTO.getUrlSplicing());
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 0) {
            state = Convert.toInt((Object)this.pubPlatMessageService.sendTextMsg(pubMsgLogDTO));
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 8) {
            state = Convert.toInt((Object)this.pubPlatMessageService.sendArticleMsg(pubMsgLogDTO));
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 1) {
            state = Convert.toInt((Object)this.pubPlatMessageService.sendImgMsg(pubMsgLogDTO));
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 3) {
            state = Convert.toInt((Object)this.pubPlatMessageService.sendFileMsg(pubMsgLogDTO));
        }
        return Result.succeed((Object)this.dealMessageService.savePubMsg(pubMsgLogDTO, state, loginUser, pubMsgLogDTO.getUrlSplicing()));
    }

    @ApiOperation(value="\u67e5\u8be2\u5fae\u5e94\u7528\u63a8\u9001\u8be6\u60c5")
    @GetMapping(value={"/pubPlat/push/detail"})
    public Result<PubMsgLogVO> queryPubMsgPushDetail(@RequestParam(value="msgId") String msgId) {
        return Result.succeed((Object)this.pubPlatMessageService.queryPubMsgPushDetail(msgId));
    }

    @ApiOperation(value="\u5b9a\u65f6\u4efb\u52a1\u5220\u9664")
    @GetMapping(value={"/pubPlat/push/delete"})
    public Result<Boolean> removeTask(@RequestParam(value="msgIDs") @ApiParam(value="\u63a8\u9001\u5386\u53f2id,\u53ef\u591a\u9009\u5220\u9664") String msgIDs, @RequestParam(value="jobId") String jobId) {
        List pubMsgLogDOS = this.pubMsgLogMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PubMsgLogDO::getObjID, (Object)msgIDs));
        this.pubMsgLogMapper.delete((Wrapper)new LambdaQueryWrapper().eq(PubMsgLogDO::getObjID, (Object)msgIDs));
        for (PubMsgLogDO pubMsgLogDO : pubMsgLogDOS) {
            this.jobServiceService.deleteJobApi(pubMsgLogDO.getJobId());
        }
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u67e5\u8be2\u63a5\u6536\u4eba")
    @GetMapping(value={"/pubPlat/push/selectReceivers"})
    public Result<Page<RosterVO>> receiverQuery(@RequestParam(value="msgId") @ApiParam(value="\u63a8\u9001id") String msgId, @RequestParam(value="organId", required=false) String organId, @RequestParam(value="name") String name, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        MessageDO messageDO = (MessageDO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)msgId)), MessageDO.class);
        String pubplatReceiverCode = messageDO.getPubplatReceiverCode();
        List<String> userIDS = Arrays.asList(pubplatReceiverCode.split(","));
        PageInfo pageInfo = new PageInfo();
        pageInfo.setSize((long)pageSize);
        pageInfo.setCurrent((long)pageNum);
        SearchOrganUserDto searchOrganUserDto = new SearchOrganUserDto();
        searchOrganUserDto.setUserIds(userIDS.stream().map(Long::parseLong).collect(Collectors.toList()));
        searchOrganUserDto.setName(name);
        searchOrganUserDto.setResultType("3");
        Page page1 = this.hussarBaseUserBoService.searchUser(pageInfo, searchOrganUserDto);
        List list1 = page1.getRecords();
        List<SearchUserTreeVo> list = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)organId)) {
            List tempList = this.hussarBaseUserBoService.getStruUserByStruIds(Stream.of(organId).map(Long::parseLong).collect(Collectors.toList()));
            for (SearchUserTreeVo searchUserTreeVo : list1) {
                List temp = tempList.stream().filter(t -> t.getUserId().equals(searchUserTreeVo.getId())).collect(Collectors.toList());
                if (!ToolUtil.isNotEmpty(temp)) continue;
                list.add(searchUserTreeVo);
            }
        } else {
            list = list1;
        }
        ArrayList resultList = new ArrayList();
        list.forEach(user -> {
            RosterVO vo = new RosterVO();
            vo.setUserId(user.getId());
            vo.setUserName(user.getLabel());
            vo.setType("unread");
            resultList.add(vo);
        });
        Page page = new Page();
        page.setTotal(page1.getTotal());
        page.setSize((long)pageSize);
        page.setCurrent((long)pageNum);
        page.setRecords(resultList);
        return Result.succeed((Object)page);
    }

    @GetMapping(value={"/pubPlat/manager/pageList"})
    @ApiOperation(value="\u67e5\u5fae\u5e94\u7528")
    public Result<Page<WorkstationApplicationVo>> getPageList(@RequestParam(value="searchKey", required=false) String searchKey, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="30") int pageSize, @RequestParam(value="classifyId", required=false) String classifyID, @RequestParam(value="appTypes", required=false) String appTypes) {
        return this.pubPlatService.getPageList(searchKey, pageNum, pageSize, classifyID, appTypes);
    }
}

