/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.unifiedtodo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.mp.common.utils.GsonUtil;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.unifiedtodo.annotation.TodoMessagePush;
import com.jxdinfo.mp.im.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.mp.im.unifiedtodo.dto.AppLinkUrl;
import com.jxdinfo.mp.im.unifiedtodo.dto.MobileLinkUrl;
import com.jxdinfo.mp.im.unifiedtodo.dto.TodoPushMessageDTO;
import com.jxdinfo.mp.im.unifiedtodo.service.TodoMessagePushService;
import com.jxdinfo.mp.im.unifiedtodo.service.UnifiedTaskService;
import com.jxdinfo.mp.push.sdk.PushService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TodoMessagePushServiceImpl
implements TodoMessagePushService {
    private static final Logger log = LoggerFactory.getLogger(TodoMessagePushServiceImpl.class);
    private final PushService pushService = PushService.getInstance();
    @Autowired
    private UnifiedTodoProperties unifiedTodoProperties;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoService;
    @Autowired
    private UnifiedTaskService unifiedTaskService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void pushTodoMessage(TodoPushMessageDTO pushMessageDTO) {
        if (pushMessageDTO == null || pushMessageDTO.getPushType() == null) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u6d88\u606f\u53c2\u6570\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u63a8\u9001");
            return;
        }
        log.info("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u5f00\u59cb\u63a8\u9001: \u7c7b\u578b={}, \u4efb\u52a1ID={}", (Object)pushMessageDTO.getPushType(), (Object)pushMessageDTO.getTaskId());
        try {
            Set<String> receiverIds = this.getReceiverIds(pushMessageDTO);
            if (CollUtil.isEmpty(receiverIds)) {
                log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u63a8\u9001: {}", (Object)pushMessageDTO.getPushType());
                return;
            }
            int successCount = 0;
            int failCount = 0;
            Map<String, List<String>> messageGroups = this.groupReceiversByMessageContent(pushMessageDTO, new ArrayList<String>(receiverIds));
            for (Map.Entry<String, List<String>> entry : messageGroups.entrySet()) {
                List<String> groupReceivers = entry.getValue();
                try {
                    String sampleReceiverId = groupReceivers.get(0);
                    ArticleMsgBean articleMsgBean = this.buildArticleMsgBeanForSingleReceiver(pushMessageDTO, sampleReceiverId);
                    if (articleMsgBean != null) {
                        if (!HussarUtils.isEmpty(groupReceivers)) {
                            if (this.isAllReceiversEmpty(groupReceivers)) {
                                log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] postMessage\u63a8\u9001\u5931\u8d25: taskId={},processTitle\u4e3a{}, \u6240\u6709\u63a5\u6536\u8005\u90fd\u4e3a\u7a7a\u503c", (Object)pushMessageDTO.getTaskId(), (Object)pushMessageDTO.getProcessTitle());
                                continue;
                            }
                            log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] postMessage\u63a8\u9001\u5f00\u59cb: taskId={},processTitle\u4e3a{}, \u63a5\u6536\u8005={}", new Object[]{pushMessageDTO.getTaskId(), pushMessageDTO.getProcessTitle(), JSONUtil.toJsonStr(groupReceivers)});
                            boolean success = this.pushService.postMessage((BaseMsgBean)articleMsgBean, groupReceivers, this.unifiedTodoProperties.getAppId(), this.unifiedTodoProperties.getAppKey(), this.unifiedTodoProperties.getCompanyId(), this.unifiedTodoProperties.getCompanyName(), this.unifiedTodoProperties.getServer());
                            if (success) {
                                successCount += groupReceivers.size();
                                continue;
                            }
                            failCount += groupReceivers.size();
                            log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u5206\u7ec4\u63a8\u9001\u5931\u8d25: taskId={}, \u63a5\u6536\u8005\u6570\u91cf={}", (Object)pushMessageDTO.getTaskId(), (Object)groupReceivers.size());
                            continue;
                        }
                        log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] postMessage\u63a8\u9001\u5931\u8d25: taskId={},processTitle\u4e3a{}, \u63a8\u9001\u5bf9\u8c61\u4e3a\u7a7a", (Object)pushMessageDTO.getTaskId(), (Object)pushMessageDTO.getProcessTitle());
                        continue;
                    }
                    failCount += groupReceivers.size();
                    log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u6784\u5efa\u6d88\u606f\u5185\u5bb9\u5931\u8d25\uff0ctaskId: {}", (Object)pushMessageDTO.getTaskId());
                }
                catch (Exception e) {
                    failCount += groupReceivers.size();
                    log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u5206\u7ec4\u63a8\u9001\u5f02\u5e38: taskId={}", (Object)pushMessageDTO.getTaskId(), (Object)e);
                }
            }
            log.info("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u5b8c\u6210: \u7c7b\u578b={}, \u4efb\u52a1ID={}, \u6210\u529f={}, \u5931\u8d25={}", new Object[]{pushMessageDTO.getPushType(), pushMessageDTO.getTaskId(), successCount, failCount});
        }
        catch (Exception e) {
            log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u63a8\u9001\u5931\u8d25: taskId={}, pushType={}", new Object[]{pushMessageDTO.getTaskId(), pushMessageDTO.getPushType(), e});
        }
    }

    private Set<String> getReceiverIds(TodoPushMessageDTO pushMessageDTO) {
        HashSet<String> receiverIds = new HashSet<String>();
        TodoMessagePush.PushType pushType = pushMessageDTO.getPushType();
        switch (pushType) {
            case SAVE_TASK: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                break;
            }
            case UPDATE_TASK: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case UPDATE_TASK_STATUS: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case UPDATE_USER_STATUS: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case DELETE_TASK: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case UPDATE_TASK_USER: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case ADD_TASK_USER: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getNewExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getNewFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case DELETE_TASK_USER: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getDeletedExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getDeletedFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case TRANSFER_TASK_DELETE_USER: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getDeletedExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getDeletedFollowerIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case ADD_URGE_TASK: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                break;
            }
            case TRANSFER_USER_TASK: {
                if (pushMessageDTO.getTransferInfo() != null) {
                    Long newExecutorId = pushMessageDTO.getTransferInfo().getNewExecutorId();
                    Long originalExecutorId = pushMessageDTO.getTransferInfo().getOriginalExecutorId();
                    this.addIfNotEmpty(receiverIds, newExecutorId != null ? newExecutorId.toString() : null);
                    this.addIfNotEmpty(receiverIds, originalExecutorId != null ? originalExecutorId.toString() : null);
                }
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            case UPDATE_TASK_STATUS_WITHOUT_FOLLOWERS: {
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getExecutorIds());
                this.addIfNotEmpty(receiverIds, pushMessageDTO.getCreateUserId() != null ? pushMessageDTO.getCreateUserId().toString() : null);
                break;
            }
            default: {
                log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u672a\u77e5\u7684\u63a8\u9001\u7c7b\u578b: {}", (Object)pushType);
            }
        }
        return receiverIds;
    }

    private void addIfNotEmpty(Set<String> receiverIds, Set<String> ids) {
        if (CollUtil.isNotEmpty(ids)) {
            receiverIds.addAll(ids);
        }
    }

    private void addIfNotEmpty(Set<String> receiverIds, String id) {
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            receiverIds.add(id);
        }
    }

    private ArticleMsgBean buildArticleMsgBeanForSingleReceiver(TodoPushMessageDTO pushMessageDTO, String receiverId) {
        String processTitle = pushMessageDTO.getProcessTitle();
        String processName = pushMessageDTO.getProcessName();
        String systemName = pushMessageDTO.getSystemName();
        String taskName = pushMessageDTO.getTaskName();
        String dataDetail = pushMessageDTO.getDataDetail();
        File iconFile = null;
        if (StrUtil.isNotEmpty((CharSequence)this.unifiedTodoProperties.getAppKey()) && !(iconFile = new File(this.unifiedTodoProperties.getAppKey())).exists()) {
            iconFile = null;
        }
        String title = this.buildMessageTitle(pushMessageDTO, processTitle, processName, receiverId);
        String subTitle = this.buildMessageSubTitle(pushMessageDTO, systemName, taskName, dataDetail, receiverId);
        String url = this.buildMobileUrl(pushMessageDTO, receiverId);
        String webUrl = this.buildWebUrl(pushMessageDTO, receiverId);
        ArticleBean.LinkType linkType = ArticleBean.LinkType.WEB;
        String extra1 = pushMessageDTO.getExtra1();
        String bid = null;
        if (StrUtil.isNotBlank((CharSequence)extra1)) {
            AppLinkUrl appLinkUrl = (AppLinkUrl)GsonUtil.getInstance().fromJson(extra1, AppLinkUrl.class);
            linkType = ArticleBean.LinkType.values()[appLinkUrl.getLinkType()];
            url = appLinkUrl.getUrl();
            bid = appLinkUrl.getBid();
        }
        ArticleBean articleBean = this.pushService.buildArticle(title, subTitle, iconFile, url, webUrl, linkType, StrUtil.isNotBlank(bid) ? bid : pushMessageDTO.getTaskId().toString(), "1");
        List<ArticleBean> articleBeans = Collections.singletonList(articleBean);
        ArticleMsgBean articleMsgBean = this.pushService.buildArticleMsgBean(articleBeans, BaseMsgBean.Mode.PUBPLAT, this.unifiedTodoProperties.getAppId(), this.unifiedTodoProperties.getAppName());
        return articleMsgBean;
    }

    private String buildMessageTitle(TodoPushMessageDTO pushMessageDTO, String processTitle, String processName, String receiverUserId) {
        StringBuilder title = new StringBuilder();
        if (StrUtil.isNotEmpty((CharSequence)processTitle)) {
            title.append(processTitle);
        }
        return title.toString();
    }

    private String buildMessageSubTitle(TodoPushMessageDTO pushMessageDTO, String systemName, String taskName, String dataDetail, String receiverUserId) {
        boolean isCreator = this.isCreator(receiverUserId, pushMessageDTO);
        if (!isCreator) {
            String finalDataDetail = dataDetail;
            if (StrUtil.isEmpty((CharSequence)dataDetail) && StrUtil.isNotEmpty((CharSequence)pushMessageDTO.getTaskId())) {
                try {
                    SaveToDoDto taskDetail = this.getTaskDetailByTaskId(pushMessageDTO.getTaskId());
                    if (taskDetail != null && StrUtil.isNotEmpty((CharSequence)taskDetail.getDataDetail())) {
                        finalDataDetail = taskDetail.getDataDetail();
                        log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u4ece\u6570\u636e\u5e93\u67e5\u8be2\u5230dataDetail: {}, pushType: {}", (Object)finalDataDetail, (Object)pushMessageDTO.getPushType());
                    }
                }
                catch (Exception e) {
                    log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u67e5\u8be2\u4efb\u52a1\u8be6\u60c5\u5931\u8d25\uff0ctaskId: {}, pushType: {}, error: {}", new Object[]{pushMessageDTO.getTaskId(), pushMessageDTO.getPushType(), e.getMessage()});
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)finalDataDetail)) {
                return finalDataDetail;
            }
        }
        StringBuilder subTitle = new StringBuilder();
        if (StrUtil.isNotEmpty((CharSequence)systemName)) {
            subTitle.append(systemName);
            if (StrUtil.isNotEmpty((CharSequence)taskName)) {
                subTitle.append(" | ");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)taskName)) {
            subTitle.append(taskName);
        }
        if (StrUtil.isEmpty((CharSequence)systemName) && StrUtil.isEmpty((CharSequence)taskName)) {
            return "";
        }
        return subTitle.toString();
    }

    private String buildMobileUrl(TodoPushMessageDTO pushMessageDTO, String receiverUserId) {
        String finalUrl;
        String extra1 = pushMessageDTO.getExtra1();
        String openType = pushMessageDTO.getOpenType();
        if (!this.isSupportMobile(pushMessageDTO)) {
            return "";
        }
        if (StrUtil.isNotEmpty((CharSequence)extra1)) {
            finalUrl = this.buildUrlFromExtra1(extra1);
        } else if ("noCode".equals(openType) || "noCodeBrowserTab".equals(openType)) {
            finalUrl = this.buildMobileNoCodeUrl(pushMessageDTO);
            log.error("\u6784\u5efa\u7684\u96f6\u4ee3\u7801\u5730\u5740\u4e3a\uff1a" + finalUrl);
        } else {
            finalUrl = this.buildMobileLowCodeUrl(pushMessageDTO, receiverUserId);
        }
        return finalUrl;
    }

    private boolean isSupportMobile(TodoPushMessageDTO pushMessageDTO) {
        boolean isLowCode;
        String extra1 = pushMessageDTO.getExtra1();
        String openType = pushMessageDTO.getOpenType();
        String mobileLinkUrl = pushMessageDTO.getMobileLinkurl();
        if (StrUtil.isNotEmpty((CharSequence)extra1)) {
            return true;
        }
        boolean bl = isLowCode = !"noCode".equals(openType) && !"noCodeBrowserTab".equals(openType);
        if (isLowCode && !this.isMobileLinkUrlEmpty(mobileLinkUrl)) {
            return true;
        }
        return "noCode".equals(openType) || "noCodeBrowserTab".equals(openType);
    }

    private boolean isAllReceiversEmpty(List<String> receivers) {
        if (HussarUtils.isEmpty(receivers)) {
            return true;
        }
        for (String receiver : receivers) {
            if (receiver == null || receiver.trim().isEmpty() || "null".equals(receiver)) continue;
            return false;
        }
        return true;
    }

    private boolean isMobileLinkUrlEmpty(String mobileLinkUrl) {
        if (StrUtil.isEmpty((CharSequence)mobileLinkUrl)) {
            return true;
        }
        try {
            MobileLinkUrl mobileLinkUrlObj = (MobileLinkUrl)this.objectMapper.readValue(mobileLinkUrl, MobileLinkUrl.class);
            return StrUtil.isEmpty((CharSequence)mobileLinkUrlObj.getCcDone()) && StrUtil.isEmpty((CharSequence)mobileLinkUrlObj.getCcTodo()) && StrUtil.isEmpty((CharSequence)mobileLinkUrlObj.getDone()) && StrUtil.isEmpty((CharSequence)mobileLinkUrlObj.getTodo());
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u89e3\u6790mobileLinkUrl\u5931\u8d25\uff0cmobileLinkUrl: {}, error: {}", (Object)mobileLinkUrl, (Object)e.getMessage());
            return true;
        }
    }

    private String buildUrlFromExtra1(String extra1) {
        try {
            AppLinkUrl appLinkUrl = (AppLinkUrl)this.objectMapper.readValue(extra1, AppLinkUrl.class);
            if (appLinkUrl.getLinkType() != null && StrUtil.isNotEmpty((CharSequence)appLinkUrl.getUrl())) {
                switch (appLinkUrl.getLinkType()) {
                    case 0: {
                        return appLinkUrl.getUrl();
                    }
                    case 1: {
                        return appLinkUrl.getUrl();
                    }
                    case 2: {
                        return appLinkUrl.getUrl();
                    }
                }
                return appLinkUrl.getUrl();
            }
            return "";
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u89e3\u6790extra1\u5931\u8d25\uff0cerror: {}", (Object)e.getMessage());
            return "";
        }
    }

    private String buildMobileNoCodeUrl(TodoPushMessageDTO pushMessageDTO) {
        String systemAddress = pushMessageDTO.getSystemAddress();
        String businessid = pushMessageDTO.getBusinessid();
        String appId = pushMessageDTO.getAppId();
        String formId = pushMessageDTO.getFormId();
        String taskId = pushMessageDTO.getTaskId();
        String processKey = pushMessageDTO.getProcessDefinitionkey();
        if (!systemAddress.startsWith("http://") && !systemAddress.startsWith("https://")) {
            systemAddress = "http://" + systemAddress;
        }
        if (systemAddress.endsWith("/")) {
            systemAddress = systemAddress.substring(0, systemAddress.length() - 1);
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(String.format("%s/hussarApp/#/container/form?id=%s&appId=%s&formId=%s", systemAddress, businessid, appId, formId));
        urlBuilder.append("&formType=1");
        if (StrUtil.equals((CharSequence)"0", (CharSequence)pushMessageDTO.getTaskStatus())) {
            urlBuilder.append("&tabType=2");
        } else if (StrUtil.equals((CharSequence)"1", (CharSequence)pushMessageDTO.getTaskStatus())) {
            urlBuilder.append("&tabType=1");
        } else {
            urlBuilder.append("&tabType=2");
        }
        if (StrUtil.isNotEmpty((CharSequence)taskId)) {
            urlBuilder.append("&taskId=").append(taskId);
        }
        if (StrUtil.isNotEmpty((CharSequence)processKey)) {
            urlBuilder.append("&processKey=").append(processKey);
        }
        return urlBuilder.toString();
    }

    private String buildWebNoCodeUrl(TodoPushMessageDTO pushMessageDTO) {
        String systemAddress = pushMessageDTO.getSystemAddress();
        String businessid = pushMessageDTO.getBusinessid();
        String appId = pushMessageDTO.getAppId();
        String formId = pushMessageDTO.getFormId();
        String taskId = pushMessageDTO.getTaskId();
        String processInstanceid = pushMessageDTO.getProcessInstanceid();
        if (!systemAddress.startsWith("http://") && !systemAddress.startsWith("https://")) {
            systemAddress = "http://" + systemAddress;
        }
        if (systemAddress.endsWith("/")) {
            systemAddress = systemAddress.substring(0, systemAddress.length() - 1);
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(String.format("%s/hussarAppFrame/?rowId=%s", systemAddress, businessid));
        if (StrUtil.equals((CharSequence)"0", (CharSequence)pushMessageDTO.getTaskStatus())) {
            urlBuilder.append("&tabType=2");
        } else if (StrUtil.equals((CharSequence)"1", (CharSequence)pushMessageDTO.getTaskStatus())) {
            urlBuilder.append("&tabType=1");
        } else {
            urlBuilder.append("&tabType=2");
        }
        if (StrUtil.isNotEmpty((CharSequence)taskId)) {
            urlBuilder.append("&taskId=").append(taskId);
        }
        if (StrUtil.isNotEmpty((CharSequence)processInstanceid)) {
            urlBuilder.append("&processInstId=").append(processInstanceid);
        }
        return urlBuilder.toString();
    }

    private String buildMobileLowCodeUrl(TodoPushMessageDTO pushMessageDTO, String receiverUserId) {
        String linkPath;
        String systemAddress = pushMessageDTO.getSystemAddress();
        String mobileLinkUrl = pushMessageDTO.getMobileLinkurl();
        if (StrUtil.isEmpty((CharSequence)systemAddress) || this.isMobileLinkUrlEmpty(mobileLinkUrl)) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u7cfb\u7edf\u5730\u5740\u6216\u79fb\u52a8\u7aef\u94fe\u63a5\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u94fe\u63a5\uff0ctaskId: {}", (Object)pushMessageDTO.getTaskId());
            return "";
        }
        if (!systemAddress.startsWith("http://") && !systemAddress.startsWith("https://")) {
            systemAddress = "http://" + systemAddress;
        }
        if (systemAddress.endsWith("/")) {
            systemAddress = systemAddress.substring(0, systemAddress.length() - 1);
        }
        if (StrUtil.isEmpty((CharSequence)(linkPath = this.selectUrlByUserRoleAndStatus(mobileLinkUrl, pushMessageDTO, receiverUserId)))) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u65e0\u6cd5\u4ecemobileLinkUrl\u4e2d\u63d0\u53d6\u94fe\u63a5\u8def\u5f84\uff0ctaskId: {}", (Object)pushMessageDTO.getTaskId());
            return "";
        }
        return systemAddress + linkPath;
    }

    private String buildWebUrl(TodoPushMessageDTO pushMessageDTO, String receiverUserId) {
        String finalUrl;
        String webLinkUrl = pushMessageDTO.getWebLinkurl();
        String openType = pushMessageDTO.getOpenType();
        String systemAddress = pushMessageDTO.getSystemAddress();
        if (StrUtil.isEmpty((CharSequence)webLinkUrl)) {
            return "";
        }
        if ("noCode".equals(openType) || "noCodeBrowserTab".equals(openType)) {
            finalUrl = this.buildMobileNoCodeUrl(pushMessageDTO);
            log.error("\u6784\u5efa\u7684\u96f6\u4ee3\u7801\u5730\u5740\u4e3a\uff1a" + finalUrl);
        } else {
            String linkPath;
            if (StrUtil.isEmpty((CharSequence)systemAddress)) {
                log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u7cfb\u7edf\u5730\u5740\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6784\u5efaweb\u7aef\u94fe\u63a5\uff0ctaskId: {}", (Object)pushMessageDTO.getTaskId());
                return "";
            }
            if (!systemAddress.startsWith("http://") && !systemAddress.startsWith("https://")) {
                systemAddress = "http://" + systemAddress;
            }
            if (systemAddress.endsWith("/")) {
                systemAddress = systemAddress.substring(0, systemAddress.length() - 1);
            }
            if (StrUtil.isEmpty((CharSequence)(linkPath = this.selectUrlByUserRoleAndStatus(webLinkUrl, pushMessageDTO, receiverUserId)))) {
                log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u65e0\u6cd5\u4ecewebLinkUrl\u4e2d\u63d0\u53d6\u94fe\u63a5\u8def\u5f84\uff0ctaskId: {}", (Object)pushMessageDTO.getTaskId());
                return "";
            }
            finalUrl = systemAddress + linkPath;
        }
        return finalUrl;
    }

    private String selectUrlByUserRoleAndStatus(String linkUrl, TodoPushMessageDTO pushMessageDTO, String receiverUserId) {
        try {
            MobileLinkUrl mobileLinkUrlObj = (MobileLinkUrl)this.objectMapper.readValue(linkUrl, MobileLinkUrl.class);
            boolean isExecutor = this.isExecutor(receiverUserId, pushMessageDTO);
            boolean isFollower = this.isFollower(receiverUserId, pushMessageDTO);
            String taskStatus = pushMessageDTO.getTaskStatus();
            String executeStatus = pushMessageDTO.getExecuteStatus();
            if (isExecutor) {
                if ("0".equals(taskStatus) && "0".equals(executeStatus)) {
                    return mobileLinkUrlObj.getTodo();
                }
                if ("1".equals(taskStatus) && "1".equals(executeStatus)) {
                    return mobileLinkUrlObj.getDone();
                }
                return mobileLinkUrlObj.getTodo();
            }
            if (isFollower) {
                if ("0".equals(taskStatus)) {
                    return mobileLinkUrlObj.getCcTodo();
                }
                if ("1".equals(taskStatus)) {
                    return mobileLinkUrlObj.getCcDone();
                }
                return mobileLinkUrlObj.getCcTodo();
            }
            return mobileLinkUrlObj.getTodo();
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u89e3\u6790mobileLinkUrl\u5931\u8d25\uff0ctaskId: {}, error: {}", (Object)pushMessageDTO.getTaskId(), (Object)e.getMessage());
            return null;
        }
    }

    private String getStatusByPushTypeAndUserRole(TodoMessagePush.PushType pushType, String receiverUserId, TodoPushMessageDTO pushMessageDTO) {
        boolean isCreator = this.isCreator(receiverUserId, pushMessageDTO);
        boolean isExecutor = this.isExecutor(receiverUserId, pushMessageDTO);
        boolean isFollower = this.isFollower(receiverUserId, pushMessageDTO);
        switch (pushType) {
            case ADD_URGE_TASK: {
                if (isExecutor) {
                    return "\u50ac\u529e";
                }
                if (isFollower) {
                    return "\u5173\u6ce8";
                }
                return "\u50ac\u529e";
            }
            case ADD_TASK_USER: {
                if (isExecutor) {
                    return "\u5f85\u5904\u7406";
                }
                if (isFollower) {
                    return "\u5173\u6ce8";
                }
                if (isCreator) {
                    return "\u5f85\u5904\u7406";
                }
                return "\u5f85\u5904\u7406";
            }
            case UPDATE_TASK_STATUS: 
            case UPDATE_TASK_STATUS_WITHOUT_FOLLOWERS: {
                if (pushMessageDTO.getTaskStatus() != null) {
                    if ("1".equals(pushMessageDTO.getTaskStatus())) {
                        return "\u5df2\u5b8c\u6210";
                    }
                    if ("0".equals(pushMessageDTO.getTaskStatus())) {
                        if (isFollower) {
                            return "\u5173\u6ce8";
                        }
                        return "\u5f85\u5904\u7406";
                    }
                }
                return "\u5f85\u5904\u7406";
            }
            case UPDATE_USER_STATUS: {
                if (pushMessageDTO.getUserExecuteStatus() != null) {
                    if ("1".equals(pushMessageDTO.getUserExecuteStatus())) {
                        return "\u5df2\u5b8c\u6210";
                    }
                    if ("0".equals(pushMessageDTO.getUserExecuteStatus())) {
                        if (isFollower) {
                            return "\u5173\u6ce8";
                        }
                        return "\u5f85\u5904\u7406";
                    }
                }
                if (pushMessageDTO.getTaskStatus() != null) {
                    if ("1".equals(pushMessageDTO.getTaskStatus())) {
                        return "\u5df2\u5b8c\u6210";
                    }
                    if ("0".equals(pushMessageDTO.getTaskStatus())) {
                        return "\u5f85\u5904\u7406";
                    }
                }
                return "\u5f85\u5904\u7406";
            }
            case DELETE_TASK: {
                return "\u5df2\u5220\u9664";
            }
            case DELETE_TASK_USER: 
            case TRANSFER_TASK_DELETE_USER: {
                return "\u5df2\u5220\u9664";
            }
            case TRANSFER_USER_TASK: {
                if (pushMessageDTO.getTransferInfo() != null) {
                    Long newExecutorId = pushMessageDTO.getTransferInfo().getNewExecutorId();
                    Long originalExecutorId = pushMessageDTO.getTransferInfo().getOriginalExecutorId();
                    if (newExecutorId != null && receiverUserId.equals(newExecutorId.toString())) {
                        return "\u8f6c\u529e";
                    }
                    if (originalExecutorId != null && receiverUserId.equals(originalExecutorId.toString())) {
                        return "\u5df2\u8f6c\u529e";
                    }
                }
                return "\u5df2\u8f6c\u529e";
            }
        }
        if (isExecutor) {
            return "\u5f85\u5904\u7406";
        }
        if (isFollower) {
            return "\u5173\u6ce8";
        }
        return "\u5f85\u5904\u7406";
    }

    private boolean isUpdateOperation(TodoMessagePush.PushType pushType) {
        return pushType == TodoMessagePush.PushType.UPDATE_TASK;
    }

    private boolean isCreator(String userId, TodoPushMessageDTO pushMessageDTO) {
        if (StrUtil.isEmpty((CharSequence)userId) || pushMessageDTO.getCreateUserId() == null) {
            return false;
        }
        return userId.equals(pushMessageDTO.getCreateUserId().toString());
    }

    private boolean isExecutor(String userId, TodoPushMessageDTO pushMessageDTO) {
        if (StrUtil.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (pushMessageDTO.getPushType() == TodoMessagePush.PushType.ADD_TASK_USER) {
            return CollUtil.isNotEmpty(pushMessageDTO.getNewExecutorIds()) && pushMessageDTO.getNewExecutorIds().contains(userId);
        }
        if (pushMessageDTO.getPushType() == TodoMessagePush.PushType.DELETE_TASK_USER || pushMessageDTO.getPushType() == TodoMessagePush.PushType.TRANSFER_TASK_DELETE_USER) {
            return CollUtil.isNotEmpty(pushMessageDTO.getDeletedExecutorIds()) && pushMessageDTO.getDeletedExecutorIds().contains(userId);
        }
        if (pushMessageDTO.getExecutorIds() == null) {
            return false;
        }
        return pushMessageDTO.getExecutorIds().contains(userId);
    }

    private boolean isFollower(String userId, TodoPushMessageDTO pushMessageDTO) {
        if (StrUtil.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (pushMessageDTO.getPushType() == TodoMessagePush.PushType.ADD_TASK_USER) {
            return CollUtil.isNotEmpty(pushMessageDTO.getNewFollowerIds()) && pushMessageDTO.getNewFollowerIds().contains(userId);
        }
        if (pushMessageDTO.getPushType() == TodoMessagePush.PushType.DELETE_TASK_USER || pushMessageDTO.getPushType() == TodoMessagePush.PushType.TRANSFER_TASK_DELETE_USER) {
            return CollUtil.isNotEmpty(pushMessageDTO.getDeletedFollowerIds()) && pushMessageDTO.getDeletedFollowerIds().contains(userId);
        }
        if (CollUtil.isEmpty(pushMessageDTO.getFollowerIds())) {
            return false;
        }
        return pushMessageDTO.getFollowerIds().contains(userId);
    }

    @Override
    public SaveToDoDto getTaskDetailByTaskId(String taskId) {
        try {
            UnifiedSystemInfo systemInfo;
            ApiResponse<SaveToDoDto> response = this.unifiedTaskService.getToDoByRealTaskId(taskId);
            if (response == null || !response.isSuccess() || response.getData() == null) {
                return null;
            }
            SaveToDoDto saveToDoDto = (SaveToDoDto)response.getData();
            if (saveToDoDto.getSystemId() != null && (systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoService.detail(String.valueOf(saveToDoDto.getSystemId())).getData()) != null) {
                saveToDoDto.setSystemAddress(systemInfo.getSystemAddress());
                saveToDoDto.setSystemName(systemInfo.getSystemName());
                saveToDoDto.setSystemSource(systemInfo.getSystemSource());
                saveToDoDto.setOpenType(systemInfo.getOpenType());
            }
            return saveToDoDto;
        }
        catch (Exception e) {
            log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u83b7\u53d6\u5f85\u529e\u8be6\u60c5\u5931\u8d25\uff0ctaskId: {}", (Object)taskId, (Object)e);
            return null;
        }
    }

    private Map<String, List<String>> groupReceiversByMessageContent(TodoPushMessageDTO pushMessageDTO, List<String> receiverIds) {
        HashMap<String, List<String>> messageGroups = new HashMap<String, List<String>>();
        for (String receiverId : receiverIds) {
            try {
                String messageKey = this.buildMessageContentKey(pushMessageDTO, receiverId);
                messageGroups.computeIfAbsent(messageKey, k -> new ArrayList()).add(receiverId);
            }
            catch (Exception e) {
                log.error("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u4e3a\u63a5\u6536\u8005\u6784\u5efa\u6d88\u606f\u5185\u5bb9\u6807\u8bc6\u5931\u8d25: taskId={}, receiverId={}", new Object[]{pushMessageDTO.getTaskId(), receiverId, e});
                String fallbackKey = "error_" + receiverId;
                messageGroups.computeIfAbsent(fallbackKey, k -> new ArrayList()).add(receiverId);
            }
        }
        return messageGroups;
    }

    private String buildMessageContentKey(TodoPushMessageDTO pushMessageDTO, String receiverId) {
        boolean isCreator = this.isCreator(receiverId, pushMessageDTO);
        boolean isExecutor = this.isExecutor(receiverId, pushMessageDTO);
        boolean isFollower = this.isFollower(receiverId, pushMessageDTO);
        String userRole = isExecutor ? "executor" : (isFollower ? "follower" : (isCreator ? "initiator" : "other"));
        String userStatus = this.getStatusByPushTypeAndUserRole(pushMessageDTO.getPushType(), receiverId, pushMessageDTO);
        return String.format("%s_%s_%s_%s_%s", new Object[]{pushMessageDTO.getSystemId(), pushMessageDTO.getTaskId(), pushMessageDTO.getPushType(), userRole, userStatus});
    }
}

