/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.unifiedtodo.service;

import com.jxdinfo.mp.im.unifiedtodo.annotation.TodoMessagePush;
import com.jxdinfo.mp.im.unifiedtodo.dto.TodoPushMessageDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TodoMessageMergeService {
    private static final Logger log = LoggerFactory.getLogger(TodoMessageMergeService.class);

    public TodoPushMessageDTO mergeMessages(TodoPushMessageDTO oldMessage, TodoPushMessageDTO newMessage) {
        if (oldMessage == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return oldMessage;
        }
        log.debug("[\u6d88\u606f\u5408\u5e76] \u5f00\u59cb\u5408\u5e76\u6d88\u606f\uff0ctaskId: {}, oldStatus: {}, newStatus: {}", new Object[]{newMessage.getTaskId(), this.getTaskStatus(oldMessage), this.getTaskStatus(newMessage)});
        return this.selectPrimaryMessage(oldMessage, newMessage);
    }

    private TodoPushMessageDTO selectPrimaryMessage(TodoPushMessageDTO oldMessage, TodoPushMessageDTO newMessage) {
        int pushTypePriority = this.comparePushTypePriority(oldMessage.getPushType(), newMessage.getPushType());
        if (pushTypePriority != 0) {
            if (pushTypePriority > 0) {
                log.debug("[\u6d88\u606f\u9009\u62e9] \u9009\u62e9\u65e7\u6d88\u606f\uff08pushType\u4f18\u5148\u7ea7\u66f4\u9ad8\uff1a{}\uff09\uff0ctaskId: {}", (Object)oldMessage.getPushType(), (Object)oldMessage.getTaskId());
                return oldMessage;
            }
            log.debug("[\u6d88\u606f\u9009\u62e9] \u9009\u62e9\u65b0\u6d88\u606f\uff08pushType\u4f18\u5148\u7ea7\u66f4\u9ad8\uff1a{}\uff09\uff0ctaskId: {}", (Object)newMessage.getPushType(), (Object)newMessage.getTaskId());
            return newMessage;
        }
        boolean oldCompleted = this.isTaskCompleted(oldMessage);
        boolean newCompleted = this.isTaskCompleted(newMessage);
        if (oldMessage.getPushType() == TodoMessagePush.PushType.SAVE_TASK && newMessage.getPushType() == TodoMessagePush.PushType.SAVE_TASK) {
            if (!oldCompleted && !newCompleted) {
                TodoPushMessageDTO laterMessage = oldMessage.getCreateTime().after(newMessage.getCreateTime()) ? oldMessage : newMessage;
                log.debug("[\u6d88\u606f\u9009\u62e9] SAVE_TASK\u90fd\u672a\u5b8c\u6210\uff0c\u9009\u62e9\u65f6\u95f4\u66f4\u665a\u7684\u6d88\u606f\uff0ctaskId: {}, createTime: {}", (Object)laterMessage.getTaskId(), (Object)laterMessage.getCreateTime());
                return laterMessage;
            }
            if (oldCompleted && newCompleted) {
                TodoPushMessageDTO laterMessage = oldMessage.getCreateTime().after(newMessage.getCreateTime()) ? oldMessage : newMessage;
                log.debug("[\u6d88\u606f\u9009\u62e9] SAVE_TASK\u90fd\u5df2\u5b8c\u6210\uff0c\u9009\u62e9\u65f6\u95f4\u66f4\u665a\u7684\u6d88\u606f\uff0ctaskId: {}, createTime: {}", (Object)laterMessage.getTaskId(), (Object)laterMessage.getCreateTime());
                return laterMessage;
            }
            if (oldCompleted && !newCompleted) {
                log.debug("[\u6d88\u606f\u9009\u62e9] SAVE_TASK\u9009\u62e9\u672a\u5b8c\u6210\u7684\u65b0\u6d88\u606f\uff0ctaskId: {}", (Object)newMessage.getTaskId());
                return newMessage;
            }
            log.debug("[\u6d88\u606f\u9009\u62e9] SAVE_TASK\u9009\u62e9\u672a\u5b8c\u6210\u7684\u65e7\u6d88\u606f\uff0ctaskId: {}", (Object)oldMessage.getTaskId());
            return oldMessage;
        }
        if (oldCompleted && !newCompleted) {
            log.debug("[\u6d88\u606f\u9009\u62e9] \u9009\u62e9\u65b0\u6d88\u606f\uff08\u672a\u5b8c\u6210\uff09\uff0ctaskId: {}", (Object)newMessage.getTaskId());
            return newMessage;
        }
        if (!oldCompleted && newCompleted) {
            log.debug("[\u6d88\u606f\u9009\u62e9] \u9009\u62e9\u65e7\u6d88\u606f\uff08\u672a\u5b8c\u6210\uff09\uff0ctaskId: {}", (Object)oldMessage.getTaskId());
            return oldMessage;
        }
        TodoPushMessageDTO laterMessage = oldMessage.getCreateTime().after(newMessage.getCreateTime()) ? oldMessage : newMessage;
        return laterMessage;
    }

    private int comparePushTypePriority(TodoMessagePush.PushType oldPushType, TodoMessagePush.PushType newPushType) {
        if (oldPushType == newPushType) {
            return 0;
        }
        int oldPriority = this.getPushTypePriority(oldPushType);
        int newPriority = this.getPushTypePriority(newPushType);
        return Integer.compare(oldPriority, newPriority);
    }

    private int getPushTypePriority(TodoMessagePush.PushType pushType) {
        if (pushType == null) {
            return 0;
        }
        switch (pushType) {
            case SAVE_TASK: {
                return 100;
            }
            case UPDATE_TASK: 
            case UPDATE_TASK_USER: 
            case UPDATE_TASK_STATUS: 
            case UPDATE_TASK_STATUS_WITHOUT_FOLLOWERS: {
                return 50;
            }
            case ADD_TASK_USER: 
            case DELETE_TASK_USER: 
            case TRANSFER_TASK_DELETE_USER: 
            case TRANSFER_USER_TASK: {
                return 30;
            }
            case DELETE_TASK: {
                return 20;
            }
            case ADD_URGE_TASK: {
                return 10;
            }
            case UPDATE_USER_STATUS: {
                return 5;
            }
        }
        return 1;
    }

    private boolean isTaskCompleted(TodoPushMessageDTO message) {
        String status;
        String state;
        if (message == null) {
            return false;
        }
        String taskState = message.getTaskStatus();
        if (StringUtils.hasText((String)taskState) && ((state = taskState.toLowerCase()).contains("complet") || state.contains("finish") || state.contains("done") || state.contains("closed") || state.contains("end") || state.equals("2"))) {
            return true;
        }
        String executeStatus = message.getExecuteStatus();
        return StringUtils.hasText((String)executeStatus) && ((status = executeStatus.toLowerCase()).contains("complet") || status.contains("finish") || status.contains("done") || status.contains("closed") || status.contains("end") || status.equals("2"));
    }

    private String getTaskStatus(TodoPushMessageDTO message) {
        if (message == null) {
            return "null";
        }
        boolean completed = this.isTaskCompleted(message);
        String taskState = message.getTaskStatus();
        String executeStatus = message.getExecuteStatus();
        return String.format("%s(state:%s,status:%s)", completed ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210", taskState != null ? taskState : "null", executeStatus != null ? executeStatus : "null");
    }
}

