/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterDO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.application.vo.WorkstationApplicationVo;
import com.jxdinfo.mp.common.utils.JqxSpringUtil;
import com.jxdinfo.mp.im.EimPubPlatService;
import com.jxdinfo.mp.im.dao.material.MaterialMapper;
import com.jxdinfo.mp.im.dao.single.PubMsgLogMapper;
import com.jxdinfo.mp.im.handler.MessageHandler;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.material.MaterialDTO;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.model.single.PubMsgLogVO;
import com.jxdinfo.mp.im.model.single.TimeDO;
import com.jxdinfo.mp.im.service.DealMessageService;
import com.jxdinfo.mp.im.service.MaterialService;
import com.jxdinfo.mp.im.service.MessageService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import com.jxdinfo.mp.im.util.FileTool;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class PubPlatMessageServiceImpl
implements PubPlatMessageService {
    @Autowired(required=false)
    private EimPubPlatService pubPlatService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private MessageService messageService;
    @Resource
    private DealMessageService dealMessageService;
    @Resource
    private PubMsgLogMapper pubMsgLogMapper;
    @Resource
    private IOrganizationBoService organizationService;
    @Resource
    private MessageHandler messageHandler;
    @Resource
    private MaterialService materialService;
    @Resource
    private MaterialMapper materialMapper;
    @Resource
    private JobServiceService jobServiceService;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysApplicationService sysApplicationService;

    public Result<PageVO<RosterVO>> getUsers(Long msgID, String searchKey, int pageSize, int pageNum, String orgIDs, String roleIDs) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)msgID));
        MessageDO messageDO = (MessageDO)this.mongoTemplate.findOne(query, MessageDO.class);
        if (messageDO == null) {
            return Result.failed(null);
        }
        PageVO pageVO = new PageVO();
        pageVO.setPageNum(Integer.valueOf(pageNum));
        pageVO.setPageSize(Integer.valueOf(pageSize));
        List userStaffVos = new ArrayList();
        userStaffVos = messageDO.getPubplatReceiverCode() == null ? this.organizationService.queryUserByUserID(new ArrayList(), searchKey, orgIDs, roleIDs, pageNum, pageSize) : this.organizationService.queryUserByUserID(Arrays.stream(messageDO.getPubplatReceiverCode().split(",")).map(Long::parseLong).collect(Collectors.toList()), searchKey, orgIDs, roleIDs, pageNum, pageSize);
        if (pageVO == null) {
            return Result.failed(null);
        }
        List<Long> userIDS = pageVO.getList().stream().map(RosterVO::getUserId).collect(Collectors.toList());
        List<TimeDO> userTimeS = this.getTime(messageDO.getReceiverCode(), userIDS);
        userStaffVos.forEach(userStaffVo -> {
            userStaffVo.setReadType("unread");
            for (TimeDO timeDO : userTimeS) {
            }
        });
        return Result.succeed((Object)pageVO);
    }

    public Page<WorkstationApplicationVo> getPubPlatMsgList(String pubPlatName, int pageNum, int pageSize) {
        Page data = (Page)this.pubPlatService.getPageList(pubPlatName, pageNum, pageSize, "", "8,19").getData();
        List appIds = data.getRecords().stream().map(SysApplication::getId).map(String::valueOf).collect(Collectors.toList());
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"mode").is((Object)2).and("senderName").ne((Object)"\u7cfb\u7edf").and("receiverCode").in(appIds)), Aggregation.group((String[])new String[]{"receiverCode"}).count().as("count").max("msgTime").as("msgTime"), Aggregation.project((String[])new String[]{"count", "msgTime"})});
        Aggregation aggregation2 = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"mode").is((Object)2).and("senderName").is((Object)"\u7cfb\u7edf").and("receiverCode").in(appIds)), Aggregation.group((String[])new String[]{"receiverCode"}).count().as("count").max("msgTime").as("msgTime"), Aggregation.project((String[])new String[]{"count", "msgTime"})});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "message", MessageDO.class);
        AggregationResults results2 = this.mongoTemplate.aggregate(aggregation2, "message", MessageDO.class);
        ArrayList pubPlatMsgList = (ArrayList)results.getRawResults().get((Object)"results");
        ArrayList pubPlatMsgList2 = (ArrayList)results2.getRawResults().get((Object)"results");
        data.getRecords().forEach(sysWorkstationAppVO -> {
            SimpleDateFormat sdf;
            sysWorkstationAppVO.setMsgNum(Long.valueOf(0L));
            for (Map msg : pubPlatMsgList) {
                if (!sysWorkstationAppVO.getId().toString().equals(msg.get("_id"))) continue;
                sysWorkstationAppVO.setMsgNum(Convert.toLong(msg.get("count")));
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                sysWorkstationAppVO.setMsgTime(sdf.format(msg.get("msgTime")));
            }
            for (Map msg : pubPlatMsgList2) {
                if (!sysWorkstationAppVO.getId().toString().equals(msg.get("_id"))) continue;
                sysWorkstationAppVO.setMsgNum(Long.valueOf(sysWorkstationAppVO.getMsgNum() + Convert.toLong(msg.get("count"))));
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                if (ToolUtil.isEmpty((Object)sysWorkstationAppVO.getMsgTime())) {
                    sysWorkstationAppVO.setMsgTime(sdf.format(msg.get("msgTime")));
                    continue;
                }
                sysWorkstationAppVO.setMsgTime(sysWorkstationAppVO.getMsgTime().compareTo(sdf.format(msg.get("msgTime"))) >= 0 ? sysWorkstationAppVO.getMsgTime() : sdf.format(msg.get("msgTime")));
            }
        });
        return data;
    }

    public PageDTO<RosterVO> getUserMsgList(PageDTO<RosterVO> pageDTO, Long pubPlatID, String searchKey, Long roleID) {
        Pattern pattern = Pattern.compile(".*" + searchKey + ".*", 2);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)2), Criteria.where((String)"receiverCode").is((Object)pubPlatID.toString())});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"pubplatReceiverCode"}).count().as("count").max("msgTime").as("msgTime"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTime"})});
        List userMsgList = this.mongoTemplate.aggregate(aggregation, MessageDO.class, Map.class).getMappedResults();
        if (CollUtil.isEmpty((Collection)userMsgList)) {
            pageDTO.setPageCount(Integer.valueOf(0));
            return pageDTO;
        }
        StringBuilder senderCodeStr = new StringBuilder();
        for (Map map : userMsgList) {
            senderCodeStr.append(map.get("_id")).append(",");
        }
        List senderIDList = CollUtil.toList((Object[])new String(senderCodeStr).split(",")).stream().distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty((Collection)userMsgList)) {
            pageDTO.setPageCount(Integer.valueOf(0));
            return pageDTO;
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.apply("1=1", new Object[0])).in((Object)"U.USER_ID", senderIDList);
        if (!HussarUtils.isEmpty((Object)searchKey)) {
            wrapper.like(StrUtil.isNotEmpty((CharSequence)searchKey), (Object)"U.USER_NAME", (Object)JqxSpringUtil.replaceSpecialChar((String)searchKey));
        }
        List<RosterVO> rosterVOList = this.pubMsgLogMapper.getRosterList((Wrapper<RosterDO>)wrapper);
        rosterVOList.forEach(rosterVO -> {
            long count = 0L;
            ArrayList<Long> msgTime = new ArrayList<Long>();
            for (Map msg : userMsgList) {
                if (!ToolUtil.isNotEmpty(msg.get("_id")) || !msg.get("_id").toString().toUpperCase().contains(rosterVO.getUserId().toString())) continue;
                count += Convert.toLong(msg.get("count")).longValue();
                msgTime.add((Long)msg.get("msgTime"));
            }
            if (!msgTime.isEmpty()) {
                rosterVO.setMsgTime(DateUtil.date((long)((Long)Collections.max(msgTime))).toString().substring(0, 19));
            }
            rosterVO.setMsgNum(Long.valueOf(count));
        });
        Collections.sort(rosterVOList);
        pageDTO.setTotal((long)rosterVOList.size());
        pageDTO.setList(rosterVOList.subList((pageDTO.getPageNum() - 1) * pageDTO.getPageSize(), Math.min(pageDTO.getPageNum() * pageDTO.getPageSize(), rosterVOList.size())));
        pageDTO.setPageCount(Integer.valueOf(rosterVOList.size()));
        return pageDTO;
    }

    public Map<String, Object> getPubMsgDetail(Long pubPlatID, Long userID, PageVO<BaseMsgBean> pageVO) {
        Pattern pattern = Pattern.compile(".*" + userID + ".*", 2);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)2), Criteria.where((String)"receiverCode").is((Object)pubPlatID.toString()), Criteria.where((String)"pubplatReceiverCode").regex(pattern)});
        pageVO = this.messageService.getPubplatMessage(criteria, pageVO);
        for (BaseMsgBean baseMsgBean : pageVO.getList()) {
            if (!"\u7cfb\u7edf".equals(baseMsgBean.getSenderName())) continue;
            baseMsgBean.setSenderCode(pubPlatID.toString());
            baseMsgBean.setSenderName(baseMsgBean.getReceiverName());
            baseMsgBean.setReceiverCode(userID.toString());
            baseMsgBean.setReceiverName(this.hussarBaseUserBoService.getUserAndStaffInfo(userID).getUserName());
        }
        CollUtil.reverse((List)pageVO.getList());
        map.put("list", pageVO.getList());
        map.put("count", pageVO.getPageCount());
        return map;
    }

    public boolean msgReply(Long pubPlatID, Long userID, String pubPlatName, String msgContent) {
        BaseMsgBean baseMsgBean = new BaseMsgBean();
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        baseMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)baseMsgBean)));
        baseMsgBean.setBody(msgContent);
        baseMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
        baseMsgBean.setMsgTime(DateUtil.now());
        baseMsgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
        baseMsgBean.setReceiverCode(pubPlatID.toString());
        baseMsgBean.setReceiverName(pubPlatName);
        baseMsgBean.setSenderCode(String.valueOf(IMConstants.IM_SYSTEM_ID));
        baseMsgBean.setSenderName("\u7cfb\u7edf");
        baseMsgBean.setResource("system");
        baseMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        baseMsgBean.setCompID(ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId()) ? BaseSecurityUtil.getUser().getTenantId().toString() : null);
        baseMsgBean.setCompName(BaseSecurityUtil.getUser().getTenantName());
        baseMsgBean.setPubplatReceiverCode(String.valueOf(userID));
        pushMessageDTO.setBaseMsgBean(baseMsgBean);
        pushMessageDTO.setReceiverIds(String.valueOf(userID));
        pushMessageDTO.setMode(baseMsgBean.getMode());
        pushMessageDTO.setMsgType(baseMsgBean.getMsgType());
        return this.pushService.sendMessage(pushMessageDTO);
    }

    @Transactional
    public boolean sendTextMsg(PubMsgLogDTO pubMsgLogDTO) {
        TextMsgBean msgBean = new TextMsgBean();
        msgBean.setMsgID(String.valueOf(IdWorker.getId((Object)msgBean)));
        msgBean.setBody(pubMsgLogDTO.getMaterialDTO().getContent());
        msgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
        msgBean.setMsgTime(DateUtil.now());
        msgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
        msgBean.setReceiverCode(pubMsgLogDTO.getPubPlatID().toString());
        msgBean.setReceiverName(pubMsgLogDTO.getPubPlatName());
        msgBean.setSenderCode(String.valueOf(IMConstants.IM_SYSTEM_ID));
        msgBean.setSenderName("\u7cfb\u7edf");
        msgBean.setResource("system");
        msgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        pubMsgLogDTO.setMsgID(Long.valueOf(Long.parseLong(msgBean.getMsgID())));
        return this.dealMessageService.sendMsg((BaseMsgBean)msgBean, pubMsgLogDTO.getUserIDs());
    }

    public boolean sendArticleMsg(PubMsgLogDTO pubMsgLogDTO) {
        ArticleMsgBean articleMsgBean = new ArticleMsgBean();
        ArrayList articleBeanList = new ArrayList();
        AtomicInteger i = new AtomicInteger(1);
        pubMsgLogDTO.getMaterialDTO().getMaterialArticleVOList().forEach(materialArticleVO -> {
            ArticleBean articleBean = new ArticleBean();
            if (materialArticleVO.getMsgLinkID() != null) {
                articleBean.setBid(String.valueOf(materialArticleVO.getMsgLinkID()));
                articleBean.setUrl(materialArticleVO.getMsgLink());
            } else {
                articleBean.setUrl(materialArticleVO.getMsgLink());
                articleBean.setBid(null);
            }
            articleBean.setLinkType(ArticleBean.LinkType.WEB);
            articleBean.setObjID(String.valueOf(IdWorker.getId((Object)articleBean)));
            articleBean.setShowOrder(i + "");
            articleBean.setSubTitle(materialArticleVO.getSubTitle());
            articleBean.setTitle(materialArticleVO.getTitle());
            articleBean.setFileID(String.valueOf(materialArticleVO.getFileID()));
            articleBeanList.add(articleBean);
            i.getAndIncrement();
        });
        articleMsgBean.setArticles(articleBeanList);
        articleMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)articleMsgBean)));
        articleMsgBean.setBody(((ArticleBean)articleMsgBean.getArticles().get(0)).getTitle());
        articleMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
        articleMsgBean.setMsgTime(DateUtil.now());
        articleMsgBean.setMsgType(BaseMsgBean.MsgType.ARTICLES);
        articleMsgBean.setReceiverCode(pubMsgLogDTO.getPubPlatID().toString());
        articleMsgBean.setReceiverName(pubMsgLogDTO.getPubPlatName());
        articleMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
        articleMsgBean.setSenderName("\u7cfb\u7edf");
        articleMsgBean.setResource("system");
        articleMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        pubMsgLogDTO.setMsgID(Long.valueOf(Long.parseLong(articleMsgBean.getMsgID())));
        return this.dealMessageService.sendMsg((BaseMsgBean)articleMsgBean, pubMsgLogDTO.getUserIDs());
    }

    public boolean sendImgMsg(PubMsgLogDTO pubMsgLogDTO) {
        ImgMsgBean imgMsgBean = new ImgMsgBean();
        imgMsgBean.setFileStatus(ImgMsgBean.FileStatus.UPLOADSUCCESS);
        imgMsgBean.setFileName(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileName());
        imgMsgBean.setFileID(String.valueOf(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileID()));
        imgMsgBean.setFileSize(String.valueOf(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileSize()));
        imgMsgBean.setWidth(pubMsgLogDTO.getMaterialDTO().getFileBean().getWidth().intValue());
        imgMsgBean.setHeight(pubMsgLogDTO.getMaterialDTO().getFileBean().getHeight().intValue());
        imgMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)imgMsgBean)));
        imgMsgBean.setBody(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileName());
        imgMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
        imgMsgBean.setMsgTime(DateUtil.now());
        imgMsgBean.setMsgType(BaseMsgBean.MsgType.IMAGE);
        imgMsgBean.setReceiverCode(pubMsgLogDTO.getPubPlatID().toString());
        imgMsgBean.setReceiverName(pubMsgLogDTO.getPubPlatName());
        imgMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
        imgMsgBean.setSenderName("\u7cfb\u7edf");
        imgMsgBean.setResource("system");
        imgMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        pubMsgLogDTO.setMsgID(Long.valueOf(Long.parseLong(imgMsgBean.getMsgID())));
        return this.dealMessageService.sendMsg((BaseMsgBean)imgMsgBean, pubMsgLogDTO.getUserIDs());
    }

    public boolean sendFileMsg(PubMsgLogDTO pubMsgLogDTO) {
        FileMsgBean fileMsgBean = new FileMsgBean();
        fileMsgBean.setFileName(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileName());
        fileMsgBean.setFileID(String.valueOf(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileID()));
        fileMsgBean.setFileSize(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileSize().floatValue());
        fileMsgBean.setFileStatus(FileMsgBean.FileStatus.UPLOADING);
        fileMsgBean.setFileType(FileTool.getFileType((String)pubMsgLogDTO.getMaterialDTO().getFileBean().getFileName()));
        fileMsgBean.setMd5("");
        fileMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)fileMsgBean)));
        fileMsgBean.setBody(pubMsgLogDTO.getMaterialDTO().getFileBean().getFileName());
        fileMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
        fileMsgBean.setMsgTime(DateUtil.now());
        fileMsgBean.setMsgType(BaseMsgBean.MsgType.FILETYPE);
        fileMsgBean.setReceiverCode(pubMsgLogDTO.getPubPlatID().toString());
        fileMsgBean.setReceiverName(pubMsgLogDTO.getPubPlatName());
        fileMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
        fileMsgBean.setSenderName("\u7cfb\u7edf");
        fileMsgBean.setResource("system");
        fileMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        pubMsgLogDTO.setMsgID(Long.valueOf(Long.parseLong(fileMsgBean.getMsgID())));
        return this.dealMessageService.sendMsg((BaseMsgBean)fileMsgBean, pubMsgLogDTO.getUserIDs());
    }

    public PubMsgLogDTO executeMaterial(PubMsgLogDTO pubMsgLogDTO, CurrentLoginUser loginUser, String urlSplicing) {
        if (pubMsgLogDTO.getMaterialDTO().getObjID() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"LIBRARY_ID", (Object)pubMsgLogDTO.getMaterialDTO().getObjID());
            if (this.materialMapper.selectCount((Wrapper)wrapper) > 0L) {
                pubMsgLogDTO.getMaterialDTO().setTitle(null);
                this.materialService.updateMaterial(pubMsgLogDTO.getMaterialDTO(), loginUser, urlSplicing);
            } else {
                this.materialService.saveMaterial(pubMsgLogDTO.getMaterialDTO(), loginUser, urlSplicing);
            }
        } else {
            pubMsgLogDTO.getMaterialDTO().setObjID(Long.valueOf(IdWorker.getId((Object)pubMsgLogDTO.getMaterialDTO())));
            this.materialService.saveMaterial(pubMsgLogDTO.getMaterialDTO(), loginUser, urlSplicing);
        }
        return pubMsgLogDTO;
    }

    public Result<Boolean> sendPubMsg(PubMsgLogDTO pubMsgLogDTO) {
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 0) {
            return Result.succeed((Object)this.sendTextMsg(pubMsgLogDTO));
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 8) {
            return Result.succeed((Object)this.sendArticleMsg(pubMsgLogDTO));
        }
        if (pubMsgLogDTO.getMaterialDTO().getMaterialType() == 1) {
            return Result.succeed((Object)this.sendImgMsg(pubMsgLogDTO));
        }
        return Result.succeed((Object)this.sendFileMsg(pubMsgLogDTO));
    }

    public List<TimeDO> getTime(String objID, List<Long> userIDS) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"objID").is((Object)objID).and("userID").in(userIDS);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, TimeDO.class);
    }

    public Result<PageVO<BaseMsgBean>> getPubMsgHistory(Long pubPlatID, int pageNum, int pageSize) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)2), Criteria.where((String)"receiverCode").is((Object)pubPlatID), Criteria.where((String)"senderCode").is((Object)"admin"), Criteria.where((String)"msgType").ne((Object)BaseMsgBean.MsgType.WITHDRAW.ordinal())});
        List messageDOS = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)criteria).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTime")})).skip((long)(pageSize * (pageNum - 1))).limit(pageSize), MessageDO.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        msgBeans.forEach(baseMsgBean -> baseMsgBean.setMsgTime(baseMsgBean.getMsgTime().substring(0, 19)));
        PageVO pageVO = new PageVO();
        pageVO.setPageNum(Integer.valueOf(pageNum));
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setList((List)msgBeans);
        pageVO.setPageCount(Integer.valueOf((int)this.mongoTemplate.count(new Query((CriteriaDefinition)criteria), MessageDO.class)));
        return Result.succeed((Object)pageVO);
    }

    @Transactional
    public Result<Boolean> timingPush(PubMsgLogDTO pubMsgLogDTO, CurrentLoginUser loginUser, String urlSplicing) {
        long msgID = IdWorker.getId((Object)pubMsgLogDTO);
        if (StrUtil.isNotEmpty((CharSequence)pubMsgLogDTO.getUserIDs())) {
            this.pubMsgLogMapper.addArticlePerson(CollUtil.toList((Object[])pubMsgLogDTO.getUserIDs().split(",")), msgID);
        }
        pubMsgLogDTO = this.executeMaterial(pubMsgLogDTO, loginUser, urlSplicing);
        PubMsgLogDO pubMsgLogDO = new PubMsgLogDO();
        pubMsgLogDO.setObjID(Long.valueOf(msgID));
        pubMsgLogDO.setCreateTime(DateUtil.now());
        pubMsgLogDO.setMaterialID(pubMsgLogDTO.getMaterialDTO().getObjID());
        pubMsgLogDO.setMode(Integer.valueOf(1));
        pubMsgLogDO.setMsgType(pubMsgLogDTO.getMaterialDTO().getMaterialType());
        pubMsgLogDO.setPubPlatID(pubMsgLogDTO.getPubPlatID());
        pubMsgLogDO.setSendTime(pubMsgLogDTO.getSendTime());
        pubMsgLogDO.setState(Integer.valueOf(2));
        pubMsgLogDO.setUserID(null);
        pubMsgLogDO.setUserIds(pubMsgLogDTO.getUserIdStr());
        pubMsgLogDO.setOrganIds(pubMsgLogDTO.getOrganiseIDs());
        pubMsgLogDO.setRoleIds(pubMsgLogDTO.getRoleIDs());
        String executeParam = pubMsgLogDTO.getPubPlatID() + "@" + pubMsgLogDTO.getPubPlatName() + "@" + pubMsgLogDTO.getMaterialDTO().getObjID() + "@" + msgID;
        SaveJobInfoRequest saveJobInfoRequest = new SaveJobInfoRequest();
        saveJobInfoRequest.setJobParams(executeParam);
        saveJobInfoRequest.setAppId(Long.valueOf(543099687121723392L));
        saveJobInfoRequest.setEnable(true);
        saveJobInfoRequest.setExecuteType(ExecuteType.STANDALONE);
        saveJobInfoRequest.setJobName("\u5fae\u5e94\u7528" + pubMsgLogDTO.getPubPlatName() + "\u5b9a\u65f6\u63a8\u9001");
        saveJobInfoRequest.setMaxInstanceNum(Integer.valueOf(1));
        saveJobInfoRequest.setProcessorInfo("com.jxdinfo.mp.im.job.PubPlatMsgJobHandler");
        saveJobInfoRequest.setProcessorType(ProcessorType.BUILT_IN);
        saveJobInfoRequest.setTenantCode("0");
        saveJobInfoRequest.setTimeExpressionType(TimeExpressionType.CRON);
        saveJobInfoRequest.setTimeExpression(pubMsgLogDTO.getCron());
        try {
            Long jobId = (Long)this.jobServiceService.saveJobApi(saveJobInfoRequest).getData();
            pubMsgLogDO.setJobId(jobId);
            this.pubMsgLogMapper.insert(pubMsgLogDO);
        }
        catch (Exception e) {
            return Result.succeed((Object)false, (String)"\u5b9a\u65f6\u63a8\u9001\u4efb\u52a1\u6784\u5efa\u5931\u8d25");
        }
        return Result.succeed((Object)true, (String)"\u5b9a\u65f6\u63a8\u9001\u4efb\u52a1\u6784\u5efa\u6210\u529f");
    }

    public PubMsgLogVO queryPubMsgPushDetail(String msgId) {
        PubMsgLogDO pubMsgLogDO = (PubMsgLogDO)this.pubMsgLogMapper.selectById((Serializable)((Object)msgId));
        PubMsgLogVO pubMsgLogVO = new PubMsgLogVO();
        if (pubMsgLogDO == null) {
            Criteria criteria = new Criteria("msgID").is((Object)msgId);
            Query query = new Query((CriteriaDefinition)criteria);
            MessageDO messageDO = (MessageDO)this.mongoTemplate.findOne(query, MessageDO.class);
            pubMsgLogVO.setAppName(messageDO.getReceiverName());
            pubMsgLogVO.setMsgType(messageDO.getMsgType());
            pubMsgLogVO.setSendTime(DateUtil.format((Date)new Date(messageDO.getMsgTime()), (String)"yyyy-MM-dd HH:mm:ss"));
            pubMsgLogVO.setPubPlatID(Long.valueOf(messageDO.getReceiverCode()));
            pubMsgLogVO.setUserIds(messageDO.getPubplatReceiverCode());
        } else {
            pubMsgLogVO = (PubMsgLogVO)BeanUtil.copyProperties((Object)pubMsgLogDO, PubMsgLogVO.class);
        }
        PubMsgLogDTO temp = this.materialService.getMaterial(pubMsgLogVO.getMaterialID());
        if (ToolUtil.isNotEmpty((Object)temp) && ToolUtil.isNotEmpty((Object)temp.getMaterialDTO())) {
            MaterialDTO materialDTO = (MaterialDTO)BeanUtil.copyProperties((Object)temp.getMaterialDTO(), MaterialDTO.class);
            pubMsgLogVO.setMaterialDTO(materialDTO);
        }
        if (ToolUtil.isNotEmpty((Object)pubMsgLogVO.getOrganIds())) {
            List struIds = Arrays.stream(pubMsgLogVO.getOrganIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
            List organList = this.hussarBaseOrganizationBoService.getSimpleOrgan(struIds);
            pubMsgLogVO.setOrganList(organList);
        }
        if (ToolUtil.isNotEmpty((Object)pubMsgLogVO.getUserIds())) {
            List userIds = Arrays.stream(pubMsgLogVO.getUserIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
            List userList = this.hussarBaseUserBoService.getUsersByOrganUser(null, userIds);
            pubMsgLogVO.setUserList(userList);
        }
        if (ToolUtil.isNotEmpty((Object)pubMsgLogVO.getRoleIds())) {
            List roleIds = Arrays.stream(pubMsgLogVO.getRoleIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
            List roleList = this.sysRolesService.listByIds(roleIds);
            pubMsgLogVO.setRoleList(roleList);
        }
        pubMsgLogVO.setAppName(((SysApplication)this.sysApplicationService.getById((Serializable)pubMsgLogVO.getPubPlatID())).getAppName());
        return pubMsgLogVO;
    }

    public long getTimeStamp(String time) throws ParseException {
        return Convert.toLong((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time).getTime());
    }
}

