/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.handler;

import com.jxdinfo.mp.common.annotation.MethodHandler;
import com.jxdinfo.mp.im.anontion.MessageType;
import com.jxdinfo.mp.im.mapping.MethodMapping;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.single.MessageDO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MessageHandler
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageHandler.class);
    private ApplicationContext applicationContext;
    private HashMap<String, List<MethodMapping>> classMethodMap = new HashMap();

    public void afterPropertiesSet() {
        Map methodHandlerMap = this.applicationContext.getBeansWithAnnotation(MethodHandler.class);
        methodHandlerMap.forEach((k, v) -> {
            Class<?> clazz = v.getClass();
            Method[] methods = clazz.getDeclaredMethods();
            ArrayList<MethodMapping> methodMappings = new ArrayList<MethodMapping>();
            for (Method method : methods) {
                if (!method.isAnnotationPresent(MessageType.class)) continue;
                MessageType messageTypeAnnotation = method.getAnnotation(MessageType.class);
                methodMappings.add(new MethodMapping(messageTypeAnnotation.msgType(), method));
            }
            if (!methodMappings.isEmpty()) {
                this.classMethodMap.put(clazz.getName(), methodMappings);
            }
        });
    }

    public BaseMsgBean execute(int ordinal, Object ... parameters) {
        if (!this.classMethodMap.containsKey(this.getClass().getName())) {
            return new BaseMsgBean();
        }
        List<MethodMapping> methodMappings = this.classMethodMap.get(this.getClass().getName());
        for (MethodMapping methodMapping : methodMappings) {
            if (methodMapping.msgType.ordinal() != ordinal) continue;
            try {
                BaseMsgBean baseMsgBean = (BaseMsgBean)methodMapping.method.invoke((Object)this, parameters);
                MessageDO messageDO = (MessageDO)parameters[0];
                baseMsgBean.setMsgID(messageDO.getMsgID().toString());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                baseMsgBean.setMsgTime(sdf.format(messageDO.getMsgTime()));
                baseMsgBean.setBody(messageDO.getBody());
                baseMsgBean.setSenderCode(messageDO.getSenderCode());
                baseMsgBean.setSenderName(messageDO.getSenderName());
                baseMsgBean.setReceiverCode(messageDO.getReceiverCode());
                baseMsgBean.setReceiverName(messageDO.getReceiverName());
                baseMsgBean.setStatus(BaseMsgBean.Status.values()[messageDO.getStatus()]);
                baseMsgBean.setMsgType(BaseMsgBean.MsgType.values()[messageDO.getMsgType()]);
                baseMsgBean.setMode(BaseMsgBean.Mode.values()[messageDO.getMode()]);
                baseMsgBean.setRead(BaseMsgBean.Read.values()[messageDO.getRead()]);
                baseMsgBean.setShowOrder(messageDO.getShowOrder());
                baseMsgBean.setResource(messageDO.getResource());
                baseMsgBean.setCompID(messageDO.getCompID());
                baseMsgBean.setCompName(messageDO.getCompName());
                baseMsgBean.setMsgReceiverName(messageDO.getMsgReceiverName());
                baseMsgBean.setMsgReceiverCode(messageDO.getMsgReceiverCode());
                baseMsgBean.setBId(String.valueOf(messageDO.getBId()));
                baseMsgBean.setPubplatReceiverCode(messageDO.getPubplatReceiverCode());
                return baseMsgBean;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("", e.getCause());
            }
        }
        return new BaseMsgBean();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

