/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.ad.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.mp.ad.model.ad.AdInfoDO;
import com.jxdinfo.mp.ad.model.ad.AdInfoDTO;
import com.jxdinfo.mp.ad.model.ad.AdVO;
import com.jxdinfo.mp.ad.service.AdPositionService;
import com.jxdinfo.mp.ad.service.AdService;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e7f\u544a\u76f8\u5173\u64cd\u4f5c"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/ad"})
public class AdController {
    @Resource
    private AdService adService;
    @Resource
    private AdPositionService adPositionService;
    @Autowired
    Environment environment;

    @ApiOperation(value="\u65b0\u589e\u5e7f\u544a,\u5df2\u6d4b")
    @PostMapping(value={"saveAd"})
    @Permission(manage={AdminEnum.AD_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> add(@RequestBody @ApiParam(value="\u5e7f\u544a\u4f20\u8f93\u5bf9\u8c61") AdInfoDTO adInfoDTO) {
        String adLinkUrl;
        String servicePath = this.environment.getProperty("mp.multi-tenant.OUT_NET_URL");
        String string = adLinkUrl = adInfoDTO.getLinkURL() == null ? "" : adInfoDTO.getLinkURL();
        if (HussarUtils.isNotEmpty((Object)adInfoDTO.getLinkType()) && adInfoDTO.getLinkType().intValue() == AdVO.LinkType.ADWEBLINK.ordinal()) {
            if (adInfoDTO.getLinkOut() == 1) {
                adInfoDTO.setLinkURL(adLinkUrl);
            } else {
                adInfoDTO.setLinkURL(servicePath + "/article.html?objId=" + adLinkUrl + "&companyId=" + String.valueOf(BaseSecurityUtil.getUser().getTenantId()));
            }
        }
        if (adInfoDTO.getObjId() == null) {
            adInfoDTO.setObjId(Long.valueOf(IdWorker.getId((Object)adInfoDTO)));
        }
        AdInfoDO adInfoDO = new AdInfoDO();
        BeanUtils.copyProperties((Object)adInfoDTO, (Object)adInfoDO);
        adInfoDO.setDataStatus("1");
        adInfoDO.setLastTime(LocalDateTime.now());
        adInfoDO.setLastEditor(BaseSecurityUtil.getUser().getUserId());
        return Result.succeed((Object)this.adService.save((Object)adInfoDO));
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5e7f\u544a,\u5df2\u6d4b")
    @GetMapping(value={"/deleteAd/{id}"})
    @Permission(manage={AdminEnum.AD_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> delete(@PathVariable @ApiParam(value="\u5e7f\u544aid") String id) {
        List<String> ids = Arrays.asList(id.split(","));
        return Result.succeed((Object)this.adService.removeByIds(ids));
    }

    @ApiOperation(value="\u4fee\u6539\u5e7f\u544a,\u5df2\u6d4b")
    @PostMapping(value={"/updateAd"})
    @Permission(manage={AdminEnum.AD_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> update(@RequestBody @ApiParam(value="\u5e7f\u544a\u4f20\u8f93\u5bf9\u8c61") AdInfoDTO adInfoDTO) {
        String servicePath = this.environment.getProperty("mp.multi-tenant.OUT_NET_URL");
        if (HussarUtils.isNotEmpty((Object)adInfoDTO.getLinkType()) && adInfoDTO.getLinkType().intValue() == AdVO.LinkType.ADWEBLINK.ordinal() && adInfoDTO.getLinkOut() == 0) {
            String adLinkUrl = adInfoDTO.getLinkURL();
            adInfoDTO.setLinkURL(servicePath + "/article.html?objId=" + adLinkUrl + "&companyId=" + String.valueOf(BaseSecurityUtil.getUser().getTenantId()));
        }
        AdInfoDO adInfoDO = new AdInfoDO();
        BeanUtils.copyProperties((Object)adInfoDTO, (Object)adInfoDO);
        adInfoDO.setObjId(adInfoDTO.getObjId());
        adInfoDO.setLastTime(LocalDateTime.now());
        adInfoDO.setLastEditor(BaseSecurityUtil.getUser().getUserId());
        return Result.succeed((Object)this.adService.updateById((Object)adInfoDO));
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544aid\u83b7\u53d6\u5e7f\u544a\u8be6\u60c5,\u5df2\u6d4b")
    @GetMapping(value={"/getDetail/{id}"})
    public Result<AdVO> detail(@PathVariable @ApiParam(value="\u5e7f\u544aid") String id) {
        String servicePath = this.environment.getProperty("mp.multi-tenant.OUT_NET_URL");
        return Result.succeed((Object)this.adService.getAdInfoByadId(id, servicePath));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u5217\u8868,\u5df2\u6d4b")
    @GetMapping(value={"list"})
    public Result<PageDTO<AdVO>> list(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="20") int pageSize, @RequestParam(value="title", required=false) @ApiParam(value="\u6807\u9898") String title, @RequestParam(value="linkType", required=false) @ApiParam(value="\u94fe\u63a5\u7c7b\u578b") String linkType, @RequestParam(value="positionId", required=false) @ApiParam(value="\u5e7f\u544a\u4f4did") String positionId) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setCurrent((long)pageNum);
        pageDTO.setSize((long)pageSize);
        return Result.succeed((Object)this.adService.getAdInfoPage(pageDTO, title, linkType, positionId));
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544a\u4f4did\u83b7\u53d6\u5e7f\u544a,\u5df2\u6d4b")
    @GetMapping(value={"/position/{positionId}"})
    public Result<List<AdVO>> getAdInfoByPosition(@PathVariable @ApiParam(value="\u5e7f\u544a\u4f4did") String positionId) {
        return Result.succeed((Object)this.adService.getAdInfoByPositionId(positionId));
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544aid\u83b7\u53d6\u56fe\u6587\u5e7f\u544a", notes="\u53ea\u6709\u56fe\u6587\u5e7f\u544a\u624d\u6709\u6587\u4ef6")
    @GetMapping(value={"/webAd"})
    public List<AdVO> getAdInfo() {
        return this.adService.getAdInfo();
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544aID\u83b7\u53d6\u56fe\u6587\u5e7f\u544a\u6587\u4ef6", notes="\u53ea\u6709\u56fe\u6587\u5e7f\u544a\u624d\u6709\u6587\u4ef6")
    @GetMapping(value={"/webAD/{adID}"})
    public String getAdFilePathById(@PathVariable String adID) {
        return this.adService.getAdFilePathById(adID);
    }

    @ApiOperation(value="\u79fb\u52a8\u5e7f\u544a\uff0c\u62d6\u62fd\u6392\u5e8f,\u5df2\u6d4b", notes="up\u8868\u793a\u4e0a\u79fb,\u5176\u4ed6\u8868\u793a\u4e0b\u79fb")
    @GetMapping(value={"{adID}/move"})
    public Result<Boolean> moveAd(@PathVariable @ApiParam(value="\u5e7f\u544aID,\u6b63\u5728\u62d6\u62fd\u7684\u5e7f\u544a") String adID, @RequestParam @ApiParam(value="up\u8868\u793a\u4e0a\u79fb,\u5176\u4ed6\u8868\u793a\u4e0b\u79fb") String flag, @RequestParam(required=false) @ApiParam(value="\u5e7f\u544aID,\u8981\u62d6\u62fd\u5230\u7684\u4f4d\u7f6e") String adID2) {
        adID2 = StrUtil.isEmpty((CharSequence)adID2) ? "" : adID2;
        return this.adService.moveAD(adID, flag, adID2);
    }
}

