/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.ad.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.mp.ad.model.position.AdPositionInfoDO;
import com.jxdinfo.mp.ad.model.position.AdPositionInfoDTO;
import com.jxdinfo.mp.ad.service.AdPositionService;
import com.jxdinfo.mp.ad.service.AdService;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5e7f\u544a\u4f4d\u76f8\u5173\u64cd\u4f5c"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/adPosition"})
public class AdPositionController {
    @Resource
    private AdPositionService adPositionService;
    @Resource
    private AdService adService;
    @Autowired
    Environment environment;

    @ApiOperation(value="\u65b0\u589e\u5e7f\u544a\u4f4d,\u5df2\u6d4b")
    @PostMapping(value={"addAdPosition"})
    public Object add(@RequestBody @ApiParam(value="\u5e7f\u544a\u4f4d\u4f20\u8f93\u5bf9\u8c61") AdPositionInfoDTO adPositionInfoDTO) {
        AdPositionInfoDO adPositionInfoDO = new AdPositionInfoDO();
        BeanUtils.copyProperties((Object)adPositionInfoDTO, (Object)adPositionInfoDO);
        if (adPositionInfoDO.getShowCount() == null) {
            adPositionInfoDO.setShowCount(Integer.valueOf(0));
        }
        adPositionInfoDO.setCreator(BaseSecurityUtil.getUser().getUserId());
        adPositionInfoDO.setCreateTime(LocalDateTime.now());
        this.adPositionService.save((Object)adPositionInfoDO);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5e7f\u544a\u4f4d")
    @GetMapping(value={"/deleteAdPosition/{id}"})
    public Object delete(@PathVariable @ApiParam(value="\u5e7f\u544a\u4f4did") String id, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser loginUser) {
        List<String> ids = Arrays.asList(id.split(","));
        if (ids.contains(this.environment.getProperty("mp.multi-tenant.QXADPOSITION"))) {
            return Result.succeed((Object)false, (String)"\u4f01\u4fe1\u9875\u9762\u5e7f\u544a\u4f4d\u4e0d\u80fd\u5220\u9664");
        }
        if (ids.contains(this.environment.getProperty("mp.multi-tenant.PUBPLATADPOSITION"))) {
            return Result.succeed((Object)false, (String)"\u5fae\u5e94\u7528\u9875\u9762\u5e7f\u544a\u4f4d\u4e0d\u80fd\u5220\u9664");
        }
        if (ids.contains(this.environment.getProperty("mp.multi-tenant.PICTEXTADPOSITION"))) {
            return Result.succeed((Object)false, (String)"\u56fe\u6587\u5e95\u90e8\u5e7f\u544a\u4f4d\u4e0d\u80fd\u5220\u9664");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"POSITION_ID", ids);
        if (HussarUtils.isNotEmpty((Object)this.adService.list((Wrapper)queryWrapper))) {
            return Result.succeed((Object)false, (String)"\u5f53\u524d\u5e7f\u544a\u4f4d\u5305\u542b\u5e7f\u544a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return Result.succeed((Object)this.adPositionService.removeByIds(ids));
    }

    @ApiOperation(value="\u4fee\u6539\u5e7f\u544a\u4f4d,\u5df2\u6d4b")
    @PostMapping(value={"/update"})
    public Object update(@RequestBody @ApiParam(value="\u5e7f\u544a\u4f4d\u4f20\u8f93\u5bf9\u8c61") AdPositionInfoDTO adPositionInfoDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq(!"".equals(adPositionInfoDTO.getPositionName()), (Object)"POSITION_NAME", (Object)adPositionInfoDTO.getPositionName())).ne((Object)"POSITION_ID", (Object)adPositionInfoDTO.getObjId());
        long count = this.adPositionService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            return Result.failed((String)"\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u5e7f\u544a\u4f4d\uff01");
        }
        if (adPositionInfoDTO.getShowCount() == null) {
            adPositionInfoDTO.setShowCount(Integer.valueOf(0));
        }
        AdPositionInfoDO adPositionInfoDO = new AdPositionInfoDO();
        BeanUtils.copyProperties((Object)adPositionInfoDTO, (Object)adPositionInfoDO);
        adPositionInfoDO.setObjId(adPositionInfoDO.getObjId());
        adPositionInfoDO.setLastEditor(BaseSecurityUtil.getUser().getUserId());
        adPositionInfoDO.setLastTime(LocalDateTime.now());
        this.adPositionService.updateById((Object)adPositionInfoDO);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544a\u4f4did\u83b7\u53d6\u5e7f\u544a\u4f4d\u8be6\u60c5,\u5df2\u6d4b")
    @GetMapping(value={"/detail/{id}"})
    public Object detail(@PathVariable @ApiParam(value="\u5e7f\u544a\u4f4did") String id) {
        return Result.succeed((Object)this.adPositionService.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u4f4d\u5217\u8868,\u5df2\u6d4b")
    @GetMapping
    public Object detail(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="20") int pageSize, @RequestParam(value="searchKey") String searchKey) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setCurrent((long)pageNum);
        pageDTO.setSize((long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"POSITION_NAME", (Object)searchKey);
        queryWrapper.orderByDesc((Object)"CREATE_TIME");
        return Result.succeed((Object)this.adPositionService.page((IPage)pageDTO, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544a\u4f4did\u83b7\u53d6\u5e7f\u544a\u4f4d\u540d,\u5df2\u6d4b")
    @GetMapping(value={"/name/{positionId}"})
    public Object getPositionNamByPosition(@PathVariable @ApiParam(value="\u5e7f\u544a\u4f4did") String positionId) {
        return Result.succeed((Object)this.adPositionService.getAdPositionName(positionId), (String)"\u83b7\u53d6\u5e7f\u544a\u4f4d\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u4f4d\u4fe1\u606f,\u5df2\u6d4b")
    @GetMapping(value={"/name"})
    public Object getPositionNam() {
        return Result.succeed((Object)this.adPositionService.getAdPositionAddress());
    }
}

