/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.model;

import com.jxdinfo.mp.common.enums.BaseErrorCode;
import com.jxdinfo.mp.common.model.CodeEnum;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import java.io.Serializable;
import org.springframework.beans.BeanUtils;

public class Result<T>
implements Serializable {
    private T data;
    private Boolean success;
    private String msg;
    private Integer code;

    public static <T> Result<T> succeed(String msg) {
        return Result.succeedWith(null, CodeEnum.SUCCESS_RESPONSE.getCode(), msg);
    }

    public static <T> Result<T> succeed(T model, String msg) {
        return Result.succeedWith(model, CodeEnum.SUCCESS_RESPONSE.getCode(), msg);
    }

    public static <T> Result<T> succeed(T model) {
        if (model instanceof PageDTO) {
            PageVO pageVO = new PageVO();
            BeanUtils.copyProperties(model, pageVO);
            return Result.succeed(pageVO);
        }
        return Result.succeedWith(model, CodeEnum.SUCCESS_RESPONSE.getCode(), "");
    }

    public static <T> Result<T> succeedWith(T data, Integer code, String msg) {
        return new Result<T>(data, true, msg, code);
    }

    public static <T> Result<T> failed(String msg) {
        return Result.failedWith(null, CodeEnum.FAILURE_RESPONSE.getCode(), msg);
    }

    public static <T> Result<T> failed(T model, String msg) {
        return Result.failedWith(model, CodeEnum.FAILURE_RESPONSE.getCode(), msg);
    }

    public static <T> Result<T> failedWith(T data, Integer code, String msg) {
        return new Result<T>(data, false, msg, code);
    }

    public static <T> Result<T> failed(BaseErrorCode errorCode) {
        return Result.failedWith(null, errorCode.getCode(), errorCode.getMessage());
    }

    public static <T> Result<T> failed(T data, BaseErrorCode errorCode) {
        return Result.failedWith(data, errorCode.getCode(), errorCode.getMessage());
    }

    public static <T> Result<T> failed(BaseErrorCode errorCode, String customMessage) {
        return Result.failedWith(null, errorCode.getCode(), customMessage);
    }

    public static <T> Result<T> failed(T data, BaseErrorCode errorCode, String customMessage) {
        return Result.failedWith(data, errorCode.getCode(), customMessage);
    }

    public T getData() {
        return this.data;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getMsg() {
        return this.msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "Result(data=" + this.getData() + ", success=" + this.getSuccess() + ", msg=" + this.getMsg() + ", code=" + this.getCode() + ")";
    }

    public Result() {
    }

    public Result(T data, Boolean success, String msg, Integer code) {
        this.data = data;
        this.success = success;
        this.msg = msg;
        this.code = code;
    }
}

