/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.utils;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern CHECK_EMOJI = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
    private static HashMap<Long, String> uuids = new HashMap();

    public static String replaceSpecialChar(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\\", "\\\\");
        str = str.replace("%", "\\%");
        str = str.replace("_", "\\_");
        return str;
    }

    public static String replaceSecretPhone(String mobilePhone) {
        if (StrUtil.isNotEmpty((CharSequence)mobilePhone) && Validator.isMobile((CharSequence)mobilePhone)) {
            return mobilePhone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        return mobilePhone;
    }

    public static String replaceSecretEmail(String email) {
        if (StrUtil.isNotEmpty((CharSequence)email) && Validator.isEmail((CharSequence)email)) {
            return email.replaceAll(".(?=.*@)", "*");
        }
        return email;
    }

    public static Boolean getCheckEmoji(String string) {
        Matcher emojiTitle = CHECK_EMOJI.matcher(string);
        return emojiTitle.find();
    }

    public static long getUniqueId(String oriValue) {
        if (oriValue == null || oriValue.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(oriValue);
        }
        catch (Exception e) {
            String s = SecureUtil.md5((String)oriValue);
            long hashCode = HashUtil.mixHash((String)s);
            Long uniqueId = Math.abs(hashCode);
            return uniqueId;
        }
    }
}

