/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.aspect;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RoleAspect {
    @Resource
    public Environment environment;
    @Resource
    public RedisTemplate redisTemplate;

    @Around(value="execution(public * *(..))&&@annotation(permission))", argNames="pjp,permission")
    public Object isManager(ProceedingJoinPoint pjp, Permission permission) {
        AdminEnum[] adminEnums;
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        if (sra == null) {
            return Result.failed("");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List roleIDS = user.getRolesList();
        if (CollUtil.contains((Collection)roleIDS, (Object)SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            return pjp.proceed();
        }
        List<String> roleIDStrings = roleIDS.stream().map(String::valueOf).collect(Collectors.toList());
        boolean judge = false;
        block9: for (AdminEnum adminEnum : adminEnums = permission.manage()) {
            switch (adminEnum) {
                case JQX_ADMIN_ROLE: {
                    judge = judge || this.hasJqxAdminRole(roleIDStrings);
                    continue block9;
                }
                case PUB_MANAGER_ROLE: {
                    judge = judge || this.hasPubAdminRole(roleIDStrings);
                    continue block9;
                }
                case IM_MANAGER_ROLE: {
                    judge = judge || this.hasIMAdminRole(roleIDStrings);
                    continue block9;
                }
                case AD_MANAGER_ROLE: {
                    judge = judge || this.hasAdManagerRole(roleIDStrings);
                    continue block9;
                }
                case ZONE_MANAGER_ROLE: {
                    judge = judge || this.hasZoneManagerRole(roleIDStrings);
                    continue block9;
                }
            }
        }
        if (judge) {
            return pjp.proceed();
        }
        return Result.failed("\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
    }

    private boolean hasJqxAdminRole(List<String> roleIDStrings) {
        String jqxAdminRoles = this.environment.getProperty("mp.role.jqx_admin_role");
        if (jqxAdminRoles == null) {
            return false;
        }
        ArrayList jqxAdminRoleList = CollUtil.toList((Object[])jqxAdminRoles.split(","));
        return CollUtil.containsAny(roleIDStrings, (Collection)jqxAdminRoleList);
    }

    private boolean hasPubAdminRole(List<String> roleIDStrings) {
        String pubManagerRole = this.environment.getProperty("mp.role.pub_manager_role");
        if (pubManagerRole == null) {
            return false;
        }
        ArrayList jqxAdminRoleList = CollUtil.toList((Object[])pubManagerRole.split(","));
        return CollUtil.containsAny(roleIDStrings, (Collection)jqxAdminRoleList);
    }

    private boolean hasIMAdminRole(List<String> roleIDStrings) {
        String imManagerRole = this.environment.getProperty("mp.role.im_manager_role");
        if (imManagerRole == null) {
            return false;
        }
        ArrayList jqxAdminRoleList = CollUtil.toList((Object[])imManagerRole.split(","));
        return CollUtil.containsAny(roleIDStrings, (Collection)jqxAdminRoleList);
    }

    private boolean hasAdManagerRole(List<String> roleIDStrings) {
        String adManagerRoles = this.environment.getProperty("mp.role.ad_manager_role");
        if (adManagerRoles == null) {
            return false;
        }
        ArrayList adManagerRoleList = CollUtil.toList((Object[])adManagerRoles.split(","));
        return CollUtil.containsAny(roleIDStrings, (Collection)adManagerRoleList);
    }

    private boolean hasZoneManagerRole(List<String> roleIDStrings) {
        String roleManagerRoles = this.environment.getProperty("mp.role.zone_manager_role");
        if (roleManagerRoles == null) {
            return false;
        }
        ArrayList roleManagerRoleList = CollUtil.toList((Object[])roleManagerRoles.split(","));
        return CollUtil.containsAny(roleIDStrings, (Collection)roleManagerRoleList);
    }
}

