/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.style.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.entity.dto.DocClassTree;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.style.api.service.IConfigDocClassService;
import com.jxdinfo.idp.style.api.service.IConfigDocVersionService;
import com.jxdinfo.idp.style.entity.dto.ConfigDocVersionDTO;
import com.jxdinfo.idp.style.entity.dto.DocClassDto;
import com.jxdinfo.idp.style.entity.dto.DocClassQuery;
import com.jxdinfo.idp.style.entity.dto.StyleLibExportDto;
import com.jxdinfo.idp.style.entity.po.ConfigDocClass;
import com.jxdinfo.idp.style.entity.po.ConfigDocVersion;
import com.jxdinfo.idp.style.entity.vo.DocClassVO;
import com.jxdinfo.idp.style.review.word.docx.content.styleHandler.StyleValueHandler;
import com.jxdinfo.idp.style.review.word.docx.number.NumWrapper;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/document/class"})
public class ConfigDocClassController {
    @Resource
    private IConfigDocVersionService docVersionService;
    @Resource
    private IConfigDocClassService docClassService;

    @PostMapping(value={"/getAllList"})
    public ApiResponse<List<DocClassDto>> getAllList(@RequestBody DocClassQuery query) {
        return ApiResponse.data((Object)this.docClassService.selectAllList(query));
    }

    @PostMapping(value={"/migration"})
    public ApiResponse<Void> migrationDocument(@RequestBody ConfigDocClass docClass) {
        this.docClassService.migrationDocument(docClass);
        return ApiResponse.success();
    }

    @PostMapping(value={"/versions"})
    public ApiResponse<List<ConfigDocVersion>> versions(@RequestBody ConfigDocVersionDTO param) {
        return ApiResponse.success((Object)this.docVersionService.getVersions(param));
    }

    @PostMapping(value={"/exportStyleLib"})
    public void exportStyleLib(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.docClassService.exportStyleLib(ids, response);
    }

    @PostMapping(value={"/importStyleLib"})
    public ApiResponse<Void> importStyleLib(@RequestPart(value="hussarFile") MultipartFile hussarFile, @RequestParam(value="isUserData") String isUserData) {
        block4: {
            byte[] a = hussarFile.getBytes();
            StyleLibExportDto a2 = (StyleLibExportDto)SerializeUtils.deserialize((byte[])a);
            if (a2 == null) break block4;
            this.docClassService.importStyleLib(a2, isUserData);
        }
        try {
            return ApiResponse.fail((String)StyleValueHandler.case("\u5bdf\u5147\u5912\u8d07\u000f\u5bde\u5146\u65a5\u6840\u89c1\u67b3\u6552\u634d\u4e18\u7a59"));
        }
        catch (ClassCastException a) {
            return ApiResponse.fail((int)10001, (String)NumWrapper.catch("\u6866\u5f20\u8995\u5236\u5ec2\u5bd3\u5134\u5f2d\u5e69\uff23\u8ba6\u4e25\u4f71\u6818\u5f5e\u89eb\u5248\u5ebc\u76d5\u5bd3\u51ab\u65a8\u4ea7"));
        }
        catch (Exception a) {
            throw new BusinessException(new StringBuilder().insert(0, StyleValueHandler.case("\u6815\u5f2c\u89e6\u523a\u5eb1\u5bdf\u5147\u5f21\u5e1a\u000f\u5bde\u5146\u65a5\u6840\u89c1\u67b3\u5913\u8d06")).append(a.getMessage()).toString());
        }
        return ApiResponse.success((String)NumWrapper.catch("\u5bd3\u5134\u623f\u52ce"));
    }

    @PostMapping(value={"/copyDocument"})
    public ApiResponse copyDocument(@RequestBody Map<String, String> classMap) {
        return ApiResponse.success((Object)this.docClassService.copyDocument(classMap));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam(value="id") String string) {
        void id;
        this.docClassService.docDel((String)id);
        return ApiResponse.success((String)NumWrapper.catch("\u520f\u9635\u623f\u52ce"));
    }

    @PostMapping(value={"/pageList"})
    public ApiResponse<Page<DocClassVO>> pageList(@RequestBody DocClassQuery query) {
        return ApiResponse.success((Object)this.docClassService.pageList(query));
    }

    @PostMapping(value={"/save"})
    public ApiResponse<ConfigDocVersion> save(@RequestBody ConfigDocClass docClass) {
        return ApiResponse.success((Object)this.docClassService.docSave(docClass));
    }

    @GetMapping(value={"/tree"})
    public ApiResponse<List<DocClassTree>> getTree() {
        return ApiResponse.success((Object)this.docClassService.getTree());
    }

    @PostMapping(value={"/getList"})
    public ApiResponse<Page<DocClassDto>> getList(@RequestBody DocClassQuery query) {
        return ApiResponse.data((Object)this.docClassService.selectList(query));
    }

    @PostMapping(value={"/getAllTotalTree"})
    public ApiResponse<List<DocClassTree>> getAllTotalTree(@RequestBody ConfigDocClass docClass) {
        return ApiResponse.success((Object)this.docClassService.getAllTotalTree(docClass));
    }
}

