/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.style.review.word.docx;

import com.jxdinfo.idp.style.controller.ConfigDocElementController;
import com.jxdinfo.idp.style.review.word.docx.content.handler.ContentHandler;
import com.jxdinfo.idp.style.review.word.docx.content.handler.ContentHandlerFactory;
import com.jxdinfo.idp.style.review.word.docx.content.styleHandler.FontStyleHandler;
import com.jxdinfo.idp.style.review.word.docx.content.styleHandler.IndStyleHandler;
import com.jxdinfo.idp.style.review.word.docx.content.styleHandler.SpacingStyleHandler;
import com.jxdinfo.idp.style.review.word.docx.content.styleHandler.StyleValueHandler;
import com.jxdinfo.idp.style.review.word.docx.number.NumFactory;
import com.jxdinfo.idp.style.review.word.docx.number.NumPr;
import java.util.HashMap;
import java.util.Map;
import org.docx4j.dml.BaseStyles;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.STTheme;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxConfiguration {
    private final StyleDefinitionsPart stylesCollection;
    private final SpacingStyleHandler spacingStyleHandler;
    private final ContentHandlerFactory contentHandlerFactory;
    private final FontStyleHandler fontStyleHandler;
    private final IndStyleHandler indStyleHandler;
    private String nextStyleId;
    private final MainDocumentPart document;
    private final Map<String, Object> contentOfWord;
    private final NumFactory factory;
    private final Properties properties;
    private final StyleValueHandler valueHandler;
    private static final Logger log = LoggerFactory.getLogger(DocxConfiguration.class);

    public SpacingStyleHandler getSpacingStyleHandler() {
        DocxConfiguration a;
        return a.spacingStyleHandler;
    }

    public NumPr getNumpr(PPrBase.NumPr a) {
        DocxConfiguration a2;
        return new NumPr(a2, a);
    }

    public MainDocumentPart getDocument() {
        DocxConfiguration a;
        return a.document;
    }

    public Numbering numbering() {
        DocxConfiguration a;
        NumberingDefinitionsPart numberingDefinitionsPart = a.document.getNumberingDefinitionsPart();
        if (numberingDefinitionsPart == null) {
            return new Numbering();
        }
        try {
            return (Numbering)numberingDefinitionsPart.getContents();
        }
        catch (Docx4JException docx4JException) {
            throw new RuntimeException(docx4JException);
        }
    }

    public void addContent(String a, Object a2) {
        DocxConfiguration a3;
        a3.contentOfWord.put(a, a2);
    }

    public StyleValueHandler getValueHandler() {
        DocxConfiguration a;
        return a.valueHandler;
    }

    public void removeNextId() {
        a.nextStyleId = null;
    }

    public void setNextStyleId(String a) {
        a.nextStyleId = a;
    }

    public DocDefaults getDefaultStyle() {
        DocDefaults docDefaults = null;
        try {
            DocxConfiguration a;
            Styles styles = (Styles)a.stylesCollection.getContents();
            docDefaults = styles.getDocDefaults();
            return docDefaults;
        }
        catch (Docx4JException docx4JException) {
            log.error(NumFactory.continue("\u83b1\u53f7\u9ede\u8b85\u6831\u5f2e\u5937\u8d04"), (Throwable)docx4JException);
            return docDefaults;
        }
    }

    public Object getContent(String a) {
        DocxConfiguration a2;
        return a2.contentOfWord.get(a);
    }

    public ContentHandler getHandler(Object a) {
        DocxConfiguration a2;
        return a2.contentHandlerFactory.getHandler(a);
    }

    public String getFont(STTheme a4, CTLanguage a2) {
        try {
            DocxConfiguration a3;
            return a3.document.getThemePart().getFont(a4, a2);
        }
        catch (Docx4JException a4) {
            log.error(ConfigDocElementController.true("\u5b4f\u4f17\u4e23\u98dc\u8f74\u5b13\u4f4b\u5975\u8d3d~"), (Throwable)a4);
            return null;
        }
    }

    public Style getStyle(String a) {
        DocxConfiguration a2;
        return a2.stylesCollection.getStyleById(a);
    }

    public NumFactory getNumFactory() {
        DocxConfiguration a;
        return a.factory;
    }

    public DocxConfiguration(MainDocumentPart a, Properties a2) {
        DocxConfiguration a3;
        DocxConfiguration docxConfiguration = a3;
        DocxConfiguration docxConfiguration2 = a3;
        DocxConfiguration docxConfiguration3 = a3;
        docxConfiguration3.document = a;
        docxConfiguration3.stylesCollection = a.getStyleDefinitionsPart();
        DocxConfiguration docxConfiguration4 = a3;
        docxConfiguration2.contentHandlerFactory = new ContentHandlerFactory(a3);
        docxConfiguration4.factory = new NumFactory(a3);
        docxConfiguration2.fontStyleHandler = new FontStyleHandler(a3);
        docxConfiguration2.spacingStyleHandler = new SpacingStyleHandler(a3);
        docxConfiguration2.indStyleHandler = new IndStyleHandler(a3);
        docxConfiguration.valueHandler = new StyleValueHandler(a3);
        docxConfiguration.contentOfWord = new HashMap<String, Object>();
        docxConfiguration.properties = a2;
    }

    public Properties getProperties() {
        DocxConfiguration a;
        return a.properties;
    }

    public BaseStyles.FontScheme getFontTheme() {
        DocxConfiguration a;
        return a.document.getThemePart().getFontScheme();
    }

    public FontStyleHandler getFontStyleHandler() {
        DocxConfiguration a;
        return a.fontStyleHandler;
    }

    public IndStyleHandler getIndStyleHandler() {
        DocxConfiguration a;
        return a.indStyleHandler;
    }

    public String getNextStyleId() {
        DocxConfiguration a;
        return a.nextStyleId;
    }
}

