/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.counter.service.ICounterService;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.scene.api.dto.SceneRuleLibRelevancyDto;
import com.jxdinfo.idp.scene.api.po.SceneRuleLibRelevancyPo;
import com.jxdinfo.idp.scene.server.mapper.SceneRuleLibRelevancyMapper;
import com.jxdinfo.idp.scene.server.service.SceneRuleLibRelevancyService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SceneRuleLibRelevancyServiceImpl
extends ServiceImpl<SceneRuleLibRelevancyMapper, SceneRuleLibRelevancyPo>
implements SceneRuleLibRelevancyService {
    private static final Logger log = LoggerFactory.getLogger(SceneRuleLibRelevancyServiceImpl.class);
    @Autowired
    private SceneRuleLibRelevancyMapper sceneRuleLibRelevancyMapper;
    @Autowired
    private ICounterService iCounterService;

    @Override
    public List<SceneRuleLibRelevancyPo> findAllBySceneId(Long sceneId) {
        return this.sceneRuleLibRelevancyMapper.findAllBySceneId(sceneId);
    }

    @Override
    public List<SceneRuleLibRelevancyPo> findAllByParam(SceneRuleLibRelevancyPo po) {
        return this.sceneRuleLibRelevancyMapper.findAllByParam(po);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(Long sceneId, List<Long> ruleLibIdList) {
        ArrayList<SceneRuleLibRelevancyPo> entityList = new ArrayList<SceneRuleLibRelevancyPo>();
        for (Long ruleLibId : ruleLibIdList) {
            SceneRuleLibRelevancyPo obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            entityList.add(obj);
        }
        this.saveBatch(entityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdate(Long sceneId, List<Long> ruleLibIdList) {
        if (ruleLibIdList == null || ruleLibIdList.isEmpty()) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneId(sceneId);
            return;
        }
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = ((SceneRuleLibRelevancyMapper)this.baseMapper).findAllBySceneId(sceneId);
        List ruleLibIdListExist = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        List<Long> ruleLibIdListDelete = ruleLibIdListExist.stream().filter(ruleLibId2 -> !ruleLibIdList.contains(ruleLibId2)).collect(Collectors.toList());
        ArrayList<SceneRuleLibRelevancyPo> ruleLibRelevancyPos = new ArrayList<SceneRuleLibRelevancyPo>();
        for (Long ruleLibId : ruleLibIdList) {
            if (ruleLibIdListExist.contains(ruleLibId)) continue;
            SceneRuleLibRelevancyPo obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            ruleLibRelevancyPos.add(obj);
            this.iCounterService.add(ruleLibId, sceneId, "2", "1");
        }
        this.saveBatch(ruleLibRelevancyPos);
        if (!ObjectUtils.isEmpty(ruleLibIdListDelete)) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneIdAndRuleLibId(sceneId, ruleLibIdListDelete);
            for (Long ruleLibId : ruleLibIdListDelete) {
                this.iCounterService.subtract(ruleLibId, sceneId, "2", "1");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateNew(SceneRuleLibRelevancyDto dto) {
        SceneRuleLibRelevancyPo obj;
        List styleRuleLibIdList;
        Long sceneId = dto.getSceneId();
        List ruleLibIdList = dto.getRuleLibIdList();
        if (ruleLibIdList == null || ruleLibIdList.isEmpty()) {
            SceneRuleLibRelevancyPo param = new SceneRuleLibRelevancyPo();
            param.setSceneId(sceneId.longValue());
            param.setSourceCode("1");
            this.sceneRuleLibRelevancyMapper.deleteByParam(param);
        }
        if ((styleRuleLibIdList = dto.getStyleRuleLibIdList()) == null || styleRuleLibIdList.isEmpty()) {
            SceneRuleLibRelevancyPo param = new SceneRuleLibRelevancyPo();
            param.setSceneId(sceneId.longValue());
            param.setSourceCode("2");
            this.sceneRuleLibRelevancyMapper.deleteByParam(param);
        }
        if ((ruleLibIdList == null || ruleLibIdList.isEmpty()) && (styleRuleLibIdList == null || styleRuleLibIdList.isEmpty())) {
            return;
        }
        ArrayList ruleLibIds = new ArrayList();
        ruleLibIds.addAll(ruleLibIdList);
        ruleLibIds.addAll(styleRuleLibIdList);
        List<SceneRuleLibRelevancyPo> sceneRuleLibRelevancyPoList = ((SceneRuleLibRelevancyMapper)this.baseMapper).findAllBySceneId(sceneId);
        List ruleLibIdListExist = sceneRuleLibRelevancyPoList.stream().map(SceneRuleLibRelevancyPo::getRuleLibId).collect(Collectors.toList());
        List<Long> ruleLibIdListDelete = ruleLibIdListExist.stream().filter(ruleLibId2 -> !ruleLibIds.contains(ruleLibId2)).collect(Collectors.toList());
        ArrayList<SceneRuleLibRelevancyPo> ruleLibRelevancyPos = new ArrayList<SceneRuleLibRelevancyPo>();
        for (Long ruleLibId : ruleLibIdList) {
            if (ruleLibIdListExist.contains(ruleLibId)) continue;
            obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            obj.setSourceCode("1");
            ruleLibRelevancyPos.add(obj);
            this.iCounterService.add(ruleLibId, sceneId, "2", "1");
        }
        for (Long ruleLibId : styleRuleLibIdList) {
            if (ruleLibIdListExist.contains(ruleLibId)) continue;
            obj = new SceneRuleLibRelevancyPo();
            obj.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
            obj.setRuleLibId(ruleLibId.longValue());
            obj.setSceneId(sceneId.longValue());
            obj.setSourceCode("2");
            ruleLibRelevancyPos.add(obj);
            this.iCounterService.add(ruleLibId, sceneId, "2", "1");
        }
        this.saveBatch(ruleLibRelevancyPos);
        if (!ObjectUtils.isEmpty(ruleLibIdListDelete)) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneIdAndRuleLibId(sceneId, ruleLibIdListDelete);
            for (Long ruleLibId : ruleLibIdListDelete) {
                this.iCounterService.subtract(ruleLibId, sceneId, "2", "1");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long sceneId) {
        this.sceneRuleLibRelevancyMapper.deleteBySceneId(sceneId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySceneIdAndRuleLibId(long sceneId, List<Long> ruleLibIdList) {
        if (!ObjectUtils.isEmpty(ruleLibIdList)) {
            this.sceneRuleLibRelevancyMapper.deleteBySceneIdAndRuleLibId(sceneId, ruleLibIdList);
        }
    }

    @Override
    public void saveOrUpdateBatchSence(List<SceneRuleLibRelevancyPo> ruleLibList) {
        if (CollUtil.isNotEmpty(ruleLibList)) {
            List<Long> sceneIds = ruleLibList.stream().map(SceneRuleLibRelevancyPo::getSceneId).collect(Collectors.toList());
            this.sceneRuleLibRelevancyMapper.deleteBySceneIds(sceneIds);
            this.saveBatch(ruleLibList);
            log.debug("\u6210\u529f\u66f4\u65b0\u5ba1\u67e5\u5e94\u7528-\u89c4\u5219\u5e93\u6570\u636e{}\u6761", (Object)ruleLibList.size());
        }
    }

    @Override
    public void delete(long sceneId, List<Long> templateIdList) {
        if (!ObjectUtils.isEmpty(templateIdList)) {
            this.sceneRuleLibRelevancyMapper.delete(sceneId, templateIdList);
        }
    }
}

