/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.po.DocTypePo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.scene.api.dto.QueryRuleLibDto;
import com.jxdinfo.idp.scene.api.dto.SceneConfigResultDto;
import com.jxdinfo.idp.scene.api.po.SceneTemplateGroupPo;
import com.jxdinfo.idp.scene.api.po.SceneTemplatePo;
import com.jxdinfo.idp.scene.api.vo.GroupTemplateVo;
import com.jxdinfo.idp.scene.api.vo.SceneTemplateVo;
import com.jxdinfo.idp.scene.dto.RuleItemObject;
import com.jxdinfo.idp.scene.server.entity.SceneTemplateQuery;
import com.jxdinfo.idp.scene.server.service.SceneService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateGroupService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneTemplateService;
import com.jxdinfo.idp.scene.server.service.TemplateRuleLibRelevancyService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene/template"})
public class SceneTemplateController {
    private static final Logger log = LoggerFactory.getLogger(SceneTemplateController.class);
    @Autowired
    private SceneTemplateService service;
    @Autowired
    private TemplateRuleLibRelevancyService templateRuleLibRelevancyService;
    @Autowired
    private SceneService sceneService;
    @Autowired
    private SceneTemplateRelevancyService sceneTemplateRelevancyService;
    @Autowired
    private SceneTemplateGroupService templateGroupService;

    @PostMapping(value={"/saveBatch"})
    public ApiResponse<Void> saveBatch(@RequestBody List<SceneTemplatePo> templatePoList) {
        try {
            templatePoList.forEach(po -> po.setId(SnowFlakeUtil.getFlowIdInstance().nextId()));
            this.service.saveBatch(templatePoList);
        }
        catch (Exception e) {
            log.error("save sceneTemplate error", (Throwable)e);
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/save"})
    public ApiResponse<Long> save(@RequestBody SceneTemplatePo templatePo) {
        long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        try {
            templatePo.setId(id);
            this.service.save(templatePo);
        }
        catch (Exception e) {
            log.error("save sceneTemplate error", (Throwable)e);
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)id);
    }

    @PostMapping(value={"/updateBatch"})
    public ApiResponse<Void> updateBatch(@RequestBody List<SceneTemplatePo> templatePoList) {
        try {
            this.service.updateBatchById(templatePoList);
        }
        catch (Exception e) {
            log.error("save sceneTemplate error", (Throwable)e);
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody SceneTemplatePo templatePo) {
        try {
            this.service.updateById(templatePo);
        }
        catch (Exception e) {
            log.error("save sceneTemplate error", (Throwable)e);
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/search"})
    public ApiResponse<List<GroupTemplateVo>> search(@RequestBody SceneTemplateQuery query) {
        return ApiResponse.success(this.service.search(query));
    }

    @GetMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestParam long id) {
        this.service.removeById(Long.valueOf(id));
        return ApiResponse.success();
    }

    @GetMapping(value={"/findAll"})
    public ApiResponse<List<SceneTemplateVo>> findAll() {
        return ApiResponse.success(this.service.findAll());
    }

    @GetMapping(value={"/findAllByGroup"})
    public ApiResponse<List<GroupTemplateVo>> findAllByGroup() {
        return ApiResponse.success(this.service.findAllByGroup());
    }

    @GetMapping(value={"/getRuleLib"})
    public ApiResponse<List<QueryRuleLibDto>> getRuleLib(@RequestParam List<Long> templateIdList) {
        return ApiResponse.success(this.service.getRuleLibByTemplate(templateIdList));
    }

    @GetMapping(value={"/getRuleLibGroup"})
    public ApiResponse<List<RuleLibVo>> getRuleLibGroup(@RequestParam List<Long> templateIdList) {
        return ApiResponse.success(this.service.getRuleLibByTemplateByGroup(templateIdList));
    }

    @GetMapping(value={"/ruleLib/saveOrUpdate"})
    public ApiResponse<Void> saveTemplateAndRuleLib(@RequestParam long templateId, @RequestParam List<Long> ruleLibIdList) {
        this.templateRuleLibRelevancyService.saveOrUpdate(templateId, ruleLibIdList);
        return ApiResponse.success();
    }

    @PostMapping(value={"/saveTemplateConfig"})
    public ApiResponse<Void> saveConfig(@RequestBody List<RuleItemObject> ruleItemObjectList) {
        this.service.saveTemplateInfo(ruleItemObjectList);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getTemplateConfig"})
    public ApiResponse<List<RuleItemObject>> getTemplateConfig(@RequestParam(value="templateId") String templateId, @RequestParam(value="ruleIdList") Long[] ruleIdList) {
        return ApiResponse.success(this.service.queryTemplateConfigInfoList(Long.valueOf(templateId), ruleIdList));
    }

    @PostMapping(value={"/config/save"})
    public ApiResponse<Void> sceneSaveAsTemplate(@RequestBody SceneConfigResultDto configResult) {
        this.service.sceneSaveAsTemplate(configResult);
        return ApiResponse.success();
    }

    @PostMapping(value={"/relevancy/save"})
    public ApiResponse<Void> addSceneTemplateRelevancy(@RequestParam long sceneId, @RequestParam List<Long> templateIdList) {
        this.service.templateSaveAsScene(sceneId, templateIdList);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getSceneChosenTemplate"})
    public ApiResponse<List<SceneTemplateVo>> getSceneChosenTemplate(@RequestParam long sceneId) {
        return ApiResponse.success(this.service.getChosenTemplate(sceneId));
    }

    @GetMapping(value={"/getDocTypeByTemplate"})
    public ApiResponse<List<DocTypePo>> getDocTypeByTemplate(@RequestParam List<Long> templateIdList) {
        return ApiResponse.success(this.service.getDocTypeByTemplate(templateIdList));
    }

    @PostMapping(value={"/group/save"})
    public ApiResponse<Void> saveTemplateGroup(@RequestBody SceneTemplateGroupPo templateGroupPo) {
        templateGroupPo.setId(SnowFlakeUtil.getFlowIdInstance().nextId());
        this.templateGroupService.save(templateGroupPo);
        return ApiResponse.success();
    }

    @PostMapping(value={"/group/update"})
    public ApiResponse<Void> updateTemplateGroup(@RequestBody SceneTemplateGroupPo templateGroupPo) {
        this.templateGroupService.updateById(templateGroupPo);
        return ApiResponse.success();
    }

    @GetMapping(value={"/group/delete"})
    public ApiResponse<Void> deleteTemplateGroup(@RequestParam long groupId) {
        this.templateGroupService.removeById(Long.valueOf(groupId));
        return ApiResponse.success();
    }
}

