/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.service.impl;

import com.jxdinfo.idp.scene.api.po.SceneDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneExtractItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.api.po.SceneRuleItemDocTypeRelevancyPo;
import com.jxdinfo.idp.scene.interf.SceneCoreService;
import com.jxdinfo.idp.scene.server.service.SceneDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneCoreServiceImpl
implements SceneCoreService {
    private static final Logger log = LoggerFactory.getLogger(SceneCoreServiceImpl.class);
    @Autowired
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Autowired
    private SceneDocTypeRelevancyService sceneDocTypeRelevancyService;
    @Autowired
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;

    public boolean hasRelevancy(long docTypeId) {
        List<SceneDocTypeRelevancyPo> sceneDocTypeRelevancyPoList = this.sceneDocTypeRelevancyService.findByDocTypeId(docTypeId);
        if (!sceneDocTypeRelevancyPoList.isEmpty()) {
            return true;
        }
        List<SceneRuleItemDocTypeRelevancyPo> sceneRuleItemDocTypeRelevancyPoList = this.sceneRuleItemDocTypeRelevancyService.findByDocTypeId(docTypeId);
        if (!sceneRuleItemDocTypeRelevancyPoList.isEmpty()) {
            return true;
        }
        List<SceneExtractItemDocTypeRelevancyPo> sceneExtractItemDocTypeRelevancyPos = this.sceneExtractItemDocTypeRelevancyService.findByDocTypeId(docTypeId);
        return !sceneExtractItemDocTypeRelevancyPos.isEmpty();
    }

    public void deleteRelevancyByDocTypeId(long docTypeId) {
        this.sceneDocTypeRelevancyService.deleteByDocTypeId(docTypeId);
        this.sceneRuleItemDocTypeRelevancyService.deleteByDocTypeId(docTypeId);
        this.sceneExtractItemDocTypeRelevancyService.deleteByDocTypeId(docTypeId);
    }
}

