/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.scene.server.hook.rule;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.rule.api.hook.IRuleItemHook;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.scene.api.po.ScenePo;
import com.jxdinfo.idp.scene.api.po.SceneRuleReviewItemRelevancyPo;
import com.jxdinfo.idp.scene.server.service.SceneExtractItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleExtractRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleItemDocTypeRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneRuleReviewItemRelevancyService;
import com.jxdinfo.idp.scene.server.service.SceneService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RuleItemHook
implements IRuleItemHook {
    @Resource
    private IRuleService ruleService;
    @Resource
    private SceneRuleReviewItemRelevancyService sceneRuleReviewItemRelevancyService;
    @Resource
    private SceneExtractItemDocTypeRelevancyService sceneExtractItemDocTypeRelevancyService;
    @Resource
    private SceneRuleExtractRelevancyService sceneRuleExtractRelevancyService;
    @Resource
    private SceneRuleItemDocTypeRelevancyService sceneRuleItemDocTypeRelevancyService;
    @Resource
    private SceneService sceneService;

    public String beforeDelRuleItem(Long ruleItemId, boolean isForce) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SceneRuleReviewItemRelevancyPo::getRuleItemId, (Object)ruleItemId);
        List ruleRels = this.sceneRuleReviewItemRelevancyService.list((Wrapper)queryWrapper);
        List<Long> sceneIdList = ruleRels.stream().map(SceneRuleReviewItemRelevancyPo::getSceneId).collect(Collectors.toList());
        if (!sceneIdList.isEmpty() && !isForce) {
            RuleItemVo ruleItemVo = this.ruleItemVo(ruleItemId);
            if (ruleItemVo == null) {
                return "";
            }
            return "\u5ba1\u67e5\u9879\u3010" + ruleItemVo.getRuleItemName() + "\u3011\u5df2\u88ab" + this.sceneNames(sceneIdList) + "\u4f7f\u7528\uff0c\u786e\u8ba4\u5220\u9664\u5c06\u540c\u6b65\u5220\u9664\u573a\u666f\u4e2d\u4f7f\u7528\u7684\u5ba1\u67e5\u89c4\u5219";
        }
        if (!sceneIdList.isEmpty()) {
            this.sceneExtractItemDocTypeRelevancyService.removeItem(ruleItemId);
            this.sceneRuleExtractRelevancyService.removeItem(ruleItemId);
            this.sceneRuleItemDocTypeRelevancyService.removeItem(ruleItemId);
            this.sceneRuleReviewItemRelevancyService.removeItem(ruleItemId);
        }
        return "";
    }

    public String afterUpdateRuleItem(Long ruleItemId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SceneRuleReviewItemRelevancyPo::getRuleItemId, (Object)ruleItemId);
        List ruleRels = this.sceneRuleReviewItemRelevancyService.list((Wrapper)queryWrapper);
        List<Long> sceneIdList = ruleRels.stream().map(SceneRuleReviewItemRelevancyPo::getSceneId).collect(Collectors.toList());
        if (!sceneIdList.isEmpty()) {
            RuleItemVo ruleItemVo = this.ruleItemVo(ruleItemId);
            if (ruleItemVo == null) {
                return "";
            }
            return "\u5ba1\u67e5\u9879\u3010" + ruleItemVo.getRuleItemName() + "\u3011\u5df2\u88ab" + this.sceneNames(sceneIdList) + "\u4f7f\u7528\uff0c\u7a0d\u540e\u8bf7\u786e\u8ba4\u5ba1\u67e5\u573a\u666f\u53ef\u6b63\u5e38\u8fd0\u884c";
        }
        return "";
    }

    private String sceneNames(List<Long> sceneIds) {
        LambdaQueryWrapper sceneQuery = new LambdaQueryWrapper();
        sceneQuery.in(ScenePo::getId, sceneIds);
        List scenes = this.sceneService.list((Wrapper)sceneQuery);
        StringBuilder sb = new StringBuilder();
        for (ScenePo scene : scenes) {
            sb.append("\u5ba1\u67e5\u573a\u666f\u3010").append(scene.getName()).append("\u3011\u3001");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private RuleItemVo ruleItemVo(Long ruleItemId) {
        RuleItemQueryVo queryVo = new RuleItemQueryVo();
        queryVo.setId(ruleItemId);
        Page page = this.ruleService.queryRuleItem(queryVo);
        if (page.getTotal() > 0L) {
            return (RuleItemVo)page.getRecords().get(0);
        }
        return null;
    }
}

