/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.controller;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.response.ResultCode;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.rule.api.hook.IRuleItemHook;
import com.jxdinfo.idp.rule.api.service.IRuleService;
import com.jxdinfo.idp.rule.api.vo.RuleGroupVo;
import com.jxdinfo.idp.rule.api.vo.RuleImportVo;
import com.jxdinfo.idp.rule.api.vo.RuleItemVo;
import com.jxdinfo.idp.rule.server.dto.RuleExportDto;
import com.jxdinfo.idp.rule.server.dto.RuleItemGroupQueryDto;
import com.jxdinfo.idp.rule.server.service.IRuleItemService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/rule/item"})
public class RuleItemController {
    @Resource
    private IRuleService ruleService;
    @Resource
    private IRuleItemService ruleItemService;
    private static final Logger log = LoggerFactory.getLogger(RuleItemController.class);
    @Autowired(required=false)
    private List<IRuleItemHook> ruleItemHooks;

    @PostMapping(value={"/queryReviewLogic"})
    public ApiResponse<String> queryReviewLogic(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.success((Object)this.ruleItemService.queryReviewLogic(ruleItemVo), (String)ResultCode.SUCCESS.getMessage());
    }

    @GetMapping(value={"/queryCount"})
    public ApiResponse<Long> queryRuleItemCount() {
        return ApiResponse.success((Object)this.ruleItemService.count());
    }

    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam Long ruleItemId, @RequestParam boolean isForce) {
        return ApiResponse.status((boolean)this.ruleItemService.del(ruleItemId, isForce));
    }

    @PostMapping(value={"AiImport"})
    public ApiResponse<Void> aiImport(@RequestPart(value="file") MultipartFile file, @RequestPart(value="ruleImportVo") RuleImportVo ruleImportVo) {
        return ApiResponse.status((boolean)this.ruleItemService.aiImport(file, ruleImportVo));
    }

    @PostMapping(value={"/saveRule"})
    public ApiResponse<Void> saveRule(@RequestBody RuleGroupVo ruleGroupVo) {
        RuleItemController ruleItemController = this;
        Map a = ruleItemController.ruleService.queryRuleParam(ruleGroupVo.getRuleItemId());
        ruleItemController.ruleItemService.saveRule(ruleGroupVo);
        Map a3 = this.ruleService.queryRuleParam(ruleGroupVo.getRuleItemId());
        if ((!a.keySet().stream().filter(a2 -> {
            if (!a3.containsKey(a2)) {
                return true;
            }
            return false;
        }).collect(Collectors.toList()).isEmpty() || a.keySet().size() != a3.keySet().size()) && CollUtil.isNotEmpty(this.ruleItemHooks)) {
            for (IRuleItemHook a4 : this.ruleItemHooks) {
                String string;
                String a5 = RuleItemGroupQueryDto.strictfp("\u001c_\u001dH");
                try {
                    string = a5 = a4.afterUpdateRuleItem(ruleGroupVo.getRuleItemId());
                }
                catch (Exception a6) {
                    log.error(RuleExportDto.strictfp("\u89ab\u524e\u4f81\u656e\u94c6\u5b07\u6208\u881b\u5f6d\u5e6f"), (Throwable)a6);
                    string = a5;
                }
                if (Objects.equals(string, RuleItemGroupQueryDto.strictfp("\u001c_\u001dH")) || !StringUtils.isNotBlank((CharSequence)a5)) continue;
                return ApiResponse.success((String)a5);
            }
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"AiGenerate"})
    public ApiResponse<Void> aiGenerate(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.status((boolean)this.ruleItemService.aiGenerate(ruleItemVo));
    }

    @PostMapping(value={"/save"})
    public ApiResponse<RuleItemVo> save(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.success((Object)this.ruleItemService.save(ruleItemVo));
    }

    @PostMapping(value={"/saveReviewLogic"})
    public ApiResponse<Void> saveReviewLogic(@RequestBody RuleItemVo ruleItemVo) {
        return ApiResponse.status((boolean)this.ruleItemService.saveReviewLogic(ruleItemVo));
    }

    @PostMapping(value={"/batchSave"})
    public ApiResponse<List<RuleItemVo>> batchSave(@RequestBody List<RuleItemVo> ruleItemVoList) {
        return ApiResponse.success(this.ruleItemService.batchSave(ruleItemVoList));
    }

    @PostMapping(value={"/queryRule"})
    public ApiResponse<RuleGroupVo> queryRule(@RequestBody RuleGroupVo ruleGroupVo) {
        return ApiResponse.success((Object)this.ruleItemService.queryRule(ruleGroupVo));
    }
}

