/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.rule.server.controller;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.rule.api.vo.ExtractItemQueryVo;
import com.jxdinfo.idp.rule.api.vo.ExtractItemVo;
import com.jxdinfo.idp.rule.api.vo.RuleLibVo;
import com.jxdinfo.idp.rule.server.controller.RuleFormulaController;
import com.jxdinfo.idp.rule.server.controller.RuleItemController;
import com.jxdinfo.idp.rule.server.dto.RuleExportDto;
import com.jxdinfo.idp.rule.server.internal.service.IExtractItemService;
import com.jxdinfo.idp.rule.server.service.IRuleLibService;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rule/lib"})
public class RuleLibController {
    @Resource
    private IRuleLibService ruleLibService;
    @Resource
    private IExtractItemService extractItemService;

    @GetMapping(value={"/getExtractItemApi"})
    public ApiResponse<List<ImplCodeDto>> getExtractItemApi() {
        return ApiResponse.success(this.extractItemService.getExtractItemApi());
    }

    @PostMapping(value={"/delRelatedExtractItem"})
    public ApiResponse<Void> delRelatedExtractItem(@RequestBody Long[] relatedExtractItemIds) {
        return ApiResponse.status((boolean)this.ruleLibService.delRelatedExtractItem(relatedExtractItemIds));
    }

    @PostMapping(value={"/addRelatedExtractItem"})
    public ApiResponse<Void> addRelatedExtractItem(@RequestBody List<ExtractItemVo> extractItemList) {
        return ApiResponse.status((boolean)this.ruleLibService.addrelatedExtractItem(extractItemList));
    }

    @GetMapping(value={"/forcedDel"})
    public ApiResponse<Void> forcedDel(@RequestParam List<Long> ruleLibId) {
        return ApiResponse.status((boolean)this.ruleLibService.forcedDel(ruleLibId));
    }

    @GetMapping(value={"/del"})
    public ApiResponse<Void> del(@RequestParam Long ruleLibId) {
        return ApiResponse.status((boolean)this.ruleLibService.batchDel(Collections.singletonList(ruleLibId)));
    }

    @PostMapping(value={"getExtractItem"})
    public ApiResponse<List<ExtractItemVo>> getExtractItem(@RequestBody ExtractItemQueryVo queryVo) {
        return ApiResponse.success(this.extractItemService.getExtractItem(queryVo));
    }

    @PostMapping(value={"/exportRule"})
    public void exportExtract(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.ruleLibService.exportExtract(ids, response);
    }

    @PostMapping(value={"/batchDel"})
    public ApiResponse<Void> batchDel(@RequestBody List<Long> ruleLibIds) {
        return ApiResponse.status((boolean)this.ruleLibService.batchDel(ruleLibIds));
    }

    @PostMapping(value={"/importRule"})
    public ApiResponse<Void> importExtract(@RequestBody MultipartFile hussarFile) {
        RuleExportDto a = null;
        try {
            a = (RuleExportDto)SerializeUtils.deserialize((byte[])hussarFile.getBytes());
        }
        catch (ClassCastException a2) {
            return ApiResponse.fail((int)10001, (String)RuleFormulaController.do("\u5bce\u67b2\u89ab\u524e\u5b93\u5132\u5f6d\u5e6f\uff63\u8ba0\u4e65\u4f77\u89ab\u524e\u5efc\u76d3\u5b93\u51ad\u65e8\u4ea1"));
        }
        catch (Exception a3) {
            throw new BusinessException(RuleItemController.volatile("\u5be1\u67b9\u8984\u5245\u5bbc\u5139\u5f42\u5e64l\u5bfd\u67a5\u8998\u5259\u89bf\u67d0\u596d\u8d65"));
        }
        this.ruleLibService.importExtract(a);
        return ApiResponse.success((String)RuleFormulaController.do("\u5b93\u5132\u627f\u52c8"));
    }

    @PostMapping(value={"/save"})
    public ApiResponse<RuleLibVo> save(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.success((Object)this.ruleLibService.save(ruleLib));
    }

    @PostMapping(value={"relateExtractItem"})
    public ApiResponse<Void> relateExtractItem(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.status((boolean)this.ruleLibService.relateExtractItem(ruleLib));
    }

    @PostMapping(value={"/getRelatedExtractItem"})
    public ApiResponse<List<ExtractItemVo>> getRuleItemExtractItem(@RequestBody RuleLibVo ruleLib) {
        return ApiResponse.success(this.ruleLibService.getLibRelatedExtractItem(ruleLib));
    }
}

