/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.robot.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.idp.common.base.dto.AuditInfoDto;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.threepartapi.rag.Knowledge;
import com.jxdinfo.idp.common.entity.threepartapi.rag.UploadDocForm;
import com.jxdinfo.idp.common.exception.IDPExcepttion;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.threepartapi.rag.IKnowledgeBaseServer;
import com.jxdinfo.idp.common.user.entity.SysUsersVo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.interf.DocInfoIoService;
import com.jxdinfo.idp.robot.dto.GPTPackagingParamDTO;
import com.jxdinfo.idp.robot.dto.IntelReviewFileDTO;
import com.jxdinfo.idp.robot.entity.AskQuestion;
import com.jxdinfo.idp.robot.entity.IntelReviewFile;
import com.jxdinfo.idp.robot.entity.IntelReviewQa;
import com.jxdinfo.idp.robot.entity.IntelTask;
import com.jxdinfo.idp.robot.rmi.GptClient;
import com.jxdinfo.idp.robot.service.IDocIntelReviewService;
import com.jxdinfo.idp.robot.service.IntelReviewFileService;
import com.jxdinfo.idp.robot.service.IntelReviewQaService;
import com.jxdinfo.idp.robot.service.IntelTaskService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class DocIntelReviewImpl
implements IDocIntelReviewService {
    private static final Logger log = LoggerFactory.getLogger(DocIntelReviewImpl.class);
    private static final String ERROR_RESPONSE = "\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002";
    private static final String INTERNAL_ERROR = "Internal Server Error";
    @Resource
    private IntelTaskService taskService;
    @Resource
    private IKnowledgeBaseServer knowledgeBaseServer;
    @Resource
    private DocInfoIoService docInfoIoService;
    @Resource
    private IntelReviewFileService fileService;
    @Resource
    private IntelReviewQaService qaService;
    @Resource
    private GptClient client;
    private static final Map<String, String> JUDGE_DESCRIBE_MAP = new ConcurrentHashMap<String, String>();

    @Override
    public void addTask(IntelTask task) {
        try {
            String kName = IdUtil.fastSimpleUUID();
            ApiResponse knowledgeBase = this.knowledgeBaseServer.createKnowledgeBase(new Knowledge(kName));
            log.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u5b8c\u6210\uff0ckName:" + kName + ",fileId:" + task.getFileId());
            FileBytesInfo fileBytesInfo = this.docInfoIoService.getFileBytesInfo(Long.valueOf(task.getFileId()));
            UploadDocForm form = new UploadDocForm();
            form.setChunk_size(Integer.valueOf(300));
            form.setOverlap_size(Integer.valueOf(50));
            form.setBytesInfo(fileBytesInfo);
            form.setKnowledge_base_name(kName);
            ApiResponse jsonObjectApiResponse = this.knowledgeBaseServer.uploadDoc(form);
            log.info("\u77e5\u8bc6\u5e93\u4e0a\u4f20\u6587\u6863\u5b8c\u6210\uff0ckName:" + kName + ",fileName:" + fileBytesInfo.getFileName());
            if (jsonObjectApiResponse.getCode() != 200) {
                log.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25:kName:" + kName + ",fileName:" + fileBytesInfo.getFileName());
                throw new IDPExcepttion("\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25");
            }
            task.setId(IdUtil.fastSimpleUUID());
            task.setLibId(kName);
            task.setTaskType("1");
            task.setRecName(fileBytesInfo.getFileName());
            this.taskService.save(task);
            log.info("addTask\u521b\u5efa\u4efb\u52a1\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff0ctaskId:" + task.getId());
            IntelReviewFile file = new IntelReviewFile();
            file.setFileId(task.getFileId());
            file.setTaskId(task.getId());
            file.setFileName(fileBytesInfo.getFileName());
            file.setUploadTime(LocalDateTime.now());
            file.setVersionId(task.getDocVersionId());
            this.fileService.save(file);
            log.info("addTask\u521b\u5efa\u4efb\u52a1\u6570\u636efile\u4fdd\u5b58\u6210\u529f\uff0ctaskId:" + task.getId() + ",FileId:" + file.getFileId());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25:" + e.getMessage());
            throw new IDPExcepttion("\u521b\u5efa\u77e5\u8bc6\u5e93\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public void batchDelTask(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        if (StringUtils.isNotEmpty(idList)) {
            List taskList = this.taskService.listByIds(idList);
            try {
                taskList.forEach(task -> this.knowledgeBaseServer.deleteKnowledgeBase(new Knowledge(task.getLibId())));
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u77e5\u8bc6\u5e93\u5931\u8d25" + e.getMessage());
            }
            LambdaQueryWrapper fileLambdaQueryWrapper = new LambdaQueryWrapper();
            fileLambdaQueryWrapper.in(IntelReviewFile::getTaskId, idList);
            this.fileService.remove((Wrapper)fileLambdaQueryWrapper);
            LambdaQueryWrapper qaLambdaQueryWrapper = new LambdaQueryWrapper();
            qaLambdaQueryWrapper.in(IntelReviewQa::getTaskId, idList);
            this.qaService.remove((Wrapper)qaLambdaQueryWrapper);
            this.taskService.removeByIds(idList);
        }
    }

    @Override
    public void delTask(String taskId) {
        IntelTask task = (IntelTask)this.taskService.getById((Serializable)((Object)taskId));
        try {
            this.knowledgeBaseServer.deleteKnowledgeBase(new Knowledge(task.getLibId()));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u77e5\u8bc6\u5e93\u5931\u8d25" + e.getMessage());
        }
        LambdaQueryWrapper fileLambdaQueryWrapper = new LambdaQueryWrapper();
        fileLambdaQueryWrapper.eq(IntelReviewFile::getTaskId, (Object)taskId);
        this.fileService.remove((Wrapper)fileLambdaQueryWrapper);
        LambdaQueryWrapper qaLambdaQueryWrapper = new LambdaQueryWrapper();
        qaLambdaQueryWrapper.eq(IntelReviewQa::getTaskId, (Object)taskId);
        this.qaService.remove((Wrapper)qaLambdaQueryWrapper);
        this.taskService.removeById((Serializable)((Object)taskId));
    }

    @Override
    public List<IntelReviewFileDTO> fileList(IntelTask task) {
        IntelReviewFile intelReviewFile = new IntelReviewFile();
        intelReviewFile.setTaskId(task.getId());
        return this.fileService.fileList(intelReviewFile);
    }

    @Override
    public IntelReviewQa chat(AskQuestion question) {
        IntelReviewQa qa = new IntelReviewQa();
        qa.setAskTime(LocalDateTime.now());
        Knowledge knowledge = new Knowledge(question.getLibName());
        knowledge.setQuery(question.getQuestion());
        knowledge.setTop_k("3");
        qa.setQuestionContent(question.getQuestion());
        qa.setTaskId(question.getTaskId());
        try {
            JSONObject answerJson = this.knowledgeBaseServer.chat2(knowledge);
            qa.setAnswerTime(LocalDateTime.now());
            qa.setAnswerContent(answerJson.get((Object)"answer").toString());
            qa.setAnswerSource(String.valueOf(answerJson.get((Object)"docs")));
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u76f8\u5e94\u5f02\u5e38\uff1a" + e.getMessage());
            qa.setAnswerContent(ERROR_RESPONSE);
        }
        if (!StringUtils.isEmpty((String)qa.getAnswerContent()) && qa.getAnswerContent().equals(INTERNAL_ERROR)) {
            qa.setAnswerContent(ERROR_RESPONSE);
        }
        this.qaService.save(qa);
        return qa;
    }

    @Override
    public List<IntelReviewQa> qaList(IntelTask task) {
        LambdaQueryWrapper qaLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qaLambdaQueryWrapper.eq(IntelReviewQa::getTaskId, (Object)task.getId())).orderByAsc(IntelReviewQa::getAskTime);
        return this.qaService.list((Wrapper)qaLambdaQueryWrapper);
    }

    @Override
    public List<IntelTask> taskList(IntelTask task) {
        SysUsersVo loginUser = UserUtils.getLoginUser();
        String userId = "";
        if (loginUser != null && loginUser.getId() != null) {
            userId = String.valueOf(loginUser.getId());
        }
        LambdaQueryWrapper taskLambdaQueryWrapper = new LambdaQueryWrapper();
        taskLambdaQueryWrapper.like(StringUtils.isNotEmpty((String)task.getRecName()), IntelTask::getRecName, (Object)task.getRecName());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)taskLambdaQueryWrapper.eq(StringUtils.isNotEmpty((String)task.getTaskType()), IntelTask::getTaskType, (Object)task.getTaskType())).eq(StringUtils.isNotEmpty((String)userId), AuditInfoDto::getCreator, (Object)userId)).orderByDesc(AuditInfoDto::getCreateTime);
        return this.taskService.list((Wrapper)taskLambdaQueryWrapper);
    }

    @Override
    public SseEmitter typeWriter(HttpServletResponse resp, AskQuestion question) {
        resp.setCharacterEncoding("utf-8");
        resp.setHeader("Cache-Control", "no-cache, no-transform");
        resp.setHeader("Content-Type", "text/event-stream");
        resp.setHeader("Connection", "keep-alive");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        resp.setHeader("Access-Control-Allow-Headers", "Content-Type,Content-Length, Authorization, Accept,X-Requested-With");
        resp.setHeader("Access-Control-Max-Age", "3600");
        resp.setHeader("X-Accel-Buffering", "no");
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(300000L));
        sseEmitter.onTimeout(() -> log.info("SSE \u8fde\u63a5\u8d85\u65f6"));
        sseEmitter.onCompletion(() -> log.info("SSE \u8fde\u63a5\u5b8c\u6210"));
        IntelReviewQa qa = new IntelReviewQa();
        String qaId = UUID.randomUUID().toString().replace("-", "");
        qa.setId(qaId);
        qa.setAskTime(LocalDateTime.now());
        qa.setQuestionContent(question.getQuestion());
        qa.setTaskId(question.getTaskId());
        Knowledge kl = new Knowledge();
        kl.setTop_k("3");
        kl.setQuery(question.getQuestion());
        kl.setKnowledge_base_name(question.getLibName());
        kl.setStream(true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            GPTPackagingParamDTO param = new GPTPackagingParamDTO();
            param.setAskTime(qa.getAskTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            param.setId(qaId);
            try {
                String answer = this.client.chat(resp, kl, sseEmitter, param);
                qa.setAnswerTime(LocalDateTime.now());
                qa.setAnswerContent(answer);
            }
            catch (InterruptedException e) {
                log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
                qa.setAnswerContent(ERROR_RESPONSE);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
                qa.setAnswerContent(ERROR_RESPONSE);
            }
            if (!StringUtils.isEmpty((String)qa.getAnswerContent()) && qa.getAnswerContent().equals(INTERNAL_ERROR)) {
                qa.setAnswerContent(ERROR_RESPONSE);
            }
            this.qaService.save(qa);
        });
        return sseEmitter;
    }

    @Override
    public List<String> getCommonInUseQa(String taskId) {
        return this.commonQaCreate();
    }

    private void asyncSave(HttpServletResponse response, Knowledge knowledge, SseEmitter emitter, IntelReviewQa qa) {
        GPTPackagingParamDTO param = new GPTPackagingParamDTO();
        param.setAskTime(qa.getAskTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            String answer = this.client.chat(response, knowledge, emitter, param);
            qa.setAnswerTime(LocalDateTime.now());
            qa.setAnswerContent(answer);
        }
        catch (InterruptedException e) {
            log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
            qa.setAnswerContent(ERROR_RESPONSE);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
            qa.setAnswerContent(ERROR_RESPONSE);
        }
        if (!StringUtils.isEmpty((String)qa.getAnswerContent()) && qa.getAnswerContent().equals(INTERNAL_ERROR)) {
            qa.setAnswerContent(ERROR_RESPONSE);
        }
        this.qaService.save(qa);
    }

    private List<String> commonQaCreate() {
        ArrayList<String> commonQuestion = new ArrayList<String>();
        commonQuestion.add("\u62db\u6807\u5355\u4f4d\u540d\u79f0\u662f\u5426\u6807\u51c6");
        commonQuestion.add("\u6280\u672f\u89c4\u8303\u4e66\u4e2d\u662f\u5426\u63d0\u51fa\u5bf9\u6295\u6807\u4eba\u5458\u7684\u5b66\u5386\u3001\u804c\u79f0\u8981\u6c42");
        commonQuestion.add("\u662f\u5426\u660e\u786e\u62a5\u4ef7\u586b\u5199\u76f8\u5173\u8981\u4e00\u76f4");
        commonQuestion.add("\u7f16\u5236\u65e5\u671f\u662f\u5426\u4e3a\u7a7a");
        commonQuestion.add("\u62db\u6807\u516c\u53f8\u540d\u79f0\u662f\u5426\u5df2\"\u79d1\u6280\u6709\u9650\u516c\u53f8\"\u7ed3\u5c3e");
        commonQuestion.add("\u670d\u52a1\u671f\u9650\u8d77\u59cb\u65f6\u95f4\u662f\u5426\u4e3a\"\u5408\u540c\u7b7e\u8ba2\u4e4b\u65e5\"");
        commonQuestion.add("\u62db\u6807\u5355\u4f4d\u540d\u79f0\u662f\u5426\u6807\u51c6");
        commonQuestion.add("\u6280\u672f\u89c4\u8303\u4e66\u4e2d\u662f\u5426\u63d0\u51fa\u5bf9\u62db\u6807\u4eba\u5458\u7684\u73b0\u573a\u8981\u6c42");
        return commonQuestion;
    }

    static {
        JUDGE_DESCRIBE_MAP.put("ne", "\u662f\u5426\u4e0d\u7b49\u4e8e");
        JUDGE_DESCRIBE_MAP.put("lt", "\u662f\u5426\u5c0f\u4e8e");
        JUDGE_DESCRIBE_MAP.put("gt", "\u662f\u5426\u5927\u4e8e");
        JUDGE_DESCRIBE_MAP.put("contain", "\u662f\u5426\u5305\u542b");
        JUDGE_DESCRIBE_MAP.put("notContain", "\u662f\u5426\u4e0d\u5305\u542b");
        JUDGE_DESCRIBE_MAP.put("before", "\u662f\u5426\u65e9\u4e8e");
        JUDGE_DESCRIBE_MAP.put("after", "\u662f\u5426\u665a\u4e8e");
    }
}

