/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.robot.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.robot.dto.IntelReviewFileDTO;
import com.jxdinfo.idp.robot.entity.AskQuestion;
import com.jxdinfo.idp.robot.entity.IntelReviewQa;
import com.jxdinfo.idp.robot.entity.IntelTask;
import com.jxdinfo.idp.robot.service.IDocIntelReviewService;
import com.jxdinfo.idp.robot.service.IntelReviewQaService;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RequestMapping(value={"/ability/intelReview"})
@RestController
public class DocIntelReviewController {
    @Resource
    private IDocIntelReviewService intelReviewService;
    @Resource
    private IntelReviewQaService qaService;

    @PostMapping(value={"/addTask"})
    public ApiResponse<Void> addTask(@RequestBody IntelTask task) throws Exception {
        try {
            this.intelReviewService.addTask(task);
            return ApiResponse.success((String)"\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)("\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/delTask"})
    public ApiResponse<Void> delTask(@RequestBody IntelTask task) {
        String taskId = task.getId();
        if (taskId == null || taskId.equals("")) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff1a\u4efb\u52a1id\u4e3a\u7a7a");
        }
        this.intelReviewService.delTask(taskId);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/taskList"})
    public ApiResponse<List<IntelTask>> taskList(@RequestBody IntelTask task) {
        return ApiResponse.data(this.intelReviewService.taskList(task));
    }

    @PostMapping(value={"/fileList"})
    public ApiResponse<List<IntelReviewFileDTO>> ListFile(@RequestBody IntelTask task) {
        return ApiResponse.data(this.intelReviewService.fileList(task));
    }

    @PostMapping(value={"/chat"})
    public ApiResponse<IntelReviewQa> chat(@RequestBody AskQuestion question) {
        return ApiResponse.data((Object)this.intelReviewService.chat(question));
    }

    @PostMapping(value={"/chatList"})
    public ApiResponse<List<IntelReviewQa>> QAList(@RequestBody IntelTask task) {
        return ApiResponse.data(this.intelReviewService.qaList(task));
    }

    @GetMapping(value={"/ChatBySse"}, produces={"text/event-stream;charset=UTF-8"})
    public SseEmitter typeWriter(HttpServletResponse response, @RequestParam(value="question") String question, @RequestParam(value="libName") String libName, @RequestParam(value="taskId") String taskId, @RequestParam(value="knowledge") String knowledge) {
        AskQuestion askQuestion = new AskQuestion();
        askQuestion.setQuestion(question);
        askQuestion.setLibName(libName);
        askQuestion.setTaskId(taskId);
        askQuestion.setKnowledge(knowledge);
        return this.intelReviewService.typeWriter(response, askQuestion);
    }

    @PostMapping(value={"/chatSave"})
    public ApiResponse<IntelReviewQa> chatSaveOfStream(@RequestBody IntelReviewQa qa) {
        return ApiResponse.data((Object)this.qaService.saveChatResp(qa));
    }

    @GetMapping(value={"/commonQa"})
    public ApiResponse<List<String>> commonInUseQa(@RequestParam(value="taskId") String taskId) {
        return ApiResponse.data(this.intelReviewService.getCommonInUseQa(taskId));
    }

    @GetMapping(value={"/delQa"})
    public void delQa(@RequestParam(required=false) String qaId, @RequestParam(value="taskId") String taskId) {
        this.qaService.delQaBatch(qaId, taskId);
    }
}

