/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.controller;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.extract.domain.dto.ExtractDelDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractExportDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractGroupDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractNode;
import com.jxdinfo.idp.extract.domain.dto.ExtractOption;
import com.jxdinfo.idp.extract.domain.dto.ExtractTypeDtoOld;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.po.ExtractGroup;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractGroupQuery;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/extractCore"})
public class ExtractCoreController {
    private static final Logger log = LoggerFactory.getLogger(ExtractCoreController.class);
    @Autowired
    private IExtractCoreService service;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/saveConfig"})
    public ApiResponse<Void> saveConfig(@RequestBody ExtractItemDto extractItemDto) {
        void dto;
        this.service.update((ExtractItemDto)dto);
        return ApiResponse.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/insert"})
    public ApiResponse<Long> insert(@RequestBody ExtractItem extractItem) {
        void item;
        return ApiResponse.success((Object)this.service.insert((ExtractItem)item));
    }

    @PostMapping(value={"/reBuildTreeData"})
    public ApiResponse<List<ExtractNode>> reBuildTreeData(@RequestBody ExtractGroupQuery query) {
        return ApiResponse.success(this.service.reBuildTreeData(query));
    }

    public static String new(String s) {
        int n = s.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 5 << 3 ^ (2 ^ 5);
        int cfr_ignored_0 = 3 << 3 ^ 1;
        int n4 = n2;
        int n5 = 5 << 4 ^ 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(s.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(s.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @PostMapping(value={"/batchUpdateGroup"})
    public ApiResponse<Void> batchUpdateGroup(@RequestBody List<ExtractGroupDto> dtoList) {
        try {
            this.service.batchUpdateGroup(dtoList);
        }
        catch (Exception a) {
            log.error(ExtractCoreController.new("\u6256\u919e\u4fc1\u6568\u63ff\u5387\u9856\u5257\u7eeb\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody ExtractItem item) {
        this.service.update(item);
        return ApiResponse.success();
    }

    @PostMapping(value={"/exportExtract"})
    public void exportExtract(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.service.exportExtract(ids, response);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getItemList"})
    public ApiResponse<List<ExtractItemDto>> getItemList(@RequestBody ExtractItemQuery extractItemQuery) {
        void query;
        return ApiResponse.success(this.service.getItemList((ExtractItemQuery)query));
    }

    @PostMapping(value={"/batchUpdate"})
    public ApiResponse<Void> batchUpdate(@RequestBody List<ExtractItem> itemList) {
        this.service.batchUpdate(itemList);
        return ApiResponse.success();
    }

    @PostMapping(value={"/extractForOneType"})
    public ApiResponse<ExtractRecord> extractForOneType(@RequestBody ExtractItemDto dto) {
        try {
            return ApiResponse.success((Object)this.service.extractForOneType(dto));
        }
        catch (Exception a) {
            log.error(ExtractCoreController.new("J)[#N2[\u0017@#`?J\u0005V!J\u6381\u53f9\u63f4\u53cc\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)ExtractCoreController.new("\u638a\u53b2\u5f2d\u5e69"));
        }
    }

    @PostMapping(value={"/recognitionMarkedImg"})
    public ApiResponse<String> recognitionMarkedImg(@RequestBody MultipartFile file) {
        return ApiResponse.data((Object)this.service.recognitionMarked(file));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/insertGroup"})
    public ApiResponse<ExtractGroup> insertGroup(@RequestBody ExtractGroupDto extractGroupDto) {
        void dto;
        return ApiResponse.success((Object)this.service.insertGroup((ExtractGroupDto)dto));
    }

    @GetMapping(value={"/extractOptions"})
    public ApiResponse<ExtractOption> extractOptions() {
        ExtractOption a;
        ExtractOption extractOption = a = new ExtractOption();
        ExtractCoreController extractCoreController = this;
        a.setExtractGroupLevel(extractCoreController.service.getGroupLevelTree());
        extractOption.setReturnTypes(extractCoreController.service.getReturnTypes());
        extractOption.setAfterHandlers(this.service.getAfterHandlerList());
        return ApiResponse.success((Object)extractOption);
    }

    @GetMapping(value={"/getTree"})
    public ApiResponse<List<ExtractGroupDto>> getTree() {
        return ApiResponse.success(this.service.getTree());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/extractTest"})
    public ApiResponse<ExtractRecord> extractTest(@RequestBody ExtractItemDto extractItemDto) {
        try {
            void dto;
            return ApiResponse.success((Object)this.service.extractTest((ExtractItemDto)dto));
        }
        catch (Exception a) {
            log.error(ExtractCoreController.new("J)[#N2[\u0005J\"[\u6381\u53f9\u6d1a\u8bfa\u63f4\u53cc\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)ExtractCoreController.new("\u638a\u53b2\u5f2d\u5e69"));
        }
    }

    @PostMapping(value={"/importExtract"})
    public ApiResponse<Void> importExtract(@RequestPart(value="hussarFile") MultipartFile hussarFile, @RequestParam(value="isUserData") String isUserData) {
        try {
            byte[] a = hussarFile.getBytes();
            ExtractExportDto a2 = (ExtractExportDto)SerializeUtils.deserialize((byte[])a);
            this.service.importExtract(a2, isUserData);
        }
        catch (ClassCastException a) {
            return ApiResponse.fail((int)10001, (String)ExtractCoreController.new("\u6381\u53f9\u9828\u5bd3\u5134\u5f2d\u5e69\uff23\u8ba6\u4e25\u4f71\u63ff\u5387\u9856\u76d5\u5bd3\u51ab\u65a8\u4ea7"));
        }
        catch (Exception a) {
            throw new BusinessException(ExtractCoreController.new("\u63ff\u5387\u9856\u5bad\u514a\u5f53\u5e17}\u5bd3\u5134\u65a8\u6832\u89cc\u67c1\u591e\u8d74"), (Throwable)a);
        }
        return ApiResponse.success((String)ExtractCoreController.new("\u5bd3\u5134\u623f\u52ce"));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/test"})
    public List<ExtractRecord> test(@RequestParam(value="itemId") Long l, @RequestParam(value="file") MultipartFile multipartFile) throws IOException {
        void file;
        void itemId;
        return this.service.test((Long)itemId, (MultipartFile)file);
    }

    @PostMapping(value={"/updateGroup"})
    public ApiResponse<Void> updateGroup(@RequestBody ExtractGroupDto dto) {
        try {
            this.service.updateGroup(dto);
        }
        catch (Exception a) {
            log.error(ExtractCoreController.new("\u4fc1\u6568\u63ff\u5387\u9856\u5257\u7eeb\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/getReturnTypes"})
    public ApiResponse<List<Map<String, String>>> getReturnTypes() {
        return ApiResponse.success(this.service.getReturnTypes());
    }

    @GetMapping(value={"/getExtractTypeList"})
    public ApiResponse<List<ExtractTypeDtoOld>> getExtractTypeList() {
        return ApiResponse.success(this.service.getExtractTypeOldList());
    }

    @GetMapping(value={"/deleteGroup"})
    public ApiResponse<Void> deleteGroup(@RequestParam(value="id") Long id) {
        try {
            this.service.deleteGroup(id);
        }
        catch (Exception a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/getGroupLevelTree"})
    public ApiResponse<List<GroupLevel>> getGroupLevelTree() {
        return ApiResponse.success(this.service.getGroupLevelTree());
    }

    @PostMapping(value={"/batchDelete"})
    public ApiResponse<Void> batchDelete(@RequestBody ExtractDelDto ids) {
        this.service.batchDelete(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/itemStatistics"})
    public ApiResponse<Long> itemStatistics() {
        return ApiResponse.success((Object)this.service.itemStatistics());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getGroupTree"})
    public ApiResponse<List<ExtractNode>> getTree(@RequestBody ExtractGroupQuery extractGroupQuery) {
        void query;
        return ApiResponse.success(this.service.getTree((ExtractGroupQuery)query));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/getDetail"})
    public ApiResponse<ExtractItemDto> getDetail(Long l) {
        void itemId;
        return ApiResponse.success((Object)this.service.getItemDto((Long)itemId));
    }

    @GetMapping(value={"/transTo"})
    public ApiResponse<ConfigDocMarkTemplate> transTo(@RequestParam(value="docId") String docId, @RequestParam(value="pageNum") Integer pageNum) {
        return ApiResponse.data((Object)this.service.pdfTransToImg(docId, pageNum));
    }

    @PostMapping(value={"/extractForAllType"})
    public ApiResponse<ExtractRecord> extractForAllType(@RequestBody ExtractItemDto dto) {
        try {
            return ApiResponse.success((Object)this.service.extractForAllType(dto));
        }
        catch (Exception a) {
            log.error(ExtractCoreController.new("J)[#N2[\u0017@#n=C\u0005V!J\u6381\u53f9\u63f4\u53cc\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)ExtractCoreController.new("\u638a\u53b2\u5f2d\u5e69"));
        }
    }
}

