/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.controller;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.extract.domain.dto.ExtractDelDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractExportDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractGroupDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractNode;
import com.jxdinfo.idp.extract.domain.dto.ExtractOption;
import com.jxdinfo.idp.extract.domain.dto.ExtractTypeDtoOld;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.po.ExtractGroup;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractGroupQuery;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf.dto.RGTableCellDto;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/extractCore"})
public class ExtractCoreController {
    private static final Logger log = LoggerFactory.getLogger(ExtractCoreController.class);
    @Autowired
    private IExtractCoreService service;

    @GetMapping(value={"/extractOptions"})
    public ApiResponse<ExtractOption> extractOptions() {
        ExtractOption a;
        ExtractOption extractOption = a = new ExtractOption();
        ExtractCoreController extractCoreController = this;
        a.setExtractGroupLevel(extractCoreController.service.getGroupLevelTree());
        extractOption.setReturnTypes(extractCoreController.service.getReturnTypes());
        extractOption.setAfterHandlers(this.service.getAfterHandlerList());
        return ApiResponse.success((Object)extractOption);
    }

    @PostMapping(value={"/importExtract"})
    public ApiResponse<Void> importExtract(@RequestPart(value="hussarFile") MultipartFile hussarFile, @RequestParam(value="isUserData") String isUserData) {
        try {
            byte[] a = hussarFile.getBytes();
            ExtractExportDto a2 = (ExtractExportDto)SerializeUtils.deserialize((byte[])a);
            this.service.importExtract(a2, isUserData);
        }
        catch (ClassCastException a) {
            return ApiResponse.fail((int)10001, (String)RGTableCellDto.instanceof("\u6381\u53f9\u9828\u5bd3\u5134\u5f2d\u5e69\uff23\u8ba6\u4e25\u4f71\u63ff\u5387\u9856\u76d5\u5bd3\u51ab\u65a8\u4ea7"));
        }
        catch (Exception a) {
            throw new BusinessException(RGTableCellDto.instanceof("\u63ff\u5387\u9856\u5bad\u514a\u5f53\u5e17}\u5bd3\u5134\u65a8\u6832\u89cc\u67c1\u591e\u8d74"), (Throwable)a);
        }
        return ApiResponse.success((String)RGTableCellDto.instanceof("\u5bd3\u5134\u623f\u52ce"));
    }

    @PostMapping(value={"/getItemList"})
    public ApiResponse<List<ExtractItemDto>> getItemList(@RequestBody ExtractItemQuery query) {
        return ApiResponse.success(this.service.getItemList(query));
    }

    @GetMapping(value={"/getDetail"})
    public ApiResponse<ExtractItemDto> getDetail(Long itemId) {
        return ApiResponse.success((Object)this.service.getItemDto(itemId));
    }

    @GetMapping(value={"/getTree"})
    public ApiResponse<List<ExtractGroupDto>> getTree() {
        return ApiResponse.success(this.service.getTree());
    }

    @PostMapping(value={"/batchUpdate"})
    public ApiResponse<Void> batchUpdate(@RequestBody List<ExtractItem> itemList) {
        this.service.batchUpdate(itemList);
        return ApiResponse.success();
    }

    @PostMapping(value={"/exportExtract"})
    public void exportExtract(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.service.exportExtract(ids, response);
    }

    @GetMapping(value={"/deleteGroup"})
    public ApiResponse<Void> deleteGroup(@RequestParam(value="id") Long id) {
        try {
            this.service.deleteGroup(id);
        }
        catch (Exception a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/test"})
    public List<ExtractRecord> test(@RequestParam(value="itemId") Long itemId, @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.service.test(itemId, file);
    }

    @PostMapping(value={"/reBuildTreeData"})
    public ApiResponse<List<ExtractNode>> reBuildTreeData(@RequestBody ExtractGroupQuery query) {
        return ApiResponse.success(this.service.reBuildTreeData(query));
    }

    @GetMapping(value={"/itemStatistics"})
    public ApiResponse<Long> itemStatistics() {
        return ApiResponse.success((Object)this.service.itemStatistics());
    }

    @GetMapping(value={"/getGroupLevelTree"})
    public ApiResponse<List<GroupLevel>> getGroupLevelTree() {
        return ApiResponse.success(this.service.getGroupLevelTree());
    }

    @PostMapping(value={"/getGroupTree"})
    public ApiResponse<List<ExtractNode>> getTree(@RequestBody ExtractGroupQuery query) {
        return ApiResponse.success(this.service.getTree(query));
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody ExtractItem item) {
        this.service.update(item);
        return ApiResponse.success();
    }

    @PostMapping(value={"/recognitionMarkedImg"})
    public ApiResponse<String> recognitionMarkedImg(@RequestBody MultipartFile file) {
        return ApiResponse.data((Object)this.service.recognitionMarked(file));
    }

    @PostMapping(value={"/updateGroup"})
    public ApiResponse<Void> updateGroup(@RequestBody ExtractGroupDto dto) {
        try {
            this.service.updateGroup(dto);
        }
        catch (Exception a) {
            log.error(RGTableCellDto.instanceof("\u4fc1\u6568\u63ff\u5387\u9856\u5257\u7eeb\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/insertGroup"})
    public ApiResponse<ExtractGroup> insertGroup(@RequestBody ExtractGroupDto dto) {
        return ApiResponse.success((Object)this.service.insertGroup(dto));
    }

    @PostMapping(value={"/extractTest"})
    public ApiResponse<ExtractRecord> extractTest(@RequestBody ExtractItemDto dto) {
        return ApiResponse.success((Object)this.service.extractTest(dto));
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<Long> insert(@RequestBody ExtractItem item) {
        return ApiResponse.success((Object)this.service.insert(item));
    }

    @PostMapping(value={"/batchUpdateGroup"})
    public ApiResponse<Void> batchUpdateGroup(@RequestBody List<ExtractGroupDto> dtoList) {
        try {
            this.service.batchUpdateGroup(dtoList);
        }
        catch (Exception a) {
            log.error(RGTableCellDto.instanceof("\u6256\u919e\u4fc1\u6568\u63ff\u5387\u9856\u5257\u7eeb\u5f53\u5e17\uff4b"), (Throwable)a);
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/getExtractTypeList"})
    public ApiResponse<List<ExtractTypeDtoOld>> getExtractTypeList() {
        return ApiResponse.success(this.service.getExtractTypeOldList());
    }

    @GetMapping(value={"/getReturnTypes"})
    public ApiResponse<List<Map<String, String>>> getReturnTypes() {
        return ApiResponse.success(this.service.getReturnTypes());
    }

    @PostMapping(value={"/saveConfig"})
    public ApiResponse<Void> saveConfig(@RequestBody ExtractItemDto dto) {
        this.service.update(dto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/batchDelete"})
    public ApiResponse<Void> batchDelete(@RequestBody ExtractDelDto ids) {
        this.service.batchDelete(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/transTo"})
    public ApiResponse<ConfigDocMarkTemplate> transTo(@RequestParam(value="docId") String docId, @RequestParam(value="pageNum") Integer pageNum) {
        return ApiResponse.data((Object)this.service.pdfTransToImg(docId, pageNum));
    }
}

