/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatabaseQuery;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/config/dataAccess/datasource/database"})
public class DataBaseController {
    @Autowired
    private DatasourceDatabaseService service;

    @PostMapping(value={"/add"})
    public ApiResponse<Void> add(@RequestBody DatasourceDatabase database) {
        this.service.add(database);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getDatabaseTypes"})
    public ApiResponse<List<Map<String, String>>> getDatabaseTypes() {
        return ApiResponse.data(this.service.getDatabaseTypes());
    }

    @PostMapping(value={"/connect"})
    public ApiResponse<List<String>> connect(@RequestBody DatasourceDatabase database) {
        try {
            List<String> a = this.service.connect(database);
            return ApiResponse.data(a);
        }
        catch (BusinessException a) {
            return ApiResponse.fail((String)a.getMessage());
        }
    }

    @PostMapping(value={"/list"})
    public ApiResponse<Page<? extends DatasourceDatabase>> list(@RequestBody DatabaseQuery databaseQuery) {
        return ApiResponse.data(this.service.getList(databaseQuery));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestBody List<String> ids) {
        try {
            this.service.deleteBatch(ids);
        }
        catch (BusinessException a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody DatasourceDatabase database) {
        this.service.update(database);
        return ApiResponse.success();
    }

    @PostMapping(value={"/getSchemas"})
    public ApiResponse<List<String>> getSchemas(@RequestBody DatasourceDatabase database) throws PropertyVetoException, SQLException {
        return ApiResponse.data(this.service.getSchemas(database));
    }

    public static String assert(String s) {
        int n = s.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 5 << 3 ^ (2 ^ 5);
        int cfr_ignored_0 = 3 << 3 ^ 1;
        int n4 = n2;
        int n5 = 5 << 4 ^ 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(s.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(s.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @PostMapping(value={"/detail"})
    public ApiResponse<DatasourceDatabase> detail(@RequestBody String id) {
        return ApiResponse.data((Object)this.service.detail(id));
    }
}

