/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttp;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpCollection;
import com.jxdinfo.idp.datacenter.datasource.entity.dto.DatasourceHttpDto;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatasourceHttpQuery;
import com.jxdinfo.idp.datacenter.datasource.service.HttpManagementService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/dataAccess/datasource/http"})
public class HttpManagementController {
    @Autowired
    private HttpManagementService service;

    @PostMapping(value={"/detail"})
    public ApiResponse<DatasourceHttp> detail(@RequestBody DatasourceHttpQuery query) {
        return ApiResponse.data((Object)this.service.detail(query));
    }

    @PostMapping(value={"/selectList"})
    public ApiResponse<Page<? extends DatasourceHttp>> selectList(@RequestBody DatasourceHttpQuery query) {
        return ApiResponse.data(this.service.selectList(query));
    }

    @PostMapping(value={"/isExistAuthor"})
    public ApiResponse<DatasourceHttpDto> isExistAuthor(@RequestBody DatasourceHttpQuery query) {
        return ApiResponse.data((Object)this.service.isExistAuthor(query));
    }

    @PostMapping(value={"/testConnection"})
    public ApiResponse<DatasourceHttpDto> testConnection(@RequestBody DatasourceHttpDto dto) {
        return ApiResponse.data((Object)this.service.testConnection(dto));
    }

    @PostMapping(value={"/addApi"})
    public ApiResponse<Void> addApi(@RequestBody DatasourceHttpDto datasourceHttpDto) {
        this.service.addApi(datasourceHttpDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/selectCollectionTree"})
    public ApiResponse<List<DatasourceHttpCollection>> selectCollectionTree() {
        return ApiResponse.data(this.service.selectCollectionTree());
    }

    @PostMapping(value={"/deleteBatchCollection"})
    public ApiResponse<Void> deleteBatchCollection(@RequestBody List<DatasourceHttpCollection> collections) {
        this.service.deleteBatchCollection(collections);
        return ApiResponse.success();
    }

    @PostMapping(value={"/updateCollection"})
    public ApiResponse<Void> updateCollection(@RequestBody DatasourceHttpCollection collection) {
        this.service.updateCollection(collection);
        return ApiResponse.success();
    }

    @PostMapping(value={"/updateApi"})
    public ApiResponse<Void> updateApi(@RequestBody DatasourceHttpDto datasourceHttpDto) {
        this.service.updateApi(datasourceHttpDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/deleteBatchApi"})
    public ApiResponse<Void> deleteBatchApi(@RequestBody List<DatasourceHttp> datasourceHttp) {
        try {
            this.service.deleteBatchApi(datasourceHttp);
        }
        catch (BusinessException a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/getSystemAuthor"})
    public ApiResponse<DatasourceHttpDto> getSystemAuthor(@RequestBody DatasourceHttpQuery query) {
        return ApiResponse.data((Object)this.service.getSystemAuthor(query));
    }

    @PostMapping(value={"/addCollection"})
    public ApiResponse<Void> addCollection(@RequestBody DatasourceHttpCollection collection) {
        this.service.addCollection(collection);
        return ApiResponse.success();
    }
}

