/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.uuid;

import com.jxdinfo.idp.common.config.IDPRestTemplateConfig;
import com.jxdinfo.idp.common.util.file.NodeUtil;
import com.jxdinfo.idp.common.util.uuid.aUX;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class UUID
implements Serializable,
Comparable<UUID> {
    private final long mostSigBits;
    private static final long serialVersionUID = -1185015143654744140L;
    private final long leastSigBits;

    public static UUID randomUUID(boolean a) {
        byte[] byArray;
        Random random = a ? aUX.goto : UUID.getRandom();
        byte[] byArray2 = byArray = new byte[16];
        byte[] byArray3 = byArray;
        random.nextBytes(byArray2);
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray;
        byArray4[6] = (byte)(byArray4[6] & 0xF);
        byArray5[6] = (byte)(byArray5[6] | 0x40);
        byArray3[8] = (byte)(byArray3[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray);
    }

    public long node() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.protected();
        return uUID.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public String toString(boolean a) {
        UUID a2;
        StringBuilder stringBuilder = new StringBuilder(a ? 32 : 36);
        stringBuilder.append(UUID.throw(a2.mostSigBits >> 32, 8));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.throw(a2.mostSigBits >> 16, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.throw(a2.mostSigBits, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.throw(a2.leastSigBits >> 48, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append(UUID.throw(a2.leastSigBits, 12));
        return stringBuilder2.toString();
    }

    public long getLeastSignificantBits() {
        UUID a;
        return a.leastSigBits;
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    public boolean equals(Object a) {
        UUID a2;
        if (null == a || a.getClass() != UUID.class) {
            return false;
        }
        a = (UUID)a;
        return a2.mostSigBits == ((UUID)a).mostSigBits && a2.leastSigBits == ((UUID)a).leastSigBits;
    }

    public int hashCode() {
        UUID a;
        long l = a.mostSigBits ^ a.leastSigBits;
        return (int)(l >> 32) ^ (int)l;
    }

    public static UUID fromString(String a) {
        int n;
        String[] stringArray = a.split(NodeUtil.short("!"));
        if (stringArray.length != 5) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, IDPRestTemplateConfig.while("i\u001cV\u0013L\u001bDRu'i6\u0000\u0001T\u0000I\u001cGH\u0000")).append(a).toString());
        }
        int n2 = n = 0;
        while (n2 < 5) {
            int n3 = n;
            String string = NodeUtil.short("at") + stringArray[n];
            stringArray[n3] = string;
            n2 = ++n;
        }
        long l = Long.decode(stringArray[0]);
        l <<= 16;
        l |= Long.decode(stringArray[1]).longValue();
        l <<= 16;
        long l2 = Long.decode(stringArray[3]);
        l2 <<= 48;
        return new UUID(l |= Long.decode(stringArray[2]).longValue(), l2 |= Long.decode(stringArray[4]).longValue());
    }

    public int clockSequence() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.protected();
        return (int)((uUID.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public int version() {
        UUID a;
        return (int)(a.mostSigBits >> 12 & 0xFL);
    }

    public long getMostSignificantBits() {
        UUID a;
        return a.mostSigBits;
    }

    @Override
    public int compareTo(UUID a) {
        UUID a2;
        if (a2.mostSigBits < a.mostSigBits) {
            return -1;
        }
        if (a2.mostSigBits > a.mostSigBits) {
            return 1;
        }
        if (a2.leastSigBits < a.leastSigBits) {
            return -1;
        }
        if (a2.leastSigBits > a.leastSigBits) {
            return 1;
        }
        return 0;
    }

    private /* synthetic */ UUID(byte[] a) {
        int n;
        UUID a2;
        long l = 0L;
        long l2 = 0L;
        assert (a.length == 16) : IDPRestTemplateConfig.while("D\u0013T\u0013\u0000\u001fU\u0001TRB\u0017\u0000C\u0016RB\u000bT\u0017SRI\u001c\u0000\u001eE\u001cG\u0006H");
        int n2 = n = 0;
        while (n2 < 8) {
            int n3 = a[n] & 0xFF;
            l = l << 8 | (long)n3;
            n2 = ++n;
        }
        int n4 = n = 8;
        while (n4 < 16) {
            int n5 = a[n] & 0xFF;
            l2 = l2 << 8 | (long)n5;
            n4 = ++n;
        }
        a2.mostSigBits = l;
        a2.leastSigBits = l2;
    }

    private /* synthetic */ void protected() {
        UUID a;
        if (a.version() != 1) {
            throw new UnsupportedOperationException(IDPRestTemplateConfig.while("n\u001dTRART\u001bM\u0017\r\u0010A\u0001E\u0016\u0000'u;d"));
        }
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance(NodeUtil.short("\u0002D\u0010=\u0001^\u001fK"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    private static /* synthetic */ String throw(long a, int a2) {
        long l;
        long l2 = l = 1L << a2 * 4;
        return Long.toHexString(l2 | a & l2 - 1L).substring(1);
    }

    public String toString() {
        UUID a;
        return a.toString(false);
    }

    public UUID(long a, long a2) {
        UUID a3;
        UUID uUID = a3;
        uUID.mostSigBits = a;
        uUID.leastSigBits = a2;
    }

    public int variant() {
        UUID a;
        return (int)(a.leastSigBits >>> (int)(64L - (a.leastSigBits >>> 62)) & a.leastSigBits >> 63);
    }

    public long timestamp() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.protected();
        return (uUID.mostSigBits & 0xFFFL) << 48 | (a.mostSigBits >> 16 & 0xFFFFL) << 32 | a.mostSigBits >>> 32;
    }

    public static UUID nameUUIDFromBytes(byte[] a) {
        byte[] byArray;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(NodeUtil.short("A\u00159"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(IDPRestTemplateConfig.while("m6\u0015RN\u001dTRS\u0007P\u0002O\u0000T\u0017D"));
        }
        byte[] byArray2 = byArray = messageDigest.digest(a);
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray;
        byArray4[6] = (byte)(byArray4[6] & 0xF);
        byArray5[6] = (byte)(byArray5[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray3[8] = (byte)(byArray3[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }
}

