/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.common.util.uuid;

import com.jxdinfo.idp.common.entity.util.docparse.pdf.PdfInfo;
import com.jxdinfo.idp.common.util.uuid.aUX;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -1185015143654744140L;
    private final long leastSigBits;
    private final long mostSigBits;

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }

    public String toString() {
        UUID a;
        return a.toString(false);
    }

    public static UUID nameUUIDFromBytes(byte[] a) {
        byte[] byArray;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(PdfInfo.super("8>@"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(PdfInfo.super("8>@Z\u001b\u0015\u0001Z\u0006\u000f\u0005\n\u001a\b\u0001\u001f\u0011"));
        }
        byte[] byArray2 = byArray = messageDigest.digest(a);
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray;
        byArray4[6] = (byte)(byArray4[6] & 0xF);
        byArray5[6] = (byte)(byArray5[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray3[8] = (byte)(byArray3[8] | 0x80);
        return new UUID(byArray);
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance(PdfInfo.super(")=;D*'42"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public long node() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.interface();
        return uUID.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    private static /* synthetic */ String int(long a, int a2) {
        long l;
        long l2 = l = 1L << a2 * 4;
        return Long.toHexString(l2 | a & l2 - 1L).substring(1);
    }

    public int version() {
        UUID a;
        return (int)(a.mostSigBits >> 12 & 0xFL);
    }

    public long getMostSignificantBits() {
        UUID a;
        return a.mostSigBits;
    }

    public UUID(long a, long a2) {
        UUID a3;
        UUID uUID = a3;
        uUID.mostSigBits = a;
        uUID.leastSigBits = a2;
    }

    public int clockSequence() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.interface();
        return (int)((uUID.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long getLeastSignificantBits() {
        UUID a;
        return a.leastSigBits;
    }

    public static UUID randomUUID(boolean a) {
        byte[] byArray;
        Random random = a ? aUX.package : UUID.getRandom();
        byte[] byArray2 = byArray = new byte[16];
        byte[] byArray3 = byArray;
        random.nextBytes(byArray2);
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray;
        byArray4[6] = (byte)(byArray4[6] & 0xF);
        byArray5[6] = (byte)(byArray5[6] | 0x40);
        byArray3[8] = (byte)(byArray3[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID fromString(String a) {
        int n;
        String[] stringArray = a.split(PdfInfo.super("X"));
        if (stringArray.length != 5) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, PdfInfo.super("<\u0014\u0003\u001b\u0019\u0013\u0011Z /<>U\t\u0001\b\u001c\u0014\u0012@U")).append(a).toString());
        }
        int n2 = n = 0;
        while (n2 < 5) {
            int n3 = n;
            String string = PdfInfo.super("J\r") + stringArray[n];
            stringArray[n3] = string;
            n2 = ++n;
        }
        long l = Long.decode(stringArray[0]);
        l <<= 16;
        l |= Long.decode(stringArray[1]).longValue();
        l <<= 16;
        long l2 = Long.decode(stringArray[3]);
        l2 <<= 48;
        return new UUID(l |= Long.decode(stringArray[2]).longValue(), l2 |= Long.decode(stringArray[4]).longValue());
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    private /* synthetic */ UUID(byte[] a) {
        int n;
        UUID a2;
        long l = 0L;
        long l2 = 0L;
        assert (a.length == 16) : PdfInfo.super("\u0011\u001b\u0001\u001bU\u0017\u0000\t\u0001Z\u0017\u001fUKCZ\u0017\u0003\u0001\u001f\u0006Z\u001c\u0014U\u0016\u0010\u0014\u0012\u000e\u001d");
        int n2 = n = 0;
        while (n2 < 8) {
            int n3 = a[n] & 0xFF;
            l = l << 8 | (long)n3;
            n2 = ++n;
        }
        int n4 = n = 8;
        while (n4 < 16) {
            int n5 = a[n] & 0xFF;
            l2 = l2 << 8 | (long)n5;
            n4 = ++n;
        }
        a2.mostSigBits = l;
        a2.leastSigBits = l2;
    }

    public int variant() {
        UUID a;
        return (int)(a.leastSigBits >>> (int)(64L - (a.leastSigBits >>> 62)) & a.leastSigBits >> 63);
    }

    public int hashCode() {
        UUID a;
        long l = a.mostSigBits ^ a.leastSigBits;
        return (int)(l >> 32) ^ (int)l;
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    private /* synthetic */ void interface() {
        UUID a;
        if (a.version() != 1) {
            throw new UnsupportedOperationException(PdfInfo.super(";\u0015\u0001Z\u0014Z\u0001\u0013\u0018\u001fX\u0018\u0014\t\u0010\u001eU/ 31"));
        }
    }

    public long timestamp() throws UnsupportedOperationException {
        UUID a;
        UUID uUID = a;
        uUID.interface();
        return (uUID.mostSigBits & 0xFFFL) << 48 | (a.mostSigBits >> 16 & 0xFFFFL) << 32 | a.mostSigBits >>> 32;
    }

    public boolean equals(Object a) {
        UUID a2;
        if (null == a || a.getClass() != UUID.class) {
            return false;
        }
        a = (UUID)a;
        return a2.mostSigBits == ((UUID)a).mostSigBits && a2.leastSigBits == ((UUID)a).leastSigBits;
    }

    public String toString(boolean a) {
        UUID a2;
        StringBuilder stringBuilder = new StringBuilder(a ? 32 : 36);
        stringBuilder.append(UUID.int(a2.mostSigBits >> 32, 8));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.int(a2.mostSigBits >> 16, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.int(a2.mostSigBits, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.int(a2.leastSigBits >> 48, 4));
        if (!a) {
            stringBuilder.append('-');
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append(UUID.int(a2.leastSigBits, 12));
        return stringBuilder2.toString();
    }

    @Override
    public int compareTo(UUID a) {
        UUID a2;
        if (a2.mostSigBits < a.mostSigBits) {
            return -1;
        }
        if (a2.mostSigBits > a.mostSigBits) {
            return 1;
        }
        if (a2.leastSigBits < a.leastSigBits) {
            return -1;
        }
        if (a2.leastSigBits > a.leastSigBits) {
            return 1;
        }
        return 0;
    }
}

