/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.bidreview.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.bidreview.api.dto.BidProjectAnalysisResultDto;
import com.jxdinfo.idp.bidreview.api.dto.BidProjectCueWordDto;
import com.jxdinfo.idp.bidreview.api.dto.BidProjectDocDto;
import com.jxdinfo.idp.bidreview.api.dto.BidProjectDto;
import com.jxdinfo.idp.bidreview.api.dto.BidProjectTaskDto;
import com.jxdinfo.idp.bidreview.api.dto.TitlesTreeNode;
import com.jxdinfo.idp.bidreview.api.po.BidProjectAnalysisResultPo;
import com.jxdinfo.idp.bidreview.api.po.BidProjectDocHtmlPo;
import com.jxdinfo.idp.bidreview.api.po.BidProjectDocRelPo;
import com.jxdinfo.idp.bidreview.api.po.BidProjectRulePo;
import com.jxdinfo.idp.bidreview.api.po.BidProjectTaskPo;
import com.jxdinfo.idp.bidreview.api.po.BidProjectTaskResultPo;
import com.jxdinfo.idp.bidreview.api.po.BidReviewProjectPo;
import com.jxdinfo.idp.bidreview.api.service.BidProjectDocRelService;
import com.jxdinfo.idp.bidreview.api.service.BidReviewProjectService;
import com.jxdinfo.idp.bidreview.util.ContentTypeUtil;
import com.jxdinfo.idp.bidreview.util.ZipUtils;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.po.DocFilePo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bidReviewProject"})
public class BidReviewProjectController {
    private static final Logger log = LoggerFactory.getLogger(BidReviewProjectController.class);
    @Resource
    private BidProjectDocRelService bidProjectDocRelService;
    @Resource
    private BidReviewProjectService bidderProjectService;

    @PostMapping(value={"/getDocTitles"})
    public ApiResponse<TitlesTreeNode> getDocTitles(@RequestBody BidProjectDto bidProjectDto) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getDocTitles(bidProjectDto));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u83f9\u53f4\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u7aae\u82a0\u4faf\u604d\u597f\u8d07\uff54")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u7ab1\u82ad\u4fb0\u6040\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/createRuleByLLM"})
    public ApiResponse<Object> createRuleByLLM(@RequestBody BidProjectAnalysisResultDto bidProjectAnalysisResult) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.createRuleByLLM(bidProjectAnalysisResult));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1|\u8c2c\u7579\u5908\u6a70\u57a4\u754e\u623f\u8995\u5236\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u7551\u6232\u898a\u523b\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getProjectTaskResultByIds"})
    public ApiResponse<Object> getProjectTaskResultByIds(@RequestBody BidProjectTaskDto bidProjectTaskDto) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getProjectTaskResultByIds(bidProjectTaskDto));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u6868\u6341\u4e6a\u9501\u67b4\u8bcd\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u4eaa\u528e\u7e82\u67b3\u8bb7\u60ea\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u67ab\u8bc0\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u4eb5\u5283\u7e9d\u67be\u8ba8\u60e7\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getProjectById"})
    public ApiResponse<BidReviewProjectPo> getProjectById(@RequestBody BidReviewProjectPo bidReviewProjectPo) {
        if (bidReviewProjectPo.getId() != null) {
            return ApiResponse.data((Object)this.bidderProjectService.getProjectById(bidReviewProjectPo));
        }
        return ApiResponse.fail((String)ZipUtils.implements("F5\u4e14\u957f\u4e22\u80ac\u4e15\u7a2b"));
    }

    @PostMapping(value={"/deleteById"})
    public ApiResponse<Void> deleteById(@RequestBody BidReviewProjectPo bidReviewProjectPo) {
        try {
            this.bidderProjectService.deleteProjectById(bidReviewProjectPo);
            return ApiResponse.success();
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u5202\u962a\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u5913\u8d6b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u520f\u9635\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u591e\u8d74")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getProjectTaskByIds"})
    public ApiResponse<List<BidProjectTaskPo>> getProjectTaskByIds(@RequestBody BidProjectDto bidProjectDto) {
        try {
            List a = this.bidderProjectService.getProjectTaskByIds(bidProjectDto);
            return ApiResponse.data((Object)a);
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u67b4\u8bcd\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u4eaa\u528e\u4fb0\u6040\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u67ab\u8bc0\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u4eb5\u5283\u4faf\u604d\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<Long> saveOrUpdate(@RequestBody BidReviewProjectPo bidReviewProjectPo) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.saveOrUpdateProject(bidReviewProjectPo));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u65fe\u58bca\u7f34\u8fdf\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u5913\u8d6b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u65e1\u58b1~\u7f39\u8fc0\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u591e\u8d74")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/deleteProjectDoc"})
    public ApiResponse<Void> deleteProjectDoc(@RequestBody BidProjectDto bdProjectDoc) {
        try {
            this.bidderProjectService.deleteProjectDoc(bdProjectDoc);
            return ApiResponse.success();
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u526e\u9646\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u65c9\u4ed4\u4e40\u5151\u801a\u5151\u7cb5\u5913\u8d6b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u5271\u964b\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u65d6\u4ed9\u4e5f\u515c\u8005\u515c\u7caa\u591e\u8d74")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/addNewDocHtml"})
    public ApiResponse<Object> addNewDocHtml(@RequestBody BidProjectDto bdProjectDoc) {
        block3: {
            try {
                String a = bdProjectDoc.getHtmlContent();
                if (!StringUtils.isEmpty((String)a)) break block3;
                return ApiResponse.fail((String)ContentTypeUtil.try("J:O\"\u51a7\u5bf7\u4e2f\u80b3\u4e18\u7a34"));
            }
            catch (Exception a) {
                log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u628a\u6828\u65d6\u4ed9\u7ab1\u82ad\u4fb0\u6040\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
                return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u753d\u625e\u6592\u65c9\u4ed4\u597f\u8d07\uff54")).append(a.getMessage()).toString());
            }
        }
        return ApiResponse.data((Object)this.bidderProjectService.addNewDocHtml(bdProjectDoc));
    }

    @PostMapping(value={"/restartExecReview"})
    public ApiResponse<Object> restartExecReview(@RequestBody BidProjectDto bidProjectDto) {
        block3: {
            try {
                if (bidProjectDto.getTaskId() != null) break block3;
                return ApiResponse.fail((String)ContentTypeUtil.try("\u6764\u8395\u5398\u5212\u4eb5\u5283'F\uff42\u65c2\u6c9b\u5b83\u67ab"));
            }
            catch (Exception a) {
                log.error(new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u919c\u659f\u6236\u8863\u5bf0\u67ca\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
                return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u9183\u6592\u6229\u886e\u5bef\u67c7\u597f\u8d07\uff54")).append(a.getMessage()).toString());
            }
        }
        return ApiResponse.data((Object)this.bidderProjectService.restartExecReview(bidProjectDto));
    }

    @PostMapping(value={"/uploadLLMFile"})
    public ApiResponse<Object> uploadLLMFile(@RequestBody BidProjectAnalysisResultDto bidProjectAnalysisResult) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.uploadLLMFile(bidProjectAnalysisResult));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1|\u8c2c\u7579\u5908\u6a70\u57a4\u4e5b\u4f0f\u65d6\u4ed9\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u4e44\u4f02\u65c9\u4ed4\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/saveOrUpdateBidProjectRule"})
    public ApiResponse<Object> saveOrUpdateBidProjectRule(@RequestBody BidProjectRulePo bidProjectRule) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.saveOrUpdateBidProjectRule(bidProjectRule));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u4f8c\u5b77\u6247\u802a\u66a5\u659f\u8995\u5236\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u4f93\u5b7a\u6258\u8027\u66ba\u6592\u898a\u523b\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getProjectList"})
    public ApiResponse<List<BidReviewProjectPo>> getProjectList(@RequestBody BidReviewProjectPo bidReviewProjectPo) {
        return ApiResponse.data((Object)this.bidderProjectService.getProjectList(bidReviewProjectPo));
    }

    @PostMapping(value={"/execReview"})
    public ApiResponse<Object> execReview(@RequestBody BidProjectDto bidProjectDto) {
        block3: {
            try {
                if (bidProjectDto.getDocIds() != null && bidProjectDto.getDocIds().size() != 0) break block3;
                return ApiResponse.fail((String)ZipUtils.implements("\u8bd8\u5119\u9026\u62b8\u65a8\u4ea7"));
            }
            catch (Exception a) {
                log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u6229\u886e\u5bef\u67c7\u597f\u8d07\uff54")).append(a.getMessage()).toString());
                return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u6236\u8863\u5bf0\u67ca\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            }
        }
        return ApiResponse.data((Object)this.bidderProjectService.execReview(bidProjectDto));
    }

    @PostMapping(value={"/deleteProjectTask"})
    public ApiResponse<Void> deleteProjectTask(@RequestBody List<Long> ids) {
        try {
            this.bidderProjectService.deleteProjectTask(ids);
            return ApiResponse.success();
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u520f\u9635\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u4ed4\u52f0\u4fce\u603e\u591e\u8d74")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u5202\u962a\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u4ed9\u52ef\u4fc3\u6021\u5913\u8d6b")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getBidDocFile"})
    public ApiResponse<Object> getBidDocFile(@RequestBody BidProjectDocHtmlPo bidProjectDocHtmlPo) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getBidDocFile(bidProjectDocHtmlPo));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u83f9\u53f4\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u6295\u6825\u65c9\u4ed4\u7aae\u82a0\u4faf\u604d\u597f\u8d07\uff54")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u628a\u6828\u65d6\u4ed9\u7ab1\u82ad\u4fb0\u6040\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getBidProjectRule"})
    public ApiResponse<Object> getBidProjectRule(@RequestBody BidProjectRulePo bidProjectRule) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getBidProjectRule(bidProjectRule));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u83e6\u53f9\u8995\u5236\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u83f9\u53f4\u898a\u523b\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getBidProjectAnalysisResult"})
    public ApiResponse<Object> getBidProjectAnalysisResult(@RequestBody BidProjectAnalysisResultDto dto) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getBidProjectAnalysisResult(dto));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u83e6\u53f9\u6730\u6b11\u89b2\u67bf\u7e82\u67b3\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u83f9\u53f4\u672f\u6b1c\u89ad\u67b2\u7e9d\u67be\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/addNewDoc"})
    public ApiResponse<String> addNewDoc(@RequestBody BidProjectDto bidProjectDto) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.addNewDoc(bidProjectDto));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u83f9\u53f4\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u7aae\u82a0\u4faf\u604d\u597f\u8d07\uff54")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u7ab1\u82ad\u4fb0\u6040\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/analysisLLM"})
    public ApiResponse<Object> analysisLLM(@RequestBody BidProjectAnalysisResultDto bidProjectAnalysisResult) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.analysisLLM(bidProjectAnalysisResult));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1|\u8c2c\u7579\u5908\u6a70\u57a4\u5257\u67bf\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u5248\u67b2\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getProjectTaskResult"})
    public ApiResponse<List<BidProjectTaskResultPo>> getProjectTaskResultList(@RequestBody BidProjectTaskDto bidProjectTaskDto) {
        try {
            List a = this.bidderProjectService.getProjectTaskResultList(bidProjectTaskDto);
            return ApiResponse.data((Object)a);
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u67b4\u8bcd\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u4eaa\u528e\u7e82\u67b3\u8bb7\u60ea\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u67ab\u8bc0\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u4eb5\u5283\u7e9d\u67be\u8ba8\u60e7\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/addProjectDoc"})
    public ApiResponse<BidProjectDocRelPo> addProjectDoc(@RequestPart(value="file") MultipartFile file, @RequestParam(value="projectId") String projectId, @RequestParam(value="docType") String docType, @RequestParam(value="documentName") String documentName, @RequestParam(value="format") String format) {
        try {
            void a;
            BidProjectDocDto bidProjectDocDto = new BidProjectDocDto();
            void v0 = a;
            void v1 = a;
            a.setProjectId(Long.valueOf(Long.parseLong(projectId)));
            v1.setDocType(docType);
            v1.setDocumentName(documentName);
            v0.setFormat(format);
            v0.setFile(file);
            return ApiResponse.data((Object)this.bidderProjectService.addProjectDoc((BidProjectDocDto)a));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u6592\u58d0\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u65a5\u4eb8\u5913\u8d6b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ZipUtils.implements("\u659f\u58cf\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u65a8\u4ea7\u591e\u8d74")).append(a.getMessage()).toString());
        }
    }

    @GetMapping(value={"/exportExtractResult"})
    public void exportExtractResult(@RequestParam Long taskId) {
        try {
            log.info(new StringBuilder().insert(0, ZipUtils.implements("\u5f51\u59e4\u6236\u8863\u5bf0\u67ca\u7e82\u67b3\u5bad\u51d5%N\"D\u0018Kk")).append(taskId).toString());
            this.bidderProjectService.exportExtractResult(taskId);
            return;
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ContentTypeUtil.try("\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u5bef\u67c7\u7e9d\u67be\u5bb2\u51d8\u597f\u8d07t")).append(a.getMessage()).toString());
            return;
        }
    }

    @PostMapping(value={"/getProjectTaskList"})
    public ApiResponse<Page<BidProjectTaskPo>> getProjectTaskList(@RequestBody BidProjectDto bidProjectDto) {
        try {
            Page a = this.bidderProjectService.getProjectTaskList(bidProjectDto);
            return ApiResponse.data((Object)a);
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u67b4\u8bcd\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u4eaa\u528e\u5246\u8847\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u67ab\u8bc0\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u4eb5\u5283\u5259\u884a\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getBidDocFileHtml"})
    public ApiResponse<Object> getBidDocFileHtml(@RequestBody BidProjectDocHtmlPo bidProjectDocHtmlPo) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getBidDocFileHtml(bidProjectDocHtmlPo));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1\u628a\u6828\u65d6\u4ed9\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u83f9\u53f4\u6849\u4e44\u5bef\u67c7\u9837\u76cc\u6295\u6825\u65c9\u4ed4\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/getBidProjectCueWord"})
    public ApiResponse<Object> getBidProjectCueWord(@RequestBody BidProjectCueWordDto bidProjectCueWord) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.getBidProjectCueWord(bidProjectCueWord));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u83e6\u53f9\u6856\u4e49\u5bf0\u67ca\u9828\u76c1|\u63ff\u796b\u8be2\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u83f9\u53f4\u6849\u4e44\u5bef\u67c7\u9837\u76ccc\u63f2\u7974\u8bef\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getProjectDocList"})
    public ApiResponse<List<DocFilePo>> getProjectDocList(@RequestBody BidProjectDocDto bidProjectDocDto) {
        void bidProjectDocDto2;
        return ApiResponse.data((Object)this.bidderProjectService.getProjectDocList((BidProjectDocDto)bidProjectDocDto2));
    }

    @PostMapping(value={"/saveOrUpdateBidProjectAnalysis"})
    public ApiResponse<Object> saveOrUpdateBidProjectAnalysis(@RequestBody BidProjectAnalysisResultPo po) {
        try {
            return ApiResponse.data((Object)this.bidderProjectService.saveOrUpdateBidProjectAnalysis(po));
        }
        catch (Exception a) {
            log.error(new StringBuilder().insert(0, ZipUtils.implements("\u8398\u5387\u6828\u4e37\u5b8e\u67b4\u9856\u76bf\u0002\u4f8c\u5b77\u6247\u802a\u66a5\u659f\u6730\u6b11\u89b2\u67bf\u7e82\u67b3\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
            return ApiResponse.fail((String)new StringBuilder().insert(0, ContentTypeUtil.try("\u8395\u5398\u6825\u4e28\u5b83\u67ab\u985b\u76a0\u000f\u4f93\u5b7a\u6258\u8027\u66ba\u6592\u672f\u6b1c\u89ad\u67b2\u7e9d\u67be\u597f\u8d07\uff54")).append(a.getMessage()).toString());
        }
    }
}

